/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.util;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.views.utils.BasicTextPane;
import com.gigaspaces.grid.esm.ESM;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.internal.log.InternalLogProvider;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntry;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogEntryMatchers;
import com.gigaspaces.log.LogProcessType;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;

public class LogUpdateTask
implements Runnable {
    private BasicTextPane _textComponent;
    private StyledDocument _document;
    private LogEntryMatcher _matcher;
    private Object _service;
    private ServiceItem _serviceItem;
    private long _pid;
    private String _gsaOwnerID;
    private boolean _isServiceLUS = false;
    private boolean _isExceptionThrown = false;
    private boolean _isFirstLogsRetrieving = true;
    private LogProcessType _processType;
    private final int MAX_LOG_LENGTH = 300000;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private static final String LOG_ENTRIES_NOT_FOUND = "No logs entries were found";

    public LogUpdateTask(BasicTextPane textComponent, StyledDocument document, int rowsAmount, String str, ServiceItem serviceItem, String gsaOwnerID, long pid) {
        this._textComponent = textComponent;
        this._document = document;
        this._serviceItem = serviceItem;
        this._service = serviceItem.service;
        this._gsaOwnerID = gsaOwnerID;
        this._pid = pid;
        this._matcher = str.trim().length() > 0 ? LogEntryMatchers.continuous((LogEntryMatcher)LogEntryMatchers.regex((String)str, (LogEntryMatcher)LogEntryMatchers.lastN((int)rowsAmount)), (LogEntryMatcher)LogEntryMatchers.regex((String)str)) : LogEntryMatchers.continuous((LogEntryMatcher)LogEntryMatchers.lastN((int)rowsAmount));
        if (this._service instanceof ServiceRegistrar) {
            this._service = ((ServiceRegistrar)this._service).getRegistrar();
            this._isServiceLUS = true;
            this._processType = LogProcessType.LUS;
        } else {
            this._processType = this._service instanceof GSC ? LogProcessType.GSC : (this._service instanceof GSM ? LogProcessType.GSM : (this._service instanceof ESM ? LogProcessType.ESM : LogProcessType.GSA));
        }
    }

    @Override
    public void run() {
        if (this._isExceptionThrown) {
            return;
        }
        LOGGER.log(Level.FINER, "-- Start Run retrieving logs --");
        try {
            int curCaretPosition;
            LogEntries logs;
            ServiceItem gsaOwnerServiceItem = null;
            if (this._gsaOwnerID != null) {
                gsaOwnerServiceItem = Repository.getInstance().getGSAServiceItem(this._gsaOwnerID);
            }
            if (gsaOwnerServiceItem != null) {
                GSA gsaOwner = (GSA)gsaOwnerServiceItem.service;
                logs = gsaOwner.logEntries(this._processType, this._pid, this._matcher);
            } else {
                logs = ((InternalLogProvider)this._service).logEntriesDirect(this._matcher);
                if (this._isServiceLUS) {
                    logs = InternalLogHelper.clientSideProcess((LogEntryMatcher)this._matcher, (LogEntries)logs);
                }
            }
            int length = this._document.getLength();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "PID=" + this._pid + "---Length:" + length + ", text length:" + this._textComponent.getText().length());
            }
            boolean isScroll = (curCaretPosition = this._textComponent.getCaretPosition()) == 0 || curCaretPosition == this._document.getLength();
            for (LogEntry log : logs.logEntries()) {
                try {
                    String textWithLF = log.getTextWithLF();
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "---textWithLF=" + textWithLF);
                    }
                    this._document.insertString(this._document.getLength(), textWithLF, null);
                    length = this._document.getLength();
                    if (length <= 300000) continue;
                    this._document.remove(0, length - 300000);
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.log(Level.FINER, "---IN IF, PID=" + this._pid + ", Length:" + length);
                }
                catch (BadLocationException badLocationException) {}
            }
            if (logs.logEntries().size() > 0) {
                this._textComponent.invokeSearch();
            }
            String curText = this._textComponent.getText().trim();
            if (this._isFirstLogsRetrieving && curText.length() == 0) {
                this._textComponent.setText(LOG_ENTRIES_NOT_FOUND);
            }
            if (logs.logEntries().size() > 0 && isScroll) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LogUpdateTask.this._textComponent.isVisible() && LogUpdateTask.this._textComponent.isShowing()) {
                            LogUpdateTask.this._textComponent.setCaretPosition(LogUpdateTask.this._document.getLength());
                        }
                    }
                });
            }
            this._isFirstLogsRetrieving = false;
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, ioe.toString(), ioe);
            }
            if (this._serviceItem.service instanceof ServiceRegistrar) {
                this._textComponent.setText("The log can only be displayed if the LUS runs as a standalone process.");
            }
            this._isExceptionThrown = true;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this._isExceptionThrown = true;
        }
        LOGGER.log(Level.FINER, "-- End Run retrieving logs --");
    }
}

