/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.util;

import com.gigaspaces.admin.ui.util.AboutBox;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import javax.swing.JFrame;

public class MacUIHelper {
    public static Properties getSystemProperties(String appName) {
        Properties props = new Properties();
        props.setProperty("apple.laf.useScreenMenuBar", "true");
        props.setProperty("com.apple.macos.smallTabs", "true");
        props.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        props.setProperty("apple.awt.brushMetalLook", "true");
        if (appName != null) {
            props.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
        }
        return props;
    }

    public static boolean isMacOS() {
        return System.getProperty("mrj.version") != null;
    }

    public static void setUIHandler(JFrame frame) {
        if (!MacUIHelper.isMacOS()) {
            return;
        }
        try {
            Class<?> appClass = MacUIHelper.class.getClassLoader().loadClass("com.apple.eawt.Application");
            Class<?> adapterClass = MacUIHelper.class.getClassLoader().loadClass("com.apple.eawt.ApplicationListener");
            Object app = appClass.newInstance();
            Method addApplicationListener = appClass.getMethod("addApplicationListener", adapterClass);
            UIHandler handler = new UIHandler(frame);
            addApplicationListener.invoke(app, Proxy.newProxyInstance(MacUIHelper.class.getClassLoader(), new Class[]{adapterClass}, (InvocationHandler)handler));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static class UIHandler
    implements InvocationHandler {
        JFrame frame;

        public UIHandler(JFrame frame) {
            this.frame = frame;
        }

        @Override
        public Object invoke(Object target, Method method, Object[] args) throws Throwable {
            this.setHandled(args[0]);
            if (method.getName().equals("handleAbout")) {
                new AboutBox(this.frame).setVisible(true);
            }
            if (method.getName().equals("handleQuit")) {
                WindowEvent event = new WindowEvent(new Window(this.frame), 201);
                WindowListener[] wListeners = this.frame.getWindowListeners();
                for (int i = 0; i < wListeners.length; ++i) {
                    wListeners[i].windowClosing(event);
                }
            }
            return null;
        }

        private void setHandled(Object arg) {
            try {
                Method handled = arg.getClass().getMethod("setHandled", Boolean.TYPE);
                handled.invoke(arg, Boolean.TRUE);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

