/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.util;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.start.Locator;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class UIHelper {
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public static String getProductUIHomeDirectoryName() {
        return Locator.getProductHomeDirectoryName() + File.separator + "ui";
    }

    public static File getProductHomeDirectory() {
        String dirPath = Locator.getProductHomeDirectoryName();
        File gigaspacesFolder = new File(dirPath);
        if (!gigaspacesFolder.exists()) {
            gigaspacesFolder.mkdir();
        }
        return gigaspacesFolder;
    }

    public static File getProductUIHomeDirectory() {
        UIHelper.getProductHomeDirectory();
        String dirPath = UIHelper.getProductUIHomeDirectoryName();
        File gigaspacesUIFolder = new File(dirPath);
        if (!gigaspacesUIFolder.exists()) {
            gigaspacesUIFolder.mkdir();
        }
        return gigaspacesUIFolder;
    }

    public static void saveProperties(Properties props) throws IOException {
        if (props == null) {
            throw new NullPointerException("props is null");
        }
        File gigaUIHomeDir = UIHelper.getProductUIHomeDirectory();
        File propFile = new File(gigaUIHomeDir, "adminui.properties");
        props.store(new FileOutputStream(propFile), null);
    }

    public static Properties loadProperties() throws IOException {
        File gigaUIHomeDir = UIHelper.getProductUIHomeDirectory();
        Properties props = new Properties();
        if (!gigaUIHomeDir.exists()) {
            return props;
        }
        File propFile = new File(gigaUIHomeDir, "adminui.properties");
        props.load(new FileInputStream(propFile));
        String savedBuildNum = props.getProperty("BUILD_NUM");
        if (savedBuildNum != null && !savedBuildNum.equals(PlatformVersion.getInstance().getId())) {
            propFile.delete();
            props = new Properties();
        }
        return props;
    }

    public static ImageIcon getImageIcon(String location) {
        ImageIcon icon = null;
        URL url = UIHelper.class.getClassLoader().getResource(location);
        if (url != null) {
            icon = new ImageIcon(url);
        }
        return icon;
    }

    public static void showError(String text, Component comp) {
        JDialog dialog = null;
        dialog = comp instanceof Dialog ? new JDialog((Dialog)comp, "Error", true) : (comp instanceof Frame ? new JDialog((Frame)comp, "Error", true) : new JDialog());
        JEditorPane errorPane = new JEditorPane();
        errorPane.setEditable(false);
        errorPane.setContentType("text/html");
        errorPane.setText(text);
        errorPane.setCaretPosition(0);
        errorPane.moveCaretPosition(0);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout(8, 8));
        pane.add((Component)new JScrollPane(errorPane), "Center");
        JButton close = new JButton("Close");
        close.addActionListener(new DisposeActionListener(dialog));
        JPanel buttonPane = new JPanel();
        buttonPane.add(close);
        pane.add((Component)buttonPane, "South");
        dialog.getContentPane().add(pane);
        int width = 650;
        int height = 300;
        dialog.pack();
        dialog.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int widthLoc = screenSize.width / 2 - width / 2;
        int heightLoc = screenSize.height / 2 - height / 2;
        dialog.setLocation(widthLoc, heightLoc);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            String walla;
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            JFrame frame = new JFrame("Frame");
            frame.setVisible(true);
            frame.setSize(200, 200);
            String kuku = walla = "abc";
            try {
                kuku.charAt(100);
            }
            catch (Exception e) {
                UIHelper.showError((Throwable)e, (Component)null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showError(Throwable t, String desc) {
        Date when = new Date(System.currentTimeMillis());
        if (Repository.getInstance().getUIExceptionTable() != null) {
            Repository.getInstance().getUIExceptionTable().addException(t, desc, when);
        }
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, t.toString(), t);
        }
    }

    public static void showError(Throwable e) {
        UIHelper.showError(e, (Component)null);
    }

    public static void showError(Throwable e, Component comp) {
        StringBuilder buffer = new StringBuilder();
        if (e.getCause() != null) {
            e = e.getCause();
        }
        StackTraceElement[] trace = e.getStackTrace();
        buffer.append("at ");
        for (int i = 0; i < trace.length; ++i) {
            buffer.append(trace[i] + "<br>");
        }
        UIHelper.showError("<html>Exception : <font color=red>" + e.getClass().getName() + "</font> : <font color=blue>" + e.getLocalizedMessage() + "</font><br>" + buffer.toString() + "</html>", comp);
    }

    public static void setWaitCursor(JComponent jcomp) {
        Component comp;
        if (jcomp != null && (comp = SwingUtilities.getRoot(jcomp)) != null) {
            comp.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static void setDefaultCursor(JComponent jcomp) {
        Component comp;
        if (jcomp != null && (comp = SwingUtilities.getRoot(jcomp)) != null) {
            comp.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static void showError(Map errorMap, String title, Component comp) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><h3>" + title + "</h3>");
        sb.append("<table BORDER COLS=2>");
        sb.append("<tr><td><b><font color=blue>Component</font></b></td>");
        sb.append("<td><b><font color=blue>Exception</font></b></td></tr>");
        for (Map.Entry entry : errorMap.entrySet()) {
            Object key = entry.getKey();
            sb.append("<tr>");
            sb.append("<td><font color=black>" + key + "</font></td>");
            Object value = entry.getValue();
            String text = value.getClass().getName();
            if (value instanceof Throwable) {
                text = text + ": " + ((Throwable)value).getMessage();
            }
            sb.append("<td><font color=red>" + text + "</font></td>");
            sb.append("</tr>");
        }
        sb.append("</table></html>");
        JOptionPane.showMessageDialog(comp, sb.toString(), title, 0);
    }

    public static Font createTableFont(int size) {
        return new Font("Dialog", 0, size);
    }

    public static Font createTextEditor(int size) {
        return new Font("Dialog", 0, size);
    }

    static class DisposeActionListener
    implements ActionListener {
        JDialog dialog;

        DisposeActionListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.dialog.dispose();
        }
    }
}

