/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views;

import com.gigaspaces.internal.utils.concurrent.GSThread;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RefreshThread
extends GSThread {
    private final long TIMEOUT = 1000L;
    private final RefreshableView _view;

    public RefreshThread(String name, RefreshableView view) {
        super(name);
        this._view = view;
    }

    public void run() {
        while (true) {
            if (this._view.shouldRefresh()) {
                this._view.updateRuntimeDetails();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ie) {
                if (!this._view.getLogger().isLoggable(Level.SEVERE)) continue;
                this._view.getLogger().log(Level.SEVERE, ie.toString(), ie);
                continue;
            }
            break;
        }
    }

    public static interface RefreshableView {
        public void updateRuntimeDetails();

        public boolean shouldRefresh();

        public Logger getLogger();
    }
}

