/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.hosts;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.grid.views.PUInstancesPanel;
import com.gigaspaces.admin.ui.views.RefreshThread;
import com.gigaspaces.admin.ui.views.hosts.ServiceDetailsBox;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.admin.ui.views.utils.LogComponent;
import com.gigaspaces.grid.esm.ESM;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.gsm.PUDetails;
import com.gigaspaces.grid.gsm.PUsDetails;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.core.lookup.ServiceItem;

public class ESMView
extends JPanel
implements RefreshThread.RefreshableView {
    private ServiceDetailsBox _serviceDetailsBox;
    private LogComponent _logComponent;
    private ESM _curESM;
    private JSplitPane _splitPane;
    private final ESMProcessingUnitsTableModel _puDetailsTableModel;
    private final BasicTable _puDetailsTable;
    private volatile boolean _isRefresh;
    private boolean _isDividerLocationSet = false;
    private MainUI _mainUI;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private static final String CP_DEPLOYMENT_ISOLATION = "deploymentIsolation";
    private static final String CP_MAX_JAVA_HEAP_SIZE = "maximumJavaHeapSize";
    private static final String CP_INITIAL_JAVA_HEAP_SIZE = "initialJavaHeapSize";
    private static final String CP_HIGHLY_AVAILABLE = "highlyAvailable";
    private static final String CP_TENANT = "tenant";
    private static final String CP_MIN_MEMORY = "minMemory";
    private static final String CP_MAX_MEMORY = "maxMemory";

    public ESMView(MainUI mainUI) {
        super(new BorderLayout());
        this._mainUI = mainUI;
        this._serviceDetailsBox = new ServiceDetailsBox(mainUI, "ESM");
        this._puDetailsTableModel = new ESMProcessingUnitsTableModel();
        this._puDetailsTable = new BasicTable(this._puDetailsTableModel);
        this.setTableProperties(this._puDetailsTable);
        JScrollPane scrollPane = new JScrollPane(this._puDetailsTable);
        scrollPane.setBorder(BorderFactory.createTitledBorder("Elastic Deployments"));
        this._logComponent = new LogComponent(mainUI);
        this._splitPane = new JSplitPane(0, scrollPane, this._logComponent);
        this.add((Component)this._serviceDetailsBox, "North");
        this.add((Component)this._splitPane, "Center");
        new RefreshThread("ESM-View-Refresh", this).start();
    }

    private void setTableProperties(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        CustomizeTableHeader header = new CustomizeTableHeader(columnModel);
        table.setTableHeader(header);
        header.setReorderingAllowed(false);
        TableColumn puNameTableColumn = columnModel.getColumn(0);
        TableColumn plannedInstancesTableColumn = columnModel.getColumn(1);
        TableColumn actualInstancesTableColumn = columnModel.getColumn(2);
        TableColumn statusTableColumn = columnModel.getColumn(3);
        TableColumn highlyAvailableTableColumn = columnModel.getColumn(5);
        TableColumn maxJavaHeapTableColumn = columnModel.getColumn(8);
        TableColumn initialJavaHeapTableColumn = columnModel.getColumn(7);
        TableColumn tenantTableColumn = columnModel.getColumn(9);
        TableColumn capacityTableColumn = columnModel.getColumn(4);
        plannedInstancesTableColumn.setPreferredWidth(15);
        actualInstancesTableColumn.setPreferredWidth(12);
        statusTableColumn.setPreferredWidth(36);
        tenantTableColumn.setPreferredWidth(35);
        highlyAvailableTableColumn.setPreferredWidth(50);
        maxJavaHeapTableColumn.setPreferredWidth(51);
        initialJavaHeapTableColumn.setPreferredWidth(55);
        capacityTableColumn.setPreferredWidth(36);
        puNameTableColumn.setCellRenderer(new ESMProcessingUnitsCellRenderer());
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
        this._serviceDetailsBox.setInvokeRefresh(refresh);
        if (!refresh) {
            this._logComponent.cancelTask();
        }
    }

    public void setESM(ServiceItem esmServiceItem, String serviceName, String lookupGroups, String lookupLocators, String zones, String gsaOwnerID, long pid, boolean isSecuredService) {
        this._curESM = (ESM)esmServiceItem.service;
        this._serviceDetailsBox.setService(esmServiceItem, serviceName, lookupGroups, lookupLocators, zones, null);
        this._logComponent.setService(esmServiceItem, serviceName, gsaOwnerID, pid, isSecuredService);
        this.updateView();
        if (!this._isDividerLocationSet) {
            this._splitPane.setDividerLocation(0.3);
            this._isDividerLocationSet = true;
        }
    }

    private void updateView() {
        this._puDetailsTableModel.clear();
        this._serviceDetailsBox.updateView();
        this.updateRuntimeDetails();
    }

    @Override
    public void updateRuntimeDetails() {
        block4: {
            if (this._curESM == null) {
                this.clear();
                return;
            }
            try {
                String[] managedProcessingUnits = this._curESM.getManagedProcessingUnits();
                ArrayList<BasicWrapper> list = new ArrayList<BasicWrapper>(managedProcessingUnits.length);
                for (String puName : managedProcessingUnits) {
                    PUDetailsWrapper wrapper = this.createPUWrapper(puName);
                    if (wrapper == null) continue;
                    list.add(wrapper);
                }
                this._puDetailsTableModel.setWrappersList(list, false);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    @Override
    public boolean shouldRefresh() {
        return this._isRefresh;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    private PUDetailsWrapper createPUWrapper(String processingUnitName) {
        PUDetailsWrapper puWrapper;
        block4: {
            puWrapper = null;
            try {
                GSM gsm = (GSM)Repository.getInstance().getProvisionMonitor();
                if (gsm != null) {
                    PUDetails[] puDetailsArray;
                    PUsDetails pusDetails = gsm.getPUsDetails();
                    for (PUDetails puDetails : puDetailsArray = pusDetails.getDetails()) {
                        String puName = puDetails.getName();
                        if (!processingUnitName.equals(puName)) continue;
                        String status = PUInstancesPanel.getStatusDescription(puDetails.getStatus());
                        int numOfInstances = puDetails.getNumberOfInstances();
                        int numOfBackups = puDetails.getNumberOfBackups();
                        int actualInstancesNum = this.getActualInstancesNumber(puName);
                        MarshalledObject beanLevelPropertiesMarshObject = puDetails.getBeanLevelProperties();
                        Object beanLevelPropertiesObj = beanLevelPropertiesMarshObject.get();
                        Properties contextProperties = (Properties)beanLevelPropertiesObj.getClass().getMethod("getContextProperties", new Class[0]).invoke(beanLevelPropertiesObj, new Object[0]);
                        String deploymentIsolation = contextProperties.getProperty(CP_DEPLOYMENT_ISOLATION);
                        String maxJavaHeapSize = contextProperties.getProperty(CP_MAX_JAVA_HEAP_SIZE);
                        String initialJavaHeapSize = contextProperties.getProperty(CP_INITIAL_JAVA_HEAP_SIZE);
                        String highlyAvailableStr = contextProperties.getProperty(CP_HIGHLY_AVAILABLE);
                        String tenant = contextProperties.getProperty(CP_TENANT);
                        String minMemory = contextProperties.getProperty(CP_MIN_MEMORY);
                        String maxMemory = contextProperties.getProperty(CP_MAX_MEMORY);
                        boolean isHighlyAvailable = highlyAvailableStr != null ? Boolean.parseBoolean(highlyAvailableStr) : false;
                        int plannedNum = numOfInstances * (1 + numOfBackups);
                        puWrapper = new PUDetailsWrapper(puName, status, plannedNum, actualInstancesNum, deploymentIsolation, maxJavaHeapSize, initialJavaHeapSize, tenant, isHighlyAvailable, minMemory, maxMemory);
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, e.toString());
            }
        }
        return puWrapper;
    }

    private int getActualInstancesNumber(String puName) {
        DefaultMutableTreeNode opStringTreeNode = this._mainUI.getUIComponent().getTreeWorker().getOpStringTreeNode(puName);
        if (opStringTreeNode != null) {
            return TreeWorker.getPUServiceHolders(opStringTreeNode).size();
        }
        return 0;
    }

    private void clear() {
        this._serviceDetailsBox.clear();
        this._logComponent.clear();
        this._puDetailsTableModel.clear();
    }

    private class ESMProcessingUnitsTableModel
    extends BasicSortableTableModel {
        private final String CN_NAME = "Name";
        private final String CN_PLANNED = "Planned";
        private final String CN_ACTUAL = "Actual";
        private final String CN_STATUS = "Status";
        private final String CN_CAPACITY = "Capacity";
        private final String CN_HIGHLY_AVAILABLE = "Highly Available";
        private final String CN_DEPLOYMENT_ISOLATION = "Deployment Isolation";
        private final String CN_INITIAL_JAVA_HEAP_SIZE = "Initial Java Heap";
        private final String CN_MAX_JAVA_HEAP_SIZE = "Max Java Heap";
        private final String CN_TENANT = "Tenant";
        protected static final int CI_NAME = 0;
        protected static final int CI_PLANNED = 1;
        protected static final int CI_ACTUAL = 2;
        protected static final int CI_STATUS = 3;
        protected static final int CI_CAPACITY = 4;
        protected static final int CI_HIGHLY_AVAILABLE = 5;
        protected static final int CI_DEPLOYMENT_ISOLATION = 6;
        protected static final int CI_INITIAL_JAVA_HEAP_SIZE = 7;
        protected static final int CI_MAX_JAVA_HEAP_SIZE = 8;
        protected static final int CI_TENANT = 9;

        private ESMProcessingUnitsTableModel() {
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[10];
            this.columnNames[0] = "Name";
            this.columnNames[1] = "Planned";
            this.columnNames[2] = "Actual";
            this.columnNames[3] = "Status";
            this.columnNames[4] = "Capacity";
            this.columnNames[5] = "Highly Available";
            this.columnNames[6] = "Deployment Isolation";
            this.columnNames[7] = "Initial Java Heap";
            this.columnNames[8] = "Max Java Heap";
            this.columnNames[9] = "Tenant";
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            PUDetailsWrapper puDetailsWrapper = (PUDetailsWrapper)basicWrapper;
            switch (column) {
                case 0: {
                    return puDetailsWrapper.getName();
                }
                case 1: {
                    return String.valueOf(puDetailsWrapper.getPlannedNum());
                }
                case 2: {
                    return String.valueOf(puDetailsWrapper.getActualNum());
                }
                case 3: {
                    return puDetailsWrapper.getStatus();
                }
                case 4: {
                    return puDetailsWrapper.getCapacity();
                }
                case 5: {
                    return puDetailsWrapper.isHighlyAvaiable();
                }
                case 6: {
                    return puDetailsWrapper.getDeploymentIsolation();
                }
                case 7: {
                    return puDetailsWrapper.getInitialJavaHeap();
                }
                case 8: {
                    return puDetailsWrapper.getMaxJavaHeap();
                }
                case 9: {
                    return puDetailsWrapper.getTenant();
                }
            }
            return "";
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            PUDetailsWrapper puDetailsWrapper1 = (PUDetailsWrapper)wrapper1;
            PUDetailsWrapper puDetailsWrapper2 = (PUDetailsWrapper)wrapper2;
            switch (colIndex) {
                case 0: {
                    String name1 = puDetailsWrapper1.getName();
                    String name2 = puDetailsWrapper2.getName();
                    if (ascending) {
                        return name1.compareToIgnoreCase(name2);
                    }
                    return name2.compareToIgnoreCase(name1);
                }
                case 1: {
                    int numOfPlannedInstances1 = puDetailsWrapper1.getPlannedNum();
                    int numOfPlannedInstances2 = puDetailsWrapper2.getPlannedNum();
                    if (ascending) {
                        return numOfPlannedInstances1 < numOfPlannedInstances2 ? -1 : (numOfPlannedInstances1 == numOfPlannedInstances2 ? 0 : 1);
                    }
                    return numOfPlannedInstances2 < numOfPlannedInstances1 ? -1 : (numOfPlannedInstances2 == numOfPlannedInstances1 ? 0 : 1);
                }
                case 2: {
                    int actualNum1 = puDetailsWrapper1.getActualNum();
                    int actualNum2 = puDetailsWrapper2.getActualNum();
                    if (ascending) {
                        return actualNum1 < actualNum2 ? -1 : (actualNum1 == actualNum2 ? 0 : 1);
                    }
                    return actualNum2 < actualNum1 ? -1 : (actualNum2 == actualNum1 ? 0 : 1);
                }
                case 3: {
                    String status1 = puDetailsWrapper1.getStatus();
                    String status2 = puDetailsWrapper2.getStatus();
                    if (ascending) {
                        return status1.compareToIgnoreCase(status2);
                    }
                    return status2.compareToIgnoreCase(status1);
                }
                case 4: {
                    String capacity1 = puDetailsWrapper1.getCapacity();
                    String capacity2 = puDetailsWrapper2.getCapacity();
                    if (ascending) {
                        return capacity1.compareToIgnoreCase(capacity2);
                    }
                    return capacity2.compareToIgnoreCase(capacity1);
                }
                case 5: {
                    Boolean isHighlyAvaialbe1 = puDetailsWrapper1.isHighlyAvaiable();
                    Boolean isHighlyAvaialbe2 = puDetailsWrapper2.isHighlyAvaiable();
                    if (ascending) {
                        return isHighlyAvaialbe1.compareTo(isHighlyAvaialbe2);
                    }
                    return isHighlyAvaialbe2.compareTo(isHighlyAvaialbe1);
                }
                case 6: {
                    String deploymentIsolation1 = puDetailsWrapper1.getDeploymentIsolation();
                    String deploymentIsolation2 = puDetailsWrapper2.getDeploymentIsolation();
                    if (ascending) {
                        return deploymentIsolation1.compareToIgnoreCase(deploymentIsolation2);
                    }
                    return deploymentIsolation2.compareToIgnoreCase(deploymentIsolation1);
                }
                case 7: {
                    String initialJavaDump1 = puDetailsWrapper1.getInitialJavaHeap();
                    String initialJavaDump2 = puDetailsWrapper2.getInitialJavaHeap();
                    if (ascending) {
                        return initialJavaDump1.compareToIgnoreCase(initialJavaDump2);
                    }
                    return initialJavaDump2.compareToIgnoreCase(initialJavaDump1);
                }
                case 8: {
                    String maxJavaDump1 = puDetailsWrapper1.getMaxJavaHeap();
                    String maxJavaDump2 = puDetailsWrapper2.getMaxJavaHeap();
                    if (ascending) {
                        return maxJavaDump1.compareToIgnoreCase(maxJavaDump2);
                    }
                    return maxJavaDump2.compareToIgnoreCase(maxJavaDump1);
                }
                case 9: {
                    String tenant1 = puDetailsWrapper1.getTenant();
                    String tenant2 = puDetailsWrapper2.getTenant();
                    if (ascending) {
                        return tenant1.compareToIgnoreCase(tenant2);
                    }
                    return tenant2.compareToIgnoreCase(tenant1);
                }
            }
            return 0;
        }
    }

    private class PUDetailsWrapper
    extends BasicWrapper {
        private final String _name;
        private final int _plannedNum;
        private final int _actualNum;
        private final String _status;
        private final String _capacity;
        private final boolean _isHighlyAvaiable;
        private final String _deploymentIsolation;
        private final String _initialJavaHeap;
        private final String _maxJavaHeap;
        private final String _tenant;
        private final String _minMemory;
        private final String _maxMemory;

        public PUDetailsWrapper(String name, String status, int plannedNum, int actualInstancesNum, String deploymentIsolation, String maxJavaHeapSize, String initialJavaHeapSize, String tenant, boolean isHighlyAvailable, String minMemory, String maxMemory) {
            this._name = name;
            this._plannedNum = plannedNum;
            this._actualNum = actualInstancesNum;
            this._status = status == null ? "n/a" : status;
            this._isHighlyAvaiable = isHighlyAvailable;
            this._deploymentIsolation = deploymentIsolation == null ? "n/a" : deploymentIsolation;
            this._initialJavaHeap = initialJavaHeapSize == null ? "n/a" : initialJavaHeapSize;
            this._maxJavaHeap = maxJavaHeapSize == null ? "n/a" : maxJavaHeapSize;
            this._tenant = tenant == null ? "n/a" : tenant;
            this._minMemory = minMemory == null ? "n/a" : minMemory;
            this._maxMemory = maxMemory == null ? "n/a" : maxMemory;
            this._capacity = minMemory == null || maxMemory == null ? "n/a" : minMemory + "-" + maxMemory;
        }

        public String getName() {
            return this._name;
        }

        public int getPlannedNum() {
            return this._plannedNum;
        }

        public int getActualNum() {
            return this._actualNum;
        }

        public String getStatus() {
            return this._status;
        }

        public String getCapacity() {
            return this._capacity;
        }

        public boolean isHighlyAvaiable() {
            return this._isHighlyAvaiable;
        }

        public String getDeploymentIsolation() {
            return this._deploymentIsolation;
        }

        public String getInitialJavaHeap() {
            return this._initialJavaHeap;
        }

        public String getMaxJavaHeap() {
            return this._maxJavaHeap;
        }

        public String getMinMemory() {
            return this._minMemory;
        }

        public String getMaxMemory() {
            return this._maxMemory;
        }

        public String getTenant() {
            return this._tenant;
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            return this.equals(wrapper);
        }

        public boolean equals(Object object) {
            if (object instanceof PUDetailsWrapper) {
                return this._name.equals(((PUDetailsWrapper)object).getName()) && this._plannedNum == ((PUDetailsWrapper)object).getPlannedNum() && this._actualNum == ((PUDetailsWrapper)object).getActualNum() && this._status.equals(((PUDetailsWrapper)object).getStatus()) && this._capacity.equals(((PUDetailsWrapper)object).getCapacity()) && this._isHighlyAvaiable == ((PUDetailsWrapper)object).isHighlyAvaiable() && this._deploymentIsolation.equals(((PUDetailsWrapper)object).getDeploymentIsolation()) && this._initialJavaHeap.equals(((PUDetailsWrapper)object).getInitialJavaHeap()) && this._maxJavaHeap.equals(((PUDetailsWrapper)object).getMaxJavaHeap()) && this._tenant.equals(((PUDetailsWrapper)object).getTenant());
            }
            return false;
        }

        public int hashCode() {
            return this._name.hashCode() ^ this._plannedNum ^ this._actualNum ^ this._status.hashCode() ^ this._capacity.hashCode() ^ Boolean.valueOf(this._isHighlyAvaiable).hashCode() ^ this._deploymentIsolation.hashCode() ^ this._initialJavaHeap.hashCode() ^ this._maxJavaHeap.hashCode() ^ this._tenant.hashCode();
        }
    }

    private class CustomizeTableHeader
    extends JTableHeader {
        public CustomizeTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int index = this.columnModel.getColumnIndexAtX(p.x);
            TableColumn tableColumn = this.columnModel.getColumn(index);
            int realIndex = tableColumn.getModelIndex();
            return this.table.getModel().getColumnName(realIndex);
        }
    }

    private class ESMProcessingUnitsCellRenderer
    extends DefaultTableCellRenderer {
        private ESMProcessingUnitsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ImageIcon icon = IconsRepository.getInstance().getIcon(1);
            this.setIcon(icon);
            return this;
        }
    }
}

