/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.hosts;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.views.hosts.ServiceDetailsBox;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.admin.ui.views.utils.LogComponent;
import com.gigaspaces.grid.gsa.AgentProcessDetails;
import com.gigaspaces.grid.gsa.AgentProcessesDetails;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;

public class GSAView
extends JPanel {
    private final ServiceDetailsBox _serviceDetailsBox;
    private GSA _curGSA;
    private ServiceItem _curGSAServiceItem;
    private final BasicTable _gsaAgentsTable;
    private final GSAAgentsTableModel _gsaAgentsTableModel;
    private boolean _isRefresh;
    private static final long TIMEOUT = 1000L;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private final LogComponent _logComponent;
    private final JSplitPane _splitPane;
    private boolean _isDividerLocationSet = false;

    public GSAView(MainUI mainUI) {
        super(new BorderLayout());
        this._serviceDetailsBox = new ServiceDetailsBox(mainUI, "GSA");
        this._gsaAgentsTableModel = new GSAAgentsTableModel();
        this._gsaAgentsTable = new BasicTable(this._gsaAgentsTableModel);
        this.setTableProperties(this._gsaAgentsTable);
        JScrollPane scrollPane = new JScrollPane(this._gsaAgentsTable);
        scrollPane.setBorder(BorderFactory.createTitledBorder("Managed Services"));
        this._logComponent = new LogComponent(mainUI);
        this._splitPane = new JSplitPane(0, scrollPane, this._logComponent);
        this.add((Component)this._serviceDetailsBox, "North");
        this.add((Component)this._splitPane, "Center");
        new RefreshThread("GSA-View-Refresh").start();
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
        this._serviceDetailsBox.setInvokeRefresh(refresh);
        if (!refresh) {
            this._logComponent.cancelTask();
        }
    }

    public void setGSA(ServiceItem gsaServiceItem, String serviceName, String lookupGroups, String lookupLocators, String zones, String gsaOwnerID, long pid, boolean isSecuredService) {
        this._curGSA = (GSA)gsaServiceItem.service;
        this._curGSAServiceItem = gsaServiceItem;
        this._serviceDetailsBox.setService(gsaServiceItem, serviceName, lookupGroups, lookupLocators, zones, null);
        this._logComponent.setService(gsaServiceItem, serviceName, gsaOwnerID, pid, isSecuredService);
        this.updateView();
        if (!this._isDividerLocationSet) {
            this._splitPane.setDividerLocation(0.3);
            this._isDividerLocationSet = true;
        }
    }

    private void updateView() {
        this._gsaAgentsTableModel.clear();
        this._serviceDetailsBox.updateView();
        this.updateRuntimeDetails();
    }

    private void updateRuntimeDetails() {
        block9: {
            try {
                AgentProcessesDetails agentProcessesDetails = this._curGSA.getDetails();
                AgentProcessDetails[] agentProcessDetailsArray = agentProcessesDetails.getProcessDetails();
                Map<Integer, ServiceItem> gsAgentsMap = Repository.getInstance().getGSAgents(this._curGSAServiceItem.serviceID);
                ArrayList<BasicWrapper> gsAgentsList = new ArrayList<BasicWrapper>(agentProcessDetailsArray.length);
                for (AgentProcessDetails agentProcessDetails : agentProcessDetailsArray) {
                    int agentID = agentProcessDetails.getAgentId();
                    String serviceType = agentProcessDetails.getServiceType();
                    long pid = -1L;
                    String upTime = "n/a";
                    String jvmVersion = "n/a";
                    ServiceID agentServiceID = null;
                    long upTimeVal = 0L;
                    String zones = "";
                    if (gsAgentsMap != null) {
                        JVMDetails jvmDetails;
                        ServiceItem agentServiceItem = gsAgentsMap.get(agentID);
                        if (agentServiceItem == null) continue;
                        Object service = agentServiceItem.service;
                        if (service instanceof ServiceRegistrar) {
                            service = ((ServiceRegistrar)service).getRegistrar();
                        }
                        if (service instanceof GridZoneProvider) {
                            zones = JSpaceUtilities.getZonesStringRepresentation((String[])((GridZoneProvider)service).getZones());
                        }
                        if ((jvmDetails = Repository.getInstance().getJVMDetails(agentServiceItem, true)) != null) {
                            pid = jvmDetails.getPid();
                            jvmVersion = jvmDetails.getVmVendor() + " " + jvmDetails.getVmVersion();
                        }
                        upTimeVal = this.getUpTime(agentServiceItem);
                        upTime = JSpaceUIUtils.getFullTimeRepresentation(upTimeVal, false);
                        agentServiceID = agentServiceItem.serviceID;
                    }
                    String agentName = JSpaceUtilities.createServiceName((String)serviceType, (int)agentID, (long)-1L);
                    serviceType = serviceType.toUpperCase();
                    GSAAgentWrapper gsaAgentWrapper = new GSAAgentWrapper(agentServiceID, agentName, serviceType, jvmVersion, upTime, upTimeVal, pid, zones);
                    gsAgentsList.add(gsaAgentWrapper);
                }
                this._gsaAgentsTableModel.setWrappersList(gsAgentsList, true);
            }
            catch (ConnectException ce) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, ce.toString(), ce);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private long getUpTime(ServiceItem serviceItem) throws RemoteException {
        JVMInfoProvider jvmInfoProvider;
        JVMStatistics jvmstatStatistics;
        Object service = serviceItem.service;
        if (service instanceof ServiceRegistrar) {
            service = ((ServiceRegistrar)service).getRegistrar();
        }
        if ((jvmstatStatistics = (jvmInfoProvider = (JVMInfoProvider)service).getJVMStatistics()) == null) {
            return 0L;
        }
        return jvmstatStatistics.getUptime();
    }

    private void clear() {
        this._serviceDetailsBox.clear();
        this._logComponent.clear();
    }

    private class RefreshThread
    extends GSThread {
        public RefreshThread(String name) {
            super(name);
        }

        public void run() {
            while (true) {
                if (GSAView.this._isRefresh) {
                    GSAView.this.updateRuntimeDetails();
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, ie.toString(), ie);
                    continue;
                }
                break;
            }
        }
    }

    private class GSAAgentsTableModel
    extends BasicSortableTableModel {
        private static final String CN_NAME = "Name";
        private static final String CN_TYPE = "Type";
        private static final String CN_PID = "PID";
        private static final String CN_ZONES = "Zones";
        private static final String CN_JVM_VERSION = "JVM Version";
        private static final String CN_UPTIME = "Uptime";
        public static final int CI_NAME_ID = 0;
        public static final int CI_TYPE_ID = 1;
        public static final int CI_PID_ID = 2;
        public static final int CI_ZONES_ID = 3;
        public static final int CI_JVM_VERSION_ID = 4;
        public static final int CI_UPTIME_ID = 5;

        private GSAAgentsTableModel() {
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[6];
            this.columnNames[0] = CN_NAME;
            this.columnNames[1] = CN_TYPE;
            this.columnNames[2] = CN_PID;
            this.columnNames[3] = CN_ZONES;
            this.columnNames[4] = CN_JVM_VERSION;
            this.columnNames[5] = CN_UPTIME;
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            GSAAgentWrapper gsaAgentWrapper = (GSAAgentWrapper)basicWrapper;
            switch (column) {
                case 0: {
                    return gsaAgentWrapper.getName();
                }
                case 1: {
                    return gsaAgentWrapper.getType();
                }
                case 2: {
                    return gsaAgentWrapper.getPid() < 0L ? "n/a" : String.valueOf(gsaAgentWrapper.getPid());
                }
                case 3: {
                    return gsaAgentWrapper.getZones();
                }
                case 4: {
                    return gsaAgentWrapper.getJvmVersion();
                }
                case 5: {
                    return gsaAgentWrapper.getUpTime();
                }
            }
            return "";
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            GSAAgentWrapper gsaAgentWrapper1 = (GSAAgentWrapper)wrapper1;
            GSAAgentWrapper gsaAgentWrapper2 = (GSAAgentWrapper)wrapper2;
            switch (colIndex) {
                case 0: {
                    String name1 = gsaAgentWrapper1.getName();
                    String name2 = gsaAgentWrapper2.getName();
                    if (ascending) {
                        return name1.compareToIgnoreCase(name2);
                    }
                    return name2.compareToIgnoreCase(name1);
                }
                case 1: {
                    String type1 = gsaAgentWrapper1.getType();
                    String type2 = gsaAgentWrapper2.getType();
                    if (ascending) {
                        return type1.compareToIgnoreCase(type2);
                    }
                    return type2.compareToIgnoreCase(type1);
                }
                case 2: {
                    long pid1 = gsaAgentWrapper1.getPid();
                    long pid2 = gsaAgentWrapper2.getPid();
                    if (ascending) {
                        return pid1 < pid2 ? -1 : (pid1 == pid2 ? 0 : 1);
                    }
                    return pid2 < pid1 ? -1 : (pid2 == pid1 ? 0 : 1);
                }
                case 3: {
                    String zones1 = gsaAgentWrapper1.getZones();
                    String zones2 = gsaAgentWrapper2.getZones();
                    if (ascending) {
                        return zones1.compareToIgnoreCase(zones2);
                    }
                    return zones2.compareToIgnoreCase(zones1);
                }
                case 4: {
                    String jvmVersion1 = gsaAgentWrapper1.getJvmVersion();
                    String jvmVersion2 = gsaAgentWrapper2.getJvmVersion();
                    if (ascending) {
                        return jvmVersion1.compareToIgnoreCase(jvmVersion2);
                    }
                    return jvmVersion2.compareToIgnoreCase(jvmVersion1);
                }
                case 5: {
                    long upTime1 = gsaAgentWrapper1.getUpTimeVal();
                    long upTime2 = gsaAgentWrapper2.getUpTimeVal();
                    if (ascending) {
                        return upTime1 < upTime2 ? -1 : (upTime1 == upTime2 ? 0 : 1);
                    }
                    return upTime2 < upTime1 ? -1 : (upTime2 == upTime1 ? 0 : 1);
                }
            }
            return 0;
        }
    }

    private class GSAAgentWrapper
    extends BasicWrapper {
        private ServiceID _agentServiceID;
        private String _name;
        private String _type;
        private String _jvmVersion;
        private String _upTime;
        private long _upTimeVal;
        private long _pid;
        private String _zones;

        public GSAAgentWrapper(ServiceID agentServiceID, String name, String type, String jvmVersion, String upTime, long upTimeLong, long pid, String zones) {
            this._agentServiceID = agentServiceID;
            this._name = name;
            this._type = type;
            this._jvmVersion = jvmVersion;
            this._upTime = upTime;
            this._upTimeVal = upTimeLong;
            this._pid = pid;
            this._zones = zones;
        }

        public String getName() {
            return this._name;
        }

        public ServiceID getAgentServiceID() {
            return this._agentServiceID;
        }

        public String getType() {
            return this._type;
        }

        public String getJvmVersion() {
            return this._jvmVersion;
        }

        public String getUpTime() {
            return this._upTime;
        }

        public long getUpTimeVal() {
            return this._upTimeVal;
        }

        public long getPid() {
            return this._pid;
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            return this.equals(wrapper) && this._upTimeVal == ((GSAAgentWrapper)wrapper).getUpTimeVal();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this._agentServiceID == null ? 0 : this._agentServiceID.hashCode());
            result = 31 * result + (int)(this._pid ^ this._pid >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GSAAgentWrapper other = (GSAAgentWrapper)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this._agentServiceID == null ? other._agentServiceID != null : !this._agentServiceID.equals((Object)other._agentServiceID)) {
                return false;
            }
            return this._pid == other._pid;
        }

        public String getZones() {
            return this._zones;
        }

        private GSAView getOuterType() {
            return GSAView.this;
        }
    }
}

