/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.hosts;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.views.hosts.ServiceDetailsBox;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.admin.ui.views.utils.LogComponent;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.gsm.PUDetails;
import com.gigaspaces.grid.gsm.PUsDetails;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import net.jini.core.lookup.ServiceItem;

public class GSMView
extends JPanel {
    private ServiceDetailsBox _serviceDetailsBox;
    private BasicTable _puServicesTable;
    private PUServicesTableModel _puServicesTableModel;
    private LogComponent _logComponent;
    private GSM _curGSM;
    private JSplitPane _splitPane;
    private boolean _isDividerLocationSet = false;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public GSMView(MainUI mainUI) {
        super(new BorderLayout());
        this._serviceDetailsBox = new ServiceDetailsBox(mainUI, "GSM", true);
        this._puServicesTableModel = new PUServicesTableModel();
        this._puServicesTable = new BasicTable(this._puServicesTableModel);
        this.setTableProperties(this._puServicesTable);
        JScrollPane scrollPane = new JScrollPane(this._puServicesTable);
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)scrollPane, "Center");
        Box buttonsBox = this.createButtonsBox();
        scrollPanel.add((Component)buttonsBox, "North");
        scrollPanel.setBorder(BorderFactory.createTitledBorder("Deployed Processing Units"));
        this._logComponent = new LogComponent(mainUI);
        this._splitPane = new JSplitPane(0, scrollPanel, this._logComponent);
        this.add((Component)this._serviceDetailsBox, "North");
        this.add((Component)this._splitPane, "Center");
    }

    private Box createButtonsBox() {
        Box buttonsBox = new Box(0);
        buttonsBox.setSize(new Dimension(200, 26));
        JButton refreshButton = new JButton("Refresh");
        Dimension buttonSize = new Dimension(85, 22);
        refreshButton.setPreferredSize(buttonSize);
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GSMView.this.updateRuntimeDetails();
            }
        });
        buttonsBox.add(refreshButton);
        buttonsBox.add(Box.createHorizontalGlue());
        return buttonsBox;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    public void setInvokeRefresh(boolean refresh) {
        this._serviceDetailsBox.setInvokeRefresh(refresh);
        if (!refresh) {
            this._logComponent.cancelTask();
        }
    }

    public void setGSM(ServiceItem gsmServiceItem, String serviceName, String lookupGroups, String lookupLocators, String zones, String gsaOwnerID, long pid, boolean isSecuredService) {
        this._curGSM = (GSM)gsmServiceItem.service;
        this._serviceDetailsBox.setService(gsmServiceItem, serviceName, lookupGroups, lookupLocators, zones, null);
        this._logComponent.setService(gsmServiceItem, serviceName, gsaOwnerID, pid, isSecuredService);
        this.updateView();
        if (!this._isDividerLocationSet) {
            this._splitPane.setDividerLocation(0.3);
            this._isDividerLocationSet = true;
        }
    }

    private void updateView() {
        this._puServicesTableModel.clear();
        this._serviceDetailsBox.updateView();
        this.updateRuntimeDetails();
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public void updateRuntimeDetails() {
        block6: {
            if (this._curGSM == null) {
                this.clear();
                return;
            }
            try {
                PUsDetails pusDetails = this._curGSM.getPUsDetails();
                PUDetails[] puDetailsArray = pusDetails.getDetails();
                ArrayList<BasicWrapper> list = new ArrayList<BasicWrapper>(puDetailsArray.length);
                for (int index = 0; index < puDetailsArray.length; ++index) {
                    list.add(new PUDetailsWrapper(puDetailsArray[index]));
                }
                this._puServicesTableModel.setWrappersList(list, false);
            }
            catch (ConnectException ce) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, ce.toString(), ce);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void clear() {
        this._serviceDetailsBox.clear();
        this._logComponent.clear();
        this._puServicesTableModel.clear();
    }

    private class PUServicesTableModel
    extends BasicSortableTableModel {
        private final String CN_NAME = "Name";
        private final String CN_NUM_OF_INSTANCES = "Planned Instances";
        private final String CN_NUM_OF_BACKUPS = "Planned Backups";
        public static final int CI_NAME_ID = 0;
        public static final int CI_NUM_OF_INSTANCES_ID = 1;
        public static final int CI_NUM_OF_BACKUPS_ID = 2;

        private PUServicesTableModel() {
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[3];
            this.columnNames[0] = "Name";
            this.columnNames[1] = "Planned Instances";
            this.columnNames[2] = "Planned Backups";
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            PUDetailsWrapper puDetailsWrapper = (PUDetailsWrapper)basicWrapper;
            switch (column) {
                case 0: {
                    return puDetailsWrapper.getName();
                }
                case 1: {
                    return "" + puDetailsWrapper.getNumOfInstances();
                }
                case 2: {
                    return "" + puDetailsWrapper.getNumOfBackups();
                }
            }
            return "";
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            PUDetailsWrapper puDetailsWrapper1 = (PUDetailsWrapper)wrapper1;
            PUDetailsWrapper puDetailsWrapper2 = (PUDetailsWrapper)wrapper2;
            switch (colIndex) {
                case 0: {
                    String name1 = puDetailsWrapper1.getName();
                    String name2 = puDetailsWrapper2.getName();
                    if (ascending) {
                        return name1.compareToIgnoreCase(name2);
                    }
                    return name2.compareToIgnoreCase(name1);
                }
                case 1: {
                    int numOfInstances1 = puDetailsWrapper1.getNumOfInstances();
                    int numOfInstances2 = puDetailsWrapper2.getNumOfInstances();
                    if (ascending) {
                        return numOfInstances1 < numOfInstances2 ? -1 : (numOfInstances1 == numOfInstances2 ? 0 : 1);
                    }
                    return numOfInstances2 < numOfInstances1 ? -1 : (numOfInstances2 == numOfInstances1 ? 0 : 1);
                }
                case 2: {
                    int numOfBackups1 = puDetailsWrapper1.getNumOfBackups();
                    int numOfBackups2 = puDetailsWrapper2.getNumOfBackups();
                    if (ascending) {
                        return numOfBackups1 < numOfBackups2 ? -1 : (numOfBackups1 == numOfBackups2 ? 0 : 1);
                    }
                    return numOfBackups2 < numOfBackups1 ? -1 : (numOfBackups2 == numOfBackups1 ? 0 : 1);
                }
            }
            return 0;
        }
    }

    private class PUDetailsWrapper
    extends BasicWrapper {
        private String _name;
        private int _numOfInstances;
        private int _numOfBackups;

        public PUDetailsWrapper(PUDetails puDetails) {
            this._name = puDetails.getName();
            this._numOfInstances = puDetails.getNumberOfInstances();
            this._numOfBackups = puDetails.getNumberOfBackups();
        }

        public String getName() {
            return this._name;
        }

        public int getNumOfInstances() {
            return this._numOfInstances;
        }

        public int getNumOfBackups() {
            return this._numOfBackups;
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            return this.equals(wrapper);
        }

        public boolean equals(Object object) {
            if (object instanceof PUDetailsWrapper) {
                return this._name.equals(((PUDetailsWrapper)object).getName()) && this._numOfInstances == ((PUDetailsWrapper)object).getNumOfInstances() && this._numOfBackups == ((PUDetailsWrapper)object).getNumOfBackups();
            }
            return false;
        }

        public int hashCode() {
            return this._name.hashCode() + this._numOfInstances + this._numOfBackups;
        }
    }
}

