/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.hosts;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.views.hosts.HostsTree;
import com.gigaspaces.admin.ui.views.hosts.ServiceDetailsBox;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSInfoProvider;
import com.gigaspaces.internal.os.OSStatistics;
import com.j_spaces.kernel.JSpaceUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.ConnectException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;

public class HostView
extends Box {
    private JTextField _ipAddressTextField;
    private JTextField _processorArchitectureTextField;
    private JTextField _numberOfProcessorsTextField;
    private JTextField _operSystemTextField;
    private JTextField _physicalMemoryTextField;
    private JTextField _cpuUtilizationTextField;
    private JTextField _memoryUtilizationTextField;
    private BasicTable _gsServicesTable;
    private ServicesTableModel _servicesTableModel;
    private DefaultMutableTreeNode _curHostTreeRoot;
    private static DecimalFormat nf = new DecimalFormat();
    private static final Dimension labelSize;
    private static final Dimension maxLabelSize;
    private static final Dimension labelSize2;
    private static final Dimension textFieldSize;
    private static final Dimension maxTextFieldSize;
    private static final Dimension minTextFieldSize;
    private static final int LEFT_ALLIGN = 3;
    private boolean _isRefresh;
    private MainUI _mainUI;
    private final long TIMEOUT = 1000L;
    private final Map<ServiceID, JVMStatistics> jvmStatisticsHistory = new ConcurrentHashMap<ServiceID, JVMStatistics>();
    private static final Logger LOGGER;

    public HostView(MainUI mainUI) {
        super(1);
        this._mainUI = mainUI;
        this.init();
        new RefreshThread("GS-Host-View-Refresh").start();
    }

    private void init() {
        JLabel ipAddressLabel = this.createLabel("IP Address:");
        this._ipAddressTextField = this.createTextField();
        Box ipAddressBox = new Box(0);
        ipAddressBox.add(Box.createHorizontalStrut(3));
        ipAddressBox.add(ipAddressLabel);
        ipAddressBox.add(this._ipAddressTextField);
        ipAddressBox.add(Box.createHorizontalGlue());
        JLabel processorArchitectureLabel = this.createLabel("Processor Architecture:");
        this._processorArchitectureTextField = this.createTextField();
        Box processorArchitectureBox = new Box(0);
        processorArchitectureBox.add(Box.createHorizontalStrut(3));
        processorArchitectureBox.add(processorArchitectureLabel);
        processorArchitectureBox.add(this._processorArchitectureTextField);
        processorArchitectureBox.add(Box.createHorizontalGlue());
        JLabel numberOfProcessorsLabel = this.createLabel("Number of Processors:");
        this._numberOfProcessorsTextField = this.createTextField();
        Box numberOfProcessorsBox = new Box(0);
        numberOfProcessorsBox.add(Box.createHorizontalStrut(3));
        numberOfProcessorsBox.add(numberOfProcessorsLabel);
        numberOfProcessorsBox.add(this._numberOfProcessorsTextField);
        numberOfProcessorsBox.add(Box.createHorizontalGlue());
        JLabel operSystemLabel = this.createLabel("Operating System:");
        this._operSystemTextField = this.createTextField();
        Box operSystemBox = new Box(0);
        operSystemBox.add(Box.createHorizontalStrut(3));
        operSystemBox.add(operSystemLabel);
        operSystemBox.add(this._operSystemTextField);
        operSystemBox.add(Box.createHorizontalGlue());
        JLabel physicalMemoryLabel = this.createLabel("Physical Memory (MB):");
        this._physicalMemoryTextField = this.createTextField();
        Box physicalMemoryBox = new Box(0);
        physicalMemoryBox.add(Box.createHorizontalStrut(3));
        physicalMemoryBox.add(physicalMemoryLabel);
        physicalMemoryBox.add(this._physicalMemoryTextField);
        physicalMemoryBox.add(Box.createHorizontalGlue());
        Box runtimeInformationBox = this.initRuntimeInformationSection();
        JPanel servicesPanel = this.initServicesTable();
        this.add(Box.createVerticalStrut(3));
        this.add(ipAddressBox);
        this.add(Box.createVerticalStrut(3));
        this.add(processorArchitectureBox);
        this.add(Box.createVerticalStrut(3));
        this.add(numberOfProcessorsBox);
        this.add(Box.createVerticalStrut(3));
        this.add(operSystemBox);
        this.add(Box.createVerticalStrut(3));
        this.add(physicalMemoryBox);
        this.add(Box.createVerticalStrut(5));
        this.add(runtimeInformationBox);
        this.add(Box.createVerticalStrut(4));
        this.add(servicesPanel);
        this.add(Box.createVerticalGlue());
    }

    private Box initRuntimeInformationSection() {
        Box runtimeInfoBox = new Box(1);
        JLabel cpuUtilizationLabel = this.createLabel2("CPU Utilization:");
        this._cpuUtilizationTextField = this.createTextField();
        Box cpuUtilizationBox = new Box(0);
        cpuUtilizationBox.add(Box.createHorizontalStrut(3));
        cpuUtilizationBox.add(cpuUtilizationLabel);
        cpuUtilizationBox.add(this._cpuUtilizationTextField);
        cpuUtilizationBox.add(Box.createHorizontalGlue());
        JLabel memoryUtilizationLabel = this.createLabel2("Memory Utilization:");
        this._memoryUtilizationTextField = this.createTextField();
        Box memoryUtilizationBox = new Box(0);
        memoryUtilizationBox.add(Box.createHorizontalStrut(3));
        memoryUtilizationBox.add(memoryUtilizationLabel);
        memoryUtilizationBox.add(this._memoryUtilizationTextField);
        memoryUtilizationBox.add(Box.createHorizontalGlue());
        runtimeInfoBox.add(cpuUtilizationBox);
        runtimeInfoBox.add(Box.createVerticalStrut(5));
        runtimeInfoBox.add(memoryUtilizationBox);
        runtimeInfoBox.add(Box.createVerticalStrut(4));
        runtimeInfoBox.setBorder(BorderFactory.createTitledBorder("Runtime Information"));
        return runtimeInfoBox;
    }

    private JPanel initServicesTable() {
        this._servicesTableModel = new ServicesTableModel();
        this._gsServicesTable = new BasicTable(this._servicesTableModel);
        this.setTableProperties(this._gsServicesTable);
        JScrollPane scrollPane = new JScrollPane(this._gsServicesTable);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scrollPane, "Center");
        scrollPane.setBorder(BorderFactory.createTitledBorder("Grid Services Running on host"));
        return tablePanel;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn nameTableColumn = tableColumnModel.getColumn(0);
        nameTableColumn.setPreferredWidth(55);
        nameTableColumn.setMaxWidth(55);
        TableColumn typeTableColumn = tableColumnModel.getColumn(1);
        typeTableColumn.setPreferredWidth(50);
        typeTableColumn.setMaxWidth(50);
        TableColumn managedByGSATableColumn = tableColumnModel.getColumn(10);
        managedByGSATableColumn.setPreferredWidth(110);
        managedByGSATableColumn.setMaxWidth(110);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        textField.setEditable(false);
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    private JLabel createLabel2(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize2);
        label.setMinimumSize(labelSize2);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
    }

    public void setHostTreeRoot(DefaultMutableTreeNode hostTreeRoot) {
        this._curHostTreeRoot = hostTreeRoot;
        this.updateView();
    }

    private void updateView() {
        if (this._curHostTreeRoot == null) {
            this.clear();
            return;
        }
        this._servicesTableModel.clear();
        int childCounts = this._curHostTreeRoot.getChildCount();
        if (childCounts > 0) {
            DefaultMutableTreeNode serviceNode = (DefaultMutableTreeNode)this._curHostTreeRoot.getChildAt(0);
            HostsTree.ServiceTreeObject serviceTreeObject = (HostsTree.ServiceTreeObject)serviceNode.getUserObject();
            this.updateOSDetails(serviceTreeObject.getServiceItem().service);
        }
        this.updateRuntimeDetails();
    }

    private synchronized void updateRuntimeDetails() {
        if (this._curHostTreeRoot == null) {
            return;
        }
        int childCount = this._curHostTreeRoot.getChildCount();
        ArrayList<BasicWrapper> serviceObjectsList = new ArrayList<BasicWrapper>(childCount);
        HashSet<Long> pidsSet = new HashSet<Long>(childCount);
        for (int index = 0; index < this._curHostTreeRoot.getChildCount(); ++index) {
            long pid;
            HostsTree.ServiceTreeObject serviceTreeObject;
            block6: {
                DefaultMutableTreeNode serviceNode = (DefaultMutableTreeNode)this._curHostTreeRoot.getChildAt(index);
                HostsTree.ServiceTreeObject serviceTreeObjectOrig = (HostsTree.ServiceTreeObject)serviceNode.getUserObject();
                serviceTreeObjectOrig.initilizeLazyFieldsIfNeeded();
                serviceTreeObject = (HostsTree.ServiceTreeObject)serviceTreeObjectOrig.clone();
                if (index == 0) {
                    this.updateRuntimeInformation(serviceTreeObject.getServiceItem());
                }
                if (pidsSet.contains(pid = serviceTreeObject.getPid())) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            this.updateMemoryAndCpuConsumptionInformation(serviceTreeObject.getServiceItem(), serviceTreeObject);
            pidsSet.add(pid);
            serviceObjectsList.add(serviceTreeObject);
        }
        this._servicesTableModel.setWrappersList(serviceObjectsList, true);
    }

    public void updateRuntimeInformation(ServiceItem serviceItem) {
        block9: {
            Object service = serviceItem.service;
            if (service instanceof ServiceRegistrar) {
                service = ((ServiceRegistrar)service).getRegistrar();
            }
            try {
                OSStatistics osStatistics = ((OSInfoProvider)service).getOSStatistics();
                OSDetails osDetails = Repository.getInstance().getOSDetails(serviceItem, true);
                long totalPhysicalMemorySize = osDetails == null ? -1L : osDetails.getTotalPhysicalMemorySize();
                double cpuPerc = -1.0;
                String memoryUtil = "n/a";
                if (osStatistics != null) {
                    cpuPerc = osStatistics.getCpuPerc();
                    if (totalPhysicalMemorySize >= 0L) {
                        double usedMemoryPerc = osStatistics.getUsedMemoryPerc();
                        long usedMemoryInBytes = osStatistics.getActualMemoryUsed();
                        double totalMemoryInGB = (double)totalPhysicalMemorySize / 1024.0 / 1024.0 / 1024.0;
                        double usedMemoryInGB = (double)usedMemoryInBytes / 1024.0 / 1024.0 / 1024.0;
                        String percent = HostView.getMemoryPercUsage(usedMemoryPerc);
                        memoryUtil = usedMemoryPerc < 0.0 || usedMemoryInBytes < 0L ? "n/a" : nf.format(usedMemoryInGB) + " of " + nf.format(totalMemoryInGB) + " GB [" + percent + "%]";
                    }
                }
                this._memoryUtilizationTextField.setText(memoryUtil);
                if (cpuPerc < 0.0) {
                    this._cpuUtilizationTextField.setText("n/a");
                } else {
                    this._cpuUtilizationTextField.setText("" + nf.format(cpuPerc * 100.0) + "%");
                }
            }
            catch (ConnectException ce) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, ce.toString(), ce);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public void updateMemoryAndCpuConsumptionInformation(ServiceItem serviceItem, HostsTree.ServiceTreeObject serviceTreeObject) {
        block8: {
            Object service = serviceItem.service;
            if (service instanceof ServiceRegistrar) {
                service = ((ServiceRegistrar)service).getRegistrar();
            }
            try {
                JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(serviceItem, true);
                JVMStatistics jvmStatistics = ((JVMInfoProvider)service).getJVMStatistics();
                long memoryHeapMax = jvmDetails == null ? -1L : jvmDetails.getMemoryHeapMax();
                String memoryUtil = "n/a";
                String cpuUtil = "n/a";
                long memoryHeapUsed = -1L;
                double cpuUsed = -1.0;
                if (jvmStatistics != null) {
                    JVMStatistics lastJvmStatistics;
                    if (memoryHeapMax >= 0L) {
                        memoryHeapUsed = jvmStatistics.getMemoryHeapUsed();
                        double usedMemoryInMB = (double)memoryHeapUsed / 1024.0 / 1024.0;
                        double memoryHeapMaxInMB = (double)memoryHeapMax / 1024.0 / 1024.0;
                        String percent = HostView.getMemoryPercUsage(memoryHeapMax, memoryHeapMax - memoryHeapUsed);
                        memoryUtil = nf.format(usedMemoryInMB) + " of " + nf.format(memoryHeapMaxInMB) + " [" + percent + "%]";
                    }
                    if (serviceItem.serviceID != null && (lastJvmStatistics = this.jvmStatisticsHistory.put(serviceItem.serviceID, jvmStatistics)) != null && (cpuUsed = jvmStatistics.computeCpuPerc(lastJvmStatistics)) != -1.0) {
                        cpuUtil = nf.format(cpuUsed * 100.0);
                    }
                }
                serviceTreeObject.setMemoryUsed(memoryHeapUsed);
                serviceTreeObject.setMemoryUtil(memoryUtil);
                serviceTreeObject.setCpuUsed(cpuUsed);
                serviceTreeObject.setCpuUtil(cpuUtil);
            }
            catch (ConnectException ce) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, ce.toString(), ce);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public static String getMemoryPercUsage(long totalPhysicalMemorySize, long freePhysicalMemorySize) {
        return HostView.getMemoryPercUsage((double)(totalPhysicalMemorySize - freePhysicalMemorySize) * 100.0 / (double)totalPhysicalMemorySize);
    }

    public static String getMemoryPercUsage(double usedMemoryPerc) {
        return usedMemoryPerc < 0.0 ? "n/a" : nf.format(usedMemoryPerc);
    }

    public void updateOSDetails(Object service) {
        block5: {
            Object localService = service;
            if (service instanceof ServiceRegistrar) {
                localService = ((ServiceRegistrar)service).getRegistrar();
            }
            try {
                OSDetails osDetails = ((OSInfoProvider)localService).getOSDetails();
                this.setBorder(BorderFactory.createTitledBorder("Summary for " + osDetails.getHostName()));
                this._processorArchitectureTextField.setText(osDetails.getArch());
                this._numberOfProcessorsTextField.setText("" + osDetails.getAvailableProcessors());
                this._operSystemTextField.setText(osDetails.getName() + " " + osDetails.getVersion());
                String hostAddress = osDetails.getHostAddress();
                this._ipAddressTextField.setText(hostAddress);
                long totalMemorySize = osDetails.getTotalPhysicalMemorySize();
                this._physicalMemoryTextField.setText(ServiceDetailsBox.getMemorySizeInMB(totalMemorySize));
            }
            catch (ConnectException ce) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, ce.toString(), ce);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void clear() {
        this._ipAddressTextField.setText("");
        this._processorArchitectureTextField.setText("");
        this._numberOfProcessorsTextField.setText("");
        this._operSystemTextField.setText("");
        this._physicalMemoryTextField.setText("");
        this._cpuUtilizationTextField.setText("");
        this._memoryUtilizationTextField.setText("");
        this._servicesTableModel.clear();
    }

    static {
        nf.setMaximumFractionDigits(1);
        labelSize = new Dimension(170, 21);
        maxLabelSize = new Dimension(470, 21);
        labelSize2 = new Dimension(166, 21);
        textFieldSize = new Dimension(310, 23);
        maxTextFieldSize = new Dimension(750, 23);
        minTextFieldSize = new Dimension(20, 23);
        LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    }

    private class ServicesTableModel
    extends BasicSortableTableModel {
        private static final String CN_NAME = "Name";
        private static final String CN_TYPE = "Type";
        private static final String CN_PID = "PID";
        private static final String CN_LOOKUP_GROUPS = "Lookup Groups";
        private static final String CN_LOOKUP_LOCATORS = "Lookup Locators";
        private static final String CN_ZONES = "Zones";
        private static final String CN_MEMORY_UTIL = "Used Memory (MB)";
        private static final String CN_CPU_UTIL = "Used CPU (%)";
        private static final String CN_SERVICE_ID = "Service ID";
        private static final String CN_JVM_VERSION = "JVM Version";
        private static final String CN_MANAGED_BY_GSA = "Managed by GSA";
        public static final int CI_NAME_ID = 0;
        public static final int CI_TYPE_ID = 1;
        public static final int CI_PID_ID = 2;
        public static final int CI_LOOKUP_GROUPS = 3;
        public static final int CI_LOOKUP_LOCATORS = 4;
        public static final int CI_ZONES = 5;
        public static final int CI_MEMORY_UTIL = 6;
        public static final int CI_CPU_UTIL = 7;
        public static final int CI_SERVICE_ID = 8;
        public static final int CI_JVM_VERSION_ID = 9;
        public static final int CI_MANAGED_BY_GSA_ID = 10;

        private ServicesTableModel() {
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[11];
            this.columnNames[0] = CN_NAME;
            this.columnNames[1] = CN_TYPE;
            this.columnNames[2] = CN_PID;
            this.columnNames[3] = CN_LOOKUP_GROUPS;
            this.columnNames[4] = CN_LOOKUP_LOCATORS;
            this.columnNames[5] = CN_ZONES;
            this.columnNames[6] = CN_MEMORY_UTIL;
            this.columnNames[7] = CN_CPU_UTIL;
            this.columnNames[8] = CN_SERVICE_ID;
            this.columnNames[9] = CN_JVM_VERSION;
            this.columnNames[10] = CN_MANAGED_BY_GSA;
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            HostsTree.ServiceTreeObject serviceTreeObject = (HostsTree.ServiceTreeObject)basicWrapper;
            switch (column) {
                case 0: {
                    return JSpaceUtilities.createServiceName((String)serviceTreeObject.getLabel().toLowerCase(), (int)serviceTreeObject.getGSAgentID(), (long)-1L);
                }
                case 1: {
                    return serviceTreeObject.getLabel();
                }
                case 2: {
                    return serviceTreeObject.getPid() < 0L ? "n/a" : String.valueOf(serviceTreeObject.getPid());
                }
                case 8: {
                    return serviceTreeObject.getServiceItem().serviceID;
                }
                case 3: {
                    return serviceTreeObject.getLookupGroups();
                }
                case 4: {
                    return serviceTreeObject.getLookupLocators();
                }
                case 5: {
                    return serviceTreeObject.getZones();
                }
                case 6: {
                    return serviceTreeObject.getMemoryUsed() < 0L ? "n/a" : serviceTreeObject.getMemoryUtil();
                }
                case 7: {
                    return serviceTreeObject.getCpuUsed() < 0.0 ? "n/a" : serviceTreeObject.getCpuUtil();
                }
                case 9: {
                    return serviceTreeObject.getJVMVersion();
                }
                case 10: {
                    return serviceTreeObject.isManagedByGSA() ? "Yes" : "No";
                }
            }
            return "";
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            HostsTree.ServiceTreeObject serviceTreeObject1 = (HostsTree.ServiceTreeObject)wrapper1;
            HostsTree.ServiceTreeObject serviceTreeObject2 = (HostsTree.ServiceTreeObject)wrapper2;
            switch (colIndex) {
                case 0: {
                    String name1 = JSpaceUtilities.createServiceName((String)serviceTreeObject1.getLabel().toLowerCase(), (int)serviceTreeObject1.getGSAgentID(), (long)-1L);
                    String name2 = JSpaceUtilities.createServiceName((String)serviceTreeObject2.getLabel().toLowerCase(), (int)serviceTreeObject2.getGSAgentID(), (long)-1L);
                    if (ascending) {
                        return name1.compareToIgnoreCase(name2);
                    }
                    return name2.compareToIgnoreCase(name1);
                }
                case 1: {
                    String label1 = serviceTreeObject1.getLabel();
                    String label2 = serviceTreeObject2.getLabel();
                    if (ascending) {
                        return label1.compareToIgnoreCase(label2);
                    }
                    return label2.compareToIgnoreCase(label1);
                }
                case 2: {
                    long pid1 = serviceTreeObject1.getPid();
                    long pid2 = serviceTreeObject2.getPid();
                    if (ascending) {
                        return pid1 < pid2 ? -1 : (pid1 == pid2 ? 0 : 1);
                    }
                    return pid2 < pid1 ? -1 : (pid2 == pid1 ? 0 : 1);
                }
                case 8: {
                    String serviceId1 = serviceTreeObject1.getServiceItem().serviceID.toString();
                    String serviceId2 = serviceTreeObject2.getServiceItem().serviceID.toString();
                    if (ascending) {
                        return serviceId1.compareToIgnoreCase(serviceId2);
                    }
                    return serviceId2.compareToIgnoreCase(serviceId1);
                }
                case 3: {
                    String lookupGroups1 = serviceTreeObject1.getLookupGroups();
                    String lookupGroups2 = serviceTreeObject2.getLookupGroups();
                    if (ascending) {
                        return lookupGroups1.compareToIgnoreCase(lookupGroups2);
                    }
                    return lookupGroups2.compareToIgnoreCase(lookupGroups1);
                }
                case 4: {
                    String lookupLocators1 = serviceTreeObject1.getLookupLocators();
                    String lookupLocators2 = serviceTreeObject2.getLookupLocators();
                    if (ascending) {
                        return lookupLocators1.compareToIgnoreCase(lookupLocators2);
                    }
                    return lookupLocators2.compareToIgnoreCase(lookupLocators1);
                }
                case 5: {
                    String zones1 = serviceTreeObject1.getZones();
                    String zones2 = serviceTreeObject2.getZones();
                    if (ascending) {
                        return zones1.compareToIgnoreCase(zones2);
                    }
                    return zones2.compareToIgnoreCase(zones1);
                }
                case 6: {
                    long memoryUsed1 = serviceTreeObject1.getMemoryUsed();
                    long memoryUsed2 = serviceTreeObject2.getMemoryUsed();
                    if (ascending) {
                        return memoryUsed1 < memoryUsed2 ? -1 : (memoryUsed1 == memoryUsed2 ? 0 : 1);
                    }
                    return memoryUsed2 < memoryUsed1 ? -1 : (memoryUsed2 == memoryUsed1 ? 0 : 1);
                }
                case 7: {
                    double cpuUsed1 = serviceTreeObject1.getCpuUsed();
                    double cpuUsed2 = serviceTreeObject2.getCpuUsed();
                    if (ascending) {
                        return cpuUsed1 < cpuUsed2 ? -1 : (cpuUsed1 == cpuUsed2 ? 0 : 1);
                    }
                    return cpuUsed2 < cpuUsed1 ? -1 : (cpuUsed2 == cpuUsed1 ? 0 : 1);
                }
                case 9: {
                    String jvmVersion1 = serviceTreeObject1.getJVMVersion();
                    String jvmversion2 = serviceTreeObject2.getJVMVersion();
                    if (ascending) {
                        return jvmVersion1.compareToIgnoreCase(jvmversion2);
                    }
                    return jvmversion2.compareToIgnoreCase(jvmVersion1);
                }
                case 10: {
                    boolean isManagedByGSA1 = serviceTreeObject1.isManagedByGSA();
                    boolean isManagedByGSA2 = serviceTreeObject2.isManagedByGSA();
                    if (ascending) {
                        return Boolean.valueOf(isManagedByGSA1).compareTo(isManagedByGSA2);
                    }
                    return Boolean.valueOf(isManagedByGSA2).compareTo(isManagedByGSA1);
                }
            }
            return 0;
        }
    }

    private class RefreshThread
    extends Thread {
        public RefreshThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                if (HostView.this._isRefresh) {
                    HostView.this.updateRuntimeDetails();
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, ie.toString(), ie);
                    continue;
                }
                break;
            }
        }
    }
}

