/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.hosts;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.ServiceNotificationListener;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.ServicesDumpDialog;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.admin.ui.views.hosts.HostsViewPanel;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.grid.esm.ESM;
import com.gigaspaces.grid.gsa.AgentIdAware;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsa.GSProcessOptions;
import com.gigaspaces.grid.gsa.GlobalProcessAlreadyRunningIOException;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JConsoleUIUtils;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;

public class HostsTree
implements ServiceNotificationListener {
    private final SortedTreeModel _treeModel;
    private final JTree _tree;
    public static DefaultMutableTreeNode _rootNode;
    public static DefaultMutableTreeNode _utilizationNode;
    private final HostsViewPanel _hostViewPanel;
    private final Map<String, DefaultMutableTreeNode> _hostRootsMap = new HashMap<String, DefaultMutableTreeNode>();
    private final Map<ServiceID, DefaultMutableTreeNode> _serviceNodesMap = new HashMap<ServiceID, DefaultMutableTreeNode>();
    private static Logger LOGGER;
    private final JFrame _parentFrame;

    public HostsTree(JFrame parentFrame, HostsViewPanel hostViewPanel) {
        this._parentFrame = parentFrame;
        _rootNode = new DefaultMutableTreeNode("Hosts");
        _utilizationNode = new DefaultMutableTreeNode("Utilization");
        this._treeModel = new SortedTreeModel(_rootNode);
        this._tree = new JTree(this._treeModel);
        this._hostViewPanel = hostViewPanel;
        this._tree.setCellRenderer(new TreeRenderer());
        this._tree.addMouseListener(new HostsServicesTreeMouseListener());
        this._treeModel.insertNodeInto(_utilizationNode, _rootNode, 0);
        this._tree.expandRow(0);
    }

    public JTree getTree() {
        return this._tree;
    }

    public void selectRoot() {
        this._tree.setSelectionRow(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceAdded(ServiceItem serviceItem) {
        block8: {
            Object service = serviceItem.service;
            if (service instanceof ServiceRegistrar) {
                ServiceRegistrar serviceRegistrar = (ServiceRegistrar)service;
                service = serviceRegistrar.getRegistrar();
            }
            if (service instanceof NIOInfoProvider && (serviceItem.service instanceof ServiceRegistrar || service instanceof GSA || service instanceof GSM || service instanceof GSC || service instanceof ESM)) {
                try {
                    String hostName = JSpaceUtilities.retriveHostName((NIOInfoProvider)((NIOInfoProvider)service));
                    DefaultMutableTreeNode hostNode = this._hostRootsMap.get(hostName);
                    if (hostNode == null) {
                        HostTreeObject hostTreeObject = new HostTreeObject(hostName);
                        hostNode = new DefaultMutableTreeNode(hostTreeObject);
                        this._hostRootsMap.put(hostName, hostNode);
                        SortedTreeModel sortedTreeModel = this._treeModel;
                        synchronized (sortedTreeModel) {
                            this._treeModel.insertNodeInto(hostNode, _rootNode, _rootNode.getChildCount());
                        }
                    }
                    this.addServiceNodeToHostNode(serviceItem, hostNode);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    public boolean isServicesDisplayed() {
        return this._hostRootsMap.size() > 0;
    }

    public int getHostsCount() {
        return this._hostRootsMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceNodeToHostNode(ServiceItem serviceItem, DefaultMutableTreeNode hostNode) {
        int childIndex;
        int servicesCount;
        long pid;
        ServiceTreeObject serviceUserObject = null;
        Object service = serviceItem.service;
        if (service instanceof GSM) {
            serviceUserObject = new GSMTreeObject(serviceItem);
            pid = serviceUserObject.getPid();
            servicesCount = hostNode.getChildCount();
            for (childIndex = 0; childIndex < servicesCount; ++childIndex) {
                DefaultMutableTreeNode serviceTreeNode = (DefaultMutableTreeNode)hostNode.getChildAt(childIndex);
                ServiceTreeObject childServiceTreeObject = (ServiceTreeObject)serviceTreeNode.getUserObject();
                if (!(childServiceTreeObject instanceof LUSTreeObject) || childServiceTreeObject.getPid() != pid) continue;
                LUSTreeObject lusTreeObject = (LUSTreeObject)childServiceTreeObject;
                lusTreeObject.setGsmOwnerTreeObject((GSMTreeObject)serviceUserObject);
                break;
            }
        } else if (service instanceof GSC) {
            serviceUserObject = new GSCTreeObject(serviceItem);
        } else if (service instanceof GSA) {
            serviceUserObject = new GSATreeObject(serviceItem);
        } else if (service instanceof ESM) {
            serviceUserObject = new ESMTreeObject(serviceItem);
        } else if (service instanceof ServiceRegistrar) {
            serviceUserObject = new LUSTreeObject(serviceItem);
            pid = serviceUserObject.getPid();
            servicesCount = hostNode.getChildCount();
            for (childIndex = 0; childIndex < servicesCount; ++childIndex) {
                DefaultMutableTreeNode serviceTreeNode = (DefaultMutableTreeNode)hostNode.getChildAt(childIndex);
                ServiceTreeObject childServiceTreeObject = (ServiceTreeObject)serviceTreeNode.getUserObject();
                if (!(childServiceTreeObject instanceof GSMTreeObject) || childServiceTreeObject.getPid() != pid) continue;
                GSMTreeObject gsmTreeObject = (GSMTreeObject)childServiceTreeObject;
                ((LUSTreeObject)serviceUserObject).setGsmOwnerTreeObject(gsmTreeObject);
                break;
            }
        }
        if (serviceUserObject != null) {
            DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(serviceUserObject);
            HostTreeObject hostTreeObject = (HostTreeObject)hostNode.getUserObject();
            String hostName = hostTreeObject.getHostName();
            serviceUserObject.setHostName(hostName);
            SortedTreeModel sortedTreeModel = this._treeModel;
            synchronized (sortedTreeModel) {
                this._treeModel.insertNodeInto(serviceNode, hostNode);
                this._serviceNodesMap.put(serviceItem.serviceID, serviceNode);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "---Service was added to Hosts tree, host name:" + hostName + ", added service id:" + serviceItem.serviceID + " , service instance:" + service + " thread id=" + Thread.currentThread().getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void serviceRemoved(ServiceItem serviceItem) {
        block8: {
            try {
                DefaultMutableTreeNode serviceNode = this._serviceNodesMap.remove(serviceItem.serviceID);
                if (serviceNode == null) break block8;
                DefaultMutableTreeNode hostNode = (DefaultMutableTreeNode)serviceNode.getParent();
                int childCount = hostNode.getChildCount();
                boolean deleteHostNode = childCount <= 1;
                SortedTreeModel sortedTreeModel = this._treeModel;
                synchronized (sortedTreeModel) {
                    this._treeModel.removeNodeFromParent(serviceNode);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Child count for host" + hostNode + " " + childCount + " is deletete Host Node=" + deleteHostNode);
                        LOGGER.log(Level.FINE, "---Service was removed from Hosts tree, host name:" + ((HostTreeObject)hostNode.getUserObject()).getHostName() + ", added service id:" + serviceItem.serviceID + " , service instance:" + serviceItem.service + " thread id=" + Thread.currentThread().getId() + "   Call stack:" + JSpaceUtilities.getStackTrace((Throwable)new Exception("FINE DEBUG")));
                    }
                    if (deleteHostNode) {
                        HostTreeObject hostTreeObject = (HostTreeObject)hostNode.getUserObject();
                        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)hostNode.getParent();
                        this._treeModel.removeNodeFromParent(hostNode);
                        String hostName = hostTreeObject.getHostName();
                        this._hostRootsMap.remove(hostName);
                        TreePath selectionPath = this._tree.getSelectionPath();
                        if (selectionPath == null || JSpaceUIUtils.isTreeNodeInPath(selectionPath, hostNode)) {
                            this._hostViewPanel.handleSelectedNode(parentNode, true);
                        }
                    }
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
    }

    @Override
    public void serviceChanged(ServiceItem item) {
    }

    public List<ServiceTreeObject> getHostsServicesObjects() {
        ArrayList<ServiceTreeObject> serviceTreeObjectsList = new ArrayList<ServiceTreeObject>(_rootNode.getChildCount());
        for (int index = 0; index < _rootNode.getChildCount(); ++index) {
            DefaultMutableTreeNode serviceNode = (DefaultMutableTreeNode)_rootNode.getChildAt(index);
            if (serviceNode.equals(_utilizationNode) || serviceNode.getChildCount() <= 0) continue;
            ServiceTreeObject serviceTreeObject = (ServiceTreeObject)((DefaultMutableTreeNode)serviceNode.getChildAt(0)).getUserObject();
            serviceTreeObjectsList.add(serviceTreeObject);
        }
        return serviceTreeObjectsList;
    }

    public TreeNode[] getPathToRoot(DefaultMutableTreeNode treeNode) {
        return this._treeModel.getPathToRoot(treeNode);
    }

    public void scrollPathToVisible(TreePath selPath) {
        this._tree.scrollPathToVisible(selPath);
    }

    public void setSelectionPath(TreePath selPath) {
        this._tree.setSelectionPath(selPath);
    }

    static {
        LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    }

    private class ServicesComparator
    implements Comparator {
        private ServicesComparator() {
        }

        public int compare(Object o1, Object o2) {
            ServiceTreeObject serviceTreeObject1 = (ServiceTreeObject)((DefaultMutableTreeNode)o1).getUserObject();
            ServiceTreeObject serviceTreeObject2 = (ServiceTreeObject)((DefaultMutableTreeNode)o2).getUserObject();
            String label1 = serviceTreeObject1.toString();
            String label2 = serviceTreeObject2.toString();
            return label1.compareToIgnoreCase(label2);
        }
    }

    private class SortedTreeModel
    extends DefaultTreeModel {
        private final Comparator comparator;

        public SortedTreeModel(TreeNode root) {
            super(root);
            this.comparator = new ServicesComparator();
        }

        public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent) {
            int index = this.findIndexFor(child, parent);
            super.insertNodeInto(child, parent, index);
        }

        private int findIndexFor(MutableTreeNode child, MutableTreeNode parent) {
            int cc = parent.getChildCount();
            if (cc == 0) {
                return 0;
            }
            if (cc == 1) {
                return this.comparator.compare(child, parent.getChildAt(0)) <= 0 ? 0 : 1;
            }
            return this.findIndexFor(child, parent, 0, cc - 1);
        }

        private int findIndexFor(MutableTreeNode child, MutableTreeNode parent, int i1, int i2) {
            if (i1 == i2) {
                return this.comparator.compare(child, parent.getChildAt(i1)) <= 0 ? i1 : i1 + 1;
            }
            int half = (i1 + i2) / 2;
            if (this.comparator.compare(child, parent.getChildAt(half)) <= 0) {
                return this.findIndexFor(child, parent, i1, half);
            }
            return this.findIndexFor(child, parent, half + 1, i2);
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        private final ImageIcon gsaIcon;
        private final ImageIcon gsmIcon;
        private final ImageIcon gscIcon;
        private final ImageIcon lusIcon;
        private final ImageIcon esmIcon;
        private final ImageIcon hostIcon;
        private final ImageIcon utilizationIcon;
        private final ImageIcon hostsRootIcon;
        private final ImageIcon securedGSAIcon;
        private final ImageIcon securedAuthenticatedGSAIcon;
        private final ImageIcon securedGSMIcon;
        private final ImageIcon securedAuthenticatedGSMIcon;
        private final ImageIcon securedGSCIcon;
        private final ImageIcon securedAuthenticatedGSCIcon;
        private final ImageIcon securedLUSIcon;
        private final ImageIcon securedAuthenticatedLUSIcon;
        private final ImageIcon securedESMIcon;
        private final ImageIcon securedAuthenticatedESMIcon;

        public TreeRenderer() {
            String path = "com/gigaspaces/admin/ui/images/";
            this.gsaIcon = IconsRepository.getInstance().getIcon(7);
            this.gsmIcon = IconsRepository.getInstance().getIcon(5);
            this.gscIcon = IconsRepository.getInstance().getIcon(6);
            this.lusIcon = IconsRepository.getInstance().getIcon(8);
            this.esmIcon = IconsRepository.getInstance().getIcon(9);
            this.hostIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/host.png");
            this.utilizationIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/hosts_utilization.png");
            this.hostsRootIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/hosts_root.png");
            this.securedGSAIcon = IconsRepository.getInstance().getIcon(12);
            this.securedAuthenticatedGSAIcon = IconsRepository.getInstance().getIcon(16);
            this.securedGSMIcon = IconsRepository.getInstance().getIcon(10);
            this.securedAuthenticatedGSMIcon = IconsRepository.getInstance().getIcon(14);
            this.securedGSCIcon = IconsRepository.getInstance().getIcon(11);
            this.securedAuthenticatedGSCIcon = IconsRepository.getInstance().getIcon(15);
            this.securedLUSIcon = IconsRepository.getInstance().getIcon(13);
            this.securedAuthenticatedLUSIcon = IconsRepository.getInstance().getIcon(17);
            this.securedESMIcon = IconsRepository.getInstance().getIcon(31);
            this.securedAuthenticatedESMIcon = IconsRepository.getInstance().getIcon(232);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jtree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(jtree, obj, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object userObj = node.getUserObject();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            if (parentNode == null) {
                this.setIcon(this.hostsRootIcon);
            } else if (node.equals(_utilizationNode)) {
                this.setIcon(this.utilizationIcon);
            } else if (userObj instanceof HostTreeObject) {
                this.setIcon(this.hostIcon);
            } else if (userObj instanceof ServiceTreeObject && ((ServiceTreeObject)userObj).isSecured()) {
                ServiceID serviceID = ((ServiceTreeObject)userObj).getServiceItem().serviceID;
                Authentication authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceID);
                ImageIcon serviceIcon = this.getServiceIcon((ServiceTreeObject)userObj, authentication);
                this.setIcon(serviceIcon);
            } else if (userObj instanceof GSATreeObject) {
                this.setIcon(this.gsaIcon);
            } else if (userObj instanceof GSATreeObject) {
                this.setIcon(this.gsaIcon);
            } else if (userObj instanceof GSMTreeObject) {
                this.setIcon(this.gsmIcon);
            } else if (userObj instanceof GSCTreeObject) {
                this.setIcon(this.gscIcon);
            } else if (userObj instanceof LUSTreeObject) {
                this.setIcon(this.getServiceIcon((LUSTreeObject)userObj, null));
            } else if (userObj instanceof ESMTreeObject) {
                this.setIcon(this.esmIcon);
            }
            return this;
        }

        private ImageIcon getServiceIcon(ServiceTreeObject serviceTreeObject, Authentication authentication) {
            if (serviceTreeObject instanceof GSATreeObject) {
                if (authentication == null) {
                    return this.securedGSAIcon;
                }
                return this.securedAuthenticatedGSAIcon;
            }
            if (serviceTreeObject instanceof GSMTreeObject) {
                if (authentication == null) {
                    return this.securedGSMIcon;
                }
                return this.securedAuthenticatedGSMIcon;
            }
            if (serviceTreeObject instanceof GSCTreeObject) {
                if (authentication == null) {
                    return this.securedGSCIcon;
                }
                return this.securedAuthenticatedGSCIcon;
            }
            if (serviceTreeObject instanceof ESMTreeObject) {
                if (authentication == null) {
                    return this.securedESMIcon;
                }
                return this.securedAuthenticatedESMIcon;
            }
            if (serviceTreeObject instanceof LUSTreeObject) {
                String gsaOwnerID = serviceTreeObject.getGSAOwnerServiceID();
                ServiceItem gsaOwnerServiceItem = Repository.getInstance().getGSAServiceItem(gsaOwnerID);
                if (gsaOwnerServiceItem == null || HostsTree.this._serviceNodesMap.get(gsaOwnerServiceItem.serviceID) == null || !((ServiceTreeObject)((DefaultMutableTreeNode)HostsTree.this._serviceNodesMap.get(gsaOwnerServiceItem.serviceID)).getUserObject()).isSecured()) {
                    return this.lusIcon;
                }
                authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(gsaOwnerServiceItem.serviceID);
                if (authentication == null) {
                    return this.securedLUSIcon;
                }
                return this.securedAuthenticatedLUSIcon;
            }
            return null;
        }
    }

    class HostsServicesTreeMouseListener
    extends MouseAdapter {
        HostsServicesTreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JMenuItem dumpGSCsOnlyMenuItem;
            JMenuItem dumpMenuItem;
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            TreePath path = HostsTree.this._tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            final DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            HostsTree.this._tree.setSelectionPath(path);
            if (selNode == null) {
                return;
            }
            Object userObject = selNode.getUserObject();
            JPopupMenu popupMenu = null;
            if (selNode.equals(_rootNode)) {
                DefaultMutableTreeNode hostNode;
                popupMenu = new JPopupMenu();
                dumpMenuItem = new JMenuItem("Generate hosts dump...");
                dumpGSCsOnlyMenuItem = new JMenuItem("Generate GSCs dump only...");
                int hostsCount = selNode.getChildCount();
                for (int hostIndex = 0; hostIndex < hostsCount && !this.handleGenerateGSCOnlyMenuItemState(dumpGSCsOnlyMenuItem, hostNode = (DefaultMutableTreeNode)selNode.getChildAt(hostIndex)); ++hostIndex) {
                }
                dumpGSCsOnlyMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HostsServicesTreeMouseListener.this.prepareAllHostsServices(true);
                    }
                });
                dumpMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HostsServicesTreeMouseListener.this.prepareAllHostsServices(false);
                    }
                });
                popupMenu.add(dumpMenuItem);
                popupMenu.add(dumpGSCsOnlyMenuItem);
            }
            if (userObject instanceof HostTreeObject) {
                popupMenu = new JPopupMenu();
                dumpMenuItem = new JMenuItem("Generate dump...");
                dumpMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HostsServicesTreeMouseListener.this.prepareHostServices(selNode, false);
                    }
                });
                dumpGSCsOnlyMenuItem = new JMenuItem("Generate GSCs dump only...");
                this.handleGenerateGSCOnlyMenuItemState(dumpGSCsOnlyMenuItem, selNode);
                dumpGSCsOnlyMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HostsServicesTreeMouseListener.this.prepareHostServices(selNode, true);
                    }
                });
                popupMenu.add(dumpMenuItem);
                popupMenu.add(dumpGSCsOnlyMenuItem);
            } else if (userObject instanceof ServiceTreeObject) {
                final ServiceTreeObject serviceTreeObject = (ServiceTreeObject)userObject;
                JMenuItem dumpMenuItem2 = new JMenuItem("Generate dump...");
                dumpMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HostsServicesTreeMouseListener.this.openServicesDumpDialog(serviceTreeObject);
                    }
                });
                if (userObject instanceof GSATreeObject) {
                    final GSATreeObject gsaTreeObject = (GSATreeObject)serviceTreeObject;
                    final GSA gsaService = gsaTreeObject.getGSA();
                    final ServiceID gsaServiceID = gsaTreeObject.getServiceItem().serviceID;
                    JMenuItem shutdownGSA = new JMenuItem("Shutdown");
                    JMenuItem startGSM = new JMenuItem("Start GSM");
                    JMenuItem startGSC = new JMenuItem("Start GSC");
                    JMenuItem startLookup = new JMenuItem("Start Lookup");
                    if (!JSpaceUIUtils.hasPermittedPermission((SecuredService)gsaService, gsaServiceID, (Privilege)GridAuthority.GridPrivilege.MANAGE_GRID)) {
                        shutdownGSA.setEnabled(false);
                        startGSM.setEnabled(false);
                        startGSC.setEnabled(false);
                        startLookup.setEnabled(false);
                    }
                    if (popupMenu == null) {
                        popupMenu = new JPopupMenu();
                    }
                    popupMenu.add(shutdownGSA);
                    popupMenu.addSeparator();
                    popupMenu.add(startGSM);
                    popupMenu.add(startGSC);
                    popupMenu.add(startLookup);
                    popupMenu.addSeparator();
                    shutdownGSA.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            HostsServicesTreeMouseListener.this.shutdownGSA(gsaService, gsaServiceID, selNode.toString(), gsaTreeObject.getLabel(), gsaTreeObject.getHostName());
                        }
                    });
                    startGSM.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            HostsServicesTreeMouseListener.this.startGSM(gsaService);
                        }
                    });
                    startGSC.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            HostsServicesTreeMouseListener.this.startGSC(gsaService);
                        }
                    });
                    startLookup.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            HostsServicesTreeMouseListener.this.startLookup(gsaService);
                        }
                    });
                } else {
                    final int gsAgentId = serviceTreeObject.getGSAgentID();
                    if (gsAgentId >= 0) {
                        ServiceID securedServiceID;
                        SecuredService securedService;
                        if (popupMenu == null) {
                            popupMenu = new JPopupMenu();
                        }
                        JMenuItem terminateService = new JMenuItem("Terminate");
                        JMenuItem restartService = new JMenuItem("Restart");
                        final GSA gsaService = Repository.getInstance().getGSAService(serviceTreeObject.getServiceItem().serviceID);
                        popupMenu.add(terminateService);
                        popupMenu.add(restartService);
                        popupMenu.addSeparator();
                        if (serviceTreeObject instanceof LUSTreeObject) {
                            String gsaOwnerID = serviceTreeObject.getGSAOwnerServiceID();
                            ServiceItem gsaOwnerServiceItem = Repository.getInstance().getGSAServiceItem(gsaOwnerID);
                            if (gsaOwnerServiceItem != null && ((ServiceTreeObject)((DefaultMutableTreeNode)HostsTree.this._serviceNodesMap.get(gsaOwnerServiceItem.serviceID)).getUserObject()).isSecured()) {
                                if (!JSpaceUIUtils.hasPermittedPermission((SecuredService)gsaOwnerServiceItem.service, gsaOwnerServiceItem.serviceID, (Privilege)GridAuthority.GridPrivilege.MANAGE_GRID, true)) {
                                    terminateService.setEnabled(false);
                                    restartService.setEnabled(false);
                                }
                                if (!JSpaceUIUtils.hasPermittedPermission((SecuredService)gsaOwnerServiceItem.service, gsaOwnerServiceItem.serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM, true)) {
                                    dumpMenuItem2.setEnabled(false);
                                }
                            }
                        } else if (serviceTreeObject.isSecured() && !JSpaceUIUtils.hasPermittedPermission(securedService = (SecuredService)serviceTreeObject.getServiceItem().service, securedServiceID = serviceTreeObject.getServiceItem().serviceID, (Privilege)GridAuthority.GridPrivilege.MANAGE_GRID)) {
                            terminateService.setEnabled(false);
                            restartService.setEnabled(false);
                        }
                        final String serviceName = serviceTreeObject.toString();
                        final String hostName = serviceTreeObject.getHostName();
                        final String label = serviceTreeObject.getLabel();
                        terminateService.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                HostsServicesTreeMouseListener.this.terminateService(gsAgentId, gsaService, serviceName, label, hostName);
                            }
                        });
                        restartService.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                HostsServicesTreeMouseListener.this.restartService(gsAgentId, gsaService, serviceName, label, hostName);
                            }
                        });
                    } else if (serviceTreeObject instanceof GSMTreeObject || serviceTreeObject instanceof GSCTreeObject) {
                        // empty if block
                    }
                }
                JMenuItem jConsoleMenuItem = new JMenuItem("JConsole...");
                String jmxServiceURL = JSpaceUtilities.getJMXConnectionUrl((ServiceItem)serviceTreeObject.getServiceItem());
                boolean isRemoteJmxPortDefined = JSpaceUtilities.isJMXRemotePortDefined((ServiceItem)serviceTreeObject.getServiceItem());
                JConsoleUIUtils.manageJConsoleMenuItem(HostsTree.this._parentFrame, jConsoleMenuItem, jmxServiceURL, !isRemoteJmxPortDefined, LOGGER, true, false, HostsTree.this._parentFrame);
                JMenuItem jVisualVmMenuItem = new JMenuItem("VisualVM...");
                JConsoleUIUtils.manageJVisualVmMenuItem(HostsTree.this._parentFrame, jVisualVmMenuItem, jmxServiceURL, LOGGER, true, false, HostsTree.this._parentFrame, false);
                if (popupMenu == null) {
                    popupMenu = new JPopupMenu();
                }
                popupMenu.add(jConsoleMenuItem);
                popupMenu.add(jVisualVmMenuItem);
                popupMenu.add(dumpMenuItem2);
            }
            if (popupMenu != null) {
                popupMenu.pack();
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void shutdownGSA(GSA gsaService, ServiceID gsaServiceID, String name, String label, String hostName) {
            block3: {
                try {
                    int retVal = JOptionPane.showConfirmDialog(HostsTree.this._parentFrame, "<HTML>Are you sure you want to shutdown " + label + " <B><FONT color=\"blue\">" + name + "</FONT></B> running on machine <FONT color=\"blue\">" + hostName + "</FONT>?</HTML>", "Shutdown " + label, 0, 2);
                    if (retVal == 0) {
                        gsaService.shutdown();
                    }
                }
                catch (RemoteException re) {
                    if (JSpaceUtilities.getCauseExceptionFromHierarchy((Exception)re, ClosedChannelException.class) != null || MainUI.lookupServiceItem(gsaServiceID) == null || !LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, re.toString(), re);
                }
            }
        }

        private boolean handleGenerateGSCOnlyMenuItemState(JMenuItem dumpGSCsOnlyMenuItem, DefaultMutableTreeNode hostNode) {
            boolean hasGSCNode = false;
            for (int index = 0; index < hostNode.getChildCount(); ++index) {
                Object serviceUserObject;
                DefaultMutableTreeNode serviceTreeNode = (DefaultMutableTreeNode)hostNode.getChildAt(index);
                if (serviceTreeNode == null || !((serviceUserObject = serviceTreeNode.getUserObject()) instanceof GSCTreeObject)) continue;
                hasGSCNode = true;
                break;
            }
            dumpGSCsOnlyMenuItem.setEnabled(hasGSCNode);
            return hasGSCNode;
        }

        private void prepareAllHostsServices(boolean isGSCOnly) {
            ArrayList<ServiceTreeObject> serviceTreeObjectsList = new ArrayList<ServiceTreeObject>(_rootNode.getChildCount() * 3);
            for (int hostIndex = 0; hostIndex < _rootNode.getChildCount(); ++hostIndex) {
                DefaultMutableTreeNode hostNode = (DefaultMutableTreeNode)_rootNode.getChildAt(hostIndex);
                for (int serviceIndex = 0; serviceIndex < hostNode.getChildCount(); ++serviceIndex) {
                    DefaultMutableTreeNode serviceNode = (DefaultMutableTreeNode)hostNode.getChildAt(serviceIndex);
                    ServiceTreeObject serviceTreeObject = (ServiceTreeObject)serviceNode.getUserObject();
                    if ((!isGSCOnly || !(serviceTreeObject.getServiceItem().service instanceof GSC)) && isGSCOnly) continue;
                    serviceTreeObjectsList.add(serviceTreeObject);
                }
            }
            this.openServicesDumpDialog(serviceTreeObjectsList, true);
        }

        private void prepareHostServices(DefaultMutableTreeNode hostNode, boolean isGSCOnly) {
            ArrayList<ServiceTreeObject> serviceTreeObjectsList = new ArrayList<ServiceTreeObject>(hostNode.getChildCount());
            for (int index = 0; index < hostNode.getChildCount(); ++index) {
                DefaultMutableTreeNode serviceNode = (DefaultMutableTreeNode)hostNode.getChildAt(index);
                ServiceTreeObject serviceTreeObject = (ServiceTreeObject)serviceNode.getUserObject();
                if ((!isGSCOnly || !(serviceTreeObject.getServiceItem().service instanceof GSC)) && isGSCOnly) continue;
                serviceTreeObjectsList.add(serviceTreeObject);
            }
            this.openServicesDumpDialog(serviceTreeObjectsList, true);
        }

        private void openServicesDumpDialog(ServiceTreeObject serviceTreeObject) {
            ArrayList<ServiceTreeObject> serviceTreeObjectsList = new ArrayList<ServiceTreeObject>(1);
            serviceTreeObjectsList.add(serviceTreeObject);
            this.openServicesDumpDialog(serviceTreeObjectsList, false);
        }

        private void openServicesDumpDialog(List<ServiceTreeObject> serviceTreeObjectsList, boolean isMachineServicesDumpSelected) {
            int listSize = serviceTreeObjectsList.size();
            ServicesDumpDialog.DumpProviderWrapper[] dumpProviderWrappresArray = new ServicesDumpDialog.DumpProviderWrapper[listSize];
            for (int index = 0; index < listSize; ++index) {
                ServicesDumpDialog.DumpProviderWrapper dumpProviderWrapper;
                ServiceTreeObject serviceTreeObject = serviceTreeObjectsList.get(index);
                ServiceItem serviceItem = serviceTreeObject.getServiceItem();
                Object service = serviceItem.service;
                if (service instanceof ServiceRegistrar) {
                    service = ((ServiceRegistrar)serviceItem.service).getRegistrar();
                }
                InternalDumpProvider dumpProvider = (InternalDumpProvider)service;
                String descr = serviceTreeObject.toString();
                boolean isSecured = serviceTreeObject.isSecured();
                dumpProviderWrappresArray[index] = dumpProviderWrapper = new ServicesDumpDialog.DumpProviderWrapper(dumpProvider, serviceItem.serviceID, isSecured, descr, serviceTreeObject.getHostName(), serviceTreeObject.getPid(), serviceItem.service instanceof ServiceRegistrar);
            }
            ServicesDumpDialog dumpDialog = new ServicesDumpDialog(HostsTree.this._parentFrame, isMachineServicesDumpSelected, dumpProviderWrappresArray);
            dumpDialog.setVisible(true);
        }

        private void handleSecurity(ServiceTreeObject serviceTreeObject, JMenuItem jConsoleMenuItem, JMenuItem jVisualVmMenuItem, JMenuItem serviceUIMenuItem, JMenuItem dumpMenuItem) {
            boolean isSecuredService = serviceTreeObject.isSecured();
            SecuredService securedService = (SecuredService)serviceTreeObject.getServiceItem().service;
            ServiceID serviceID = serviceTreeObject.getServiceItem().serviceID;
            boolean hasManageGridPermission = JSpaceUIUtils.hasPermittedPermission(securedService, serviceID, (Privilege)GridAuthority.GridPrivilege.MANAGE_GRID, isSecuredService);
            boolean hasMonitorJVMPermission = JSpaceUIUtils.hasPermittedPermission(securedService, serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM, isSecuredService);
            serviceUIMenuItem.setEnabled(hasManageGridPermission);
            jConsoleMenuItem.setEnabled(hasMonitorJVMPermission);
            jVisualVmMenuItem.setEnabled(hasMonitorJVMPermission);
            dumpMenuItem.setEnabled(hasMonitorJVMPermission);
        }

        private void terminateService(int id, GSA gsaService, String serviceName, String serviceLabel, String hostName) {
            block3: {
                try {
                    int returnValue = this.showTerminateServiceConfirmDialog(serviceName, serviceLabel, hostName);
                    if (returnValue == 0) {
                        gsaService.killProcess(id);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }

        private int showTerminateServiceConfirmDialog(String serviceName, String serviceLabel, String hostName) {
            return JOptionPane.showConfirmDialog(HostsTree.this._parentFrame, "<HTML>Are you sure you want to terminate " + serviceLabel + " <B><FONT color=\"blue\">" + serviceName + "</FONT></B> running on machine <FONT color=\"blue\">" + hostName + "</FONT>?</HTML>", "Terminate " + serviceLabel, 0, 1);
        }

        private void restartService(final int id, final GSA gsaService, String serviceName, String serviceLabel, String hostName) {
            int returnValue = JOptionPane.showConfirmDialog(HostsTree.this._parentFrame, "<HTML>Are you sure you want to restart " + serviceLabel + " <B><FONT color=\"blue\">" + serviceName + "</FONT></B> running on machine <FONT color=\"blue\">" + hostName + "</FONT>?</HTML>", "Restart " + serviceLabel, 0, 1);
            if (returnValue == 0) {
                AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                gsaService.restartProcess(id);
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                                LOGGER.log(Level.SEVERE, e.toString(), e);
                            }
                        }
                    }
                });
            }
        }

        private void startGSM(GSA gsaService) {
            block2: {
                try {
                    this.startProcess(gsaService, "gsm");
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }

        private void startGSC(GSA gsaService) {
            block2: {
                try {
                    this.startProcess(gsaService, "gsc");
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }

        private void startLookup(GSA gsaService) {
            block2: {
                try {
                    this.startProcess(gsaService, "lus");
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }

        private void startProcess(GSA gsaService, String type) throws RemoteException, IOException {
            GSProcessOptions processOptions = new GSProcessOptions(type);
            processOptions.setUseScript(true);
            try {
                gsaService.startProcess(processOptions);
            }
            catch (GlobalProcessAlreadyRunningIOException e) {
                JOptionPane.showMessageDialog(HostsTree.this._parentFrame, e.getMessage(), "Start " + type.toUpperCase() + " Process", 1);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(HostsTree.this._parentFrame, e.toString(), "Start " + type.toUpperCase() + " Process", 2);
            }
        }
    }

    public static class HostTreeObject {
        private final String _hostName;

        public HostTreeObject(String hostName) {
            this._hostName = hostName;
        }

        public String toString() {
            return this.getHostName();
        }

        public String getHostName() {
            return this._hostName;
        }
    }

    public static class ESMTreeObject
    extends ServiceTreeObject {
        public ESMTreeObject(ServiceItem serviceItem) {
            super(serviceItem, "ESM");
        }

        public String toString() {
            return JSpaceUtilities.createServiceName((String)"esm", (int)this.getGSAgentID(), (long)this.getPid(), (String[])this._zonesArray);
        }

        public ESM getESM() {
            return (ESM)this._serviceItem.service;
        }
    }

    public static class LUSTreeObject
    extends ServiceTreeObject {
        private GSMTreeObject _gsmOwnerTreeObject;

        public LUSTreeObject(ServiceItem serviceItem) {
            super(serviceItem, "LUS");
        }

        public String toString() {
            return JSpaceUtilities.createServiceName((String)"lus", (int)this.getGSAgentID(), (long)this.getPid(), (String[])this._zonesArray);
        }

        public ServiceRegistrar getServiceRegistrar() {
            return (ServiceRegistrar)this._serviceItem.service;
        }

        public GSMTreeObject getGsmOwnerTreeObject() {
            return this._gsmOwnerTreeObject;
        }

        public void setGsmOwnerTreeObject(GSMTreeObject gsmTreeObject) {
            this._gsmOwnerTreeObject = gsmTreeObject;
        }
    }

    public static class GSATreeObject
    extends ServiceTreeObject {
        public GSATreeObject(ServiceItem serviceItem) {
            super(serviceItem, "GSA");
        }

        public String toString() {
            return JSpaceUtilities.createServiceName((String)"gsa", (int)-1, (long)this.getPid(), (String[])this._zonesArray);
        }

        public GSA getGSA() {
            return (GSA)this._serviceItem.service;
        }
    }

    public static class GSCTreeObject
    extends ServiceTreeObject {
        public GSCTreeObject(ServiceItem serviceItem) {
            super(serviceItem, "GSC");
        }

        public String toString() {
            return JSpaceUtilities.createServiceName((String)"gsc", (int)this.getGSAgentID(), (long)this.getPid(), (String[])this._zonesArray);
        }

        public GSC getGSC() {
            return (GSC)this._serviceItem.service;
        }
    }

    public static class GSMTreeObject
    extends ServiceTreeObject {
        public GSMTreeObject(ServiceItem serviceItem) {
            super(serviceItem, "GSM");
        }

        public String toString() {
            return JSpaceUtilities.createServiceName((String)"gsm", (int)this.getGSAgentID(), (long)this.getPid(), (String[])this._zonesArray);
        }

        public GSM getGSM() {
            return (GSM)this._serviceItem.service;
        }
    }

    public static abstract class ServiceTreeObject
    extends BasicWrapper
    implements Cloneable {
        protected ServiceItem _serviceItem;
        protected String _lookupGroups;
        protected String _lookupLocators;
        private String _jvmVersion;
        private final String _label;
        private boolean _isManagedByGSA;
        private final int _gsaAgentID;
        protected String _gsaOwnerServiceID;
        private long _pid = -1L;
        private boolean _isSecured;
        private long _memoryHeapUsed;
        private String _memoryUtil = "";
        private double _cpuUsed;
        private String _cpuUtil = "";
        protected String _zones;
        protected String[] _zonesArray;
        private String _hostName;

        public ServiceTreeObject(ServiceItem serviceItem, String label) {
            this._serviceItem = serviceItem;
            this._label = label;
            this._gsaAgentID = Repository.getInstance().getGSAgentID(this._serviceItem.serviceID);
            this.init();
        }

        public void setHostName(String hostName) {
            this._hostName = hostName;
        }

        public String getHostName() {
            return this._hostName;
        }

        private void init() {
            block16: {
                Object service;
                block15: {
                    block14: {
                        service = this._serviceItem.service;
                        if (service instanceof ServiceRegistrar) {
                            service = ((ServiceRegistrar)service).getRegistrar();
                        }
                        if (service instanceof AgentIdAware) {
                            try {
                                this._gsaOwnerServiceID = ((AgentIdAware)service).getGSAServiceID();
                            }
                            catch (ConnectException ce) {
                                if (LOGGER.isLoggable(Level.WARNING)) {
                                    LOGGER.log(Level.WARNING, ce.toString(), ce);
                                }
                            }
                            catch (RemoteException re) {
                                if (!LOGGER.isLoggable(Level.SEVERE)) break block14;
                                LOGGER.log(Level.SEVERE, re.toString(), re);
                            }
                        }
                    }
                    if (service instanceof SecuredService) {
                        try {
                            this._isSecured = ((SecuredService)service).isServiceSecured();
                        }
                        catch (ConnectException ce) {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, ce.toString(), ce);
                            }
                        }
                        catch (RemoteException re) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block15;
                            LOGGER.log(Level.SEVERE, re.toString(), re);
                        }
                    }
                }
                if (service instanceof AgentIdAware) {
                    AgentIdAware agentIdAware = (AgentIdAware)service;
                    try {
                        this._isManagedByGSA = agentIdAware.getAgentId() >= 0;
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block16;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            this.initPid();
            this.initZones();
        }

        private void initPid() {
            JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(this._serviceItem, true);
            if (jvmDetails != null) {
                this._pid = jvmDetails.getPid();
            }
        }

        private synchronized void initJVMVersion() {
            if (this._jvmVersion != null) {
                return;
            }
            Object service = this._serviceItem.service;
            if (service instanceof ServiceRegistrar) {
                service = ((ServiceRegistrar)this._serviceItem.service).getRegistrar();
            }
            JVMInfoProvider jvmInfoProvider = (JVMInfoProvider)service;
            try {
                JVMDetails jvmDetails = jvmInfoProvider.getJVMDetails();
                this._jvmVersion = jvmDetails.getVmVendor() + " " + jvmDetails.getVmVersion();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                this._jvmVersion = "";
            }
        }

        private synchronized void initLookupGroupsAndLocators() {
            if (this._lookupGroups != null && this._lookupLocators != null) {
                return;
            }
            Object service = this._serviceItem.service;
            if (service instanceof ServiceRegistrar) {
                service = ((ServiceRegistrar)this._serviceItem.service).getRegistrar();
            }
            if (service instanceof Administrable) {
                try {
                    Object admin = ((Administrable)service).getAdmin();
                    if (admin instanceof JoinAdmin) {
                        JoinAdmin joinAdmin = (JoinAdmin)admin;
                        String[] lookupGroups = new String[]{};
                        lookupGroups = this._serviceItem.service instanceof ServiceRegistrar ? ((ServiceRegistrar)this._serviceItem.service).getGroups() : joinAdmin.getLookupGroups();
                        this._lookupGroups = JSpaceUtilities.getLookupGroupsStringRepresentation((String[])lookupGroups);
                        LookupLocator[] lookupLocators = joinAdmin.getLookupLocators();
                        this._lookupLocators = JSpaceUtilities.getLookupLocatorsStringRepresentation((LookupLocator[])lookupLocators);
                    }
                }
                catch (ConnectException ce) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, ce.toString(), ce);
                    }
                    this._lookupGroups = "";
                    this._lookupLocators = "";
                }
                catch (RemoteException re) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, re.toString(), re);
                    }
                    this._lookupGroups = "";
                    this._lookupLocators = "";
                }
            } else {
                this._lookupGroups = "";
                this._lookupLocators = "";
            }
        }

        private synchronized void initZones() {
            if (this._zones != null) {
                return;
            }
            Object service = this._serviceItem.service;
            if (service instanceof ServiceRegistrar) {
                service = ((ServiceRegistrar)this._serviceItem.service).getRegistrar();
            }
            if (service instanceof GridZoneProvider) {
                try {
                    this._zonesArray = ((GridZoneProvider)service).getZones();
                    this._zones = JSpaceUtilities.getZonesStringRepresentation((String[])this._zonesArray);
                }
                catch (ConnectException ce) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, ce.toString(), ce);
                    }
                    this._zones = "";
                }
                catch (RemoteException re) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, re.toString(), re);
                    }
                    this._zones = "";
                }
            } else {
                this._zones = "";
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        protected int getGSAgentID() {
            return this._gsaAgentID;
        }

        protected long getPid() {
            return this._pid;
        }

        public ServiceItem getServiceItem() {
            return this._serviceItem;
        }

        public String getLookupGroups() {
            if (this._lookupGroups == null) {
                this.initLookupGroupsAndLocators();
            }
            return this._lookupGroups == null ? "" : this._lookupGroups;
        }

        public String getZones() {
            return this._zones == null ? "" : this._zones;
        }

        public String getLookupLocators() {
            if (this._lookupLocators == null) {
                this.initLookupGroupsAndLocators();
            }
            return this._lookupLocators == null ? "" : this._lookupLocators;
        }

        public String getJVMVersion() {
            if (this._jvmVersion == null) {
                this.initJVMVersion();
            }
            return this._jvmVersion == null ? "" : this._jvmVersion;
        }

        public String getLabel() {
            return this._label;
        }

        public boolean isManagedByGSA() {
            return this._isManagedByGSA;
        }

        public boolean isSecured() {
            return this._isSecured;
        }

        public String getGSAOwnerServiceID() {
            return this._gsaOwnerServiceID;
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            ServiceTreeObject serviceTreeObject = (ServiceTreeObject)wrapper;
            return this._memoryHeapUsed == serviceTreeObject.getMemoryUsed() && this._cpuUsed == serviceTreeObject.getCpuUsed();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceTreeObject other = (ServiceTreeObject)obj;
            return !(this._serviceItem == null ? other._serviceItem != null : !this._serviceItem.serviceID.equals((Object)other._serviceItem.serviceID));
        }

        public int hashCode() {
            return this._serviceItem.serviceID.hashCode();
        }

        public void setMemoryUsed(long memoryHeapUsed) {
            this._memoryHeapUsed = memoryHeapUsed;
        }

        public void setMemoryUtil(String memoryUtil) {
            this._memoryUtil = memoryUtil;
        }

        public long getMemoryUsed() {
            return this._memoryHeapUsed;
        }

        public String getMemoryUtil() {
            return this._memoryUtil;
        }

        public double getCpuUsed() {
            return this._cpuUsed;
        }

        public String getCpuUtil() {
            return this._cpuUtil;
        }

        public void setCpuUsed(double cpuUsed) {
            this._cpuUsed = cpuUsed;
        }

        public void setCpuUtil(String cpuUtil) {
            this._cpuUtil = cpuUtil;
        }

        public void initilizeLazyFieldsIfNeeded() {
            this.initLookupGroupsAndLocators();
            this.initJVMVersion();
        }
    }
}

