/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.hosts;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.views.RefreshThread;
import com.gigaspaces.admin.ui.views.hosts.HostView;
import com.gigaspaces.admin.ui.views.hosts.HostsTree;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSInfoProvider;
import com.gigaspaces.internal.os.OSStatistics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;

public class HostsUtilizationView
extends JPanel
implements RefreshThread.RefreshableView {
    private BasicTable _hostsUtilizationTable;
    private HostsUtilizationTableModel _hostsUtilizationTableModel;
    private boolean _isRefresh;
    private HostsTree _hostsTree;
    private static final DecimalFormat nf = new DecimalFormat();
    private static final Logger LOGGER;

    public HostsUtilizationView(HostsTree hostsTree) {
        this.setLayout(new BorderLayout());
        this._hostsTree = hostsTree;
        this._hostsUtilizationTableModel = new HostsUtilizationTableModel();
        this._hostsUtilizationTable = new BasicTable(this._hostsUtilizationTableModel);
        this.setTableProperties(this._hostsUtilizationTable);
        JScrollPane scrollPane = new JScrollPane(this._hostsUtilizationTable);
        scrollPane.setBorder(BorderFactory.createTitledBorder("Hosts Utilization Summary"));
        this.add((Component)scrollPane, "Center");
        new RefreshThread("Hosts-Utilization-View-Refresh", this).start();
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = table.getColumnModel();
        int columnWidth = 90;
        TableColumn processorsNumColumn = tableColumnModel.getColumn(3);
        TableColumn cpuUtilColumn = tableColumnModel.getColumn(4);
        TableColumn memoryUtilColumn = tableColumnModel.getColumn(5);
        processorsNumColumn.setPreferredWidth(135);
        processorsNumColumn.setMaxWidth(135);
        cpuUtilColumn.setPreferredWidth(90);
        cpuUtilColumn.setMaxWidth(90);
        memoryUtilColumn.setPreferredWidth(90);
        memoryUtilColumn.setMaxWidth(90);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
    }

    @Override
    public void updateRuntimeDetails() {
        block4: {
            try {
                List<HostsTree.ServiceTreeObject> servicesObjectsList = this._hostsTree.getHostsServicesObjects();
                ArrayList<BasicWrapper> hostUtilizationWrappersList = new ArrayList<BasicWrapper>(servicesObjectsList.size());
                for (HostsTree.ServiceTreeObject serviceTreeObject : servicesObjectsList) {
                    ServiceItem serviceItem = serviceTreeObject.getServiceItem();
                    OSDetails osDetails = Repository.getInstance().getOSDetails(serviceItem, true);
                    if (osDetails == null) continue;
                    OSStatistics osStatistics = this.getOSStatistics(serviceItem);
                    double cpuUsage = -1.0;
                    String memoryPerc = "n/a";
                    long actualMemoryUsed = -1L;
                    if (osStatistics != null) {
                        cpuUsage = osStatistics.getCpuPerc();
                        actualMemoryUsed = osStatistics.getActualMemoryUsed();
                        double usedMemoryPerc = osStatistics.getUsedMemoryPerc();
                        memoryPerc = HostView.getMemoryPercUsage(usedMemoryPerc);
                    }
                    hostUtilizationWrappersList.add(new HostUtilizationWrapper(osDetails.getHostName(), osDetails.getArch(), osDetails.getVersion(), osDetails.getAvailableProcessors(), cpuUsage < 0.0 ? "n/a" : String.valueOf(nf.format(cpuUsage * 100.0)) + "%", cpuUsage, memoryPerc.equals("n/a") ? memoryPerc : memoryPerc + " %", actualMemoryUsed));
                }
                this._hostsUtilizationTableModel.setWrappersList(hostUtilizationWrappersList, true);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    @Override
    public boolean shouldRefresh() {
        return this._isRefresh;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    private OSStatistics getOSStatistics(ServiceItem serviceItem) {
        OSStatistics osStatistics;
        block3: {
            osStatistics = null;
            Object service = serviceItem.service;
            if (service instanceof ServiceRegistrar) {
                service = ((ServiceRegistrar)service).getRegistrar();
            }
            try {
                osStatistics = ((OSInfoProvider)service).getOSStatistics();
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return osStatistics;
    }

    private void clear() {
    }

    static {
        nf.setMaximumFractionDigits(1);
        LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    }

    private class HostsUtilizationTableModel
    extends BasicSortableTableModel {
        private final String CN_HOST = "Host";
        private final String CN_PROCESSOR_ARC = "Processor Architecture";
        private final String CN_OS = "Operating System";
        private final String CN_NUM_OF_PROCESSORS = "Number of Processors";
        private final String CN_CPU_UTILIZATION = "CPU Util.";
        private final String CN_MEMORY_UTILIZATION = "Memory Util.";
        public static final int CI_HOST_ID = 0;
        public static final int CI_PROCESSOR_ARC_ID = 1;
        public static final int CI_OS_ID = 2;
        public static final int CI_NUM_OF_PROCESSORS_ID = 3;
        public static final int CI_CPU_UTILIZATION_ID = 4;
        public static final int CI_MEMORY_UTILIZATION_ID = 5;

        private HostsUtilizationTableModel() {
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[6];
            this.columnNames[0] = "Host";
            this.columnNames[1] = "Processor Architecture";
            this.columnNames[2] = "Operating System";
            this.columnNames[3] = "Number of Processors";
            this.columnNames[4] = "CPU Util.";
            this.columnNames[5] = "Memory Util.";
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            HostUtilizationWrapper hostUtilizationWrapper = (HostUtilizationWrapper)basicWrapper;
            switch (column) {
                case 0: {
                    return hostUtilizationWrapper.getHostName();
                }
                case 1: {
                    return hostUtilizationWrapper.getProcessorArc();
                }
                case 2: {
                    return hostUtilizationWrapper.getOS();
                }
                case 3: {
                    return String.valueOf(hostUtilizationWrapper.getNumberOfProcessors());
                }
                case 4: {
                    return hostUtilizationWrapper.getCpuUtil();
                }
                case 5: {
                    return hostUtilizationWrapper.getMemoryUtil();
                }
            }
            return "";
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            HostUtilizationWrapper hostUtilWrapper1 = (HostUtilizationWrapper)wrapper1;
            HostUtilizationWrapper hostUtilWrapper2 = (HostUtilizationWrapper)wrapper2;
            switch (colIndex) {
                case 0: {
                    String hostName1 = hostUtilWrapper1.getHostName();
                    String hostName2 = hostUtilWrapper2.getHostName();
                    if (ascending) {
                        return hostName1.compareToIgnoreCase(hostName2);
                    }
                    return hostName2.compareToIgnoreCase(hostName1);
                }
                case 1: {
                    String processorArc1 = hostUtilWrapper1.getProcessorArc();
                    String processorArc2 = hostUtilWrapper2.getProcessorArc();
                    if (ascending) {
                        return processorArc1.compareToIgnoreCase(processorArc2);
                    }
                    return processorArc2.compareToIgnoreCase(processorArc1);
                }
                case 2: {
                    String os1 = hostUtilWrapper1.getOS();
                    String os2 = hostUtilWrapper2.getOS();
                    if (ascending) {
                        return os1.compareToIgnoreCase(os2);
                    }
                    return os2.compareToIgnoreCase(os1);
                }
                case 3: {
                    int processorsNum1 = hostUtilWrapper1.getNumberOfProcessors();
                    int processorsNum2 = hostUtilWrapper2.getNumberOfProcessors();
                    if (ascending) {
                        return processorsNum1 < processorsNum2 ? -1 : (processorsNum1 == processorsNum2 ? 0 : 1);
                    }
                    return processorsNum2 < processorsNum1 ? -1 : (processorsNum2 == processorsNum1 ? 0 : 1);
                }
                case 4: {
                    double cpuUtilization1 = hostUtilWrapper1.getCpuUtilVal();
                    double cpuUtilization2 = hostUtilWrapper2.getCpuUtilVal();
                    if (ascending) {
                        return cpuUtilization1 < cpuUtilization2 ? -1 : (cpuUtilization1 == cpuUtilization2 ? 0 : 1);
                    }
                    return cpuUtilization2 < cpuUtilization1 ? -1 : (cpuUtilization2 == cpuUtilization1 ? 0 : 1);
                }
                case 5: {
                    double memoryUtil1 = hostUtilWrapper1.getMemoryUtilVal();
                    double memoryUtil2 = hostUtilWrapper2.getMemoryUtilVal();
                    if (ascending) {
                        return memoryUtil1 < memoryUtil2 ? -1 : (memoryUtil1 == memoryUtil2 ? 0 : 1);
                    }
                    return memoryUtil2 < memoryUtil1 ? -1 : (memoryUtil2 == memoryUtil1 ? 0 : 1);
                }
            }
            return 0;
        }
    }

    private class HostUtilizationWrapper
    extends BasicWrapper {
        private String _hostName;
        private String _processsArc;
        private String _os;
        private int _numberOfProcessors;
        private String _cpuUtil;
        private String _memoryUtil;
        private double _cpuUtilVal;
        private long _memoryUtilVal;

        public HostUtilizationWrapper(String hostName, String processsArc, String os, int numberOfProcessors, String cpuUtil, double cpuUtilVal, String memoryUtil, long memoryUtilVal) {
            this._hostName = hostName;
            this._processsArc = processsArc;
            this._os = os;
            this._numberOfProcessors = numberOfProcessors;
            this._cpuUtil = cpuUtil;
            this._memoryUtil = memoryUtil;
            this._memoryUtilVal = memoryUtilVal;
            this._cpuUtilVal = cpuUtilVal;
        }

        public double getCpuUtilVal() {
            return this._cpuUtilVal;
        }

        public long getMemoryUtilVal() {
            return this._memoryUtilVal;
        }

        public String getHostName() {
            return this._hostName;
        }

        public String getProcessorArc() {
            return this._processsArc;
        }

        public String getOS() {
            return this._os;
        }

        public int getNumberOfProcessors() {
            return this._numberOfProcessors;
        }

        public String getCpuUtil() {
            return this._cpuUtil;
        }

        public String getMemoryUtil() {
            return this._memoryUtil;
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            if (wrapper instanceof HostUtilizationWrapper) {
                HostUtilizationWrapper hostUtilizationWrapper = (HostUtilizationWrapper)wrapper;
                return this.equals(wrapper) && this._cpuUtilVal == hostUtilizationWrapper.getCpuUtilVal() && this._memoryUtilVal == hostUtilizationWrapper.getMemoryUtilVal();
            }
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof HostUtilizationWrapper) {
                return this._hostName.equals(((HostUtilizationWrapper)object).getHostName());
            }
            return false;
        }

        public int hashCode() {
            return this._hostName.hashCode();
        }
    }
}

