/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.hosts;

import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.IServiceGridUIComponent;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.ServiceNotificationListener;
import com.gigaspaces.admin.ui.grid.gsc.GSCMonitorPanel;
import com.gigaspaces.admin.ui.views.hosts.ESMView;
import com.gigaspaces.admin.ui.views.hosts.GSAView;
import com.gigaspaces.admin.ui.views.hosts.GSCView;
import com.gigaspaces.admin.ui.views.hosts.GSMView;
import com.gigaspaces.admin.ui.views.hosts.HostView;
import com.gigaspaces.admin.ui.views.hosts.HostsTree;
import com.gigaspaces.admin.ui.views.hosts.HostsUtilizationView;
import com.gigaspaces.admin.ui.views.hosts.LUSView;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceItem;

public class HostsViewPanel
extends JPanel
implements IServiceGridUIComponent,
ServiceNotificationListener,
TreeSelectionListener {
    private HostsTree _hostsTreePanel;
    private JPanel _centerContainer;
    private CardLayout _cardLayout = new CardLayout();
    private JTree _hostsTree;
    private GSCView _gscView;
    private GSMView _gsmView;
    private GSAView _gsaView;
    private LUSView _lusView;
    private ESMView _esmView;
    private HostView _hostView;
    private HostsUtilizationView _hostsUtilizationView;
    private GSCMonitorPanel _gscMonitorPanel;
    private MainUI _mainUI;
    private static final String VIEW_BLANK = "Blank";
    private static final String VIEW_UTILIZATION = "Utilization";
    private static final String VIEW_GSM = "GSMView";
    private static final String VIEW_GSC = "GSCView";
    private static final String VIEW_GSA = "GSAView";
    private static final String VIEW_LUS = "LUSView";
    private static final String VIEW_ESM = "ESMView";
    private static final String VIEW_HOST = "HostView";
    private static final String VIEW_MONITORING = "Monitoring";
    private static Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public HostsViewPanel(MainUI mainUI, GSCMonitorPanel gscMonitorPanel) {
        this.setBorder(null);
        this._mainUI = mainUI;
        this._gscMonitorPanel = gscMonitorPanel;
        this._hostsTreePanel = new HostsTree(mainUI, this);
        this._centerContainer = new JPanel(this._cardLayout);
        this.setLayout(new BorderLayout());
        this._hostsTree = this._hostsTreePanel.getTree();
        this._hostsUtilizationView = new HostsUtilizationView(this._hostsTreePanel);
        JScrollPane jScrollPane = new JScrollPane(this._hostsTree);
        jScrollPane.setBorder(null);
        JSplitPane splitPane = new JSplitPane(1, jScrollPane, this._centerContainer);
        splitPane.setBorder(null);
        splitPane.setDividerLocation(200);
        this.add((Component)splitPane, "Center");
        this._hostsTree.addTreeSelectionListener(this);
        this.initCardViews(mainUI);
        this._hostsTreePanel.selectRoot();
    }

    private void initCardViews(MainUI mainUI) {
        this._gscView = new GSCView(mainUI);
        this._hostView = new HostView(mainUI);
        this._gsaView = new GSAView(mainUI);
        this._gsmView = new GSMView(mainUI);
        this._lusView = new LUSView(mainUI);
        this._esmView = new ESMView(mainUI);
        this._centerContainer.add((Component)new JPanel(), VIEW_BLANK);
        this._centerContainer.add((Component)this._hostsUtilizationView, VIEW_UTILIZATION);
        this._centerContainer.add((Component)this._gscView, VIEW_GSC);
        this._centerContainer.add((Component)this._gsaView, VIEW_GSA);
        this._centerContainer.add((Component)this._gsmView, VIEW_GSM);
        this._centerContainer.add((Component)this._esmView, VIEW_ESM);
        this._centerContainer.add((Component)this._lusView, VIEW_LUS);
        this._centerContainer.add((Component)this._hostView, VIEW_HOST);
        this._centerContainer.add((Component)this._gscMonitorPanel, VIEW_MONITORING);
    }

    public int getHostsCount() {
        return this._hostsTreePanel.getHostsCount();
    }

    public boolean isServicesDisplayed() {
        return this._hostsTreePanel.isServicesDisplayed();
    }

    @Override
    public synchronized void serviceAdded(ServiceItem serviceItem) {
        this._hostsTreePanel.serviceAdded(serviceItem);
    }

    @Override
    public void serviceRemoved(ServiceItem serviceItem) {
        this._hostsTreePanel.serviceRemoved(serviceItem);
    }

    @Override
    public void serviceChanged(ServiceItem item) {
    }

    @Override
    public void closeServices() {
    }

    @Override
    public String getComponentName() {
        return "Hosts";
    }

    @Override
    public String getComponentToolTip() {
        return "Hosts";
    }

    @Override
    public JMenu[] getMenus() {
        return null;
    }

    @Override
    public JLabel getStatusBar() {
        return null;
    }

    @Override
    public JButton[] getToolBarButtons() {
        return null;
    }

    @Override
    public void resetInternalWindows() {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._hostsTree.getLastSelectedPathComponent();
        this._mainUI.getTreeSelectionsExecutor().submit(node, new Runnable(){

            @Override
            public void run() {
                HostsViewPanel.this.handleSelectedNode(node, false);
            }
        });
    }

    protected void handleSelectedNode(DefaultMutableTreeNode selNode, boolean selectNode) {
        if (selNode == null) {
            this._cardLayout.show(this._centerContainer, VIEW_BLANK);
            this._gsmView.setInvokeRefresh(false);
            this._gscView.setInvokeRefresh(false);
            this._gsaView.setInvokeRefresh(false);
            this._lusView.setInvokeRefresh(false);
            this._esmView.setInvokeRefresh(false);
            this._hostView.setInvokeRefresh(false);
            this._hostsUtilizationView.setInvokeRefresh(false);
            return;
        }
        if (selectNode) {
            Object[] pn = this._hostsTreePanel.getPathToRoot(selNode);
            TreePath selPath = new TreePath(pn);
            this._hostsTreePanel.scrollPathToVisible(selPath);
            this._hostsTreePanel.setSelectionPath(selPath);
        }
        Object userObject = selNode.getUserObject();
        this._gsmView.setInvokeRefresh(userObject instanceof HostsTree.GSMTreeObject);
        this._gscView.setInvokeRefresh(userObject instanceof HostsTree.GSCTreeObject);
        this._gsaView.setInvokeRefresh(userObject instanceof HostsTree.GSATreeObject);
        this._lusView.setInvokeRefresh(userObject instanceof HostsTree.LUSTreeObject);
        this._esmView.setInvokeRefresh(userObject instanceof HostsTree.ESMTreeObject);
        this._hostView.setInvokeRefresh(userObject instanceof HostsTree.HostTreeObject);
        this._hostsUtilizationView.setInvokeRefresh(HostsTree._utilizationNode.equals(selNode));
        TreeNode parentTreeNode = selNode.getParent();
        if (selNode.equals(HostsTree._utilizationNode)) {
            AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            HostsViewPanel.this._hostsUtilizationView.updateRuntimeDetails();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                            LOGGER.log(Level.SEVERE, e.toString(), e);
                        }
                    }
                }
            });
            this._cardLayout.show(this._centerContainer, VIEW_UTILIZATION);
        } else if (selNode.equals(HostsTree._rootNode)) {
            this._cardLayout.show(this._centerContainer, VIEW_MONITORING);
        } else if (userObject instanceof HostsTree.HostTreeObject) {
            this._hostView.setHostTreeRoot(selNode);
            this._cardLayout.show(this._centerContainer, VIEW_HOST);
        } else if (userObject instanceof HostsTree.GSMTreeObject) {
            HostsTree.GSMTreeObject gsmTreeObject = (HostsTree.GSMTreeObject)userObject;
            ServiceItem gsmServiceItem = gsmTreeObject.getServiceItem();
            String lookupGroups = gsmTreeObject.getLookupGroups();
            String lookupLocators = gsmTreeObject.getLookupLocators();
            String zones = gsmTreeObject.getZones();
            long pid = gsmTreeObject.getPid();
            boolean isSecured = gsmTreeObject.isSecured();
            String gsaOwnerServiceID = gsmTreeObject.getGSAOwnerServiceID();
            this._gsmView.setGSM(gsmServiceItem, parentTreeNode.toString() + ":" + userObject.toString(), lookupGroups, lookupLocators, zones, gsaOwnerServiceID, pid, isSecured);
            this._cardLayout.show(this._centerContainer, VIEW_GSM);
        } else if (userObject instanceof HostsTree.GSCTreeObject) {
            HostsTree.GSCTreeObject gscTreeObject = (HostsTree.GSCTreeObject)userObject;
            ServiceItem gscServiceItem = gscTreeObject.getServiceItem();
            String lookupGroups = gscTreeObject.getLookupGroups();
            String lookupLocators = gscTreeObject.getLookupLocators();
            String zones = gscTreeObject.getZones();
            long pid = gscTreeObject.getPid();
            boolean isSecured = gscTreeObject.isSecured();
            String gsaOwnerServiceID = gscTreeObject.getGSAOwnerServiceID();
            this._gscView.setGSC(gscServiceItem, parentTreeNode.toString() + ":" + userObject.toString(), lookupGroups, lookupLocators, zones, gsaOwnerServiceID, pid, isSecured);
            this._cardLayout.show(this._centerContainer, VIEW_GSC);
        } else if (userObject instanceof HostsTree.ESMTreeObject) {
            HostsTree.ESMTreeObject esmTreeObject = (HostsTree.ESMTreeObject)userObject;
            ServiceItem esmServiceItem = esmTreeObject.getServiceItem();
            String lookupGroups = esmTreeObject.getLookupGroups();
            String lookupLocators = esmTreeObject.getLookupLocators();
            String zones = esmTreeObject.getZones();
            long pid = esmTreeObject.getPid();
            boolean isSecured = esmTreeObject.isSecured();
            String gsaOwnerServiceID = esmTreeObject.getGSAOwnerServiceID();
            this._esmView.setESM(esmServiceItem, parentTreeNode.toString() + ":" + userObject.toString(), lookupGroups, lookupLocators, zones, gsaOwnerServiceID, pid, isSecured);
            this._cardLayout.show(this._centerContainer, VIEW_ESM);
        } else if (userObject instanceof HostsTree.GSATreeObject) {
            HostsTree.GSATreeObject gsaTreeObject = (HostsTree.GSATreeObject)userObject;
            ServiceItem gsaServiceItem = gsaTreeObject.getServiceItem();
            String lookupGroups = gsaTreeObject.getLookupGroups();
            String lookupLocators = gsaTreeObject.getLookupLocators();
            String zones = gsaTreeObject.getZones();
            long pid = gsaTreeObject.getPid();
            boolean isSecured = gsaTreeObject.isSecured();
            this._gsaView.setGSA(gsaServiceItem, parentTreeNode.toString() + ":" + userObject.toString(), lookupGroups, lookupLocators, zones, null, pid, isSecured);
            this._cardLayout.show(this._centerContainer, VIEW_GSA);
        } else if (userObject instanceof HostsTree.LUSTreeObject) {
            HostsTree.LUSTreeObject lusTreeObject = (HostsTree.LUSTreeObject)userObject;
            ServiceItem serviceRegistrarItem = lusTreeObject.getServiceItem();
            String lookupGroups = lusTreeObject.getLookupGroups();
            String lookupLocators = lusTreeObject.getLookupLocators();
            String zones = lusTreeObject.getZones();
            long pid = lusTreeObject.getPid();
            boolean isSecured = lusTreeObject.isSecured();
            String gsaOwnerServiceID = lusTreeObject.getGSAOwnerServiceID();
            this._lusView.setLUS(serviceRegistrarItem, parentTreeNode.toString() + ":" + userObject.toString(), lookupGroups, lookupLocators, zones, gsaOwnerServiceID, pid, isSecured, lusTreeObject.getGsmOwnerTreeObject());
            this._cardLayout.show(this._centerContainer, VIEW_LUS);
        } else {
            this._cardLayout.show(this._centerContainer, VIEW_BLANK);
        }
    }
}

