/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.hosts;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.ILoginListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.util.PropertiesDialog;
import com.gigaspaces.admin.ui.views.RefreshThread;
import com.gigaspaces.admin.ui.views.hosts.HostsTree;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.JConsoleUIUtils;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.rmi.ConnectException;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import org.jini.rio.monitor.ProvisionMonitor;

public class ServiceDetailsBox
extends Box
implements ActionListener,
AuthenticationListener,
RefreshThread.RefreshableView,
ILoginListener {
    private JTextField _jvmVersionTextField;
    private JTextField _lookupGroupsTextField;
    private JTextField _lookupLocatorsTextField;
    private JTextField _zonesTextField;
    private JTextField _availableMemoryTextField;
    private JTextField _pidTextField;
    private JTextField _jmxServiceUrlTextField;
    private JLabel _restUrlLabel;
    private JTextField _usedMemoryTextField;
    private JTextField _usedCPUTextField;
    private JTextField _numberOfThreadsTextField;
    private JButton _jconsoleButton;
    private JButton _jVisualVmButton;
    private JButton _sysPropertiesButton;
    private static String _calculatedJavaHome;
    private ServiceItem _curServiceItem;
    private Object _curService;
    private String _serviceName;
    private String _lookupGroups = "";
    private String _lookupLocators = "";
    private String _zones = "";
    private String _jmxServiceURL;
    private String _restURL;
    private boolean _isJmxRemotePortDefined;
    private static DecimalFormat nf;
    private static DecimalFormat nfForCPU;
    private static final Dimension labelSize;
    private static final Dimension maxLabelSize;
    private static final Dimension labelSize2;
    private static final Dimension textFieldSize;
    private static final Dimension maxTextFieldSize;
    private static final Dimension minTextFieldSize;
    private static final int LEFT_ALLIGN = 3;
    private boolean _isRefresh;
    private MainUI _mainUI;
    private PropertiesDialog _propertiesDialog;
    private final boolean _isGSMView;
    private final long TIMEOUT = 1000L;
    private JVMStatistics _lastJvmStatistics;
    private static final Logger LOGGER;
    private Box _restUrlBox;

    public ServiceDetailsBox(MainUI mainUI, String serviceName) {
        this(mainUI, serviceName, false);
    }

    public ServiceDetailsBox(MainUI mainUI, String serviceName, boolean isGSMView) {
        super(1);
        this._mainUI = mainUI;
        this._isGSMView = isGSMView;
        this.init();
        this.setBorder(BorderFactory.createTitledBorder("Summary for " + serviceName));
        SecurityServicesRepository.getInstance().addAuthenticationListener(this);
        SecurityServicesRepository.getInstance().addLoginListener(this);
        new RefreshThread("Refresh-summary-detailed-for-" + serviceName, this).start();
    }

    private void init() {
        JLabel jvmVerionLabel = this.createLabel("JVM Version:");
        this._jvmVersionTextField = this.createTextField();
        Box jvmVerionBox = new Box(0);
        jvmVerionBox.add(Box.createHorizontalStrut(3));
        jvmVerionBox.add(jvmVerionLabel);
        jvmVerionBox.add(this._jvmVersionTextField);
        jvmVerionBox.add(Box.createHorizontalGlue());
        JLabel lookupGroupsLabel = this.createLabel("Lookup Groups:");
        this._lookupGroupsTextField = this.createTextField();
        Box lookupGroupsBox = new Box(0);
        lookupGroupsBox.add(Box.createHorizontalStrut(3));
        lookupGroupsBox.add(lookupGroupsLabel);
        lookupGroupsBox.add(this._lookupGroupsTextField);
        lookupGroupsBox.add(Box.createHorizontalGlue());
        JLabel lookupLocatorsLabel = this.createLabel("Lookup Locators:");
        this._lookupLocatorsTextField = this.createTextField();
        Box lookupLocatorsBox = new Box(0);
        lookupLocatorsBox.add(Box.createHorizontalStrut(3));
        lookupLocatorsBox.add(lookupLocatorsLabel);
        lookupLocatorsBox.add(this._lookupLocatorsTextField);
        lookupLocatorsBox.add(Box.createHorizontalGlue());
        JLabel zonesLabel = this.createLabel("Zones:");
        this._zonesTextField = this.createTextField();
        Box zonesBox = new Box(0);
        zonesBox.add(Box.createHorizontalStrut(3));
        zonesBox.add(zonesLabel);
        zonesBox.add(this._zonesTextField);
        zonesBox.add(Box.createHorizontalGlue());
        JLabel availableMemoryLabel = this.createLabel("Available Memory (MB):");
        this._availableMemoryTextField = this.createTextField();
        Box availableMemoryBox = new Box(0);
        availableMemoryBox.add(Box.createHorizontalStrut(3));
        availableMemoryBox.add(availableMemoryLabel);
        availableMemoryBox.add(this._availableMemoryTextField);
        availableMemoryBox.add(Box.createHorizontalGlue());
        JLabel pidLabel = this.createLabel("Process ID:");
        this._pidTextField = this.createTextField();
        Box pidBox = new Box(0);
        pidBox.add(Box.createHorizontalStrut(3));
        pidBox.add(pidLabel);
        pidBox.add(this._pidTextField);
        pidBox.add(Box.createHorizontalGlue());
        JLabel jmxUrlLabel = this.createLabel("JMX service URL:");
        this._jmxServiceUrlTextField = this.createTextField();
        Box jxmServiceUrlBox = new Box(0);
        jxmServiceUrlBox.add(Box.createHorizontalStrut(3));
        jxmServiceUrlBox.add(jmxUrlLabel);
        jxmServiceUrlBox.add(this._jmxServiceUrlTextField);
        jxmServiceUrlBox.add(Box.createHorizontalGlue());
        Box runtimeInformationBox = this.initRuntimeInformationSection();
        Box staticDetailsBox = new Box(1);
        Box horizDetailsBox = new Box(0);
        staticDetailsBox.add(Box.createVerticalStrut(3));
        staticDetailsBox.add(jvmVerionBox);
        staticDetailsBox.add(Box.createVerticalStrut(3));
        staticDetailsBox.add(lookupGroupsBox);
        staticDetailsBox.add(Box.createVerticalStrut(3));
        staticDetailsBox.add(lookupLocatorsBox);
        staticDetailsBox.add(Box.createVerticalStrut(3));
        staticDetailsBox.add(zonesBox);
        staticDetailsBox.add(Box.createVerticalStrut(3));
        staticDetailsBox.add(availableMemoryBox);
        staticDetailsBox.add(Box.createVerticalStrut(3));
        staticDetailsBox.add(pidBox);
        staticDetailsBox.add(Box.createVerticalStrut(3));
        staticDetailsBox.add(jxmServiceUrlBox);
        staticDetailsBox.add(Box.createVerticalStrut(3));
        if (this._isGSMView) {
            JLabel restUrlLabel = this.createLabel("Rest URL:");
            this._restUrlBox = new Box(0);
            this._restUrlBox.add(Box.createHorizontalStrut(3));
            this._restUrlBox.add(restUrlLabel);
            this._restUrlBox.add(this.createRestUrlLabel());
            this._restUrlBox.add(Box.createHorizontalGlue());
            staticDetailsBox.add(this._restUrlBox);
            staticDetailsBox.add(Box.createHorizontalStrut(3));
        }
        horizDetailsBox.add(staticDetailsBox);
        horizDetailsBox.add(Box.createHorizontalStrut(7));
        horizDetailsBox.add(runtimeInformationBox);
        horizDetailsBox.add(Box.createHorizontalGlue());
        this.add(horizDetailsBox);
        this.add(Box.createVerticalStrut(5));
        this.add(this.createButtonsBox());
        this.add(Box.createVerticalGlue());
    }

    private Box initRuntimeInformationSection() {
        Box runtimeInfoBox = new Box(1);
        JLabel usedMemoryLabel = this.createLabel2("Used Memory (MB):");
        this._usedMemoryTextField = this.createTextField();
        Box usedMemoryBox = new Box(0);
        usedMemoryBox.add(Box.createHorizontalStrut(3));
        usedMemoryBox.add(usedMemoryLabel);
        usedMemoryBox.add(this._usedMemoryTextField);
        usedMemoryBox.add(Box.createHorizontalGlue());
        JLabel usedCPULabel = this.createLabel2("Used CPU:");
        this._usedCPUTextField = this.createTextField();
        Box usedCPUBox = new Box(0);
        usedCPUBox.add(Box.createHorizontalStrut(3));
        usedCPUBox.add(usedCPULabel);
        usedCPUBox.add(this._usedCPUTextField);
        usedCPUBox.add(Box.createHorizontalGlue());
        JLabel numberOfThreadsLabel = this.createLabel2("Number of Threads:");
        this._numberOfThreadsTextField = this.createTextField();
        Box numberOfThreadsBox = new Box(0);
        numberOfThreadsBox.add(Box.createHorizontalStrut(3));
        numberOfThreadsBox.add(numberOfThreadsLabel);
        numberOfThreadsBox.add(this._numberOfThreadsTextField);
        numberOfThreadsBox.add(Box.createHorizontalGlue());
        runtimeInfoBox.add(usedMemoryBox);
        runtimeInfoBox.add(Box.createVerticalStrut(5));
        runtimeInfoBox.add(usedCPUBox);
        runtimeInfoBox.add(Box.createVerticalStrut(4));
        runtimeInfoBox.add(numberOfThreadsBox);
        runtimeInfoBox.add(Box.createVerticalStrut(4));
        runtimeInfoBox.setBorder(BorderFactory.createTitledBorder("Runtime Information"));
        runtimeInfoBox.setPreferredSize(new Dimension(600, 110));
        runtimeInfoBox.setMaximumSize(new Dimension(2000, 120));
        Box vertResultBox = new Box(1);
        vertResultBox.add(runtimeInfoBox);
        vertResultBox.add(Box.createVerticalGlue());
        return vertResultBox;
    }

    private Box createButtonsBox() {
        this._sysPropertiesButton = new JButton("View System Properties...");
        this._jconsoleButton = new JButton("JConsole...");
        _calculatedJavaHome = JConsoleUIUtils.manageJConsoleMenuItem(this._mainUI, this._jconsoleButton, null, true, LOGGER, false, false, this._mainUI);
        this._jVisualVmButton = new JButton("VisualVM...");
        _calculatedJavaHome = JConsoleUIUtils.manageJVisualVmMenuItem(this._mainUI, this._jVisualVmButton, null, LOGGER, false, false, this._mainUI, false);
        this._jconsoleButton.addActionListener(this);
        this._jVisualVmButton.addActionListener(this);
        this._sysPropertiesButton.addActionListener(this);
        Dimension buttonSize = new Dimension(175, 23);
        this._jconsoleButton.setPreferredSize(buttonSize);
        this._jconsoleButton.setMinimumSize(buttonSize);
        this._jconsoleButton.setMaximumSize(buttonSize);
        this._jVisualVmButton.setPreferredSize(buttonSize);
        this._jVisualVmButton.setMinimumSize(buttonSize);
        this._jVisualVmButton.setMaximumSize(buttonSize);
        this._sysPropertiesButton.setPreferredSize(buttonSize);
        this._sysPropertiesButton.setMinimumSize(buttonSize);
        this._sysPropertiesButton.setMaximumSize(buttonSize);
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalStrut(3));
        buttonsBox.add(this._jconsoleButton);
        buttonsBox.add(Box.createHorizontalStrut(8));
        buttonsBox.add(this._jVisualVmButton);
        buttonsBox.add(Box.createHorizontalStrut(8));
        buttonsBox.add(this._sysPropertiesButton);
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 11, 0));
        return buttonsBox;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setSelectionMode(0);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        textField.setEditable(false);
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    private JLabel createLabel2(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize2);
        label.setMinimumSize(labelSize2);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    public void setInvokeRefresh(boolean refresh) {
        this._isRefresh = refresh;
    }

    public void setService(ServiceItem serviceItem, String serviceName, String lookupGroups, String lookupLocators, String zones, HostsTree.GSMTreeObject gsmTreeObject) {
        this._lastJvmStatistics = null;
        this._curServiceItem = serviceItem;
        this._curService = this._curServiceItem.service;
        if (this._curService instanceof ServiceRegistrar) {
            this._curService = ((ServiceRegistrar)this._curService).getRegistrar();
        } else if (this._isGSMView) {
            GSM gsm = (GSM)this._curService;
            Repository.ProvisionMonitorHolder provisionMonitorHolder = Repository.getInstance().getProvisionMonitorHolder((ProvisionMonitor)gsm);
            String restUrl = provisionMonitorHolder != null && provisionMonitorHolder.hasManagers() ? this.retrieveRestUrl(serviceItem) : null;
            this.setRestUrl(restUrl);
        }
        this._serviceName = serviceName;
        this._zones = zones;
        this._lookupGroups = lookupGroups;
        this._lookupLocators = lookupLocators;
        this._jmxServiceURL = JSpaceUtilities.getJMXConnectionUrl((ServiceItem)serviceItem);
        this._isJmxRemotePortDefined = JSpaceUtilities.isJMXRemotePortDefined((ServiceItem)serviceItem);
        this.handleVmMonitoringButtonState();
        if (serviceItem.service instanceof ServiceRegistrar) {
            this._sysPropertiesButton.setVisible(gsmTreeObject == null);
        }
        this.updateView();
    }

    private String retrieveRestUrl(ServiceItem serviceItem) {
        String sysPropValue = (String)Repository.getInstance().getJVMDetails(serviceItem.serviceID).getSystemProperties().get("com.gs.manager.rest.url");
        return sysPropValue != null ? sysPropValue.split(",")[0] : "";
    }

    private void setRestUrl(String restURL) {
        this._restURL = restURL;
        if (restURL == null) {
            this._restUrlBox.setVisible(false);
        } else {
            this._restUrlBox.setVisible(true);
            FontMetrics fontMetrics = this._restUrlLabel.getFontMetrics(this._restUrlLabel.getFont());
            this._restUrlLabel.setText("<HTML><A HREF=\"" + this._restURL + "\">" + this._restURL + "</A></HTML>");
            int stringWidth = fontMetrics.stringWidth(restURL);
            this._restUrlLabel.setPreferredSize(new Dimension(stringWidth + 5, 23));
            this._restUrlLabel.setMaximumSize(new Dimension(stringWidth + 5, 23));
        }
    }

    private JLabel createRestUrlLabel() {
        this._restUrlLabel = new JLabel();
        this._restUrlLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ServiceDetailsBox.this._mainUI.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ServiceDetailsBox.this._mainUI.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JSpaceUIUtils.showInBrowser(ServiceDetailsBox.this._mainUI, ServiceDetailsBox.this._restURL, LOGGER);
            }
        });
        return this._restUrlLabel;
    }

    private void handleVmMonitoringButtonState() {
        this._jconsoleButton.setEnabled(this._jmxServiceURL != null);
        this._jVisualVmButton.setEnabled(this._jmxServiceURL != null);
        if (this._curServiceItem.service instanceof SecuredService) {
            SecuredService securedService = (SecuredService)this._curServiceItem.service;
            ServiceID serviceID = this._curServiceItem.serviceID;
            boolean hasMonitorJVMPermission = JSpaceUIUtils.hasPermittedPermission(securedService, serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM);
            this._sysPropertiesButton.setEnabled(hasMonitorJVMPermission);
            if (this._jmxServiceURL != null) {
                this._jconsoleButton.setEnabled(hasMonitorJVMPermission);
                this._jVisualVmButton.setEnabled(hasMonitorJVMPermission);
            }
        } else if (this._curServiceItem.service instanceof ServiceRegistrar) {
            // empty if block
        }
    }

    protected void updateView() {
        block3: {
            if (this._curServiceItem == null) {
                this.clear();
                return;
            }
            try {
                JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(this._curServiceItem, true);
                this._lookupGroupsTextField.setText(this._lookupGroups);
                this._lookupLocatorsTextField.setText(this._lookupLocators);
                this._zonesTextField.setText(this._zones);
                this._jvmVersionTextField.setText(jvmDetails == null ? "n/a" : jvmDetails.getVmVendor() + " " + jvmDetails.getVmVersion());
                this._availableMemoryTextField.setText(jvmDetails == null ? "n/a" : ServiceDetailsBox.getMemorySizeInMB(jvmDetails.getMemoryHeapMax()));
                this._pidTextField.setText(jvmDetails == null ? "n/a" : String.valueOf(jvmDetails.getPid()));
                this._jmxServiceUrlTextField.setText(JSpaceUtilities.getJMXConnectionUrl((ServiceItem)this._curServiceItem));
                this.updateRuntimeDetails();
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
    }

    @Override
    public void updateRuntimeDetails() {
        block7: {
            try {
                JVMStatistics jvmStatistics = ((JVMInfoProvider)this._curService).getJVMStatistics();
                if (jvmStatistics != null) {
                    this._usedMemoryTextField.setText(ServiceDetailsBox.getMemorySizeInMB(jvmStatistics.getMemoryHeapUsed()));
                    double cpuPerc = -1.0;
                    if (this._lastJvmStatistics != null) {
                        cpuPerc = jvmStatistics.computeCpuPerc(this._lastJvmStatistics);
                    }
                    this._lastJvmStatistics = jvmStatistics;
                    this._usedCPUTextField.setText(cpuPerc < 0.0 ? "n/a" : nfForCPU.format(cpuPerc * 100.0) + "%");
                    this._numberOfThreadsTextField.setText("" + jvmStatistics.getThreadCount());
                } else {
                    this._usedMemoryTextField.setText("n/a");
                    this._usedCPUTextField.setText("n/a");
                    this._numberOfThreadsTextField.setText("n/a");
                }
            }
            catch (ConnectException ce) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, ce.toString(), ce);
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block7;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
    }

    @Override
    public boolean shouldRefresh() {
        return this._isRefresh && this._curService != null;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public static String getMemorySizeInMB(long bytes) {
        return nf.format((double)bytes / 1024.0 / 1024.0);
    }

    protected void clear() {
        this._jvmVersionTextField.setText("");
        this._lookupGroupsTextField.setText("");
        this._lookupLocatorsTextField.setText("");
        this._zonesTextField.setText("");
        this._availableMemoryTextField.setText("");
        this._pidTextField.setText("");
        if (this._restUrlLabel != null) {
            this._restUrlLabel.setText("");
        }
        this._usedMemoryTextField.setText("");
        this._usedCPUTextField.setText("");
        this._numberOfThreadsTextField.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this._jconsoleButton)) {
            String[] commandArray = JConsoleUIUtils.createJConsoleCommand(this._mainUI, this._jmxServiceURL, _calculatedJavaHome, !this._isJmxRemotePortDefined);
            this.runCommand(commandArray);
        } else if (e.getSource().equals(this._jVisualVmButton)) {
            JConsoleUIUtils.VisualVmFileVerifierWrapper visualVmFileVerifierWrapper = JConsoleUIUtils.checkJVisualVMFile(this._mainUI, LOGGER);
            if (visualVmFileVerifierWrapper.exists()) {
                String[] commandArray = JConsoleUIUtils.createJVisualVmCommand(this._jmxServiceURL, _calculatedJavaHome, visualVmFileVerifierWrapper.getjVisualVmAppFile());
                this.runCommand(commandArray);
            } else if (visualVmFileVerifierWrapper.isShowMessage()) {
                JConsoleUIUtils.showVisualVmFileNotFoundMessage(this._mainUI, visualVmFileVerifierWrapper);
            }
        } else if (e.getSource().equals(this._sysPropertiesButton)) {
            if (this._propertiesDialog == null) {
                this._propertiesDialog = new PropertiesDialog(this._mainUI);
            }
            JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(this._curServiceItem, true);
            Map systemProperties = jvmDetails.getSystemProperties();
            this._propertiesDialog.setServiceProperties(systemProperties, this._serviceName);
            this._propertiesDialog.setVisible(true);
        }
    }

    private void runCommand(String[] commandArray) {
        block3: {
            if (commandArray != null) {
                try {
                    Runtime.getRuntime().exec(commandArray);
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
                }
            }
        }
    }

    public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
        if (this._curServiceItem != null && serviceItem.serviceID.equals((Object)this._curServiceItem.serviceID)) {
            this.handleVmMonitoringButtonState();
        }
    }

    public void loginPerformed(String userName) {
    }

    public void logoutPerformed() {
        if (this._curServiceItem != null) {
            this.setService(this._curServiceItem, this._serviceName, this._lookupGroups, this._lookupLocators, this._zones, null);
        }
    }

    static {
        nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        nfForCPU = new DecimalFormat();
        nfForCPU.setMaximumFractionDigits(1);
        labelSize = new Dimension(170, 21);
        maxLabelSize = new Dimension(470, 21);
        labelSize2 = new Dimension(166, 21);
        textFieldSize = new Dimension(330, 23);
        maxTextFieldSize = new Dimension(1000, 23);
        minTextFieldSize = new Dimension(20, 23);
        LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    }
}

