/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.utils;

import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.admin.ui.views.utils.ColumnSortListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

public abstract class BasicSortableTableModel
extends DefaultTableModel {
    protected String[] columnNames;
    private final List<BasicWrapper> _wrappersList = new ArrayList<BasicWrapper>();
    private ColumnSortListener _columnSortListener;
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public BasicSortableTableModel() {
        this.initColumnNames();
    }

    protected abstract void initColumnNames();

    public List<BasicWrapper> getWrappersList() {
        return this._wrappersList;
    }

    public BasicWrapper getWrapperAt(int index) {
        if (index >= 0 && index < this._wrappersList.size()) {
            return this._wrappersList.get(index);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        BasicWrapper basicWrapper;
        if (row >= 0 && row < this._wrappersList.size() && (basicWrapper = this._wrappersList.get(row)) != null) {
            Object val = this.getCellValue(basicWrapper, column);
            return val == null ? "" : val;
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return this.columnNames != null ? this.columnNames.length : -1;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames != null ? this.columnNames[column] : null;
    }

    public Class getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._wrappersList == null ? 0 : this._wrappersList.size();
    }

    public abstract Object getCellValue(BasicWrapper var1, int var2);

    public void clear() {
        int curRowCount = this._wrappersList.size();
        if (curRowCount > 0) {
            this._wrappersList.clear();
            this.fireTableRowsDeleted(0, curRowCount - 1);
        }
    }

    public int getWrapperIndex(BasicWrapper basicWrapper) {
        return this._wrappersList.indexOf(basicWrapper);
    }

    public void setColumnSortListener(ColumnSortListener columnSortListener) {
        this._columnSortListener = columnSortListener;
    }

    public void addWrapper(BasicWrapper basicWrapper) {
        if (!this._wrappersList.contains(basicWrapper)) {
            this._wrappersList.add(basicWrapper);
            this.fireTableRowsInserted(this._wrappersList.size() - 1, this._wrappersList.size() - 1);
            if (this._columnSortListener != null) {
                this.sortAllRows();
            }
        }
    }

    public void setWrapperAt(BasicWrapper basicWrapper, int index) {
        if (index >= 0 && index < this._wrappersList.size()) {
            this._wrappersList.set(index, basicWrapper);
            this.fireTableRowsUpdated(index, index);
            if (this._columnSortListener != null) {
                this.sortAllRows();
            }
        }
    }

    public boolean containsWrapper(BasicWrapper basicWrapper) {
        return this._wrappersList.contains(basicWrapper);
    }

    public void removeWrapper(BasicWrapper basicWrapper) {
        int index = this._wrappersList.indexOf(basicWrapper);
        if (index >= 0) {
            this._wrappersList.remove(basicWrapper);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public BasicWrapper removeWrapperAt(int index) {
        BasicWrapper removedWrapper = this._wrappersList.remove(index);
        if (removedWrapper != null) {
            this.fireTableRowsDeleted(index, index);
        }
        return removedWrapper;
    }

    public void setWrappersList(List<BasicWrapper> newBasicWrappersList, boolean isOverrideSimilarWrapper) {
        block6: {
            try {
                int newRowCount = newBasicWrappersList.size();
                boolean isTableDataChanged = false;
                for (int rowIndex = 0; rowIndex < newRowCount; ++rowIndex) {
                    BasicWrapper newBasicWrapper = newBasicWrappersList.get(rowIndex);
                    int curIndex = this._wrappersList.indexOf(newBasicWrapper);
                    if (curIndex >= 0) {
                        BasicWrapper curWrapper;
                        if (!isOverrideSimilarWrapper || (curWrapper = this._wrappersList.get(curIndex)).compareRuntimeDetails(newBasicWrapper)) continue;
                        this._wrappersList.set(curIndex, newBasicWrapper);
                        this.fireTableRowsUpdated(curIndex, curIndex);
                        isTableDataChanged = true;
                        continue;
                    }
                    this._wrappersList.add(newBasicWrapper);
                    this.fireTableRowsInserted(this._wrappersList.size() - 1, this._wrappersList.size() - 1);
                    isTableDataChanged = true;
                }
                int curRowCount = this._wrappersList.size();
                for (int rowIndex = curRowCount - 1; rowIndex >= 0; --rowIndex) {
                    BasicWrapper curBasicWrapper = this._wrappersList.get(rowIndex);
                    if (newBasicWrappersList.contains(curBasicWrapper)) continue;
                    this._wrappersList.remove(curBasicWrapper);
                    this.fireTableRowsDeleted(curRowCount - 1, curRowCount - 1);
                    isTableDataChanged = true;
                }
                if (isTableDataChanged && this._columnSortListener != null) {
                    this.sortAllRows();
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
    }

    public void sortAllRows() {
        this._columnSortListener.sortAllRows();
    }

    protected abstract int compareWrappers(BasicWrapper var1, BasicWrapper var2, int var3, boolean var4);
}

