/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.utils;

import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.admin.ui.views.utils.ColumnSortListener;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class BasicTable
extends JTable {
    private ColumnSortListener _columnSortListener;

    public BasicTable(BasicSortableTableModel tableModel) {
        super(tableModel);
        this._columnSortListener = new ColumnSortListener(this, tableModel);
        this.getTableHeader().addMouseListener(this._columnSortListener);
    }

    protected void selectTableRow(BasicWrapper selBasicWrapper) {
        int wrapperIndex;
        if (selBasicWrapper != null && (wrapperIndex = ((BasicSortableTableModel)this.getModel()).getWrapperIndex(selBasicWrapper)) != -1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (wrapperIndex < BasicTable.this.getModel().getRowCount()) {
                        BasicTable.this.setRowSelectionInterval(wrapperIndex, wrapperIndex);
                        BasicTable.this.scrollRectToVisible(BasicTable.this.getCellRect(wrapperIndex, -1, true));
                    }
                }
            });
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        int hitColumnIndex = this.columnAtPoint(p);
        int hitRowIndex = this.rowAtPoint(p);
        Object obj = this.getModel().getValueAt(hitRowIndex, hitColumnIndex);
        if (obj != null && !(obj instanceof Boolean)) {
            return obj.toString().trim().length() == 0 ? null : obj.toString();
        }
        return null;
    }
}

