/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.utils;

import com.gigaspaces.admin.ui.views.utils.UnderlineHighlighter;
import com.gigaspaces.admin.ui.views.utils.WordSearcher;
import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class BasicTextPane
extends JTextPane {
    private StyledDocument _doc;
    public static final String ERROR_STYLE_NAME = "error";
    public static final String SEARCH_STYLE_NAME = "search";
    public static final String REGEX_STYLE_NAME = "regex";
    private WordSearcher _searcher;
    private String _curSearchTxt;
    private static final Color SELECTION_COLOR = new Color(255, 255, 96);
    private static final Color REGEX_SELECTION_COLOR = new Color(81, 81, 210);

    public BasicTextPane() {
        this.setHighlighter(new UnderlineHighlighter(this, SELECTION_COLOR));
        this._doc = this.getStyledDocument();
        this._searcher = new WordSearcher(this, SELECTION_COLOR);
        this.initStyles();
    }

    public synchronized void search(final String searchTxt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicTextPane.this._curSearchTxt = searchTxt;
                int offset = BasicTextPane.this._searcher.search(searchTxt);
                if (offset != -1) {
                    try {
                        BasicTextPane.this.scrollRectToVisible(BasicTextPane.this.modelToView(offset));
                        BasicTextPane.this.repaint();
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void initStyles() {
        Style errorStyle = this._doc.addStyle(ERROR_STYLE_NAME, null);
        StyleConstants.setForeground(errorStyle, Color.ORANGE);
        StyleConstants.setFontFamily(errorStyle, "MonoSpaced");
        StyleConstants.setFontSize(errorStyle, 11);
        Style searchStyle = this._doc.addStyle(SEARCH_STYLE_NAME, null);
        StyleConstants.setForeground(searchStyle, Color.black);
        StyleConstants.setFontFamily(searchStyle, "MonoSpaced");
        StyleConstants.setFontSize(searchStyle, 11);
        Style regexStyle = this._doc.addStyle(REGEX_STYLE_NAME, null);
        StyleConstants.setForeground(regexStyle, REGEX_SELECTION_COLOR);
        StyleConstants.setFontFamily(regexStyle, "MonoSpaced");
        StyleConstants.setFontSize(regexStyle, 11);
    }

    public void invokeSearch() {
        this.search(this._curSearchTxt);
    }
}

