/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.utils;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public abstract class CheckBoxHeader
extends JCheckBox
implements TableCellRenderer,
MouseListener {
    protected CheckBoxHeader rendererComponent = this;
    protected boolean mousePressed = false;
    private JTableHeader _tableHeader;
    private int _column;

    public CheckBoxHeader(JTable table, int column) {
        this._column = column;
        this._tableHeader = table.getTableHeader();
        this._tableHeader.addMouseListener(this.rendererComponent);
        this.rendererComponent.setForeground(this._tableHeader.getForeground());
        this.rendererComponent.setBackground(this._tableHeader.getBackground());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.rendererComponent.setHorizontalAlignment(0);
        return this.rendererComponent;
    }

    protected void handleClickEvent(MouseEvent e) {
        if (this.mousePressed) {
            TableColumnModel columnModel;
            int viewColumn;
            this.mousePressed = false;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            int column = tableView.convertColumnIndexToModel(viewColumn = (columnModel = tableView.getColumnModel()).getColumnIndexAtX(e.getX()));
            if (column == this._column) {
                this.doClick();
                this.handleSelection(this.isSelected());
            }
        }
    }

    @Override
    public void setSelected(boolean isSelected) {
        super.setSelected(isSelected);
        this._tableHeader.repaint();
    }

    protected abstract void handleSelection(boolean var1);

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handleClickEvent(e);
        ((JTableHeader)e.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

