/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.utils;

import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;

public class ColumnSortListener
extends MouseAdapter {
    private boolean _ascending = false;
    private int _sortedColumnIndex = -1;
    private BasicTable _table;
    private BasicSortableTableModel _tableModel;
    private TableColumnModel _columnModel;

    public ColumnSortListener(BasicTable table, BasicSortableTableModel tableModel) {
        this._table = table;
        this._tableModel = tableModel;
        this._columnModel = this._table.getColumnModel();
        this._tableModel.setColumnSortListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this._sortedColumnIndex = this._columnModel.getColumnIndexAtX(e.getX());
            this.sortAllRowsBy(this._sortedColumnIndex, this._ascending);
            this._tableModel.fireTableDataChanged();
            this._ascending = !this._ascending;
        }
    }

    private void sortAllRowsBy(int colIndex, boolean ascending) {
        int selRow = this._table.getSelectedRow();
        BasicWrapper selBasicWrapper = null;
        if (selRow >= 0) {
            selBasicWrapper = this._tableModel.getWrapperAt(selRow);
        }
        if (this._tableModel.getWrappersList().size() > 1) {
            Collections.sort(this._tableModel.getWrappersList(), new ColumnSorter(colIndex, ascending));
        }
        this._table.selectTableRow(selBasicWrapper);
    }

    protected void sortAllRows() {
        if (this._sortedColumnIndex >= 0) {
            this.sortAllRowsBy(this._sortedColumnIndex, !this._ascending);
        }
    }

    private class ColumnSorter
    implements Comparator {
        private int colIndex;
        private boolean ascending;

        public ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        public int compare(Object a, Object b) {
            BasicWrapper wrapper1 = (BasicWrapper)a;
            BasicWrapper wrapper2 = (BasicWrapper)b;
            return ColumnSortListener.this._tableModel.compareWrappers(wrapper1, wrapper2, this.colIndex, this.ascending);
        }
    }
}

