/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.utils;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.ILoginListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.AdminUIScheduledThreadPool;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.views.CustomView;
import com.gigaspaces.admin.ui.grid.views.NoPermissionsView;
import com.gigaspaces.admin.ui.util.LogUpdateTask;
import com.gigaspaces.admin.ui.views.utils.BasicTextPane;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import com.j_spaces.tools.spacebrowser.utils.FindTextComponent;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;

public class LogComponent
extends JPanel
implements ActionListener,
AuthenticationListener,
ILoginListener {
    private BasicTextPane _logComponent;
    private StyledDocument _logComponentDocument;
    private JScrollPane _logScrollPane;
    private JTextField _patternTextField;
    private JTextField _rowsNumberField;
    private JButton _applyButton;
    private FindTextComponent _findTextComponent;
    private JButton _copyButton;
    private JButton _clearButton;
    private JToggleButton _retrieveLogsToggleButton;
    private JToolBar _toolBar;
    private JMenuItem _copyMenuItem;
    private JMenuItem _clearMenuItem;
    private JPopupMenu _popupMenu;
    private ImageIcon _startIcon;
    private ImageIcon _stopIcon;
    private JFrame _parentFrame;
    private ServiceItem _serviceItem;
    private String _gsaOwnerID;
    private long _pid;
    private String _serviceName;
    final String LOG_VIEW = "LogView";
    final String NO_PERMISSION_VIEW = "NoPermissionView";
    final String CUSTOM_VIEW = "CustomView";
    private final int DEFAULT_ROWS_NUMBER = 100;
    private ScheduledFuture _curScheduledFuture;
    private CardLayout _cardLayout;
    private static boolean _isRetrieveLogs = true;

    public LogComponent(JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.init();
        SecurityServicesRepository.getInstance().addAuthenticationListener(this);
        SecurityServicesRepository.getInstance().addLoginListener(this);
    }

    public void setService(ServiceItem serviceItem, String serviceName, String gsaOwnerID, long pid, boolean isSecuredService) {
        this.clear();
        this._retrieveLogsToggleButton.setIcon(_isRetrieveLogs ? this._stopIcon : this._startIcon);
        this._retrieveLogsToggleButton.setSelected(!_isRetrieveLogs);
        this._serviceItem = serviceItem;
        this._gsaOwnerID = gsaOwnerID;
        this._pid = pid;
        this._serviceName = serviceName;
        Object curService = serviceItem.service;
        boolean isLUS = false;
        if (curService instanceof ServiceRegistrar) {
            curService = ((ServiceRegistrar)curService).getRegistrar();
            isLUS = true;
        }
        this.setBorder(BorderFactory.createTitledBorder(serviceName + " log"));
        boolean hasPermission = true;
        if (!isLUS) {
            hasPermission = JSpaceUIUtils.hasPermittedPermission((SecuredService)curService, serviceItem.serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM, isSecuredService);
        } else {
            ServiceItem gsaOwnerServiceItem = Repository.getInstance().getGSAServiceItem(gsaOwnerID);
            if (gsaOwnerServiceItem != null) {
                SecuredService gsaSecuredService = (SecuredService)gsaOwnerServiceItem.service;
                hasPermission = JSpaceUIUtils.hasPermittedPermission(gsaSecuredService, gsaOwnerServiceItem.serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM);
            }
        }
        if (!hasPermission) {
            this._cardLayout.show(this, "NoPermissionView");
        } else {
            this._cardLayout.show(this, "LogView");
            this.handleApply(false);
        }
    }

    public void showCustomView(String serviceName) {
        this.cancelTask();
        this.setBorder(BorderFactory.createTitledBorder(serviceName + " log"));
        this._cardLayout.show(this, "CustomView");
    }

    private void runLogUpdateTask(ServiceItem serviceItem, String gsaOwnerID, long pid, String str, int rowsNumber) {
        if (!this._retrieveLogsToggleButton.isSelected()) {
            LogUpdateTask logUpdateTask = new LogUpdateTask(this._logComponent, this._logComponentDocument, rowsNumber, str, serviceItem, gsaOwnerID, pid);
            this.cancelTask();
            this._curScheduledFuture = AdminUIScheduledThreadPool.getThreadPool().scheduleWithFixedDelay(logUpdateTask, 0L, 1500L, TimeUnit.MILLISECONDS);
        }
    }

    public void cancelTask() {
        if (this._curScheduledFuture != null) {
            this._curScheduledFuture.cancel(true);
            this._curScheduledFuture = null;
        }
    }

    public void clear() {
        this._logComponent.setText("");
    }

    private void init() {
        this._logComponent = new BasicTextPane();
        this._logComponentDocument = (StyledDocument)this._logComponent.getDocument();
        this._logComponent.setEditable(false);
        this._logComponent.setBackground(Color.WHITE);
        this._logComponent.setFont(Font.getFont("Monospaced"));
        this._logScrollPane = new JScrollPane(this._logComponent);
        this._logScrollPane.setPreferredSize(new Dimension(800, 600));
        NoPermissionsView noPermissionsView = new NoPermissionsView(MonitorAuthority.MonitorPrivilege.MONITOR_JVM.toString());
        CustomView lusView = new CustomView("This view is not available for a LUS which runs within a GSM.Please refer to the log of the containing GSM");
        this._cardLayout = new CardLayout();
        this.setLayout(this._cardLayout);
        Box logView = new Box(1);
        logView.add(this.createEditorsAndButtonBox());
        logView.add(Box.createVerticalStrut(6));
        logView.add(this._logScrollPane);
        this.add((Component)logView, "LogView");
        this.add((Component)noPermissionsView, "NoPermissionView");
        this.add((Component)lusView, "CustomView");
    }

    private Box createEditorsAndButtonBox() {
        this._rowsNumberField = new WholeNumberField(true, 1, 10000);
        this._rowsNumberField.setText(String.valueOf(100));
        this._patternTextField = new JTextField();
        this._findTextComponent = new FindTextComponent(this._parentFrame, this._logComponent, true);
        this._findTextComponent.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        int componentHeight = 23;
        Dimension size1 = new Dimension(85, componentHeight);
        Dimension size2 = new Dimension(250, componentHeight);
        this._rowsNumberField.setPreferredSize(size1);
        this._rowsNumberField.setMaximumSize(size1);
        this._patternTextField.setPreferredSize(size2);
        this._patternTextField.setMaximumSize(size2);
        EnterKeyListener enterKeyListener = new EnterKeyListener();
        this._rowsNumberField.addKeyListener(enterKeyListener);
        this._patternTextField.addKeyListener(enterKeyListener);
        JLabel rowsNumberLabel = new JLabel("Number of initial rows:");
        JLabel patternTextLabel = new JLabel("Regex:");
        this._applyButton = new JButton("Apply");
        this._applyButton.setPreferredSize(new Dimension(100, componentHeight));
        this._applyButton.setMaximumSize(new Dimension(100, componentHeight));
        this.createToolBar();
        this._toolBar.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        Box filterOptionsBox = new Box(0);
        Box findBox = new Box(0);
        Box horizBox = new Box(0);
        filterOptionsBox.add(Box.createHorizontalStrut(3));
        filterOptionsBox.add(patternTextLabel);
        filterOptionsBox.add(Box.createHorizontalStrut(3));
        filterOptionsBox.add(this._patternTextField);
        filterOptionsBox.add(Box.createHorizontalStrut(10));
        filterOptionsBox.add(rowsNumberLabel);
        filterOptionsBox.add(Box.createHorizontalStrut(3));
        filterOptionsBox.add(this._rowsNumberField);
        filterOptionsBox.add(Box.createHorizontalStrut(5));
        filterOptionsBox.add(this._applyButton);
        filterOptionsBox.setBorder(BorderFactory.createTitledBorder("Filter"));
        findBox.add(Box.createHorizontalGlue());
        findBox.add(this._toolBar);
        findBox.add(Box.createHorizontalStrut(5));
        findBox.add(this._findTextComponent);
        findBox.add(Box.createHorizontalStrut(5));
        horizBox.add(filterOptionsBox);
        horizBox.add(Box.createHorizontalGlue());
        horizBox.add(findBox);
        horizBox.setMaximumSize(new Dimension(2000, componentHeight + 17));
        this._applyButton.addActionListener(this);
        return horizBox;
    }

    private void createToolBar() {
        this._toolBar = new JToolBar();
        this._toolBar.setFloatable(false);
        this._toolBar.setRollover(true);
        this._toolBar.setBorderPainted(false);
        this._popupMenu = new JPopupMenu();
        this._logComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    LogComponent.this._popupMenu.show(LogComponent.this._logComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        ImageIcon copyIcon = IconsRepository.getInstance().getIcon(111);
        this._copyButton = new JButton(copyIcon);
        this._copyButton.setToolTipText("Copy");
        this._copyButton.addActionListener(this);
        this._copyMenuItem = new JMenuItem("Copy", copyIcon);
        this._copyMenuItem.addActionListener(this);
        this._popupMenu.add(this._copyMenuItem);
        this._toolBar.add(this._copyButton);
        ImageIcon clearIcon = IconsRepository.getInstance().getIcon(112);
        this._clearButton = new JButton(clearIcon);
        this._clearButton.setToolTipText("Clear Log");
        this._clearButton.addActionListener(this);
        this._clearMenuItem = new JMenuItem("Clear", clearIcon);
        this._clearMenuItem.addActionListener(this);
        this._popupMenu.add(this._clearMenuItem);
        this._toolBar.add(this._clearButton);
        this._startIcon = IconsRepository.getInstance().getIcon(113);
        this._stopIcon = IconsRepository.getInstance().getIcon(114);
        this._retrieveLogsToggleButton = new JToggleButton(this._stopIcon);
        this._retrieveLogsToggleButton.setToolTipText("Disable log sampling");
        this._retrieveLogsToggleButton.addActionListener(this);
        this._toolBar.add(this._retrieveLogsToggleButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._applyButton)) {
            this.handleApply(true);
        } else if (source.equals(this._copyButton) || source.equals(this._copyMenuItem)) {
            String selectedText = this._logComponent.getSelectedText();
            if (selectedText != null && selectedText.trim().length() > 0) {
                StringSelection ss = new StringSelection(selectedText);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
            }
        } else if (source.equals(this._clearButton) || source.equals(this._clearMenuItem)) {
            int returnValue = JOptionPane.showConfirmDialog(this._parentFrame, "Are you sure you want to clear the log content accumulated until this point?", "Clear Log", 0, 1);
            if (returnValue == 0) {
                this._logComponent.setText("");
            }
        } else if (source.equals(this._retrieveLogsToggleButton)) {
            boolean isSelected = this._retrieveLogsToggleButton.isSelected();
            this._retrieveLogsToggleButton.setIcon(isSelected ? this._startIcon : this._stopIcon);
            if (isSelected) {
                _isRetrieveLogs = false;
                this.cancelTask();
                this._retrieveLogsToggleButton.setToolTipText("Enable log sampling");
            } else {
                _isRetrieveLogs = true;
                this.handleApply(true);
                this._retrieveLogsToggleButton.setToolTipText("Disable log sampling");
            }
        }
    }

    private void handleApply(boolean isInvokeClear) {
        String rowsNumText = this._rowsNumberField.getText();
        if (rowsNumText.trim().length() == 0) {
            JOptionPane.showMessageDialog(this._parentFrame, "The initial number of rows to display cannot be empty.", "Log", 1);
            return;
        }
        int rowsNum = Integer.parseInt(rowsNumText);
        String pattern = this._patternTextField.getText();
        if (isInvokeClear) {
            this.clear();
        }
        this.runLogUpdateTask(this._serviceItem, this._gsaOwnerID, this._pid, pattern, rowsNum);
    }

    public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
        if (this._serviceItem != null) {
            if (this._serviceItem.serviceID.equals((Object)serviceItem.serviceID)) {
                this.setService(serviceItem, this._serviceName, this._gsaOwnerID, this._pid, true);
            } else if (this._serviceItem.service instanceof ServiceRegistrar && serviceItem.service instanceof GSA && this._gsaOwnerID != null && serviceItem.serviceID.toString().equals(this._gsaOwnerID)) {
                this.setService(this._serviceItem, this._serviceName, this._gsaOwnerID, this._pid, true);
            }
        }
    }

    public void loginPerformed(String userName) {
    }

    public void logoutPerformed() {
        this._cardLayout.show(this, "NoPermissionView");
    }

    public class EnterKeyListener
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                LogComponent.this.handleApply(true);
            }
        }
    }
}

