/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.utils;

import com.gigaspaces.admin.ui.views.utils.BasicTextPane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

class UnderlineHighlighter
extends DefaultHighlighter {
    protected Highlighter.HighlightPainter painter;

    public UnderlineHighlighter(BasicTextPane textPane, Color c) {
        this.painter = new UnderlineHighlightPainter(textPane, c);
    }

    public Object addHighlight(int p0, int p1) throws BadLocationException {
        return this.addHighlight(p0, p1, this.painter);
    }

    @Override
    public void setDrawsLayeredHighlights(boolean newValue) {
        if (!newValue) {
            throw new IllegalArgumentException("UnderlineHighlighter only draws layered highlights");
        }
        super.setDrawsLayeredHighlights(true);
    }

    public static class UnderlineHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        protected Color color;
        private JTextComponent _textComponent;

        public UnderlineHighlightPainter(JTextComponent textComponent, Color c) {
            super(c);
            this.color = c;
            this._textComponent = textComponent;
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            g.setColor(this.color == null ? c.getSelectionColor() : this.color);
            Rectangle alloc = null;
            if (this._textComponent.getSelectedText() == null || this._textComponent.getSelectedText().trim().length() == 0) {
                if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                    alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
                } else {
                    try {
                        Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                        alloc = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    }
                    catch (BadLocationException e) {
                        return null;
                    }
                }
                g.fillRect(alloc.x, alloc.y + 2, alloc.width, alloc.height - 2);
            }
            return alloc;
        }
    }
}

