/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.views.utils;

import com.gigaspaces.admin.ui.views.utils.UnderlineHighlighter;
import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

class WordSearcher {
    protected JTextComponent comp;
    protected Highlighter.HighlightPainter painter;

    public WordSearcher(JTextComponent comp, Color color) {
        this.comp = comp;
        this.painter = new UnderlineHighlighter.UnderlineHighlightPainter(comp, color);
    }

    public int search(String word) {
        int firstOffset = -1;
        Highlighter highlighter = this.comp.getHighlighter();
        Highlighter.Highlight[] highlights = highlighter.getHighlights();
        for (int i = 0; i < highlights.length; ++i) {
            Highlighter.Highlight h = highlights[i];
            if (!(h.getPainter() instanceof UnderlineHighlighter.UnderlineHighlightPainter)) continue;
            highlighter.removeHighlight(h);
        }
        if (word == null || word.equals("")) {
            return -1;
        }
        String content = null;
        try {
            Document d = this.comp.getDocument();
            content = d.getText(0, d.getLength()).toLowerCase();
        }
        catch (BadLocationException e) {
            return -1;
        }
        word = word.toLowerCase();
        int lastIndex = 0;
        int wordSize = word.length();
        while ((lastIndex = content.indexOf(word, lastIndex)) != -1) {
            int endIndex = lastIndex + wordSize;
            try {
                highlighter.addHighlight(lastIndex, endIndex, this.painter);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (firstOffset == -1) {
                firstOffset = lastIndex;
            }
            lastIndex = endIndex;
        }
        return firstOffset;
    }
}

