/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.security.ui.CustomLoginDialog;
import com.gigaspaces.admin.security.ui.LoginDialog;
import com.gigaspaces.admin.ui.security.monitor.LoginMonitorDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import net.jini.core.lookup.ServiceItem;

public class SecurityUtils {
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public static boolean login(Component parentComponent, boolean showLoginMonitoring) {
        LoginDialog loginDialog = null;
        if (parentComponent instanceof JFrame) {
            loginDialog = new LoginDialog((JFrame)parentComponent);
        } else if (parentComponent instanceof JDialog) {
            loginDialog = new LoginDialog((JDialog)parentComponent);
        }
        loginDialog.setVisible(true);
        boolean isUserLoggedIn = SecurityServicesRepository.getInstance().isUserLoggedIn();
        if (showLoginMonitoring && loginDialog.isOKPressed() && parentComponent instanceof JFrame) {
            LoginMonitorDialog.getInstance((JFrame)parentComponent).setVisible(true);
        }
        return isUserLoggedIn;
    }

    public static boolean login(Component parentComponent, ServiceItem serviceItem) {
        Dialog loginDialog = null;
        if (parentComponent instanceof JFrame) {
            loginDialog = new LoginDialog((JFrame)parentComponent, serviceItem);
        } else if (parentComponent instanceof JDialog) {
            loginDialog = new LoginDialog((JDialog)parentComponent, serviceItem);
        }
        loginDialog.setVisible(true);
        return false;
    }

    public static boolean customLogin(Component parentComponent, boolean showLoginMonitoring) {
        CustomLoginDialog customLoginDialog = null;
        if (parentComponent instanceof JFrame) {
            customLoginDialog = new CustomLoginDialog((JFrame)parentComponent);
        } else if (parentComponent instanceof JDialog) {
            customLoginDialog = new CustomLoginDialog((JDialog)parentComponent);
        }
        customLoginDialog.setVisible(true);
        boolean isUserLoggedIn = SecurityServicesRepository.getInstance().isUserLoggedIn();
        if (showLoginMonitoring && customLoginDialog.isOKPressed() && parentComponent instanceof JFrame) {
            LoginMonitorDialog.getInstance((JFrame)parentComponent).setVisible(true);
        }
        return isUserLoggedIn;
    }

    public static boolean customLogin(Component parentComponent, ServiceItem serviceItem) {
        Dialog customLoginDialog = null;
        if (parentComponent instanceof JFrame) {
            customLoginDialog = new CustomLoginDialog((JFrame)parentComponent, serviceItem);
        } else if (parentComponent instanceof JDialog) {
            customLoginDialog = new CustomLoginDialog((JDialog)parentComponent, serviceItem);
        }
        customLoginDialog.setVisible(true);
        return false;
    }

    public static void logout() {
        SecurityServicesRepository.getInstance().logout();
    }
}

