/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.grid.deploy.GSMTable;
import com.gigaspaces.internal.utils.SecurityUtils;
import com.gigaspaces.internal.utils.ValidationUtils;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import java.awt.Component;
import javax.swing.JOptionPane;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class UIValidationUtils
extends ValidationUtils {
    private static final String MSG_UNABLE_TO_DEPLOY_READ_ONLY_GSM = "Authentication failure. Unable to deploy processing unit without the <" + GridAuthority.GridPrivilege.PROVISION_PU + "> permission.";
    private static final String MSG_UNABLE_TO_DEPLOY_USER_DOES_NOT_EXIST = "Unable to perform deployment. Authentication failed.";

    public static boolean validateCredentials(Component parentComponent, Authentication authentication, ServiceItem serviceItem, GSMTable gsmTable) {
        if (authentication == null) {
            if (SecurityServicesRepository.getInstance().isUserLoggedIn()) {
                JOptionPane.showMessageDialog(parentComponent, MSG_UNABLE_TO_DEPLOY_THEN_LOGIN_TO_GSM_ALREADY_LOOGED_IN, "Deployment", 2);
                return false;
            }
            int returnedVal = JOptionPane.showConfirmDialog(parentComponent, MSG_UNABLE_TO_DEPLOY_THEN_LOGIN_TO_GSM, "Deployment Validation", 0, 2);
            if (returnedVal == 0) {
                boolean isLoginSucceed = SecurityUtils.login(parentComponent, serviceItem);
                if (isLoginSucceed) {
                    ServiceID securedServiceID = serviceItem.serviceID;
                    Authentication resultAuthentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(securedServiceID);
                    if (resultAuthentication != null) {
                        gsmTable.reloadSelectedDeployAdmin();
                        gsmTable.repaint();
                        if (resultAuthentication.getGrantedAuthorities().isGranted((Privilege)GridAuthority.GridPrivilege.PROVISION_PU)) {
                            return true;
                        }
                        JOptionPane.showMessageDialog(parentComponent, MSG_UNABLE_TO_DEPLOY_READ_ONLY_GSM, "Deployment Validation", 2);
                        return false;
                    }
                } else {
                    JOptionPane.showMessageDialog(parentComponent, MSG_UNABLE_TO_DEPLOY_USER_DOES_NOT_EXIST, "Deployment", 2);
                    return false;
                }
            }
            return false;
        }
        if (!authentication.getGrantedAuthorities().isGranted((Privilege)GridAuthority.GridPrivilege.PROVISION_PU)) {
            JOptionPane.showMessageDialog(parentComponent, MSG_UNABLE_TO_DEPLOY_READ_ONLY_GSM, "Deployment Validation", 1);
            return false;
        }
        return true;
    }
}

