/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.excel;

import com.gigaspaces.internal.utils.excel.ExcelWorkbookException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.RichTextString;

public class ExcelWorkbook {
    protected final HSSFWorkbook wb;
    final String xlsFileName;
    final boolean alreadyExists;

    public ExcelWorkbook(String xlsFileName) {
        if (!xlsFileName.endsWith(".xls")) {
            throw new IllegalArgumentException("Excel file name must end with .xls");
        }
        this.xlsFileName = xlsFileName;
        boolean fileAlreadyExists = false;
        try {
            File file = new File(xlsFileName);
            fileAlreadyExists = file.exists();
            if (file.length() == 0L) {
                file.delete();
                file.createNewFile();
                fileAlreadyExists = false;
            }
            if (fileAlreadyExists) {
                ExcelWorkbook.createBackupOf(file);
                POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
                this.wb = new HSSFWorkbook(fs);
            } else {
                this.wb = new HSSFWorkbook();
            }
            FileOutputStream fileOut = new FileOutputStream(xlsFileName);
            fileOut.close();
        }
        catch (Exception e) {
            throw new ExcelWorkbookException(e);
        }
        finally {
            this.alreadyExists = fileAlreadyExists;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createBackupOf(File inputFile) throws Exception {
        String backupFileName = inputFile.getPath();
        backupFileName = backupFileName.replaceFirst(".xls", ".bak.xls");
        File outputFile = new File(backupFileName);
        FileInputStream fis = new FileInputStream(inputFile);
        FileOutputStream fos = new FileOutputStream(outputFile);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void close() {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.xlsFileName);
            this.wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            throw new ExcelWorkbookException(e);
        }
    }

    public boolean alreadyExists() {
        return this.alreadyExists;
    }

    public void createSheet(String sheetName) {
        if (!this.containsSheet(sheetName)) {
            this.wb.createSheet(sheetName);
        }
    }

    public boolean containsSheet(String sheetName) {
        HSSFSheet sheet = this.wb.getSheet(sheetName);
        return sheet != null;
    }

    public void createTitleRow(String sheetName, Object ... objects) {
        HSSFFont font = this.wb.createFont();
        font.setBold(true);
        HSSFCellStyle style = this.wb.createCellStyle();
        style.setFont(font);
        this.createRowUtil(sheetName, style, objects);
    }

    public void createRow(String sheetName, Object ... objects) {
        this.createRowUtil(sheetName, null, objects);
    }

    private void createRowUtil(String sheetName, HSSFCellStyle style, Object ... objects) {
        this.createSheet(sheetName);
        HSSFSheet sheet = this.wb.getSheet(sheetName);
        int lastRowNum = sheet.getLastRowNum() + 1;
        HSSFRow row = sheet.createRow(lastRowNum);
        for (int i = 0; i < objects.length; ++i) {
            HSSFCell cell = row.createCell((int)((short)i));
            this.setCellValue(cell, objects[i]);
            if (style == null) continue;
            cell.setCellStyle(style);
        }
    }

    private void setCellValue(HSSFCell cell, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            cell.setCellValue(((Integer)value).doubleValue());
        } else if (value instanceof Long) {
            cell.setCellValue(((Long)value).doubleValue());
        } else if (value instanceof String) {
            cell.setCellValue((RichTextString)new HSSFRichTextString((String)value));
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            HSSFCellStyle cellStyle = this.wb.createCellStyle();
            cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
            cell.setCellValue((Date)value);
            cell.setCellStyle(cellStyle);
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
        }
    }
}

