/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.tools.IServiceManager;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lookup.RegistrarEventRegistration;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.export.Exporter;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;

public class LookupServiceListener
implements DiscoveryListener,
RemoteEventListener,
ServiceDiscoveryListener {
    private transient LeaseRenewalManager _leaseManager;
    private final List<IServiceManager> _serviceManagers;
    private static final Class[] CONTAINER_CLASSTYPE = new Class[]{IJSpaceContainer.class, IJSpaceContainerAdmin.class};
    private static final Class[] SPACE_CLASSTYPE = new Class[]{IJSpace.class};
    private final ServiceTemplate _containerServiceTemplate;
    private final ServiceTemplate _spaceServiceTemplate;
    private final RemoteEventListener _stub;
    private final Exporter _exporter = ServiceConfigLoader.getExporter();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public LookupServiceListener(IServiceManager serviceManager, Class[] serviceClassType) throws RemoteException {
        this._serviceManagers = new Vector<IServiceManager>();
        if (serviceManager != null) {
            this._serviceManagers.add(serviceManager);
        }
        this._leaseManager = new LeaseRenewalManager();
        this._containerServiceTemplate = new ServiceTemplate(null, CONTAINER_CLASSTYPE, null);
        this._spaceServiceTemplate = new ServiceTemplate(null, SPACE_CLASSTYPE, null);
        this._stub = (RemoteEventListener)this._exporter.export((Remote)((Object)this));
    }

    public LookupServiceListener(IServiceManager serviceManager) throws RemoteException {
        this(serviceManager, null);
    }

    public LookupServiceListener() throws RemoteException {
        this(null, null);
    }

    public synchronized void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] registrars = discoveryEvent.getRegistrars();
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("LookupServiceListener | discovered() | " + registrars[0].getLocator().getHost());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.doLookupWork(registrars);
        this.doEventReg(registrars);
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }

    public void doLookupWork(ServiceRegistrar[] registrars) {
        for (int i = 0; i < registrars.length; ++i) {
            try {
                int j;
                ServiceMatches csm = registrars[i].lookup(this._containerServiceTemplate, Integer.MAX_VALUE);
                ServiceMatches ssm = registrars[i].lookup(this._spaceServiceTemplate, Integer.MAX_VALUE);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("csm: " + csm + " total:" + csm.totalMatches + "\nssm: " + ssm + " total:" + ssm.totalMatches);
                }
                for (j = 0; j < csm.items.length; ++j) {
                    if (csm.items[j].service == null) continue;
                    for (IServiceManager manager : this._serviceManagers) {
                        manager.addService(csm.items[j]);
                    }
                }
                for (j = 0; j < ssm.items.length; ++j) {
                    if (ssm.items[j].service == null) continue;
                    for (IServiceManager manager : this._serviceManagers) {
                        manager.addService(ssm.items[j]);
                    }
                }
                continue;
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void doEventReg(ServiceRegistrar[] registrars) {
        RegistrarEventRegistration conReg = null;
        RegistrarEventRegistration spaceReg = null;
        for (int i = 0; i < registrars.length; ++i) {
            block6: {
                try {
                    conReg = registrars[i].notify(new ServiceTemplate(null, CONTAINER_CLASSTYPE, null), 3, this._stub, new MarshalledObject<ServiceRegistrar>(registrars[i]), Long.MAX_VALUE);
                    spaceReg = registrars[i].notify(new ServiceTemplate(null, SPACE_CLASSTYPE, null), 3, this._stub, new MarshalledObject<ServiceRegistrar>(registrars[i]), Long.MAX_VALUE);
                }
                catch (Exception ex) {
                    if (ex instanceof ClassNotFoundException) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("Wrong definition of java.rmi.server.codebase=" + System.getProperty("java.rmi.server.codebase"));
                        }
                    }
                    if (!_logger.isLoggable(Level.FINE)) break block6;
                    _logger.log(Level.FINE, ex.getMessage(), ex);
                }
            }
            if (conReg != null) {
                this._leaseManager.renewUntil(conReg.getLease(), Long.MAX_VALUE, null);
            }
            if (spaceReg == null) continue;
            this._leaseManager.renewUntil(spaceReg.getLease(), Long.MAX_VALUE, null);
        }
    }

    public synchronized void notify(RemoteEvent inEvt) throws UnknownEventException, RemoteException {
        ServiceEvent srvEvt = (ServiceEvent)inEvt;
        if (srvEvt.getServiceItem() == null) {
            for (IServiceManager manager : this._serviceManagers) {
                manager.removeService(srvEvt.getServiceID(), null);
            }
        } else {
            for (IServiceManager manager : this._serviceManagers) {
                manager.addService(srvEvt.getServiceItem());
            }
        }
    }

    public void addServiceManager(IServiceManager manager) {
        this._serviceManagers.add(manager);
    }

    public void removeServiceManager(IServiceManager manager) {
        this._serviceManagers.remove(manager);
    }

    public void serviceAdded(ServiceDiscoveryEvent event) {
        ServiceItem item = event.getPostEventServiceItem();
        this.serviceAdded(item);
    }

    public void serviceRemoved(ServiceDiscoveryEvent event) {
        ServiceItem item = event.getPreEventServiceItem();
        this.serviceRemoved(item);
    }

    public void serviceChanged(ServiceDiscoveryEvent event) {
    }

    public void serviceAdded(ServiceItem item) {
        if (item != null) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("%%%| Service ADDED: " + item.toString());
            }
            for (IServiceManager manager : this._serviceManagers) {
                manager.addService(item);
            }
        }
    }

    public void serviceRemoved(ServiceItem item) {
        if (item != null) {
            for (IServiceManager manager : this._serviceManagers) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("%%%| Service Removed: " + item.toString());
                }
                manager.removeService(item.serviceID, null);
            }
        }
    }

    public void serviceChanged(ServiceItem item) {
    }
}

