/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;

public class PrimaryBackupIndicationListener {
    private static final PrimaryBackupIndicationListener listenerInstance;
    private final Map<ServiceID, SpaceIndicationWrapper> _registeredSpacesMap = new Hashtable<ServiceID, SpaceIndicationWrapper>();
    private static final Logger _logger;

    public static PrimaryBackupIndicationListener getInstance() {
        return listenerInstance;
    }

    public SpaceMode getSpaceMode(ServiceID spaceID) {
        SpaceIndicationWrapper spaceIndicationWrapper;
        SpaceMode spaceMode = null;
        if (spaceID != null && (spaceIndicationWrapper = this._registeredSpacesMap.get(spaceID)) != null) {
            spaceMode = spaceIndicationWrapper.getSpaceMode();
        }
        return spaceMode;
    }

    public void removeSpace(ServiceID serviceID) {
        if (serviceID != null) {
            SpaceIndicationWrapper spaceIndicationWrapper = this._registeredSpacesMap.remove(serviceID);
            if (_logger.isLoggable(Level.FINE)) {
                IJSpace space = null;
                if (spaceIndicationWrapper != null) {
                    space = spaceIndicationWrapper._space;
                }
                _logger.fine("removeSpace - PrimaryBackupIndication: space=" + space + ", service id:" + serviceID + ", CALLED FROM: \n" + JSpaceUtilities.getStackTrace((Throwable)new Exception("--DEBUG--")));
            }
        }
    }

    public void addSpace(IJSpace spaceProxy, ServiceID serviceID) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("addSpace - PrimaryBackupIndication: " + spaceProxy + ", service id:" + serviceID + ", stack trace:" + JSpaceUtilities.getStackTrace((Throwable)new Exception("FINE CALL DEBUG")));
        }
        if (!this._registeredSpacesMap.containsKey(serviceID)) {
            try {
                ISpaceModeListener remoteListener = (ISpaceModeListener)spaceProxy.getDirectProxy().getStubHandler().exportObject((Remote)((Object)new SpaceModeListenerImpl(spaceProxy, serviceID)));
                IInternalRemoteJSpaceAdmin internalRemoteJSpaceAdmin = (IInternalRemoteJSpaceAdmin)Repository.addSpaceAdminObjectToMap(spaceProxy);
                SpaceMode mode = internalRemoteJSpaceAdmin.addSpaceModeListener(remoteListener);
                short spaceMode = mode.equals((Object)SpaceMode.PRIMARY) ? (short)2 : 3;
                SpaceBrowser.getInstance().setSpaceMode(serviceID, spaceMode);
                SpaceIndicationWrapper spaceIndicationWrapper = new SpaceIndicationWrapper(mode, spaceProxy, internalRemoteJSpaceAdmin);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("-- PrimaryBackupIndication, Put to registered map: " + spaceProxy + " service id:" + serviceID + " space mode=" + mode);
                }
                this._registeredSpacesMap.put(serviceID, spaceIndicationWrapper);
            }
            catch (Exception re) {
                _logger.log(Level.FINE, "Failed to add space mode listener to clustered space" + JSpaceUtilities.LINE_SEPARATOR + re.toString(), re);
            }
        }
    }

    private PrimaryBackupIndicationListener() {
    }

    static {
        _logger = Logger.getLogger("com.gigaspaces.admin.ui");
        listenerInstance = new PrimaryBackupIndicationListener();
    }

    private class SpaceIndicationWrapper {
        private SpaceMode _spaceMode;
        private IInternalRemoteJSpaceAdmin _remoteJSpaceAdmin;
        private IJSpace _space;

        public SpaceIndicationWrapper(SpaceMode spaceMode, IJSpace space, IInternalRemoteJSpaceAdmin remoteJSpaceAdmin) {
            this._spaceMode = spaceMode;
            this._space = space;
            this._remoteJSpaceAdmin = remoteJSpaceAdmin;
        }

        public SpaceMode getSpaceMode() {
            return this._spaceMode;
        }

        public void setSpaceMode(SpaceMode spaceMode) {
            this._spaceMode = spaceMode;
        }

        public IInternalRemoteJSpaceAdmin getRemoteJSpaceAdmin() {
            return this._remoteJSpaceAdmin;
        }
    }

    class SpaceModeListenerImpl
    implements ISpaceModeListener {
        private ServiceID _spaceID;
        private IJSpace _spaceProxy;

        SpaceModeListenerImpl(IJSpace spaceProxy, ServiceID spaceID) {
            this._spaceID = spaceID;
            this._spaceProxy = spaceProxy;
        }

        public void beforeSpaceModeChange(SpaceMode newMode) throws RemoteException {
        }

        public void afterSpaceModeChange(SpaceMode newMode) throws RemoteException {
            SpaceIndicationWrapper spaceIndicationWrapper = (SpaceIndicationWrapper)PrimaryBackupIndicationListener.this._registeredSpacesMap.get(this._spaceID);
            _logger.log(Level.FINE, "> afterSpaceModeChange, space=" + this._spaceProxy + ", serviceID=" + this._spaceID + ", new mode=" + newMode);
            if (spaceIndicationWrapper != null) {
                _logger.log(Level.FINE, "> afterSpaceModeChange WITHIN IF, serviceID=" + this._spaceID + ", new mode=" + newMode);
                spaceIndicationWrapper.setSpaceMode(newMode);
                short spaceMode = newMode.equals((Object)SpaceMode.PRIMARY) ? (short)2 : 3;
                SpaceBrowser.getInstance().setSpaceMode(this._spaceID, spaceMode);
            }
        }
    }
}

