/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.gigaspaces.cluster.replication.MirrorServiceConfig;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.GroupInfo;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EditCluster {
    private Document rootDoc;
    private String clusterConfigFile;
    private String clusterName;
    private ClusterMemberInfo[] clusterMembers;
    private ClusterMemberInfo[] primaryMembers;
    private ClusterMemberInfo[] backupsMembers;
    private int backupsPerMember;
    private GroupInfo[] clusterGroups;
    private long creationTime;
    private MirrorServiceConfig _mirrorServiceConfig;
    private ClusterMemberInfo _mirrorMemInfo;
    private String _clusterSchemaName;
    private boolean _isUseClusterSchema;
    private boolean _isGenerateMembersDynamically;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public EditCluster(String clusterConfigURLs) throws Exception {
        this(clusterConfigURLs, null, null);
    }

    public EditCluster(String clusterConfigURLs, Document doc, SpaceConfig spaceConfig) throws Exception {
        ClusterXML clusterXML = null;
        clusterXML = doc == null ? new ClusterXML(clusterConfigURLs) : new ClusterXML(doc, "remote location");
        if (spaceConfig != null) {
            this._mirrorServiceConfig = spaceConfig.getClusterInfo().getMirrorServiceConfig();
        }
        this.init(spaceConfig, clusterXML);
        clusterXML = null;
    }

    public EditCluster(int totalMembers, int backupMembers, String clusterSchemaName, String clusterName, String distCacheConfigName, String jmsConfigName) throws Exception {
        ClusterXML clusterXML = new ClusterXML(totalMembers, backupMembers, clusterSchemaName, clusterName, distCacheConfigName, jmsConfigName, null);
        this.init(null, clusterXML);
        clusterXML = null;
    }

    private void init(SpaceConfig spaceConfig, ClusterXML clusterXML) throws Exception {
        this.clusterConfigFile = clusterXML.getClusterFileURL();
        this.rootDoc = clusterXML.getXMLRootDocument();
        this.clusterName = ClusterXML.getNodeValueIfExists((Element)((Element)this.rootDoc.getFirstChild()), (String)"cluster-name");
        this.clusterMembers = this.createClusterMemberProperties(this.clusterName, spaceConfig);
        this.clusterGroups = this.createClusterGroups(clusterXML);
        this._clusterSchemaName = clusterXML.getClusterSchemaName();
        this._isUseClusterSchema = clusterXML.useClusterSchema();
        this._isGenerateMembersDynamically = clusterXML.isGenerateMembersDynamically();
        this.creationTime = System.currentTimeMillis();
    }

    public String getClusterSchemaName() {
        return this._clusterSchemaName;
    }

    public boolean useClusterSchema() {
        return this._isUseClusterSchema;
    }

    public boolean isGenerateMembersDynamically() {
        return this._isGenerateMembersDynamically;
    }

    public String toString() {
        return this.clusterName;
    }

    public ClusterMemberInfo[] getClusterMembers() {
        return this.clusterMembers;
    }

    public ClusterMemberInfo[] getPrimaryMemers() {
        return this.primaryMembers;
    }

    public ClusterMemberInfo[] getBackupsMemers() {
        return this.backupsMembers;
    }

    public int getBackupsPerMember() {
        return this.backupsPerMember;
    }

    public boolean isMirrorDefined() {
        return this._mirrorMemInfo != null;
    }

    public GroupInfo[] getClusterGroups() {
        return this.clusterGroups;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterFile() {
        return this.clusterConfigFile;
    }

    private ClusterMemberInfo[] createClusterMemberProperties(String clusterName, SpaceConfig spaceConfig) throws CreateException {
        NodeList cml;
        ClusterPolicy clusterPolicy;
        Vector<ClusterMemberInfo> membersVec = new Vector<ClusterMemberInfo>();
        Vector<ClusterMemberInfo> primaryVec = new Vector<ClusterMemberInfo>();
        Vector<ClusterMemberInfo> backupsVec = new Vector<ClusterMemberInfo>();
        String firstBackupMemberPrefix = null;
        this.backupsPerMember = 0;
        Map clusterMemberInfoMap = null;
        ClusterPolicy clusterPolicy2 = clusterPolicy = spaceConfig != null ? spaceConfig.getClusterPolicy() : null;
        if (clusterPolicy != null) {
            clusterMemberInfoMap = JSpaceUtilities.getClusterMembersInfoMap((ClusterPolicy)clusterPolicy);
        }
        if ((cml = this.rootDoc.getElementsByTagName("cluster-members")).getLength() == 0) {
            throw new CreateException("<cluster-members> tag not found in " + this.clusterConfigFile + " cluster config file.");
        }
        Element clusMemElem = (Element)cml.item(0);
        NodeList memberNodeList = clusMemElem.getElementsByTagName("member");
        for (int i = 0; i < memberNodeList.getLength(); ++i) {
            Vector paramTable = new Vector();
            String memberName = ClusterXML.getNodeValueIfExists((Element)((Element)memberNodeList.item(i)), (String)"member-name");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(">>> clusterMemberInfoMap=" + clusterMemberInfoMap);
                if (clusterMemberInfoMap != null) {
                    _logger.fine("clusterMemberInfoMap=" + clusterMemberInfoMap.toString());
                    _logger.fine("> memberName=" + memberName);
                    _logger.fine(">> clusterMemberInfoMap.get( memberName )=" + clusterMemberInfoMap.get(memberName));
                    if (clusterMemberInfoMap.get(memberName) != null) {
                        _logger.fine(">> clusterMemberInfoMap.get( memberName ).memberURL.getURL()=" + ((ClusterMemberInfo)clusterMemberInfoMap.get((Object)memberName)).memberURL);
                    }
                }
            }
            String memberURL = clusterMemberInfoMap != null && clusterMemberInfoMap.get(memberName) != null ? ((ClusterMemberInfo)clusterMemberInfoMap.get((Object)memberName)).memberURL.getURL() : ClusterXML.getNodeValueIfExists((Element)((Element)memberNodeList.item(i)), (String)"member-url");
            SpaceURL spaceURL = null;
            try {
                spaceURL = SpaceURLParser.parseURL((String)memberURL);
            }
            catch (MalformedURLException e) {
                _logger.log(Level.SEVERE, e.toString(), e);
            }
            NodeList paramNL = ((Element)memberNodeList.item(i)).getElementsByTagName("param");
            for (int z = 0; z < paramNL.getLength(); ++z) {
                String paramName = ClusterXML.getNodeValueIfExists((Element)((Element)paramNL.item(z)), (String)"param-name");
                String paramValue = ClusterXML.getNodeValueIfExists((Element)((Element)paramNL.item(z)), (String)"param-value");
                if (paramName == null) {
                    throw new CreateException("\"param-name\" tag or value not exists for " + memberName + " member name. Check " + this.clusterConfigFile + " cluster config file.");
                }
                if (paramValue == null) {
                    throw new CreateException("\"param-value\" tag or value not exists for " + memberName + " member name. Check " + this.clusterConfigFile + " cluster config file.");
                }
                Vector<String> pt = new Vector<String>();
                pt.add(paramName);
                pt.add(paramValue);
                paramTable.add(pt);
            }
            boolean isBackup = false;
            int fromIndex = memberName.indexOf(95);
            if (fromIndex != -1 && memberName.indexOf(95, fromIndex + 1) != -1) {
                isBackup = true;
                String backupMemberPrefix = memberName.substring(0, memberName.indexOf(95, fromIndex + 1));
                if (firstBackupMemberPrefix == null) {
                    firstBackupMemberPrefix = backupMemberPrefix;
                    ++this.backupsPerMember;
                } else if (firstBackupMemberPrefix.equals(backupMemberPrefix)) {
                    ++this.backupsPerMember;
                }
            }
            ClusterMemberInfo memInfo = new ClusterMemberInfo(memberName, spaceURL, clusterName, null, paramTable, isBackup, null, false);
            membersVec.add(memInfo);
            if (memInfo.isBackup) {
                backupsVec.add(memInfo);
                continue;
            }
            primaryVec.add(memInfo);
        }
        if (this._mirrorServiceConfig != null) {
            this._mirrorMemInfo = this.createMirrorClusterMember();
            membersVec.add(this._mirrorMemInfo);
            primaryVec.add(this._mirrorMemInfo);
        }
        this.primaryMembers = primaryVec.toArray(new ClusterMemberInfo[primaryVec.size()]);
        this.backupsMembers = backupsVec.toArray(new ClusterMemberInfo[backupsVec.size()]);
        return membersVec.toArray(new ClusterMemberInfo[membersVec.size()]);
    }

    private ClusterMemberInfo createMirrorClusterMember() {
        SpaceURL memberURL = this._mirrorServiceConfig.serviceURL;
        String mirrorMemberName = memberURL.getURL();
        if (memberURL != null) {
            String mirrorSpaceName;
            String mirrrorContainerName = memberURL.getContainerName();
            mirrorMemberName = mirrorSpaceName = memberURL.getSpaceName();
            if (mirrrorContainerName != null) {
                mirrorMemberName = mirrrorContainerName + ":" + mirrorSpaceName;
            }
        }
        ClusterMemberInfo mirrorMemInfo = new ClusterMemberInfo(mirrorMemberName, memberURL, this.clusterName, null, new Vector(1), false, null, true);
        return mirrorMemInfo;
    }

    private GroupInfo[] createClusterGroups(ClusterXML clusterXML) throws CreateException {
        Vector<GroupInfo> groupsVec = new Vector<GroupInfo>();
        NodeList gl = this.rootDoc.getElementsByTagName("group");
        if (gl.getLength() == 0) {
            throw new CreateException("<group> tag not found in " + this.clusterConfigFile + " cluster config file.");
        }
        block0: for (int i = 0; i < gl.getLength(); ++i) {
            Element groupElem = (Element)gl.item(i);
            NodeList ml = groupElem.getElementsByTagName("member-name");
            if (ml.getLength() <= 0) continue;
            String groupName = ClusterXML.getNodeValueIfExists((Element)groupElem, (String)"group-name");
            ClusterMemberInfo[] memGroup = this.createGroupMembers(groupElem, groupName, clusterXML);
            GroupInfo.ReplicationInfo repGroup = this.createReplicationGroup(groupName, memGroup[0].memberName, clusterXML);
            GroupInfo.LoadBalancingInfo lbGroup = this.createLoadBalancingGroup(groupElem);
            FailOverPolicy failOverGroup = this.createFailOverGroup(groupName, memGroup[0].memberName, clusterXML);
            GroupInfo grInfo = new GroupInfo(repGroup, lbGroup, failOverGroup, groupName, this.clusterName);
            grInfo.groupMembers = memGroup;
            groupsVec.add(grInfo);
            if (repGroup == null) continue;
            for (int z = 0; z < memGroup.length; ++z) {
                if ((memGroup[z].m_replTransmissionPolicies == null || memGroup[z].m_replTransmissionPolicies.size() <= 0) && memGroup[z].m_replFilters == null && memGroup[z].m_replRecovery == null) continue;
                repGroup.m_TransmissionMatrix = true;
                continue block0;
            }
        }
        return groupsVec.toArray(new GroupInfo[groupsVec.size()]);
    }

    private ClusterMemberInfo[] createGroupMembers(Element groupElem, String groupName, ClusterXML clusterXML) throws CreateException {
        ClusterMemberInfo clonedMirrorMember;
        Vector<ClusterMemberInfo> groupMem = new Vector<ClusterMemberInfo>();
        ArrayList<String> groupMemNames = new ArrayList<String>();
        ArrayList<Node> groupMemNodes = new ArrayList<Node>();
        HashMap<String, ClusterMemberInfo> clusMemInfoCloneMap = new HashMap<String, ClusterMemberInfo>(this.clusterMembers.length);
        for (int i = 0; i < this.clusterMembers.length; ++i) {
            ClusterMemberInfo clusterMemberInfo = this.clusterMembers[i];
            clusterMemberInfo.setGroupName(groupName);
            clusMemInfoCloneMap.put(clusterMemberInfo.memberName, (ClusterMemberInfo)clusterMemberInfo.clone());
        }
        NodeList memList = groupElem.getElementsByTagName("member-name");
        int listSize = memList.getLength();
        if (listSize < 1) {
            throw new CreateException("The group: " + groupName + " should contain at least 1 cluster member.");
        }
        for (int i = 0; i < listSize; ++i) {
            String memName = memList.item(i).getFirstChild().getNodeValue();
            ClusterMemberInfo groupMember = (ClusterMemberInfo)clusMemInfoCloneMap.get(memName);
            if (groupMember == null) continue;
            groupMem.add(groupMember);
            groupMemNames.add(groupMember.memberName);
            groupMemNodes.add(memList.item(i).getParentNode());
        }
        if (this._mirrorMemInfo != null && (clonedMirrorMember = (ClusterMemberInfo)clusMemInfoCloneMap.get(this._mirrorMemInfo.memberName)) != null) {
            groupMem.add(clonedMirrorMember);
            groupMemNames.add(clonedMirrorMember.memberName);
            groupMemNodes.add(memList.item(0).getParentNode());
        }
        int groupMembersCount = groupMem.size();
        for (int i = 0; i < groupMembersCount; ++i) {
            ClusterMemberInfo memInfo = (ClusterMemberInfo)groupMem.get(i);
            ReplicationPolicy.ReplicationPolicyDescription polDesc = clusterXML.createReplDescPolicy(memInfo.memberName, (Element)groupMemNodes.get(i), groupMemNames);
            ClusterMemberInfo.ReplFilters replFilter = null;
            ClusterMemberInfo.ReplRecovery replRecovery = null;
            if (polDesc.inputReplicationFilterClassName != null) {
                replFilter = new ClusterMemberInfo.ReplFilters();
                replFilter.inputReplicationFilterClassName = polDesc.inputReplicationFilterClassName;
                if (polDesc.inputReplicationFilterParamUrl != null) {
                    replFilter.inputReplicationFilterParamUrl = polDesc.inputReplicationFilterParamUrl;
                }
            }
            if (polDesc.outputReplicationFilterClassName != null) {
                if (replFilter == null) {
                    replFilter = new ClusterMemberInfo.ReplFilters();
                }
                replFilter.outputReplicationFilterClassName = polDesc.outputReplicationFilterClassName;
                if (polDesc.outputReplicationFilterParamUrl != null) {
                    replFilter.outputReplicationFilterParamUrl = polDesc.outputReplicationFilterParamUrl;
                }
            }
            if (polDesc.sourceMemberRecovery != null) {
                String sourceRecovery = polDesc.sourceMemberRecovery == null ? "First available member" : polDesc.sourceMemberRecovery;
                replRecovery = new ClusterMemberInfo.ReplRecovery(polDesc.memberRecovery, sourceRecovery);
            }
            memInfo.createClusterMemberAttributes(polDesc.replTransmissionPolicies, replFilter, replRecovery);
        }
        return groupMem.toArray(new ClusterMemberInfo[groupMem.size()]);
    }

    private GroupInfo.LoadBalancingInfo createLoadBalancingGroup(Element groupElem) throws CreateException {
        GroupInfo.LoadBalancingInfo lbInfo = null;
        NodeList loadBalNodeList = groupElem.getElementsByTagName("load-bal-policy");
        if (loadBalNodeList.getLength() > 0) {
            lbInfo = new GroupInfo.LoadBalancingInfo();
            Element lbElem = (Element)loadBalNodeList.item(0);
            String applyOwnershipStr = ClusterXML.getNodeValueIfExists((Element)lbElem, (String)"apply-ownership");
            lbInfo.setApplyOwnership(applyOwnershipStr != null ? Boolean.parseBoolean(applyOwnershipStr) : false);
            String disaleParallelScatteringStr = ClusterXML.getNodeValueIfExists((Element)lbElem, (String)"disable-parallel-scattering");
            lbInfo.setDisableParallelScattering(disaleParallelScatteringStr != null ? Boolean.parseBoolean(disaleParallelScatteringStr) : false);
            String threadPoolMinSizeStr = ClusterXML.getNodeValueIfExists((Element)lbElem, (String)"proxy-broadcast-threadpool-min-size");
            lbInfo.setProxyBroadcatThreadpoolMinSize(threadPoolMinSizeStr != null && threadPoolMinSizeStr.length() != 0 ? Integer.parseInt(threadPoolMinSizeStr) : 0);
            String threadPoolMaxSizeStr = ClusterXML.getNodeValueIfExists((Element)lbElem, (String)"proxy-broadcast-threadpool-max-size");
            lbInfo.setProxyBroadcatThreadpoolMaxSize(threadPoolMaxSizeStr != null && threadPoolMaxSizeStr.length() != 0 ? Integer.parseInt(threadPoolMaxSizeStr) : 0);
            lbInfo.m_WriteOperationsPolicy = this.createLoadBalancingDescPolicy(lbElem, "write");
            lbInfo.m_ReadOperationsPolicy = this.createLoadBalancingDescPolicy(lbElem, "read");
            lbInfo.m_TakeOperationsPolicy = this.createLoadBalancingDescPolicy(lbElem, "take");
            lbInfo.m_NotifyOperationsPolicy = this.createLoadBalancingDescPolicy(lbElem, "notify");
            lbInfo.m_DefaultPolicy = this.createLoadBalancingDescPolicy(lbElem, "default");
        }
        return lbInfo;
    }

    private GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription createLoadBalancingDescPolicy(Element loadBalanceElem, String operationName) throws CreateException {
        GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription loadBalanceDesc = null;
        NodeList operTypeNL = loadBalanceElem.getElementsByTagName(operationName);
        if (operTypeNL.getLength() > 0) {
            Vector paramTable = new Vector();
            Element operElem = (Element)operTypeNL.item(0);
            String policyType = ClusterXML.getNodeValueIfExists((Element)operElem, (String)"policy-type");
            String broadcastCondition = ClusterXML.getNodeValueIfExists((Element)operElem, (String)"broadcast-condition");
            if (policyType == null) {
                throw new CreateException("\"policy-type\" tag or value not exists for [" + operationName + "] operation under " + "load-bal-policy" + " tag.");
            }
            NodeList paramNL = operElem.getElementsByTagName("param");
            for (int z = 0; z < paramNL.getLength(); ++z) {
                String paramName = ClusterXML.getNodeValueIfExists((Element)((Element)paramNL.item(z)), (String)"param-name");
                String paramValue = ClusterXML.getNodeValueIfExists((Element)((Element)paramNL.item(z)), (String)"param-value");
                if (paramName == null) {
                    throw new CreateException("\"param-name\" tag or value not exists for " + operationName + " operation name under " + "load-bal-policy" + " tag. Check " + this.clusterConfigFile + " cluster config file.");
                }
                if (paramValue == null) {
                    throw new CreateException("\"param-value\" tag or value not exists for " + operationName + " operation name under " + "load-bal-policy" + " tag. Check " + this.clusterConfigFile + " cluster config file.");
                }
                Vector<String> pt = new Vector<String>();
                pt.add(paramName);
                pt.add(paramValue);
                paramTable.add(pt);
            }
            loadBalanceDesc = new GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription();
            loadBalanceDesc.m_PolicyType = policyType;
            Vector vector = loadBalanceDesc.m_paramTable = paramTable.size() > 0 ? paramTable : null;
            if (broadcastCondition == null) {
                broadcastCondition = operationName.equals("write") || operationName.equals("notify") ? "never" : "routing-index-is-null";
            }
            loadBalanceDesc.setBroadcastCondition(broadcastCondition);
        }
        return loadBalanceDesc;
    }

    private GroupInfo.ReplicationInfo createReplicationGroup(String groupName, String memberName, ClusterXML clusterXML) throws CreateException {
        ReplicationPolicy replPolicy = null;
        try {
            replPolicy = clusterXML.createClusterPolicy((String)memberName).m_ReplicationPolicy;
        }
        catch (NullPointerException ex) {
            _logger.log(Level.SEVERE, ex.toString(), ex);
            return null;
        }
        if (replPolicy == null || !replPolicy.m_ReplicationGroupName.equals(groupName)) {
            return null;
        }
        GroupInfo.ReplicationInfo repInfo = new GroupInfo.ReplicationInfo();
        repInfo.m_PolicyType = replPolicy.m_PolicyType;
        repInfo.m_MemoryRecovery = replPolicy.m_Recovery;
        repInfo.m_ReplicateNotifyTemplates = replPolicy.m_ReplicateNotifyTemplates;
        repInfo.m_TriggerNotifyTemplates = replPolicy.m_TriggerNotifyTemplates;
        repInfo.m_SpaceFinderTimeout = String.valueOf(replPolicy.m_SpaceFinderTimeout);
        repInfo.m_SyncOnCommit = replPolicy.m_SyncOnCommit;
        repInfo.m_ReplicateOriginalState = replPolicy.isReplicateOriginalState();
        repInfo.m_SyncOnCommitTimeOut = String.valueOf(replPolicy.m_SyncOnCommitTimeout);
        repInfo.m_ReplicationChunkSize = String.valueOf(replPolicy.m_ReplicationChunkSize);
        repInfo.m_ReplicationIntervalMillis = String.valueOf(replPolicy.m_ReplicationIntervalMillis);
        repInfo.m_ReplicationIntervalOperations = String.valueOf(replPolicy.m_ReplicationIntervalOperations);
        repInfo.m_ReliableAsyncReplication = replPolicy.isReliableAsyncRepl();
        repInfo.m_ReplicationMode = replPolicy.m_ReplicationMode;
        repInfo.m_TodoQueueTimeout = String.valueOf(replPolicy.m_SyncReplPolicy.getTodoQueueTimeout());
        repInfo.m_MinUnicastWorkingThreads = String.valueOf(replPolicy.m_SyncReplPolicy.getUnicastMinThreadPoolSize());
        repInfo.m_MaxUnicastWorkingThreads = String.valueOf(replPolicy.m_SyncReplPolicy.getUnicastMaxThreadPoolSize());
        repInfo.m_MinMulticastWorkingThreads = String.valueOf(replPolicy.m_SyncReplPolicy.getMulticastMinThreadPoolSize());
        repInfo.m_MaxMulticastWorkingThreads = String.valueOf(replPolicy.m_SyncReplPolicy.getMulticastMaxThreadPoolSize());
        repInfo.m_IpGroup = String.valueOf(replPolicy.m_SyncReplPolicy.getMulticastIpGroup());
        repInfo.m_Port = String.valueOf(replPolicy.m_SyncReplPolicy.getMulticastPort());
        repInfo.m_TTL = ClusterXML.TTL_DEFAULT_VALUE;
        repInfo.m_ReplFindReportInterval = ClusterXML.REPL_FIND_REPORT_INTERVAL_DEFAULT_VALUE;
        repInfo.m_RedoLogCapacity = ClusterXML.REPL_REDO_LOG_CAPACITY_DEFAULT_VALUE;
        repInfo.m_RecoveryChunkSize = ClusterXML.RECOVERY_CHUNK_SIZE_DEFAULT_VALUE;
        repInfo.m_RecoveryThreadPoolSize = "4";
        return repInfo;
    }

    private FailOverPolicy createFailOverGroup(String groupName, String memberName, ClusterXML clusterXML) throws CreateException {
        FailOverPolicy failOverGroup = null;
        try {
            failOverGroup = clusterXML.createClusterPolicy((String)memberName).m_FailOverPolicy;
        }
        catch (NullPointerException ex) {
            return null;
        }
        if (failOverGroup != null && failOverGroup.failOverGroupName.equals(groupName)) {
            return failOverGroup;
        }
        return null;
    }

    public void setSpaceIDToMember(ServiceID spaceID, String memberName) {
        this.setSpaceIDToMember(this.primaryMembers, spaceID, memberName);
        this.setSpaceIDToMember(this.clusterMembers, spaceID, memberName);
        this.setSpaceIDToMember(this.backupsMembers, spaceID, memberName);
        for (GroupInfo groupInfo : this.clusterGroups) {
            this.setSpaceIDToMember(groupInfo.groupMembers, spaceID, memberName);
        }
    }

    private void setSpaceIDToMember(ClusterMemberInfo[] members, ServiceID spaceID, String memberName) {
        if (members == null) {
            return;
        }
        for (ClusterMemberInfo member : members) {
            if (!member.memberName.equals(memberName)) continue;
            member.setSpaceID(spaceID);
            break;
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

