/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.ISetPanel;
import com.j_spaces.tools.cluster.TwoSelectionListPanel;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class GroupFailOverPanel
extends JPanel
implements ISetPanel {
    JFrame m_parent;
    GroupInfo m_groupInfo;
    Vector<String> m_allGroupMembers;
    JLabel labFailOverFindTimeout;
    WholeNumberField txtfFailOverFindTimeout;
    final int ENABLE_COLUMN_WIDTH = 60;
    final String[] OPERATIONS;
    final String[] POLICY_TYPE;
    OperationsTable m_operationTable;
    ColumnSortListener m_columnSortListener;
    JTabbedPane m_tabbedPanOperations;
    JTabbedPane m_tabbedPaneFO;
    JPanel m_panPolicyDesc;
    BackupMembersDialog m_backupMembersDialog;
    FailOverPolicyDescriptionPanel[] m_panOperationPolicyDesc;
    private JCheckBox failBackCheckBox;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public GroupFailOverPanel(JFrame parent, GroupInfo info, GroupInfo[] allGroups) {
        block4: {
            this.m_allGroupMembers = new Vector();
            this.ENABLE_COLUMN_WIDTH = 60;
            this.OPERATIONS = new String[]{"Default", "Write", "Read", "Take", "Notify"};
            this.POLICY_TYPE = new String[]{"Fail To Available", "Fail To Backup"};
            this.m_operationTable = new OperationsTable();
            this.m_columnSortListener = new ColumnSortListener();
            this.m_tabbedPanOperations = new JTabbedPane();
            this.m_tabbedPaneFO = new JTabbedPane();
            this.m_panPolicyDesc = new JPanel();
            this.failBackCheckBox = new JCheckBox("Fail-back");
            this.m_parent = parent;
            try {
                String groupName = null;
                if (info != null) {
                    groupName = info.groupName;
                }
                this.m_backupMembersDialog = new BackupMembersDialog(parent);
                this.m_panOperationPolicyDesc = new FailOverPolicyDescriptionPanel[5];
                for (int i = 0; i < this.m_panOperationPolicyDesc.length; ++i) {
                    this.m_panOperationPolicyDesc[i] = new FailOverPolicyDescriptionPanel(this, this.OPERATIONS[i]);
                }
                this.jbInit();
                this.init(info, allGroups);
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    public GroupFailOverPanel(JFrame parent) {
        this(parent, null, null);
    }

    public GroupFailOverPanel() {
        this(new JFrame());
    }

    public void init(GroupInfo groupInfo, Object[] availableAltGroups) {
        this.m_groupInfo = groupInfo;
        String groupToRemove = null;
        Object altGroups = null;
        this.m_allGroupMembers.clear();
        if (groupInfo != null) {
            groupToRemove = groupInfo.groupName;
            for (int i = 0; i < groupInfo.groupMembers.length; ++i) {
                ClusterMemberInfo item = groupInfo.groupMembers[i];
                if (item == null) continue;
                this.m_allGroupMembers.add(item.memberName);
            }
            this.restoreSettings(groupInfo.failOverInfo, true);
        }
    }

    void jbInit() throws Exception {
        this.labFailOverFindTimeout = new JLabel("Find Timeout Msec:");
        this.txtfFailOverFindTimeout = new WholeNumberField();
        JPanel panTimeOut = new JPanel(new GridBagLayout());
        panTimeOut.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), ""), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        panTimeOut.add((Component)this.labFailOverFindTimeout, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        panTimeOut.add((Component)this.txtfFailOverFindTimeout, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        for (int i = 0; i < this.m_panOperationPolicyDesc.length; ++i) {
            this.m_tabbedPanOperations.add((Component)this.m_panOperationPolicyDesc[i], this.OPERATIONS[i]);
        }
        JScrollPane operationsScrollPane = new JScrollPane(this.m_operationTable);
        operationsScrollPane.setPreferredSize(new Dimension(5, 109));
        this.m_panPolicyDesc.setLayout(new BorderLayout());
        this.m_panPolicyDesc.add((Component)operationsScrollPane, "North");
        this.m_panPolicyDesc.add((Component)this.m_tabbedPanOperations, "Center");
        this.m_tabbedPaneFO.add((Component)this.m_panPolicyDesc, "Policy Description");
        this.setLayout(new BorderLayout());
        this.failBackCheckBox.setMnemonic('F');
        this.add((Component)this.failBackCheckBox, "North");
        this.add((Component)this.m_tabbedPaneFO, "Center");
        this.m_tabbedPanOperations.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int row = GroupFailOverPanel.this.m_tabbedPanOperations.getSelectedIndex();
                if (row != GroupFailOverPanel.this.m_operationTable.getSelectedRow()) {
                    GroupFailOverPanel.this.m_operationTable.changeSelection(row, row, false, false);
                }
            }
        });
    }

    @Override
    public void reset() {
        this.txtfFailOverFindTimeout.setValueInt(2000);
        this.failBackCheckBox.setSelected(false);
        for (int i = 0; i < this.m_tabbedPanOperations.getTabCount(); ++i) {
            this.m_tabbedPanOperations.setEnabledAt(i, false);
            this.m_panOperationPolicyDesc[i].reset();
        }
        this.m_operationTable.reset();
    }

    @Override
    public void restoreSettings(Object obj, boolean isEditMode) {
        if (obj == null || !(obj instanceof FailOverPolicy)) {
            return;
        }
        FailOverPolicy failOverInfo = (FailOverPolicy)obj;
        this.txtfFailOverFindTimeout.setValueInt((int)failOverInfo.spaceFinderTimeout);
        this.failBackCheckBox.setSelected(failOverInfo.isFailBackEnabled());
        HashMap<String, FailOverPolicy.FailOverPolicyDescription> foPolicyDesc = new HashMap<String, FailOverPolicy.FailOverPolicyDescription>();
        foPolicyDesc.put(this.OPERATIONS[0], failOverInfo.m_DefaultFOPolicy);
        foPolicyDesc.put(this.OPERATIONS[1], failOverInfo.m_WriteFOPolicy);
        foPolicyDesc.put(this.OPERATIONS[2], failOverInfo.m_ReadFOPolicy);
        foPolicyDesc.put(this.OPERATIONS[3], failOverInfo.m_TakeFOPolicy);
        foPolicyDesc.put(this.OPERATIONS[4], failOverInfo.m_NotifyFOPolicy);
        for (int i = 0; i < this.m_panOperationPolicyDesc.length; ++i) {
            Object desc = foPolicyDesc.get(this.m_panOperationPolicyDesc[i].mi_operationName);
            if (desc != null) {
                this.m_panOperationPolicyDesc[i].restoreSettings(desc, isEditMode);
            }
            this.m_tabbedPanOperations.setEnabledAt(i, desc != null);
        }
        Vector newDataVector = new Vector();
        for (int i = 0; i < this.OPERATIONS.length; ++i) {
            FailOverPolicy.FailOverPolicyDescription desc = (FailOverPolicy.FailOverPolicyDescription)foPolicyDesc.get(this.OPERATIONS[i]);
            Boolean isEnabled = desc != null;
            String policyType = desc != null ? this.POLICY_TYPE[desc.m_PolicyType] : this.POLICY_TYPE[0];
            Vector<Object> rowVector = new Vector<Object>(3);
            rowVector.add(isEnabled);
            rowVector.add(this.OPERATIONS[i]);
            rowVector.add(policyType);
            newDataVector.add(rowVector);
        }
        this.m_operationTable.tableModel.updateDataVector(newDataVector);
    }

    private int getEnabledTabIndex(JTabbedPane tabbedPane) {
        int index = -1;
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            if (!tabbedPane.isEnabledAt(i)) continue;
            index = i;
            break;
        }
        return index;
    }

    private class OperationsTable
    extends JTable {
        final String[] COLUMN_LABELS;
        static final int OPERATION_DEFAULT = 0;
        CustomTableModel tableModel;
        JComboBox cmboxPolicyType;
        Object previousPolicyType;

        public OperationsTable() {
            block3: {
                this.COLUMN_LABELS = new String[]{"Enable", "Operation", "Policy Type"};
                this.tableModel = new CustomTableModel();
                this.cmboxPolicyType = new JComboBox<String>(GroupFailOverPanel.this.POLICY_TYPE);
                try {
                    for (int i = 0; i < GroupFailOverPanel.this.OPERATIONS.length; ++i) {
                        this.tableModel.addRow(new Object[]{Boolean.FALSE, GroupFailOverPanel.this.OPERATIONS[i], GroupFailOverPanel.this.POLICY_TYPE[0], Boolean.FALSE});
                    }
                    this.setModel(this.tableModel);
                    this.setRowHeight(this.getRowHeight() + 2);
                    this.getColumnModel().getColumn(2).setCellEditor(new PolicyTypeCellEditor(this.cmboxPolicyType, this));
                    this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            int selectedRow;
                            if (e.getValueIsAdjusting()) {
                                return;
                            }
                            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                            if (!lsm.isSelectionEmpty() && OperationsTable.this.tableModel.isOperationEnabled(selectedRow = lsm.getMinSelectionIndex())) {
                                GroupFailOverPanel.this.m_tabbedPanOperations.setSelectedIndex(selectedRow);
                            }
                        }
                    });
                    this.getColumnModel().getColumn(0).setMaxWidth(60);
                    this.getColumnModel().getColumn(0).setMinWidth(60);
                    this.getTableHeader().addMouseListener(GroupFailOverPanel.this.m_columnSortListener);
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block3;
                    _logger.log(Level.SEVERE, ex.toString(), ex);
                }
            }
        }

        public void reset() {
            Vector newDataVector = new Vector();
            int rowCount = GroupFailOverPanel.this.m_operationTable.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Vector<Object> rowVector = new Vector<Object>(4);
                rowVector.add(Boolean.FALSE);
                rowVector.add(GroupFailOverPanel.this.OPERATIONS[i]);
                rowVector.add(GroupFailOverPanel.this.POLICY_TYPE[0]);
                rowVector.add(Boolean.FALSE);
                newDataVector.add(rowVector);
            }
            GroupFailOverPanel.this.m_operationTable.tableModel.updateDataVector(newDataVector);
            this.clearSelection();
            this.changeSelection(0, 0, false, false);
        }

        public Object[] getOpeartionSettings(int row) {
            Object[] result = new Object[3];
            result[0] = this.getValueAt(row, 0);
            Object policyType = this.getValueAt(row, 2);
            for (int i = 0; i < GroupFailOverPanel.this.POLICY_TYPE.length; ++i) {
                if (!policyType.equals(GroupFailOverPanel.this.POLICY_TYPE[i])) continue;
                result[1] = i;
            }
            result[2] = this.getValueAt(row, 3);
            return result;
        }

        public boolean hasPolicyType(String policyType) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.getValueAt(row, 2).equals(policyType)) continue;
                return true;
            }
            return false;
        }

        public boolean hasPolicyType(int operation, String policyType) {
            return this.getValueAt(operation, 2).equals(policyType);
        }

        public boolean isOperationEnabled(int row) {
            return this.tableModel.isOperationEnabled(row);
        }

        class CustomTableModel
        extends DefaultTableModel {
            public CustomTableModel() {
                for (int i = 0; i < OperationsTable.this.COLUMN_LABELS.length; ++i) {
                    this.addColumn(OperationsTable.this.COLUMN_LABELS[i]);
                }
                this.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent ev) {
                        if (ev.getType() == 0) {
                            int selectedRowIndex = ev.getFirstRow();
                            CustomTableModel model = (CustomTableModel)ev.getSource();
                            boolean enabled = (Boolean)model.getValueAt(selectedRowIndex, 0);
                            String policyType = (String)model.getValueAt(selectedRowIndex, 2);
                            if (ev.getColumn() == 0) {
                                GroupFailOverPanel.this.m_tabbedPanOperations.setEnabledAt(selectedRowIndex, enabled);
                                if (enabled) {
                                    GroupFailOverPanel.this.m_tabbedPanOperations.setSelectedIndex(selectedRowIndex);
                                } else {
                                    if (!CustomTableModel.this.isBasicOperationsEnabled()) {
                                        GroupFailOverPanel.this.m_operationTable.setValueAt(Boolean.TRUE, 0, 0);
                                        return;
                                    }
                                    int rowIndex = GroupFailOverPanel.this.getEnabledTabIndex(GroupFailOverPanel.this.m_tabbedPanOperations);
                                    if (rowIndex == -1) {
                                        rowIndex = 0;
                                        GroupFailOverPanel.this.m_tabbedPanOperations.setEnabledAt(rowIndex, true);
                                        GroupFailOverPanel.this.m_operationTable.setValueAt(Boolean.TRUE, 0, 0);
                                    }
                                    GroupFailOverPanel.this.m_operationTable.changeSelection(rowIndex, 1, false, false);
                                    GroupFailOverPanel.this.m_tabbedPanOperations.setSelectedIndex(rowIndex);
                                }
                            }
                            if (ev.getColumn() == 2) {
                                boolean b = policyType.equals(GroupFailOverPanel.this.POLICY_TYPE[1]);
                                GroupFailOverPanel.this.m_panOperationPolicyDesc[selectedRowIndex].setTabsEnabled(b);
                            }
                        }
                    }
                });
            }

            public boolean isBasicOperationsEnabled() {
                for (int i = 1; i < GroupFailOverPanel.this.OPERATIONS.length; ++i) {
                    if (this.isOperationEnabled(i)) continue;
                    return false;
                }
                return true;
            }

            public boolean isOperationEnabled(int row) {
                return (Boolean)this.getValueAt(row, 0);
            }

            public void updateDataVector(Vector dataVec) {
                this.dataVector = dataVec;
                this.fireTableRowsUpdated(0, dataVec.size() - 1);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column != 0 && !this.isOperationEnabled(row)) {
                    return false;
                }
                return column != 1;
            }

            public Class getColumnClass(int columnIndex) {
                if (columnIndex != 2) {
                    Vector v = (Vector)this.dataVector.elementAt(0);
                    return v.elementAt(columnIndex).getClass();
                }
                return super.getColumnClass(columnIndex);
            }
        }

        class PolicyTypeCellEditor
        extends DefaultCellEditor {
            JComboBox combo;
            JTable table;

            public PolicyTypeCellEditor(JComboBox combo, JTable table) {
                super(combo);
                this.combo = combo;
                this.table = table;
                combo.setFont(table.getFont());
            }

            @Override
            public boolean isCellEditable(EventObject ev) {
                OperationsTable.this.previousPolicyType = this.table.getValueAt(this.table.getSelectedRow(), 2);
                return super.isCellEditable(ev);
            }
        }
    }

    private class FailOverPolicyDescriptionPanel
    extends JPanel
    implements ISetPanel {
        private static final int ADD_ROW_HEIGHT = 4;
        String mi_operationName;
        JTabbedPane mi_tabbedPaneBackups;
        BackupOnlyPanel mi_backupOnlyPanel;
        BackupMembersPanel mi_backupMembersPanel;

        public FailOverPolicyDescriptionPanel(Component parent, String operationName) {
            block2: {
                this.mi_tabbedPaneBackups = new JTabbedPane();
                this.mi_backupOnlyPanel = new BackupOnlyPanel(this);
                this.mi_backupMembersPanel = new BackupMembersPanel(this);
                try {
                    this.mi_operationName = operationName;
                    this.jbInit();
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block2;
                    _logger.log(Level.SEVERE, ex.toString(), ex);
                }
            }
        }

        void jbInit() throws Exception {
            this.mi_tabbedPaneBackups.add((Component)this.mi_backupMembersPanel, "Backup Members");
            this.mi_tabbedPaneBackups.add((Component)this.mi_backupOnlyPanel, "Backup Only");
            this.setLayout(new BorderLayout());
            this.add((Component)this.mi_tabbedPaneBackups, "Center");
        }

        public void setTabsEnabled(boolean enable) {
            this.mi_tabbedPaneBackups.setEnabledAt(0, enable);
            this.mi_tabbedPaneBackups.setEnabledAt(1, enable);
            JSpaceUIUtils.setAWTComponentsStatus(this.mi_backupOnlyPanel, enable);
            JSpaceUIUtils.setAWTComponentsStatus(this.mi_backupMembersPanel, enable);
        }

        @Override
        public void reset() {
            this.mi_backupMembersPanel.reset();
            this.mi_backupOnlyPanel.reset();
        }

        @Override
        public void restoreSettings(Object obj, boolean isEditMode) {
            if (obj == null) {
                return;
            }
            FailOverPolicy.FailOverPolicyDescription descr = (FailOverPolicy.FailOverPolicyDescription)obj;
            this.mi_backupMembersPanel.restoreSettings(descr.m_BackupMemberNames, isEditMode);
            this.mi_backupOnlyPanel.restoreSettings(descr.m_BackupOnly, isEditMode);
        }

        public void saveSettingsTo(FailOverPolicy.FailOverPolicyDescription decription) {
            decription.m_BackupMemberNames = (HashMap)this.mi_backupMembersPanel.saveSettings();
            decription.m_BackupOnly = (Vector)this.mi_backupOnlyPanel.saveSettings();
        }

        public Object saveSettings() {
            return null;
        }

        private class BackupMembersPanel
        extends JPanel
        implements ISetPanel {
            JTable table;
            final String[] COLUMN_LABELS;
            CustomTableModel tableModel;
            HashSet mi_selectedMembers;
            Object mi_lastProcesedMember;

            public BackupMembersPanel(Component parent) {
                block2: {
                    this.COLUMN_LABELS = new String[]{"Member Name", "Backup Members"};
                    this.tableModel = new CustomTableModel();
                    this.mi_selectedMembers = new HashSet();
                    try {
                        this.init();
                        this.reset();
                    }
                    catch (Exception ex) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block2;
                        _logger.log(Level.SEVERE, ex.toString(), ex);
                    }
                }
            }

            void init() throws Exception {
                this.table = new JTable(this.tableModel){

                    @Override
                    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            Object value = this.getValueAt(rowIndex, vColIndex);
                            if (value != null) {
                                jc.setToolTipText(value.toString());
                            }
                        }
                        return c;
                    }
                };
                TableColumnModel columnModel = this.table.getColumnModel();
                columnModel.getColumn(0).setCellEditor(new MemberCellEditor(new JComboBox<String>(GroupFailOverPanel.this.m_allGroupMembers), this.table));
                columnModel.getColumn(1).setCellEditor(new BackupCellEditor());
                this.table.setAutoscrolls(true);
                this.table.setAutoCreateColumnsFromModel(false);
                this.table.setRowHeight(this.table.getRowHeight() + 4);
                this.table.getTableHeader().addMouseListener(GroupFailOverPanel.this.m_columnSortListener);
                this.table.setPreferredScrollableViewportSize(new Dimension(5, 5));
                JScrollPane scrollPanel = new JScrollPane(this.table);
                scrollPanel.setPreferredSize(new Dimension(5, 5));
                this.setLayout(new GridBagLayout());
                this.add((Component)scrollPanel, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            }

            @Override
            public void reset() {
                if (this.table.isEditing()) {
                    this.table.getCellEditor().stopCellEditing();
                }
                this.tableModel.reset();
                this.mi_selectedMembers.clear();
                FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.reset();
            }

            @Override
            public void restoreSettings(Object obj, boolean isEditMode) {
                if (obj == null) {
                    return;
                }
                HashMap backupMembers = (HashMap)obj;
                Object memberName2 = null;
                List backups = null;
                this.reset();
                for (Object memberName2 : backupMembers.keySet()) {
                    backups = (List)backupMembers.get(memberName2);
                    Vector tmpBackups = new Vector();
                    Iterator iter1 = backups.iterator();
                    while (iter1.hasNext()) {
                        tmpBackups.add(iter1.next());
                    }
                    this.tableModel.addRow(new Object[]{memberName2, tmpBackups});
                    this.mi_selectedMembers.add(memberName2);
                }
            }

            public Object saveSettings() {
                HashMap<String, Vector> result = new HashMap<String, Vector>();
                Iterator<Vector> iter = this.tableModel.getDataVector().iterator();
                while (iter.hasNext()) {
                    Vector v = iter.next();
                    String member = (String)v.get(0);
                    Vector backups = (Vector)v.get(1);
                    if (member != null && member.trim().length() > 0 && backups.size() > 0) {
                        result.put(member, backups);
                        continue;
                    }
                    iter.remove();
                }
                this.tableModel.fireTableDataChanged();
                return result;
            }

            class CustomTableModel
            extends DefaultTableModel {
                public CustomTableModel() {
                    for (int i = 0; i < BackupMembersPanel.this.COLUMN_LABELS.length; ++i) {
                        this.addColumn(BackupMembersPanel.this.COLUMN_LABELS[i]);
                    }
                    this.addTableModelListener(new TableModelListener(){
                        Object selectedItem;

                        @Override
                        public void tableChanged(TableModelEvent ev) {
                            if (ev.getType() == 0) {
                                if (ev.getColumn() == 0) {
                                    CustomTableModel model = (CustomTableModel)ev.getSource();
                                    this.selectedItem = model.getValueAt(ev.getFirstRow(), ev.getColumn());
                                    if (this.selectedItem == null) {
                                        return;
                                    }
                                    BackupMembersPanel.this.mi_selectedMembers.add(this.selectedItem);
                                    if (FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.isSelected(this.selectedItem)) {
                                        JOptionPane.showMessageDialog(GroupFailOverPanel.this.m_parent, "The member [" + this.selectedItem + "] was removed from backup only table.");
                                    }
                                    if (!this.selectedItem.equals(BackupMembersPanel.this.mi_lastProcesedMember)) {
                                        model.setValueAt(new Vector(), ev.getFirstRow(), 1);
                                    }
                                }
                                if (ev.getColumn() == 1) {
                                    FailOverPolicyDescriptionPanel.this.mi_backupOnlyPanel.updateTable(FailOverPolicyDescriptionPanel.this.mi_backupMembersPanel.tableModel.getBackupOnlyMembers());
                                }
                            }
                        }
                    });
                }

                public void reset() {
                    this.dataVector = new Vector();
                    this.fireTableDataChanged();
                }

                public Vector getOwnerMembers() {
                    Vector<String> result = new Vector<String>();
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        String value = (String)this.getValueAt(row, 0);
                        if (value == null || value.length() <= 0) continue;
                        result.add(value);
                    }
                    return result;
                }

                public HashSet getBackupOnlyMembers() {
                    HashSet result = new HashSet();
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        Iterator iter = ((Vector)this.getValueAt(row, 1)).iterator();
                        while (iter.hasNext()) {
                            result.add(iter.next());
                        }
                    }
                    Iterator iter = this.getOwnerMembers().iterator();
                    while (iter.hasNext()) {
                        result.remove(iter.next());
                    }
                    return result;
                }
            }

            class MemberCellEditor
            extends DefaultCellEditor {
                JComboBox combo;

                public MemberCellEditor(JComboBox combo, JTable table) {
                    super(combo);
                    this.combo = combo;
                    combo.setFont(table.getFont());
                    this.setClickCountToStart(2);
                }

                @Override
                public boolean isCellEditable(EventObject ev) {
                    boolean flag = super.isCellEditable(ev);
                    if (flag) {
                        this.updateCellEditorValues();
                    }
                    return flag;
                }

                public void updateCellEditorValues() {
                    int row = BackupMembersPanel.this.table.getSelectedRow();
                    if (row != -1) {
                        BackupMembersPanel.this.mi_lastProcesedMember = BackupMembersPanel.this.tableModel.getValueAt(row, 0);
                        BackupMembersPanel.this.mi_selectedMembers.remove(BackupMembersPanel.this.mi_lastProcesedMember);
                    }
                    Vector items = (Vector)GroupFailOverPanel.this.m_allGroupMembers.clone();
                    Iterator iter = BackupMembersPanel.this.mi_selectedMembers.iterator();
                    while (iter.hasNext()) {
                        items.remove(iter.next());
                    }
                    this.combo.setModel(new DefaultComboBoxModel(items));
                }
            }

            class BackupCellEditor
            extends DefaultCellEditor {
                JButton button;
                Vector<String> availableBackups;
                Vector<String> selectedBackups;
                BackupMembersDialog backupDialog;

                public BackupCellEditor() {
                    super(new JCheckBox());
                    this.button = new JButton();
                    this.editorComponent = this.button;
                    this.button.setBackground(BackupMembersPanel.this.table.getBackground());
                    this.button.setFocusPainted(false);
                    this.button.setFont(BackupMembersPanel.this.table.getFont());
                    this.button.setHorizontalAlignment(2);
                    this.button.setBorderPainted(false);
                    this.button.setMargin(new Insets(0, 0, 0, 0));
                    this.button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int row = BackupMembersPanel.this.table.getSelectedRow();
                            if (row == -1) {
                                return;
                            }
                            if (BackupMembersPanel.this.tableModel.getValueAt(row, 0) == null || ((String)BackupMembersPanel.this.tableModel.getValueAt(row, 0)).length() <= 0) {
                                return;
                            }
                            BackupCellEditor.this.availableBackups = (Vector)GroupFailOverPanel.this.m_allGroupMembers.clone();
                            BackupCellEditor.this.selectedBackups = (Vector)BackupMembersPanel.this.table.getModel().getValueAt(row, 1);
                            BackupCellEditor.this.availableBackups.remove(BackupMembersPanel.this.tableModel.getValueAt(row, 0));
                            Iterator<String> iter = BackupCellEditor.this.selectedBackups.iterator();
                            while (iter.hasNext()) {
                                BackupCellEditor.this.availableBackups.remove(iter.next());
                            }
                            GroupFailOverPanel.this.m_backupMembersDialog.setTitle("Define backup members for <" + BackupMembersPanel.this.tableModel.getValueAt(row, 0) + ">");
                            GroupFailOverPanel.this.m_backupMembersDialog.setCellEditor(BackupCellEditor.this);
                            GroupFailOverPanel.this.m_backupMembersDialog.setListModels(BackupCellEditor.this.availableBackups, BackupCellEditor.this.selectedBackups);
                            GroupFailOverPanel.this.m_backupMembersDialog.show();
                            BackupCellEditor.this.fireEditingStopped();
                        }
                    });
                }

                @Override
                public Object getCellEditorValue() {
                    Vector v = new Vector();
                    if (this.selectedBackups != null) {
                        v = (Vector)this.selectedBackups.clone();
                        this.selectedBackups.clear();
                    }
                    return v;
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    ((JButton)this.editorComponent).setText(value.toString());
                    return this.editorComponent;
                }

                public void setResult(Vector result) {
                    this.selectedBackups = result;
                }
            }
        }

        private class BackupOnlyPanel
        extends JPanel
        implements ISetPanel {
            CustomTableModel tableModel;
            JTable table;
            JPanel panTable;

            public BackupOnlyPanel(Component parent) {
                block2: {
                    this.tableModel = new CustomTableModel();
                    this.table = new JTable(this.tableModel);
                    this.panTable = new JPanel();
                    try {
                        this.init();
                        this.reset();
                    }
                    catch (Exception ex) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block2;
                        _logger.log(Level.SEVERE, ex.toString(), ex);
                    }
                }
            }

            void init() throws Exception {
                this.table.setAutoscrolls(true);
                this.table.setAutoCreateColumnsFromModel(false);
                this.table.setRowHeight(this.table.getRowHeight() + 4);
                this.table.getColumnModel().getColumn(0).setMaxWidth(60);
                this.table.getColumnModel().getColumn(0).setMinWidth(60);
                this.table.getTableHeader().addMouseListener(GroupFailOverPanel.this.m_columnSortListener);
                this.table.setPreferredScrollableViewportSize(new Dimension(5, 5));
                JScrollPane scrollPane = new JScrollPane(this.table);
                scrollPane.setPreferredSize(new Dimension(5, 5));
                this.setLayout(new BorderLayout());
                this.add((Component)scrollPane, "Center");
            }

            @Override
            public void reset() {
                this.tableModel.reset();
            }

            @Override
            public void restoreSettings(Object obj, boolean isEditMode) {
                if (obj == null) {
                    return;
                }
                this.reset();
                this.updateTable(FailOverPolicyDescriptionPanel.this.mi_backupMembersPanel.tableModel.getBackupOnlyMembers());
                if (this.tableModel.getRowCount() <= 0) {
                    return;
                }
                List backupOnly = (List)obj;
                Iterator iter = backupOnly.iterator();
                while (iter.hasNext()) {
                    this.tableModel.setEnabledMember(iter.next(), true);
                }
            }

            public Object saveSettings() {
                Vector<Object> result = new Vector<Object>();
                for (int i = 0; i < this.table.getRowCount(); ++i) {
                    if (!((Boolean)this.table.getValueAt(i, 0)).booleanValue()) continue;
                    result.add(this.table.getValueAt(i, 1));
                }
                return result;
            }

            public boolean isSelected(Object memberName) {
                return this.tableModel.isSelected(memberName);
            }

            public boolean isContains(Object memberName) {
                return this.tableModel.isContains(memberName);
            }

            public void addItem(Object memberName) {
                this.tableModel.addItem(memberName);
            }

            public void removeItem(Object memberName) {
                this.tableModel.removeItem(memberName);
            }

            public void addItems(Vector memberName) {
                this.tableModel.addItems(memberName);
            }

            public void removeItems(Vector members) {
                this.tableModel.removeItems(members);
            }

            public void updateTable(Object removeItem, Object addItem) {
                this.tableModel.removeItem(removeItem);
                if (addItem != null && ((String)addItem).length() > 0 && !this.tableModel.isContains(addItem)) {
                    this.tableModel.addItem(addItem);
                }
            }

            public void updateTable(HashSet newBackupMembers) {
                for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                    if (newBackupMembers.contains(this.tableModel.getValueAt(i, 1))) continue;
                    this.tableModel.removeRow(i);
                }
                for (Object item : newBackupMembers) {
                    if (this.tableModel.isContains(item)) continue;
                    this.tableModel.addItem(item);
                }
            }

            class CustomTableModel
            extends DefaultTableModel {
                final String[] COLUMN_LABELS = new String[]{"Enabled", "Member Name"};

                public CustomTableModel() {
                    for (int i = 0; i < this.COLUMN_LABELS.length; ++i) {
                        this.addColumn(this.COLUMN_LABELS[i]);
                    }
                }

                public void reset() {
                    this.dataVector = new Vector();
                    this.fireTableDataChanged();
                }

                public Class getColumnClass(int columnIndex) {
                    Vector v = (Vector)this.dataVector.elementAt(0);
                    return v.elementAt(columnIndex).getClass();
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 0;
                }

                public boolean isContains(Object memberName) {
                    Iterator iter = this.dataVector.iterator();
                    while (iter.hasNext()) {
                        if (!((Vector)iter.next()).contains(memberName)) continue;
                        return true;
                    }
                    return false;
                }

                public boolean isSelected(Object memberName) {
                    for (Vector value : this.dataVector) {
                        if (!value.contains(memberName)) continue;
                        if (!value.contains(Boolean.TRUE)) break;
                        return true;
                    }
                    return false;
                }

                public void removeItem(Object memberName) {
                    Iterator iter = this.dataVector.iterator();
                    while (iter.hasNext()) {
                        if (!((Vector)iter.next()).contains(memberName)) continue;
                        iter.remove();
                    }
                    this.fireTableDataChanged();
                }

                public void addItem(Object memberName) {
                    Vector<Object> v = new Vector<Object>();
                    v.add(Boolean.FALSE);
                    v.add(memberName);
                    this.dataVector.add(v);
                    this.fireTableDataChanged();
                }

                public void addItems(Vector items) {
                    Iterator iter = items.iterator();
                    while (iter.hasNext()) {
                        this.addItem(iter.next());
                    }
                }

                public void removeItems(Vector items) {
                    Iterator iter = items.iterator();
                    while (iter.hasNext()) {
                        this.removeItem(iter.next());
                    }
                }

                public int findMemberRow(Object memberName) {
                    if (this.getRowCount() > 0) {
                        for (int row = 0; row < this.getRowCount(); ++row) {
                            if (!this.getValueAt(row, 1).equals(memberName)) continue;
                            return row;
                        }
                    }
                    return -1;
                }

                public void setEnabledMember(Object memberName, boolean enabled) {
                    int row = this.findMemberRow(memberName);
                    if (row != -1) {
                        this.setValueAt(enabled, row, 0);
                    }
                }
            }
        }
    }

    private static class BackupMembersDialog
    extends JDialog {
        FailOverPolicyDescriptionPanel.BackupMembersPanel.BackupCellEditor cellEditor;
        JButton butOK;
        JButton butCancel;
        TwoSelectionListPanel panSelectBackup;

        public BackupMembersDialog(JFrame parent) {
            block2: {
                super((Frame)parent, true);
                this.butOK = new JButton("OK");
                this.butCancel = new JButton("Cancel");
                try {
                    this.panSelectBackup = new TwoSelectionListPanel(true, null);
                    this.butOK.setMnemonic(79);
                    this.butOK.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            cellEditor.setResult((Vector)panSelectBackup.saveSettings());
                            this.dispose();
                        }
                    });
                    this.butCancel.setMnemonic(67);
                    this.butCancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.dispose();
                        }
                    });
                    JPanel southPane = new JPanel();
                    southPane.add((Component)this.butOK, null);
                    southPane.add((Component)this.butCancel, null);
                    JPanel contPane = (JPanel)this.getContentPane();
                    contPane.setLayout(new BorderLayout());
                    contPane.add((Component)this.panSelectBackup, "Center");
                    contPane.add((Component)southPane, "South");
                    this.setSize(400, 250);
                    JSpaceUIUtils.setLocationRelativeTo(this, parent);
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block2;
                    _logger.log(Level.SEVERE, ex.toString(), ex);
                }
            }
        }

        public void setCellEditor(FailOverPolicyDescriptionPanel.BackupMembersPanel.BackupCellEditor editor) {
            this.cellEditor = editor;
        }

        public void setListModels(Vector available, Vector selected) {
            this.panSelectBackup.setListModels(available, selected, null);
        }

        public void reset() {
            this.panSelectBackup.reset();
            this.butOK.setEnabled(false);
        }
    }
}

