/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.gigaspaces.internal.utils.CollectionUtils;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.ISetPanel;
import com.j_spaces.tools.cluster.ISetParam;
import com.j_spaces.tools.cluster.SetParamDialog;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class GroupLBPanel
extends JPanel
implements ISetPanel {
    private static final Vector paramColNames = GroupLBPanel.initParamColNames();
    private JTabbedPane lbTabbedPane;
    private JPanel optionPan;
    private JPanel loadBalPanel;
    private JCheckBox applyOwnershipCB;
    private JCheckBox defaultCB;
    private JCheckBox notifyCB;
    private JCheckBox readCB;
    private JCheckBox takeCB;
    private JCheckBox writeCB;
    private JComboBox readComBox;
    private JComboBox writeComBox;
    private JComboBox defaultComBox;
    private JComboBox notifyComBox;
    private JComboBox takeComBox;
    private LoadBalParamPanel writeLB;
    private LoadBalParamPanel readLB;
    private LoadBalParamPanel takeLB;
    private LoadBalParamPanel notifyLB;
    private LoadBalParamPanel defaultLB;
    private LoadBalParamPanel[] loadBalPanelArr;
    private ClusterMemberInfo[] allMembers;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");
    private boolean _isViewOnlyMode;

    private static Vector initParamColNames() {
        Vector<String> result = new Vector<String>();
        result.add("Param Name");
        result.add("Param Value");
        return result;
    }

    public GroupLBPanel(GroupInfo.LoadBalancingInfo lbInfo, ClusterMemberInfo[] allMembers, boolean isViewOnlyMode) {
        block2: {
            this.lbTabbedPane = new JTabbedPane();
            this.optionPan = new JPanel();
            this.loadBalPanel = new JPanel();
            this.applyOwnershipCB = new JCheckBox("Apply Ownership");
            this.defaultCB = new JCheckBox();
            this.notifyCB = new JCheckBox();
            this.readCB = new JCheckBox();
            this.takeCB = new JCheckBox();
            this.writeCB = new JCheckBox();
            this.readComBox = new JComboBox();
            this.writeComBox = new JComboBox();
            this.defaultComBox = new JComboBox();
            this.notifyComBox = new JComboBox();
            this.takeComBox = new JComboBox();
            this.writeLB = new LoadBalParamPanel(this, 1);
            this.readLB = new LoadBalParamPanel(this, 2);
            this.takeLB = new LoadBalParamPanel(this, 3);
            this.notifyLB = new LoadBalParamPanel(this, 4);
            this.defaultLB = new LoadBalParamPanel(this, 5);
            this.loadBalPanelArr = new LoadBalParamPanel[]{this.writeLB, this.readLB, this.takeLB, this.notifyLB, this.defaultLB};
            this._isViewOnlyMode = false;
            try {
                this._isViewOnlyMode = isViewOnlyMode;
                this.jbInit();
                this.init(lbInfo, allMembers);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public void init(GroupInfo.LoadBalancingInfo lbInfo, ClusterMemberInfo[] allMembers) {
        this.allMembers = allMembers;
        this.reset();
        this.updateGroupMembers(allMembers);
        this.restoreSettings(lbInfo, false);
    }

    public GroupLBPanel(boolean isViewOnlyMode) {
        this(null, null, isViewOnlyMode);
    }

    private void jbInit() throws Exception {
        this.defaultCB.setText("Default:");
        this.defaultCB.setRequestFocusEnabled(false);
        this.defaultCB.addActionListener(new CheckBoxActionListener(this.defaultComBox, 4));
        this.optionPan.setLayout(new BorderLayout());
        this.optionPan.setLayout(new GridBagLayout());
        this.notifyCB.setText("Notify:");
        this.notifyCB.setRequestFocusEnabled(false);
        this.notifyCB.addActionListener(new CheckBoxActionListener(this.notifyComBox, 3));
        this.loadBalPanel.setLayout(new BorderLayout());
        this.writeCB.setText("Write:");
        this.writeCB.setRequestFocusEnabled(false);
        this.writeCB.addActionListener(new CheckBoxActionListener(this.writeComBox, 0));
        this.readCB.setText("Read:");
        this.readCB.setRequestFocusEnabled(false);
        this.readCB.addActionListener(new CheckBoxActionListener(this.readComBox, 1));
        this.takeCB.setText("Take:");
        this.takeCB.setRequestFocusEnabled(false);
        this.takeCB.addActionListener(new CheckBoxActionListener(this.takeComBox, 2));
        this.lbTabbedPane.add((Component)this.writeLB, "Write");
        this.lbTabbedPane.add((Component)this.readLB, "Read");
        this.lbTabbedPane.add((Component)this.takeLB, "Take");
        this.lbTabbedPane.add((Component)this.notifyLB, "Notify");
        this.lbTabbedPane.add((Component)this.defaultLB, "Default");
        this.setLoadBalPolicy(this.writeComBox);
        this.setLoadBalPolicy(this.readComBox);
        this.setLoadBalPolicy(this.takeComBox);
        this.setLoadBalPolicy(this.notifyComBox);
        this.setLoadBalPolicy(this.defaultComBox);
        Box northBox = this.createLoadBalancingMainComponents();
        this.loadBalPanel.add((Component)northBox, "North");
        this.loadBalPanel.add((Component)this.optionPan, "West");
        this.optionPan.add((Component)this.writeComBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.readComBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.takeComBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.notifyComBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.defaultComBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, -2));
        this.optionPan.add((Component)this.defaultCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.optionPan.add((Component)this.notifyCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.optionPan.add((Component)this.takeCB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.optionPan.add((Component)this.readCB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.optionPan.add((Component)this.writeCB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.loadBalPanel.add((Component)this.lbTabbedPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.loadBalPanel, "North");
    }

    private Box createLoadBalancingMainComponents() {
        Box resultBox = new Box(1);
        Box applyOwnershipBox = new Box(0);
        applyOwnershipBox.add(Box.createHorizontalStrut(5));
        applyOwnershipBox.add(this.applyOwnershipCB);
        applyOwnershipBox.add(Box.createHorizontalGlue());
        resultBox.add(Box.createVerticalStrut(5));
        if (this._isViewOnlyMode) {
            resultBox.add(Box.createVerticalStrut(3));
            resultBox.add(applyOwnershipBox);
        }
        resultBox.add(Box.createVerticalGlue());
        resultBox.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this.applyOwnershipCB.setMnemonic('A');
        this.applyOwnershipCB.setEnabled(false);
        return resultBox;
    }

    private void setLoadBalPolicy(JComboBox comBox) {
        String[] pol = new String[]{"local-space", "round-robin", "hash-based"};
        for (int i = 0; i < pol.length; ++i) {
            comBox.addItem(pol[i]);
        }
    }

    private GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription createLoadBalancinPolicy(JComboBox lbComboBox, Vector paramData, String selectedBroadcastCondition) {
        GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription operPolicy = null;
        if (lbComboBox.isEnabled()) {
            operPolicy = new GroupInfo.LoadBalancingInfo.LoadBalancingPolicyDescription();
            operPolicy.m_PolicyType = (String)lbComboBox.getSelectedItem();
            operPolicy.m_paramTable = paramData != null && paramData.size() > 0 ? paramData : null;
            operPolicy.setBroadcastCondition(selectedBroadcastCondition);
        }
        return operPolicy;
    }

    @Override
    public void reset() {
        this.applyOwnershipCB.setSelected(false);
        this.writeCB.setSelected(false);
        this.readCB.setSelected(false);
        this.takeCB.setSelected(false);
        this.notifyCB.setSelected(false);
        this.defaultCB.setSelected(true);
        for (int i = 0; i < this.lbTabbedPane.getTabCount() - 1; ++i) {
            this.lbTabbedPane.setEnabledAt(i, false);
        }
        this.lbTabbedPane.setSelectedIndex(this.lbTabbedPane.getTabCount() - 1);
        this.writeComBox.setSelectedIndex(0);
        this.readComBox.setSelectedIndex(0);
        this.takeComBox.setSelectedIndex(0);
        this.notifyComBox.setSelectedIndex(0);
        this.defaultComBox.setSelectedIndex(0);
        for (int j = 0; j < this.loadBalPanelArr.length; ++j) {
            this.loadBalPanelArr[j].clearPanel();
        }
        boolean status = false;
        this.writeComBox.setEnabled(status && this.writeCB.isSelected());
        this.readComBox.setEnabled(status && this.readCB.isSelected());
        this.takeComBox.setEnabled(status && this.takeCB.isSelected());
        this.notifyComBox.setEnabled(status && this.notifyCB.isSelected());
        this.defaultComBox.setEnabled(status && this.defaultCB.isSelected());
    }

    private void updateGroupMembers(ClusterMemberInfo[] groupMembers) {
        this.allMembers = groupMembers;
        if (this.allMembers != null) {
            for (int i = 0; i < this.allMembers.length; ++i) {
                this.setParamDialogs(this.allMembers[i].memberName);
            }
        }
    }

    public void setParamDialogs(String paramName) {
        for (int j = 0; j < this.loadBalPanelArr.length; ++j) {
            this.loadBalPanelArr[j].setParamDialog.setParamName(paramName);
        }
    }

    @Override
    public void restoreSettings(Object obj, boolean isEditMode) {
        if (obj == null) {
            return;
        }
        GroupInfo.LoadBalancingInfo loadBalInfo = (GroupInfo.LoadBalancingInfo)obj;
        this.applyOwnershipCB.setSelected(loadBalInfo.isApplyOwnership());
        if (loadBalInfo.m_WriteOperationsPolicy != null) {
            this.lbTabbedPane.setEnabledAt(0, true);
            this.writeCB.setSelected(true);
            if (isEditMode) {
                this.writeComBox.setEnabled(isEditMode);
            }
            this.writeComBox.setSelectedItem(loadBalInfo.m_WriteOperationsPolicy.m_PolicyType);
            this.writeLB.setParam(loadBalInfo.m_WriteOperationsPolicy.m_paramTable);
            this.writeLB.setSelectedBroadcastCondition(loadBalInfo.m_WriteOperationsPolicy.getBroadcastCondition());
        }
        if (loadBalInfo.m_ReadOperationsPolicy != null) {
            this.lbTabbedPane.setEnabledAt(1, true);
            this.readCB.setSelected(true);
            if (isEditMode) {
                this.readComBox.setEnabled(isEditMode);
            }
            this.readComBox.setSelectedItem(loadBalInfo.m_ReadOperationsPolicy.m_PolicyType);
            this.readLB.setParam(loadBalInfo.m_ReadOperationsPolicy.m_paramTable);
            this.readLB.setSelectedBroadcastCondition(loadBalInfo.m_ReadOperationsPolicy.getBroadcastCondition());
        }
        if (loadBalInfo.m_TakeOperationsPolicy != null) {
            this.lbTabbedPane.setEnabledAt(2, true);
            this.takeCB.setSelected(true);
            if (isEditMode) {
                this.takeComBox.setEnabled(isEditMode);
            }
            this.takeComBox.setSelectedItem(loadBalInfo.m_TakeOperationsPolicy.m_PolicyType);
            this.takeLB.setParam(loadBalInfo.m_TakeOperationsPolicy.m_paramTable);
            this.takeLB.setSelectedBroadcastCondition(loadBalInfo.m_TakeOperationsPolicy.getBroadcastCondition());
        }
        if (loadBalInfo.m_NotifyOperationsPolicy != null) {
            this.lbTabbedPane.setEnabledAt(3, true);
            this.notifyCB.setSelected(true);
            if (isEditMode) {
                this.notifyComBox.setEnabled(isEditMode);
            }
            this.notifyComBox.setSelectedItem(loadBalInfo.m_NotifyOperationsPolicy.m_PolicyType);
            this.notifyLB.setParam(loadBalInfo.m_NotifyOperationsPolicy.m_paramTable);
            this.notifyLB.setSelectedBroadcastCondition(loadBalInfo.m_NotifyOperationsPolicy.getBroadcastCondition());
        }
        if (loadBalInfo.m_DefaultPolicy != null) {
            this.lbTabbedPane.setEnabledAt(4, true);
            this.defaultCB.setSelected(true);
            if (isEditMode) {
                this.defaultComBox.setEnabled(isEditMode);
            }
            this.defaultComBox.setSelectedItem(loadBalInfo.m_DefaultPolicy.m_PolicyType);
            this.defaultLB.setParam(loadBalInfo.m_DefaultPolicy.m_paramTable);
            this.defaultLB.setSelectedBroadcastCondition(loadBalInfo.m_DefaultPolicy.getBroadcastCondition());
        } else {
            this.lbTabbedPane.setEnabledAt(4, false);
            this.defaultCB.setSelected(false);
            this.defaultComBox.setEnabled(false);
        }
    }

    public Object saveSettings() {
        GroupInfo.LoadBalancingInfo lbInfo = new GroupInfo.LoadBalancingInfo();
        lbInfo.setApplyOwnership(this.applyOwnershipCB.isSelected());
        lbInfo.setProxyBroadcatThreadpoolMinSize(4);
        lbInfo.setProxyBroadcatThreadpoolMaxSize(64);
        lbInfo.m_WriteOperationsPolicy = this.createLoadBalancinPolicy(this.writeComBox, this.writeLB.lbModel.getDataVector(), this.writeLB.getSelectedBroadcastCondition());
        lbInfo.m_ReadOperationsPolicy = this.createLoadBalancinPolicy(this.readComBox, this.readLB.lbModel.getDataVector(), this.readLB.getSelectedBroadcastCondition());
        lbInfo.m_TakeOperationsPolicy = this.createLoadBalancinPolicy(this.takeComBox, this.takeLB.lbModel.getDataVector(), this.takeLB.getSelectedBroadcastCondition());
        lbInfo.m_NotifyOperationsPolicy = this.createLoadBalancinPolicy(this.notifyComBox, this.notifyLB.lbModel.getDataVector(), this.notifyLB.getSelectedBroadcastCondition());
        lbInfo.m_DefaultPolicy = this.createLoadBalancinPolicy(this.defaultComBox, this.defaultLB.lbModel.getDataVector(), this.defaultLB.getSelectedBroadcastCondition());
        return lbInfo;
    }

    public void setEnableComponentsStatus(boolean isEnabled) {
        JSpaceUIUtils.setAWTComponentsStatus(this, isEnabled);
        this.writeComBox.setEnabled(isEnabled && this.writeCB.isSelected());
        this.readComBox.setEnabled(isEnabled && this.readCB.isSelected());
        this.takeComBox.setEnabled(isEnabled && this.takeCB.isSelected());
        this.notifyComBox.setEnabled(isEnabled && this.notifyCB.isSelected());
        this.defaultComBox.setEnabled(isEnabled && this.defaultCB.isSelected());
        this.applyOwnershipCB.setEnabled(false);
    }

    private static Vector<String> getBroadcastConditions() {
        return new Vector<String>(CollectionUtils.toUnmodifiableSet((Object[])new String[]{"routing-index-is-null", "always", "never"}));
    }

    static /* synthetic */ Vector access$800() {
        return GroupLBPanel.getBroadcastConditions();
    }

    private static class LoadBalParamPanel
    extends JPanel
    implements ISetParam {
        private DefaultTableModel lbModel;
        private JTable lbTable;
        private SetParamDialog setParamDialog;
        private JComboBox broadcastConditionComboBox = new JComboBox(GroupLBPanel.access$800());
        private short operatiionCode;
        public static final short OP_CODE_WRITE = 1;
        public static final short OP_CODE_READ = 2;
        public static final short OP_CODE_TAKE = 3;
        public static final short OP_CODE_NOTIFY = 4;
        public static final short OP_CODE_DEFAULT = 5;

        private LoadBalParamPanel(Component parent, short operatiionCode) {
            this.operatiionCode = operatiionCode;
            this.setParamDialog = new SetParamDialog(this, new JDialog());
            this.setLayout(new BorderLayout());
            this.lbModel = new DefaultTableModel();
            this.lbTable = new JTable(this.lbModel);
            this.lbModel.addColumn("Param Name");
            this.lbModel.addColumn("Param Value");
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.add((Component)new JScrollPane(this.lbTable), "Center");
            tablePanel.setPreferredSize(new Dimension(5, 5));
            this.add((Component)tablePanel, "Center");
            Box broadcastConditionBox = this.createBroadcastConditionBox();
            this.add((Component)broadcastConditionBox, "South");
        }

        public void setSelectedBroadcastCondition(String broadcastCondition) {
            this.broadcastConditionComboBox.setSelectedItem(broadcastCondition);
        }

        public String getSelectedBroadcastCondition() {
            return (String)this.broadcastConditionComboBox.getSelectedItem();
        }

        private Box createBroadcastConditionBox() {
            Box box = new Box(0);
            JLabel label = new JLabel("Broadcast Condition:");
            this.broadcastConditionComboBox.setPreferredSize(new Dimension(140, 20));
            box.add(label);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.broadcastConditionComboBox);
            box.add(Box.createHorizontalGlue());
            box.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 2));
            if (this.operatiionCode == 1 || this.operatiionCode == 4) {
                this.broadcastConditionComboBox.setSelectedItem("never");
                this.broadcastConditionComboBox.setEnabled(false);
            }
            return box;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            if (this.operatiionCode == 1 || this.operatiionCode == 4) {
                this.broadcastConditionComboBox.setEnabled(false);
            }
        }

        public void setParam(Vector param) {
            if (param != null) {
                this.lbModel.setDataVector(param, paramColNames);
            }
        }

        @Override
        public void setParams(String paramName, String paramValue) {
            for (int i = 0; i < this.lbModel.getRowCount(); ++i) {
                Object paramObj = this.lbModel.getValueAt(i, 0);
                if (!paramObj.equals(paramName)) continue;
                return;
            }
            this.lbModel.addRow(new Object[]{paramName, paramValue});
            this.lbTable.clearSelection();
        }

        public void clearPanel() {
            this.setParamDialog.comboModel.removeAllElements();
            this.lbModel.setDataVector(new Object[0][0], new Object[]{"Param Name", "Param Value"});
            if (this.operatiionCode == 1 || this.operatiionCode == 4) {
                this.broadcastConditionComboBox.setSelectedItem("never");
            } else {
                this.broadcastConditionComboBox.setSelectedItem("routing-index-is-null");
            }
        }
    }

    class CheckBoxActionListener
    implements ActionListener {
        JComboBox comBox;
        int index;

        public CheckBoxActionListener(JComboBox comBox, int index) {
            this.comBox = comBox;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(GroupLBPanel.this.writeCB.isSelected() && GroupLBPanel.this.readCB.isSelected() && GroupLBPanel.this.takeCB.isSelected() && GroupLBPanel.this.notifyCB.isSelected())) {
                GroupLBPanel.this.lbTabbedPane.setEnabledAt(GroupLBPanel.this.lbTabbedPane.getTabCount() - 1, true);
                GroupLBPanel.this.lbTabbedPane.setSelectedIndex(this.index);
                GroupLBPanel.this.defaultCB.setSelected(true);
                GroupLBPanel.this.defaultComBox.setEnabled(true);
            }
            JCheckBox checkBox = (JCheckBox)e.getSource();
            this.comBox.setEnabled(checkBox.isSelected());
            GroupLBPanel.this.lbTabbedPane.setEnabledAt(this.index, checkBox.isSelected());
            if (checkBox.isSelected()) {
                GroupLBPanel.this.lbTabbedPane.setSelectedIndex(this.index);
            } else {
                GroupLBPanel.this.lbTabbedPane.setSelectedIndex(this.getEnabledTabIndex(GroupLBPanel.this.lbTabbedPane));
            }
        }

        private int getEnabledTabIndex(JTabbedPane tabbedPane) {
            int index = -1;
            for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                if (!tabbedPane.isEnabledAt(i)) continue;
                index = i;
                break;
            }
            return index;
        }
    }
}

