/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.ISetPanel;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public class GroupReplicationPanel
extends JPanel
implements ISetPanel {
    private JPanel commonPanel;
    private JPanel asyncPanel;
    private JPanel syncPanel;
    private JTabbedPane replicationTabbedPane;
    private JComboBox repModeComboBox;
    private JLabel repPolicyTypeLabel;
    private JCheckBox repMemoryRecCB;
    private JCheckBox repNotifyTemplCB;
    private JCheckBox triggerNotifyCB;
    private JLabel findTimeoutLabel;
    private WholeNumberField repFindTimeoutTF;
    private JRadioButton asyncButton;
    private JRadioButton syncButton;
    private ButtonGroup group;
    private Border replicationModeBorder;
    private TitledBorder replicationModeTitledBorder;
    private JCheckBox chboxTransmMatrix;
    private DefaultListModel m_groupMembersListModel;
    private JCheckBox syncOnCommitCB;
    private JLabel syncTimeOutLabel;
    private JLabel chunkSizeLabel;
    private JLabel interMsLabel;
    private JLabel interOperLabel;
    private JCheckBox repOriginalStateCB;
    private WholeNumberField interOperTF;
    private WholeNumberField interMsTF;
    private WholeNumberField chunkSizeTF;
    private WholeNumberField syncTimeOutTF;
    private JComboBox communicationModeComboBox;
    private JLabel todoQueueTimeoutLabel;
    private WholeNumberField todoQueueTimeoutTF;
    private JPanel unicastReplPanel;
    private JLabel minUnicastWorkThreadsLabel;
    private JLabel maxUnicastWorkThreadsLabel;
    private WholeNumberField minUnicastWorkThreadsTF;
    private WholeNumberField maxUnicastWorkThreadsTF;
    private JPanel multicastReplPanel;
    private JLabel ipGroupLabel;
    private JLabel portLabel;
    private JTextField ipGroupTF;
    private WholeNumberField portTF;
    private JLabel minMulticastWorkThreadsLabel;
    private JLabel maxMulticastWorkThreadsLabel;
    private WholeNumberField minMulticastWorkThreadsTF;
    private WholeNumberField maxMulticastWorkThreadsTF;
    private static final String UNICAST = "Unicast";
    private static final String MULTICAST = "Multicast";
    private JRadioButton syncRadioButton;
    private JRadioButton syncRecAckRadioButton;
    private JFrame frameOwner;
    private JDialog dialogOwner;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public GroupReplicationPanel(GroupInfo groupInfo, JFrame frameOwner, JDialog dialogOwner) {
        block2: {
            this.replicationTabbedPane = new JTabbedPane();
            this.repModeComboBox = new JComboBox();
            this.repPolicyTypeLabel = new JLabel();
            this.repMemoryRecCB = new JCheckBox();
            this.repNotifyTemplCB = new JCheckBox();
            this.triggerNotifyCB = new JCheckBox();
            this.findTimeoutLabel = new JLabel();
            this.repFindTimeoutTF = new WholeNumberField();
            this.asyncButton = new JRadioButton();
            this.syncButton = new JRadioButton();
            this.group = new ButtonGroup();
            this.chboxTransmMatrix = new JCheckBox();
            this.syncOnCommitCB = new JCheckBox();
            this.syncTimeOutLabel = new JLabel();
            this.chunkSizeLabel = new JLabel();
            this.interMsLabel = new JLabel();
            this.interOperLabel = new JLabel();
            this.repOriginalStateCB = new JCheckBox();
            this.interOperTF = new WholeNumberField();
            this.interMsTF = new WholeNumberField();
            this.chunkSizeTF = new WholeNumberField();
            this.syncTimeOutTF = new WholeNumberField();
            this.communicationModeComboBox = new JComboBox();
            this.todoQueueTimeoutLabel = new JLabel();
            this.todoQueueTimeoutTF = new WholeNumberField();
            this.minUnicastWorkThreadsLabel = new JLabel();
            this.maxUnicastWorkThreadsLabel = new JLabel();
            this.minUnicastWorkThreadsTF = new WholeNumberField();
            this.maxUnicastWorkThreadsTF = new WholeNumberField();
            this.ipGroupLabel = new JLabel();
            this.portLabel = new JLabel();
            this.ipGroupTF = new JTextField();
            this.portTF = new WholeNumberField();
            this.minMulticastWorkThreadsLabel = new JLabel();
            this.maxMulticastWorkThreadsLabel = new JLabel();
            this.minMulticastWorkThreadsTF = new WholeNumberField();
            this.maxMulticastWorkThreadsTF = new WholeNumberField();
            try {
                this.frameOwner = frameOwner;
                this.dialogOwner = dialogOwner;
                this.jbInit();
                this.reset();
                this.init(groupInfo);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public void init(GroupInfo groupInfo) {
        if (groupInfo != null) {
            this.updateDataForRepMatrix(groupInfo.groupMembers, groupInfo.repInfo != null);
            this.restoreSettings(groupInfo.repInfo, true);
        }
    }

    public JPanel createCommonPanel() {
        JPanel commonReplPanel = new JPanel(new GridBagLayout());
        JPanel replicationModePanel = new JPanel(new GridBagLayout());
        this.repPolicyTypeLabel.setText("Policy Type: ");
        this.repModeComboBox.addItem("Full Replication");
        this.repModeComboBox.addItem("Partial Replication");
        this.repMemoryRecCB.setText("Recovery");
        this.repMemoryRecCB.setRequestFocusEnabled(false);
        this.repNotifyTemplCB.setText("Replicate Notify Templates");
        this.repNotifyTemplCB.setRequestFocusEnabled(false);
        this.triggerNotifyCB.setText("Trigger Notify Templates");
        this.triggerNotifyCB.setRequestFocusEnabled(false);
        this.chboxTransmMatrix.setText("Replication Matrix");
        this.chboxTransmMatrix.setRequestFocusEnabled(false);
        JLabel communicationModeLabel = new JLabel();
        communicationModeLabel.setText("Communication Mode: ");
        this.communicationModeComboBox.addItem(UNICAST);
        this.communicationModeComboBox.addItem(MULTICAST);
        this.findTimeoutLabel.setText("Find timeout msec: ");
        this.asyncButton.setText("Asynchronous");
        this.syncButton.setText("Synchronous");
        this.replicationModeBorder = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.replicationModeTitledBorder = new TitledBorder(this.replicationModeBorder, "Replication Mode");
        replicationModePanel.setBorder(this.replicationModeTitledBorder);
        this.group.add(this.asyncButton);
        this.group.add(this.syncButton);
        commonReplPanel.add((Component)communicationModeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 7, 2, 2), 0, 0));
        commonReplPanel.add((Component)this.communicationModeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 2, 2, 7), 0, 0));
        commonReplPanel.add((Component)replicationModePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(2, 5, 2, 5), 0, 0));
        replicationModePanel.add((Component)this.asyncButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        replicationModePanel.add((Component)this.syncButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        commonReplPanel.add((Component)this.repPolicyTypeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        commonReplPanel.add((Component)this.repModeComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 7), 0, 0));
        commonReplPanel.add((Component)this.findTimeoutLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        commonReplPanel.add((Component)this.repFindTimeoutTF, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        commonReplPanel.add((Component)this.repMemoryRecCB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        commonReplPanel.add((Component)this.repNotifyTemplCB, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        commonReplPanel.add((Component)this.triggerNotifyCB, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        commonReplPanel.add((Component)this.chboxTransmMatrix, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        return commonReplPanel;
    }

    public JPanel createAsynchronousPanel() {
        JPanel asynchronousReplPanel = new JPanel(new GridBagLayout());
        this.syncOnCommitCB.setRequestFocusEnabled(false);
        this.syncOnCommitCB.setText("Synch on Commit");
        this.syncTimeOutLabel.setText("Synch on Commit time limit msec: ");
        this.chunkSizeLabel.setText("Chunk Size: ");
        this.interMsLabel.setText("Interval Operations msec: ");
        this.interOperLabel.setText("Number of Operations: ");
        this.repOriginalStateCB.setText("Replicate Original State");
        asynchronousReplPanel.add((Component)this.chunkSizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        asynchronousReplPanel.add((Component)this.chunkSizeTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        asynchronousReplPanel.add((Component)this.interMsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        asynchronousReplPanel.add((Component)this.interMsTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        asynchronousReplPanel.add((Component)this.interOperLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 7, 2, 2), 0, 0));
        asynchronousReplPanel.add((Component)this.interOperTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        asynchronousReplPanel.add((Component)this.syncTimeOutLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 2, 2), 0, 0));
        asynchronousReplPanel.add((Component)this.syncTimeOutTF, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 7), 0, 0));
        asynchronousReplPanel.add((Component)this.syncOnCommitCB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        asynchronousReplPanel.add((Component)this.repOriginalStateCB, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        return asynchronousReplPanel;
    }

    private JPanel createSynchronousPanel() throws Exception {
        JPanel synchronousReplPanel = new JPanel(new GridBagLayout());
        this.unicastReplPanel = new JPanel(new GridBagLayout());
        this.multicastReplPanel = new JPanel(new GridBagLayout());
        this.unicastReplPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), UNICAST), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.multicastReplPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), MULTICAST), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.syncRadioButton = new JRadioButton("Sync");
        this.syncRadioButton.setMnemonic('S');
        this.syncRecAckRadioButton = new JRadioButton("Sync-Rec-Ack ( One Way )");
        this.syncRecAckRadioButton.setMnemonic('R');
        ButtonGroup replModeButtonGroup = new ButtonGroup();
        replModeButtonGroup.add(this.syncRadioButton);
        replModeButtonGroup.add(this.syncRecAckRadioButton);
        this.todoQueueTimeoutLabel.setText("Todo Queue Timeout: ");
        this.minUnicastWorkThreadsLabel.setText("Min Work Threads: ");
        this.maxUnicastWorkThreadsLabel.setText("Max Work Threads: ");
        this.ipGroupLabel.setText("IP Group: ");
        this.portLabel.setText("Port: ");
        this.minMulticastWorkThreadsLabel.setText("Min Work Threads: ");
        this.maxMulticastWorkThreadsLabel.setText("Max Work Threads: ");
        Box replicationModeBox = new Box(0);
        replicationModeBox.setBorder(BorderFactory.createTitledBorder("Replication Mode"));
        replicationModeBox.add(Box.createHorizontalStrut(5));
        replicationModeBox.add(this.syncRadioButton);
        replicationModeBox.add(Box.createHorizontalStrut(10));
        replicationModeBox.add(this.syncRecAckRadioButton);
        synchronousReplPanel.add((Component)replicationModeBox, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 2, 2), 0, 0));
        synchronousReplPanel.add((Component)this.todoQueueTimeoutLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 7, 2, 2), 0, 0));
        synchronousReplPanel.add((Component)this.todoQueueTimeoutTF, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 2, 2, 7), 0, 0));
        synchronousReplPanel.add((Component)this.unicastReplPanel, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 12, 5), 0, 0));
        this.unicastReplPanel.add((Component)this.minUnicastWorkThreadsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.unicastReplPanel.add((Component)this.minUnicastWorkThreadsTF, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.unicastReplPanel.add((Component)this.maxUnicastWorkThreadsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.unicastReplPanel.add((Component)this.maxUnicastWorkThreadsTF, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        synchronousReplPanel.add((Component)this.multicastReplPanel, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 18, 2, new Insets(7, 5, 2, 5), 0, 0));
        this.multicastReplPanel.add((Component)this.minMulticastWorkThreadsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.minMulticastWorkThreadsTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.maxMulticastWorkThreadsLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.maxMulticastWorkThreadsTF, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.ipGroupLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.ipGroupTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.portLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.multicastReplPanel.add((Component)this.portTF, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        return synchronousReplPanel;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.commonPanel = this.createCommonPanel();
        this.asyncPanel = this.createAsynchronousPanel();
        this.syncPanel = this.createSynchronousPanel();
        this.replicationTabbedPane.add((Component)this.commonPanel, "Common");
        this.replicationTabbedPane.add((Component)this.asyncPanel, "Asynchronous");
        this.replicationTabbedPane.add((Component)this.syncPanel, "Synchronous");
        this.add((Component)this.replicationTabbedPane, "Center");
    }

    private void resetCommonPanel() {
        this.asyncButton.setSelected(true);
        this.replicationTabbedPane.setEnabledAt(2, false);
        this.replicationTabbedPane.setEnabledAt(1, true);
        this.repModeComboBox.setSelectedIndex(0);
        this.repMemoryRecCB.setSelected(false);
        this.repNotifyTemplCB.setSelected(false);
        this.triggerNotifyCB.setSelected(false);
        this.syncRadioButton.setSelected(true);
        this.chboxTransmMatrix.setSelected(false);
        this.repFindTimeoutTF.setText(String.valueOf(5000));
        this.replicationTabbedPane.setEnabledAt(1, true);
        this.replicationTabbedPane.setEnabledAt(2, false);
        RadioListener radioListener = new RadioListener();
        this.asyncButton.addActionListener(radioListener);
        this.syncButton.addActionListener(radioListener);
    }

    private void resetAsyncPanel() {
        this.syncOnCommitCB.setSelected(false);
        this.syncTimeOutTF.setText(String.valueOf(300000));
        this.chunkSizeTF.setText(String.valueOf(500));
        this.interMsTF.setText(String.valueOf(3000));
        this.interOperTF.setText(String.valueOf(500));
        this.repOriginalStateCB.setSelected(false);
    }

    private void resetSyncPanel() {
        this.communicationModeComboBox.setSelectedItem(UNICAST);
        this.todoQueueTimeoutTF.setText(String.valueOf(1500L));
        this.minUnicastWorkThreadsTF.setText(String.valueOf(4));
        this.maxUnicastWorkThreadsTF.setText(String.valueOf(16));
        this.ipGroupTF.setText(String.valueOf("224.0.0.1"));
        this.portTF.setText(String.valueOf(28672));
        this.minMulticastWorkThreadsTF.setText(String.valueOf(4));
        this.maxMulticastWorkThreadsTF.setText(String.valueOf(16));
    }

    @Override
    public void reset() {
        this.resetCommonPanel();
        this.resetAsyncPanel();
        this.resetSyncPanel();
    }

    public boolean isSyncAckReplicationModelSelected() {
        return this.syncRecAckRadioButton.isSelected();
    }

    private void restoreCommonSettings(GroupInfo.ReplicationInfo repInfo) {
        if (repInfo.m_ReplicationMode.equalsIgnoreCase("async")) {
            this.asyncButton.setSelected(true);
            this.replicationTabbedPane.setEnabledAt(2, false);
            this.replicationTabbedPane.setEnabledAt(1, true);
        } else {
            this.syncButton.setSelected(true);
            this.replicationTabbedPane.setEnabledAt(1, false);
            this.replicationTabbedPane.setEnabledAt(2, true);
            if (repInfo.m_ReplicationMode.equalsIgnoreCase("sync-rec-ack")) {
                this.syncRecAckRadioButton.setSelected(true);
            } else {
                this.syncRadioButton.setSelected(true);
            }
        }
        this.repModeComboBox.setSelectedIndex(repInfo.m_PolicyType);
        this.repMemoryRecCB.setSelected(repInfo.m_MemoryRecovery);
        this.repNotifyTemplCB.setSelected(repInfo.m_ReplicateNotifyTemplates);
        this.triggerNotifyCB.setSelected(repInfo.m_TriggerNotifyTemplates);
        this.chboxTransmMatrix.setSelected(repInfo.m_TransmissionMatrix);
        this.repFindTimeoutTF.setText(String.valueOf(repInfo.m_SpaceFinderTimeout));
        String communicationMode = repInfo.m_CommunicationMode;
        String replicationMode = repInfo.m_ReplicationMode;
        if (replicationMode.equalsIgnoreCase("sync") || replicationMode.equalsIgnoreCase("sync-rec-ack")) {
            this.syncButton.setSelected(true);
            if (repInfo.m_ReplicationMode.equalsIgnoreCase("sync-rec-ack")) {
                this.syncRecAckRadioButton.setSelected(true);
            } else {
                this.syncRadioButton.setSelected(true);
            }
        } else if (replicationMode.equalsIgnoreCase("async")) {
            this.asyncButton.setSelected(true);
        }
        if (communicationMode != null && communicationMode.equalsIgnoreCase("multicast")) {
            this.communicationModeComboBox.setSelectedItem(MULTICAST);
        } else {
            this.communicationModeComboBox.setSelectedItem(UNICAST);
        }
    }

    private void restoreAsyncSettings(GroupInfo.ReplicationInfo repInfo) {
        this.syncOnCommitCB.setSelected(repInfo.m_SyncOnCommit);
        this.syncTimeOutTF.setText(String.valueOf(repInfo.m_SyncOnCommitTimeOut));
        this.chunkSizeTF.setText(String.valueOf(repInfo.m_ReplicationChunkSize));
        this.interMsTF.setText(String.valueOf(repInfo.m_ReplicationIntervalMillis));
        this.interOperTF.setText(String.valueOf(repInfo.m_ReplicationIntervalOperations));
        this.repOriginalStateCB.setSelected(repInfo.m_ReplicateOriginalState);
    }

    private void restoreSyncSettings(GroupInfo.ReplicationInfo repInfo) {
        this.todoQueueTimeoutTF.setText(String.valueOf(repInfo.m_TodoQueueTimeout));
        this.minUnicastWorkThreadsTF.setText(String.valueOf(repInfo.m_MinUnicastWorkingThreads));
        this.maxUnicastWorkThreadsTF.setText(String.valueOf(repInfo.m_MaxUnicastWorkingThreads));
        this.ipGroupTF.setText(String.valueOf(repInfo.m_IpGroup));
        this.portTF.setText(String.valueOf(repInfo.m_Port));
        this.minMulticastWorkThreadsTF.setText(String.valueOf(repInfo.m_MinMulticastWorkingThreads));
        this.maxMulticastWorkThreadsTF.setText(String.valueOf(repInfo.m_MaxMulticastWorkingThreads));
    }

    @Override
    public void restoreSettings(Object obj, boolean isEditMode) {
        if (obj == null) {
            this.reset();
            return;
        }
        GroupInfo.ReplicationInfo repInfo = (GroupInfo.ReplicationInfo)obj;
        this.restoreCommonSettings(repInfo);
        this.restoreAsyncSettings(repInfo);
        this.restoreSyncSettings(repInfo);
    }

    public Object saveSettings() {
        GroupInfo.ReplicationInfo repInfo = new GroupInfo.ReplicationInfo();
        repInfo.m_ReplicationMode = this.asyncButton.isSelected() ? "async" : (this.isSyncAckReplicationModelSelected() ? "sync-rec-ack" : "sync");
        repInfo.m_PolicyType = this.repModeComboBox.getSelectedIndex();
        repInfo.m_MemoryRecovery = this.repMemoryRecCB.isSelected();
        repInfo.m_ReplicateNotifyTemplates = this.repNotifyTemplCB.isSelected();
        repInfo.m_TriggerNotifyTemplates = this.triggerNotifyCB.isSelected();
        repInfo.m_TransmissionMatrix = this.chboxTransmMatrix.isSelected();
        repInfo.m_SpaceFinderTimeout = this.repFindTimeoutTF.getText().trim().length() > 0 ? this.repFindTimeoutTF.getText().trim() : Integer.toString(5000);
        repInfo.m_SyncOnCommit = this.syncOnCommitCB.isSelected();
        repInfo.m_SyncOnCommitTimeOut = this.syncTimeOutTF.getText().trim().length() > 0 ? this.syncTimeOutTF.getText().trim() : Integer.toString(300000);
        repInfo.m_ReplicationChunkSize = this.chunkSizeTF.getText().trim().length() > 0 ? this.chunkSizeTF.getText().trim() : Integer.toString(500);
        repInfo.m_ReplicationIntervalMillis = this.interMsTF.getText().trim().length() > 0 ? this.interMsTF.getText().trim() : Integer.toString(3000);
        repInfo.m_ReplicationIntervalOperations = this.interOperTF.getText().trim().length() > 0 ? this.interOperTF.getText().trim() : Integer.toString(500);
        repInfo.m_ReplicateOriginalState = this.repOriginalStateCB.isSelected();
        repInfo.m_CommunicationMode = (String)this.communicationModeComboBox.getSelectedItem();
        repInfo.m_TodoQueueTimeout = this.todoQueueTimeoutTF.getText().trim().length() > 0 ? this.todoQueueTimeoutTF.getText().trim() : String.valueOf(1500L);
        repInfo.m_MinUnicastWorkingThreads = this.minUnicastWorkThreadsTF.getText().trim().length() > 0 ? this.minUnicastWorkThreadsTF.getText().trim() : Integer.toString(4);
        repInfo.m_MaxUnicastWorkingThreads = this.maxUnicastWorkThreadsTF.getText().trim().length() > 0 ? this.maxUnicastWorkThreadsTF.getText().trim() : Integer.toString(16);
        repInfo.m_MinMulticastWorkingThreads = this.minMulticastWorkThreadsTF.getText().trim().length() > 0 ? this.minMulticastWorkThreadsTF.getText().trim() : Integer.toString(4);
        repInfo.m_MaxMulticastWorkingThreads = this.maxMulticastWorkThreadsTF.getText().trim().length() > 0 ? this.maxMulticastWorkThreadsTF.getText().trim() : Integer.toString(16);
        repInfo.m_IpGroup = this.ipGroupTF.getText().trim().length() > 0 ? this.ipGroupTF.getText().trim() : "224.0.0.1";
        repInfo.m_Port = this.portTF.getText().trim().length() > 0 ? this.portTF.getText().trim() : Integer.toString(28672);
        repInfo.m_TTL = ClusterXML.TTL_DEFAULT_VALUE;
        repInfo.m_ReplFindReportInterval = ClusterXML.REPL_FIND_REPORT_INTERVAL_DEFAULT_VALUE;
        repInfo.m_RedoLogCapacity = ClusterXML.REPL_REDO_LOG_CAPACITY_DEFAULT_VALUE;
        repInfo.m_RecoveryChunkSize = ClusterXML.RECOVERY_CHUNK_SIZE_DEFAULT_VALUE;
        repInfo.m_RecoveryThreadPoolSize = "4";
        return repInfo;
    }

    public void updateDataForRepMatrix(ClusterMemberInfo[] groupMembers, boolean replicationEnabled) {
        DefaultListModel<ClusterMemberInfo> groupMembersListModel = new DefaultListModel<ClusterMemberInfo>();
        for (int i = 0; i < groupMembers.length; ++i) {
            groupMembersListModel.addElement(groupMembers[i]);
        }
        this.updateDataForRepMatrix(groupMembersListModel, replicationEnabled);
    }

    public void updateDataForRepMatrix(DefaultListModel membersList, boolean replicationEnabled) {
        this.m_groupMembersListModel = membersList;
        boolean flag = membersList.getSize() > 1 && replicationEnabled;
        this.chboxTransmMatrix.setSelected(flag);
    }

    public void setGroupMembersListModel(DefaultListModel membersList) {
        this.m_groupMembersListModel = membersList;
    }

    public void itemStateChanged(ItemEvent arg0) {
    }

    public void stateChanged(ChangeEvent arg0) {
    }

    public class RadioListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean b = GroupReplicationPanel.this.asyncButton.isSelected();
            GroupReplicationPanel.this.replicationTabbedPane.setEnabledAt(1, b);
            GroupReplicationPanel.this.replicationTabbedPane.setEnabledAt(2, !b);
        }
    }
}

