/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.tools.cluster.ISetParam;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetParamDialog
extends JDialog {
    ISetParam m_parentDialog;
    JButton okButton;
    DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
    JComboBox paramNameTF = new JComboBox(this.comboModel);
    JTextField paramValueSpinner = new JTextField();

    public SetParamDialog(ISetParam parentDialog) {
        this(parentDialog, (JDialog)((Object)parentDialog));
    }

    public SetParamDialog(ISetParam parentDialog, JDialog parentModalDialog) {
        super((Dialog)parentModalDialog, true);
        this.m_parentDialog = parentDialog;
        this.setTitle("Define new parameter");
        Container paramDialog = this.getContentPane();
        paramDialog.setLayout(new GridBagLayout());
        GridBagConstraints gridCons = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 3, 0, 1), 0, 0);
        JLabel paramName = new JLabel("Param Name: ");
        JLabel paramValue = new JLabel("Param Value: ");
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        paramDialog.add((Component)paramName, gridCons);
        gridCons.gridy = 1;
        paramDialog.add((Component)paramValue, gridCons);
        gridCons.gridx = 1;
        gridCons.gridy = 0;
        gridCons.fill = 2;
        gridCons.weightx = 1.0;
        paramDialog.add((Component)this.paramNameTF, gridCons);
        gridCons.gridy = 1;
        paramDialog.add((Component)this.paramValueSpinner, gridCons);
        gridCons.gridy = 2;
        gridCons.insets = new Insets(5, 0, 5, 0);
        paramDialog.add((Component)buttonPanel, gridCons);
        this.setModal(true);
        this.setResizable(false);
        this.okButton.setRequestFocusEnabled(false);
        cancelButton.setRequestFocusEnabled(false);
        JSpaceUIUtils.setLocationRelativeTo(this, (Component)((Object)this.m_parentDialog));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetParamDialog.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int intValue;
                String paramValue = SetParamDialog.this.paramValueSpinner.getText();
                if (paramValue.trim().length() <= 0) {
                    intValue = -1;
                } else {
                    try {
                        intValue = Integer.parseInt(paramValue);
                    }
                    catch (NumberFormatException ex) {
                        intValue = -1;
                    }
                }
                if (intValue < 0) {
                    JOptionPane.showConfirmDialog(SetParamDialog.this, "Param value must be an integer greater than zero.", "Valication Error", -1, 0);
                    return;
                }
                paramValue = String.valueOf(intValue);
                SetParamDialog.this.m_parentDialog.setParams((String)SetParamDialog.this.paramNameTF.getSelectedItem(), paramValue);
                SetParamDialog.this.dispose();
            }
        });
    }

    public void setParamName(String paramName) {
        this.comboModel.addElement(paramName);
    }
}

