/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.tools.cluster.ISetPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TwoSelectionListPanel
extends JPanel
implements ISetPanel {
    ImageIcon leftArrowIcon;
    ImageIcon rightArrowIcon;
    ImageIcon priorityUPIcon;
    ImageIcon priorityDownIcon;
    JPanel panCenter;
    JPanel panAllItems;
    JPanel panSelectedItems;
    JPanel panSelectItem;
    JPanel panSelItemButtons;
    JPanel panPriorityButtons;
    JPanel panPriorityItem;
    JButton butLeftSelection;
    JButton butRightSelection;
    JButton butPriorityUp;
    JButton butPriorityDown;
    JLabel labSelectedItems;
    JLabel labAllItems;
    GridBagLayout gridBagLayout1;
    JList listAvailableItems;
    JList listSelectedItems;
    DefaultListModel availableItemsModel;
    DefaultListModel selectedItemsModel;
    ISelectionFilter filter;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public TwoSelectionListPanel(Vector availableItems, Vector selectedItems, boolean showPriority, String itemToRemove) {
        block2: {
            this.panCenter = new JPanel();
            this.panAllItems = new JPanel();
            this.panSelectedItems = new JPanel();
            this.panSelectItem = new JPanel();
            this.panSelItemButtons = new JPanel();
            this.panPriorityButtons = new JPanel();
            this.panPriorityItem = new JPanel();
            this.butLeftSelection = new JButton();
            this.butRightSelection = new JButton();
            this.butPriorityUp = new JButton();
            this.butPriorityDown = new JButton();
            this.labSelectedItems = new JLabel();
            this.labAllItems = new JLabel();
            this.gridBagLayout1 = new GridBagLayout();
            this.listAvailableItems = new JList();
            this.listSelectedItems = new JList();
            try {
                this.availableItemsModel = new DefaultListModel();
                this.selectedItemsModel = new DefaultListModel();
                this.listAvailableItems = new JList(this.availableItemsModel);
                this.listSelectedItems = new JList(this.selectedItemsModel);
                this.leftArrowIcon = this.getImage("/left_pointerSmall.gif");
                this.rightArrowIcon = this.getImage("/rigth_pointerSmall.gif");
                this.priorityUPIcon = this.getImage("/moveUp.gif");
                this.priorityDownIcon = this.getImage("/moveDown.gif");
                this.butLeftSelection.setIcon(this.leftArrowIcon);
                this.butRightSelection.setIcon(this.rightArrowIcon);
                this.butPriorityUp.setIcon(this.priorityUPIcon);
                this.butPriorityDown.setIcon(this.priorityDownIcon);
                this.formatArrowButton(this.butLeftSelection);
                this.formatArrowButton(this.butRightSelection);
                this.formatArrowButton(this.butPriorityUp);
                this.formatArrowButton(this.butPriorityDown);
                this.setListeners();
                this.setListModels(availableItems, selectedItems, itemToRemove);
                this.jbInit(showPriority);
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    public TwoSelectionListPanel(boolean showPriority, String itemToRemove) {
        this(new Vector(), new Vector(), showPriority, itemToRemove);
    }

    public TwoSelectionListPanel() {
        this(new Vector(), new Vector(), false, null);
    }

    private void jbInit(boolean showPriority) throws Exception {
        this.labAllItems.setText("Available Items:");
        this.labSelectedItems.setText("Selected Items:");
        this.butPriorityUp.setToolTipText("Set more high priority.");
        this.butPriorityDown.setToolTipText("Set more low priority.");
        this.butPriorityUp.setEnabled(false);
        this.butPriorityDown.setEnabled(false);
        this.panSelItemButtons.add((Component)this.butRightSelection, null);
        this.panSelItemButtons.add((Component)this.butLeftSelection, null);
        this.panPriorityButtons.add((Component)this.butPriorityUp, null);
        this.panPriorityButtons.add((Component)this.butPriorityDown, null);
        JScrollPane scrollPaneAvailableItems = new JScrollPane(this.listAvailableItems);
        scrollPaneAvailableItems.setPreferredSize(new Dimension(5, 5));
        JScrollPane scrollPaneSelectedItems = new JScrollPane(this.listSelectedItems);
        scrollPaneSelectedItems.setPreferredSize(new Dimension(5, 5));
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.labAllItems, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)scrollPaneAvailableItems, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.panSelItemButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.labSelectedItems, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)scrollPaneSelectedItems, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        if (showPriority) {
            this.add((Component)this.panPriorityButtons, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 0), 0, 0));
        }
    }

    private void setListeners() {
        this.butRightSelection.addActionListener(new ListAddRemoveActionListener(this.listAvailableItems, this.listSelectedItems, true, false));
        this.butLeftSelection.addActionListener(new ListAddRemoveActionListener(this.listSelectedItems, this.listAvailableItems, true, true));
        this.butPriorityUp.addActionListener(new PriorityUPListActionListener(this.listSelectedItems));
        this.butPriorityDown.addActionListener(new PriorityDownListActionListener(this.listSelectedItems));
        this.listSelectedItems.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TwoSelectionListPanel.this.listSelectedItems.getSelectedValue() != null && TwoSelectionListPanel.this.listSelectedItems.getSelectedIndex() != -1) {
                    DefaultListModel model = (DefaultListModel)TwoSelectionListPanel.this.listSelectedItems.getModel();
                    int index = TwoSelectionListPanel.this.listSelectedItems.getAnchorSelectionIndex();
                    TwoSelectionListPanel.this.listSelectedItems.ensureIndexIsVisible(index);
                    TwoSelectionListPanel.this.butPriorityUp.setEnabled(model.size() > 1 && index > 0);
                    TwoSelectionListPanel.this.butPriorityDown.setEnabled(model.size() > 1 && index + 1 < model.size());
                } else {
                    TwoSelectionListPanel.this.butPriorityUp.setEnabled(false);
                    TwoSelectionListPanel.this.butPriorityDown.setEnabled(false);
                }
            }
        });
    }

    private void formatArrowButton(JButton button) {
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
    }

    public void setListFont(Font f) {
        this.listAvailableItems.setFont(f);
        this.listSelectedItems.setFont(f);
    }

    public void setListModels(List availableItems, List selectedItems, String itemToRemove) {
        Object item2 = null;
        if (availableItems == null) {
            availableItems = new Vector();
        }
        if (selectedItems == null) {
            selectedItems = new Vector();
        }
        this.availableItemsModel.clear();
        Iterator iter = availableItems.iterator();
        while (iter.hasNext()) {
            this.availableItemsModel.addElement(iter.next());
        }
        this.selectedItemsModel.clear();
        for (Object item2 : selectedItems) {
            this.selectedItemsModel.addElement(item2);
            this.availableItemsModel.removeElement(item2);
        }
        if (itemToRemove != null) {
            this.availableItemsModel.removeElement(itemToRemove);
        }
        this.validate();
        this.repaint();
    }

    public void setListModels(Object[] availableItems, Object[] selectedItems, String itemToRemove) {
        int i;
        Vector<String> available = new Vector<String>();
        Vector<String> selected = new Vector<String>();
        if (availableItems != null) {
            for (i = 0; i < availableItems.length; ++i) {
                if (availableItems[i] == null) continue;
                available.addElement(availableItems[i].toString());
            }
        }
        if (selectedItems != null) {
            for (i = 0; i < selectedItems.length; ++i) {
                if (selectedItems[i] == null) continue;
                selected.addElement(selectedItems[i].toString());
            }
        }
        this.setListModels(available, selected, itemToRemove);
    }

    private ImageIcon getImage(String imageName) {
        return new ImageIcon(this.getClass().getResource("/image/cluster-wizard" + imageName));
    }

    @Override
    public void reset() {
        this.listSelectedItems.clearSelection();
        this.listAvailableItems.clearSelection();
        this.selectedItemsModel.clear();
        this.availableItemsModel.clear();
        this.butPriorityDown.setEnabled(false);
        this.butPriorityUp.setEnabled(false);
        this.validate();
    }

    @Override
    public void restoreSettings(Object obj, boolean isEditMode) {
    }

    public Object saveSettings() {
        Vector result = new Vector();
        for (int i = 0; i < this.selectedItemsModel.size(); ++i) {
            result.add(this.selectedItemsModel.get(i));
        }
        return result;
    }

    public String[] getSelectedItems() {
        int size = this.selectedItemsModel.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.selectedItemsModel.get(i).toString();
        }
        return result;
    }

    public boolean hasSelectedItems() {
        return this.selectedItemsModel.size() > 0;
    }

    public void setSelectionFilter(ISelectionFilter filter) {
        this.filter = filter;
    }

    private class PriorityDownListActionListener
    implements ActionListener {
        JList list;
        DefaultListModel model;

        public PriorityDownListActionListener(JList list) {
            this.list = list;
            this.model = (DefaultListModel)list.getModel();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selObj = this.list.getSelectedValue();
            int index = this.list.getSelectedIndex();
            Object downObj = this.model.get(index + 1);
            this.model.set(index + 1, selObj);
            this.model.set(index, downObj);
            this.list.setSelectedIndex(index + 1);
        }
    }

    private class PriorityUPListActionListener
    implements ActionListener {
        JList list;
        DefaultListModel model;

        public PriorityUPListActionListener(JList list) {
            this.list = list;
            this.model = (DefaultListModel)list.getModel();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selObj = this.list.getSelectedValue();
            int index = this.list.getSelectedIndex();
            Object upObj = this.model.get(index - 1);
            this.model.set(index - 1, selObj);
            this.model.set(index, upObj);
            this.list.setSelectedIndex(index - 1);
        }
    }

    public static interface ISelectionFilter {
        public boolean process();
    }

    private class ListAddRemoveActionListener
    extends MouseAdapter
    implements ActionListener {
        JList removeList;
        JList addList;
        DefaultListModel removeModel;
        DefaultListModel addModel;
        boolean toStringConvert;
        boolean useFilter;

        public ListAddRemoveActionListener(JList removeList, JList addList, boolean toStringConvert, boolean useFilter) {
            this.removeList = removeList;
            this.addList = addList;
            this.addModel = (DefaultListModel)addList.getModel();
            this.removeModel = (DefaultListModel)removeList.getModel();
            this.toStringConvert = toStringConvert;
            this.useFilter = useFilter;
            removeList.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (this.useFilter && TwoSelectionListPanel.this.filter != null && !TwoSelectionListPanel.this.filter.process()) {
                    return;
                }
                int index = this.removeList.locationToIndex(e.getPoint());
                if (index == -1) {
                    return;
                }
                Object remObj = this.removeModel.remove(index);
                this.addModel.addElement(this.toStringConvert ? remObj.toString() : remObj);
                this.addList.setSelectedIndex(this.addModel.getSize() - 1);
                this.addList.ensureIndexIsVisible(this.addModel.getSize() - 1);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.useFilter && TwoSelectionListPanel.this.filter != null && !TwoSelectionListPanel.this.filter.process()) {
                return;
            }
            Object[] selObjs = this.removeList.getSelectedValues();
            if (selObjs.length <= 0) {
                return;
            }
            for (int i = 0; i < selObjs.length; ++i) {
                this.removeModel.removeElement(this.toStringConvert ? selObjs[i].toString() : selObjs[i]);
                this.addModel.addElement(this.toStringConvert ? selObjs[i].toString() : selObjs[i]);
            }
            this.addList.setSelectedIndex(this.addModel.getSize() - 1);
            this.addList.ensureIndexIsVisible(this.addModel.getSize() - 1);
        }
    }
}

