/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster;

import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.StyledDocument;

public class ViewFileDialog
extends JDialog {
    JTextPane textPane = new JTextPane();
    StyledDocument document = (StyledDocument)this.textPane.getDocument();
    String m_fileURL;

    public ViewFileDialog(JFrame parentDialog, String fileURL) throws IOException {
        super((Frame)parentDialog, true);
        this.initDialog(parentDialog);
        this.initFile(fileURL);
    }

    public ViewFileDialog(JDialog parentDialog) {
        super((Dialog)parentDialog, true);
        this.initDialog(parentDialog);
    }

    private void initFile(String fileURL) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        InputStream isr = null;
        StringTokenizer st = new StringTokenizer(fileURL);
        while (st.hasMoreTokens()) {
            this.m_fileURL = st.nextToken();
            try {
                URL url = new URL(this.m_fileURL);
                isr = url.openConnection().getInputStream();
                break;
            }
            catch (MalformedURLException ex) {
                try {
                    isr = new FileInputStream(this.m_fileURL);
                }
                catch (IOException e) {
                    if (st.hasMoreTokens()) continue;
                    throw e;
                }
            }
        }
        this.setTitle("XML Preview " + this.m_fileURL);
        while ((ch = isr.read()) != -1) {
            sb.append((char)ch);
        }
        isr.close();
        this.setText(sb.toString());
    }

    private void initDialog(Component parentDialog) {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton("Close");
        buttonPanel.add(closeButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.textPane), null);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.textPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setModal(true);
        this.textPane.setEditable(false);
        this.textPane.setFont(new Font("Dialog", 1, 12));
        JSpaceUIUtils.setLocationRelativeTo(this, parentDialog);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewFileDialog.this.dispose();
            }
        });
        this.pack();
        this.setSize(600, 600);
        JSpaceUIUtils.setLocationRelativeTo(this, parentDialog);
    }

    private void setAttributes(String text) {
    }

    public void setText(String text) {
        this.textPane.setText(text);
        this.setAttributes(text);
    }
}

