/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.utils.concurrent.GSTimer;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.MembersTable;
import com.j_spaces.tools.spacebrowser.ClusterSpacesViewPanel;
import com.j_spaces.tools.spacebrowser.SpacesViewPanel;
import com.j_spaces.tools.spacebrowser.utils.InstancesInfoBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class ClusterPanel
extends JPanel {
    private ClusterViewDlg m_owner;
    private GroupInfo[] _curGroupsInfo;
    private ClusterMemberInfo[] m_membersInfo;
    private MembersTable m_membersTable;
    private ClusterSpacesViewPanel _clusterSpacesViewPanel;
    private JPanel grPan;
    private JSplitPane splitPan;
    private JTextField clusterNameTextField;
    private JTextField lookupGroupNameTextField;
    private JTextField clusterSchemaTextField;
    private JTextField totalMemberTextField;
    private InstancesInfoBox _infoBox;
    private JFrame _parentFrame;
    private static final Dimension labelSize = new Dimension(140, 21);
    private static final Dimension maxLabelSize = new Dimension(470, 21);
    private static final Dimension textFieldSize = new Dimension(350, 23);
    private static final Dimension maxTextFieldSize = new Dimension(750, 23);
    private static final Dimension minTextFieldSize = new Dimension(30, 23);
    private static final int LEFT_ALLIGN = 3;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public ClusterPanel(JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.init();
    }

    public void setClusterPanel(ClusterViewDlg owner, GroupInfo[] groupsArr, ClusterMemberInfo[] members, int primaryMembersCount, int backupMembersCount) {
        block5: {
            this.m_owner = owner;
            try {
                String clusterName = owner.getClusterName();
                this._clusterSpacesViewPanel.setClusterName(clusterName, this.m_owner.getServiceManager());
                if (this._curGroupsInfo == null || this._curGroupsInfo != groupsArr) {
                    this.clear();
                    this._curGroupsInfo = groupsArr;
                    this.m_membersInfo = members;
                    this.clusterNameTextField.setText(clusterName);
                    this.totalMemberTextField.setText(backupMembersCount == 0 ? String.valueOf(primaryMembersCount) : String.valueOf(primaryMembersCount) + "," + String.valueOf(backupMembersCount));
                    int spacesCount = this._clusterSpacesViewPanel.getSpacesCount();
                    SpaceClusterInfo clusterInfo = null;
                    SpacesViewPanel.SpaceViewWrapper spaceViewWraper = null;
                    for (int currentIndex = 0; currentIndex < spacesCount && clusterInfo == null; ++currentIndex) {
                        spaceViewWraper = this._clusterSpacesViewPanel.getWrapperAt(currentIndex);
                        if (spaceViewWraper == null || !spaceViewWraper.getSpaceConfig().getClusterInfo().isClustered()) continue;
                        clusterInfo = spaceViewWraper.getSpaceConfig().getClusterInfo();
                    }
                    if (clusterInfo != null) {
                        this.lookupGroupNameTextField.setText(spaceViewWraper.getJiniGroup());
                        this.clusterSchemaTextField.setText(clusterInfo.getClusterSchema());
                    }
                    this.m_membersTable.setMembers(this.m_membersInfo);
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block5;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
        this._infoBox.setCount(this.m_membersTable.getRowsCount());
    }

    public void refreshClusterSpaces() {
        this._clusterSpacesViewPanel.refreshClusterSpaces();
    }

    private void clear() {
        this.clusterNameTextField.setText("");
        this.clusterSchemaTextField.setText("");
        this.lookupGroupNameTextField.setText("");
        this.totalMemberTextField.setText("");
    }

    public void clearCurGroupInfo() {
        this._curGroupsInfo = null;
    }

    private void init() {
        this.grPan = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(100, 150));
        Box textFieldsBox = this.createTextFieldsBox();
        this._clusterSpacesViewPanel = new ClusterSpacesViewPanel(this._parentFrame);
        this._clusterSpacesViewPanel.setBorder(new TitledBorder("Cluster Spaces"));
        this.grPan.add((Component)textFieldsBox, "North");
        this.grPan.add((Component)this._clusterSpacesViewPanel, "Center");
        this.m_membersTable = new MembersTable();
        this._infoBox = new InstancesInfoBox("defined cluster member", "alive cluster member");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.m_membersTable, "Center");
        bottomPanel.add((Component)this._infoBox, "South");
        this.splitPan = new JSplitPane(0, this.grPan, bottomPanel);
        this.splitPan.setOneTouchExpandable(true);
        this.splitPan.setDividerLocation(350);
        this.add((Component)this.splitPan, "Center");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ClusterPanel.this.updateAliveMembersCount();
            }
        };
        GSTimer clustersAliveCountTimer = new GSTimer();
        clustersAliveCountTimer.schedule(timerTask, 2000L, 1000L);
        this.setInvokeRefresh(true);
    }

    private Box createTextFieldsBox() {
        JLabel clusterNameLabel = this.createLabel("Name:");
        this.clusterNameTextField = this.createTextField();
        Box clusterNameBox = new Box(0);
        clusterNameBox.add(Box.createHorizontalStrut(3));
        clusterNameBox.add(clusterNameLabel);
        clusterNameBox.add(this.clusterNameTextField);
        clusterNameBox.add(Box.createHorizontalGlue());
        JLabel lookupGroupLabel = this.createLabel("Lookup Group:");
        this.lookupGroupNameTextField = this.createTextField();
        Box lookupGroupBox = new Box(0);
        lookupGroupBox.add(Box.createHorizontalStrut(3));
        lookupGroupBox.add(lookupGroupLabel);
        lookupGroupBox.add(this.lookupGroupNameTextField);
        lookupGroupBox.add(Box.createHorizontalGlue());
        JLabel clusterSchemaLabel = this.createLabel("Cluster Schema:");
        this.clusterSchemaTextField = this.createTextField();
        Box clusterSchemaBox = new Box(0);
        clusterSchemaBox.add(Box.createHorizontalStrut(3));
        clusterSchemaBox.add(clusterSchemaLabel);
        clusterSchemaBox.add(this.clusterSchemaTextField);
        clusterSchemaBox.add(Box.createHorizontalGlue());
        JLabel totalMembersLabel = this.createLabel("Total Members:");
        this.totalMemberTextField = this.createTextField();
        Box totalMembersBox = new Box(0);
        totalMembersBox.add(Box.createHorizontalStrut(3));
        totalMembersBox.add(totalMembersLabel);
        totalMembersBox.add(this.totalMemberTextField);
        totalMembersBox.add(Box.createHorizontalGlue());
        Box vertBox = new Box(1);
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(clusterNameBox);
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(lookupGroupBox);
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(clusterSchemaBox);
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(totalMembersBox);
        vertBox.add(Box.createVerticalStrut(5));
        vertBox.setBorder(BorderFactory.createTitledBorder("Details"));
        vertBox.setPreferredSize(new Dimension(600, 150));
        return vertBox;
    }

    private JTextField createTextField() {
        JTextField textField = new JTextField();
        textField.setEditable(false);
        textField.setPreferredSize(textFieldSize);
        textField.setMaximumSize(maxTextFieldSize);
        textField.setMinimumSize(minTextFieldSize);
        return textField;
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
        label.setMaximumSize(maxLabelSize);
        return label;
    }

    public void setInvokeRefresh(boolean invokeRefresh) {
        this._clusterSpacesViewPanel.setInvokeRefresh(invokeRefresh);
    }

    public void updateAliveMembersCount() {
        this._infoBox.setCount2(this.m_membersTable.getAliveClusterMembersCount());
    }

    public void setClusterTreeNode(String nodeName) {
        this.m_owner.setClusterTreeNode(nodeName);
    }

    public void removeSpace(ServiceID serviceID) {
        this._clusterSpacesViewPanel.removeSpace(serviceID);
    }

    public void spaceAdded(ServiceItem item) {
        this._clusterSpacesViewPanel.spaceAdded(item);
    }
}

