/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ClusterPanel;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.GroupPanel;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.CardLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClusterTree
extends JPanel {
    private DefaultMutableTreeNode[] m_groupTreeNodes;
    private JTree m_tree;
    private ClusterViewDlg m_owner;
    private GroupInfo[] m_groupsInfo;
    private String m_clusterName;
    private SpaceBrowser _spaceBrowser;
    private DefaultMutableTreeNode m_Root;
    private Map<String, DefaultMutableTreeNode> _allGroupsNodesMap;
    private Map<String, DefaultMutableTreeNode> _allMembersNodesMap;
    private Map<String, GroupInfo> _allGroupInfoMap;
    public static final String CLUSTER_NAME_SUFFIX = " [Space Cluster]";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public ClusterTree(ClusterViewDlg parent, String clusterName, GroupInfo[] groups, SpaceBrowser spaceBrowser, boolean isAddOperationsNode) {
        block2: {
            this._allGroupsNodesMap = new HashMap<String, DefaultMutableTreeNode>(3);
            this._allMembersNodesMap = new HashMap<String, DefaultMutableTreeNode>(5);
            this._allGroupInfoMap = new HashMap<String, GroupInfo>(3);
            try {
                this.m_owner = parent;
                this.m_clusterName = clusterName;
                this.m_groupsInfo = groups;
                this._spaceBrowser = spaceBrowser;
                this.init(isAddOperationsNode);
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    private void init(boolean isAddOperationsNode) throws Exception {
        int numOfGroups = this.m_groupsInfo.length;
        this.m_Root = new DefaultMutableTreeNode(this.m_clusterName + CLUSTER_NAME_SUFFIX);
        this.m_tree = new JTree(this.m_Root);
        this.m_groupTreeNodes = new DefaultMutableTreeNode[numOfGroups];
        for (int i = 0; i < numOfGroups; ++i) {
            String groupName = this.m_groupsInfo[i].groupName;
            this.m_groupTreeNodes[i] = new DefaultMutableTreeNode(groupName, true);
            this.m_Root.add(this.m_groupTreeNodes[i]);
            this._allGroupsNodesMap.put(groupName, this.m_groupTreeNodes[i]);
            this._allGroupInfoMap.put(groupName, this.m_groupsInfo[i]);
            for (int j = 0; j < this.m_groupsInfo[i].groupMembers.length; ++j) {
                String memberName = this.m_groupsInfo[i].groupMembers[j].memberName;
                this.createAndAddMemberNode(this.m_groupTreeNodes[i], memberName);
            }
        }
        if (isAddOperationsNode) {
            this.addClusterOperationsNode(this.m_Root);
        }
        this.m_tree.setAutoscrolls(true);
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                block3: {
                    try {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            ClusterTree.this.performNodeAction(ClusterTree.this.m_tree.getPathForLocation(e.getX(), e.getY()));
                        }
                    }
                    catch (Exception ex) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block3;
                        _logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        });
        this.m_tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ClusterTree.this.performNodeAction(ClusterTree.this.m_tree.getSelectionPath());
            }

            @Override
            public void keyTyped(KeyEvent e) {
                ClusterTree.this.performNodeAction(ClusterTree.this.m_tree.getSelectionPath());
            }
        });
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setSelectionRow(0);
    }

    public void addClusterOperationsNode(DefaultMutableTreeNode clusterNameRootNode) {
        DefaultMutableTreeNode operationNode = new DefaultMutableTreeNode("Operations", true);
        clusterNameRootNode.add(operationNode);
        operationNode.add(new DefaultMutableTreeNode("Data Types", false));
        operationNode.add(new DefaultMutableTreeNode("Transactions", false));
        operationNode.add(new DefaultMutableTreeNode("Query", false));
        operationNode.add(new DefaultMutableTreeNode("Statistics", false));
        operationNode.add(new DefaultMutableTreeNode("Connections", false));
        operationNode.add(new DefaultMutableTreeNode("Benchmark", false));
    }

    public JTree getTree() {
        return this.m_tree;
    }

    private void createAndAddMemberNode(DefaultMutableTreeNode groupTreeNode, String memberName) {
        DefaultMutableTreeNode memberNode = new DefaultMutableTreeNode(memberName, true);
        groupTreeNode.insert(memberNode, groupTreeNode.getChildCount());
        this._allMembersNodesMap.put(memberName, memberNode);
    }

    private void removeMemberNode(DefaultMutableTreeNode childNode) {
        childNode.removeFromParent();
        this._allMembersNodesMap.remove(childNode.toString());
    }

    public void performNodeAction(TreePath selPath) {
        if (selPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            TreeNode parentTreeNode = node.getParent();
            TreeNode parentTreeNode2 = null;
            if (parentTreeNode != null) {
                parentTreeNode2 = parentTreeNode.getParent();
            }
            if (parentTreeNode2 != null && ((DefaultMutableTreeNode)parentTreeNode2).getUserObject() instanceof EditCluster) {
                this.showHighLevelNode((DefaultMutableTreeNode)parentTreeNode, parentTreeNode.toString());
                GroupPanel grPanel = this.getGroupPanel();
                grPanel.performActionOnMember(selPath, node.getUserObject().toString());
            } else {
                this.showHighLevelNode(node, node.toString());
                GroupPanel grPanel = this.getGroupPanel();
                grPanel.setRelaxAllowed();
                grPanel.clearReplicationDetails();
            }
        }
    }

    public void performSelectedNodeAction() {
        JTree conTree = this.m_owner.getBrowser().getContainerTree();
        TreePath selPath = conTree.getSelectionPath();
        this.performNodeAction(selPath);
    }

    public void showHighLevelNode(DefaultMutableTreeNode node, String groupName) {
        String cardPanelName = "CLUSTER_MEMEBER_VIEW";
        if (node.getUserObject() instanceof EditCluster) {
            cardPanelName = "CLUSTER_ROOT_VIEW";
        }
        JPanel panel = this.m_owner.getClusterPanel();
        ((CardLayout)panel.getLayout()).show(panel, cardPanelName);
        if (groupName != null) {
            this.m_owner.setGroupInfo(this._allGroupInfoMap.get(groupName));
        }
        this.m_owner.startGraphTread(node.getUserObject().toString());
    }

    public void setSelectedNode(String nodeName) {
        block8: {
            try {
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
                if (selectedNode == null || selectedNode.getUserObject().toString().equals(nodeName)) {
                    return;
                }
                DefaultMutableTreeNode parentNode = null;
                boolean isGroup = false;
                if (selectedNode.isRoot()) {
                    parentNode = selectedNode;
                    isGroup = true;
                } else {
                    parentNode = (DefaultMutableTreeNode)selectedNode.getParent();
                    if (parentNode.isRoot()) {
                        parentNode = selectedNode;
                    }
                }
                for (int i = 0; i < parentNode.getChildCount(); ++i) {
                    selectedNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                    if (!selectedNode.getUserObject().toString().equals(nodeName)) continue;
                    TreePath path = new TreePath(selectedNode.getPath());
                    this.m_tree.setSelectionPath(path);
                    if (isGroup) {
                        this.performNodeAction(path);
                    }
                    break;
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block8;
                _logger.log(Level.FINE, ex.toString(), ex);
            }
        }
    }

    private GroupPanel getGroupPanel() {
        return this.m_owner.getGroupPanel();
    }

    public ClusterPanel getClusterPanelComponent() {
        return this.m_owner.getClusterPanelComponent();
    }

    public boolean isExistGroup(String groupName) {
        for (int i = 0; i < this.m_groupsInfo.length; ++i) {
            if (!this.m_groupsInfo[i].groupName.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    public boolean isExistMember(String memberName) {
        return this.m_owner.isExistMember(memberName);
    }

    public DefaultMutableTreeNode getRoot() {
        return this.m_Root;
    }
}

