/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.UI;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ClusterPanel;
import com.j_spaces.tools.cluster.view.ClusterTree;
import com.j_spaces.tools.cluster.view.ClusterViewMenuBar;
import com.j_spaces.tools.cluster.view.GroupPanel;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;

public class ClusterViewDlg {
    private String m_clusterName;
    private GroupInfo[] m_groupsInfo;
    private ClusterMemberInfo[] m_membersInfo;
    private ClusterPanel m_clusterPanel;
    private JPanel m_panCenter;
    private ClusterViewMenuBar m_menuBar;
    private SpaceBrowser _spaceBrowserInstance;
    private MainUI _parentFrame;
    private UI _uiComponent;
    private ServiceManagerImpl m_serviceManager;
    private EditCluster curEditCluster;
    private Map<String, ClusterWrapper> _clusterWrappersMap;
    private CardLayout centerPanelCardLayout;
    private GroupPanel groupPanel;
    private static final int CLUSTERS_MEMBER_COUNT_SWITCH_ZOOM = 5;
    public static final String CLUSTER_MEMBERS_VIEW = "CLUSTER_MEMEBER_VIEW";
    public static final String CLUSTER_ROOT_VIEW = "CLUSTER_ROOT_VIEW";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public ClusterViewDlg(MainUI parentFrame, SpaceBrowser spaceBrowserInstance) {
        block2: {
            this.centerPanelCardLayout = new CardLayout();
            this.groupPanel = null;
            try {
                this._parentFrame = parentFrame;
                this._spaceBrowserInstance = spaceBrowserInstance;
                this.m_serviceManager = new ServiceManagerImpl();
                this.m_menuBar = new ClusterViewMenuBar(this);
                this._clusterWrappersMap = new HashMap<String, ClusterWrapper>();
                this.init();
                IRefreshable[] module = new IRefreshable[]{this.groupPanel.getGraphPanel()};
                this.m_serviceManager.setRefreshModules(module);
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, ex.toString(), ex);
            }
        }
    }

    public void setSpaceBrowser(SpaceBrowser spaceBrowser) {
        this._spaceBrowserInstance = spaceBrowser;
    }

    public SpaceBrowser getBrowser() {
        return this._spaceBrowserInstance;
    }

    private void init() {
        this.m_clusterPanel = new ClusterPanel(this._parentFrame);
        this.m_menuBar.selectDefaultSpeedMenu();
        this.m_panCenter = new JPanel(this.centerPanelCardLayout);
        this.groupPanel = new GroupPanel(this);
        JPanel membersPanel = new JPanel(new BorderLayout());
        membersPanel.add((Component)this.groupPanel, "Center");
        this.m_panCenter.add(CLUSTER_MEMBERS_VIEW, membersPanel);
        this.m_panCenter.add(CLUSTER_ROOT_VIEW, this.m_clusterPanel);
    }

    public void clearCurrentCluster() {
        this.curEditCluster = null;
        this.m_clusterPanel.clearCurGroupInfo();
        this.groupPanel.clearCurGroupInfo();
        this.m_serviceManager.clearCurMembersInfo();
    }

    public EditCluster getCurEditCluster() {
        return this.curEditCluster;
    }

    public JFrame getParentFrame() {
        return this._parentFrame;
    }

    public JPanel getClusterPanel() {
        return this.m_panCenter;
    }

    public ClusterPanel getClusterPanelComponent() {
        return this.m_clusterPanel;
    }

    public void setClusterView(EditCluster editCluster, boolean isRefreshClusterView, boolean isClusterMemberSelected, boolean isServiceManagerThreadPaused, boolean isAddOperationsNode) {
        try {
            boolean isAnotherClusterSelected;
            boolean bl = isAnotherClusterSelected = editCluster == null || this.curEditCluster != editCluster;
            if (isAnotherClusterSelected || isRefreshClusterView) {
                this.curEditCluster = editCluster;
                this.m_clusterName = editCluster.getClusterName();
                this.m_groupsInfo = editCluster.getClusterGroups();
                this.m_membersInfo = editCluster.getClusterMembers();
                if (isAnotherClusterSelected) {
                    this.m_serviceManager.setCurrentClusterMembers(this.m_membersInfo, isServiceManagerThreadPaused);
                    this.m_clusterPanel.updateAliveMembersCount();
                }
                if (isRefreshClusterView) {
                    int primariesCount = editCluster.getPrimaryMemers().length;
                    if (editCluster.isMirrorDefined()) {
                        --primariesCount;
                    }
                    this.m_clusterPanel.setClusterPanel(this, this.m_groupsInfo, this.m_membersInfo, primariesCount, editCluster.getBackupsPerMember());
                    this.groupPanel.setPanelEnabled(false);
                }
                ClusterTree clusterTree = null;
                ClusterWrapper clusterWrapper = this._clusterWrappersMap.get(this.m_clusterName);
                if (clusterWrapper == null) {
                    clusterTree = new ClusterTree(this, this.m_clusterName, this.m_groupsInfo, this._spaceBrowserInstance, isAddOperationsNode);
                    this.putCluster(editCluster, clusterTree);
                } else {
                    clusterTree = this.getClusterTree(this.m_clusterName);
                }
                this.m_serviceManager.setClusterTreeReference(clusterTree);
            }
            this.m_serviceManager.paused(isServiceManagerThreadPaused, true);
        }
        catch (Exception ex) {
            this._spaceBrowserInstance.debug(ex);
        }
    }

    public void refreshClusterSpaces() {
        this.m_clusterPanel.refreshClusterSpaces();
    }

    public void setOvalShapeMode(boolean isOvalShape) {
        this.groupPanel.setOvalShapeMode(isOvalShape);
    }

    public void increaseZoom() {
        this.groupPanel.increaseZoom();
    }

    public void decreaseZoom() {
        this.groupPanel.decreaseZoom();
    }

    public String toString() {
        return this.m_clusterName;
    }

    public String getClusterName() {
        return this.m_clusterName;
    }

    public GroupInfo[] getAllGroups() {
        return this.m_groupsInfo;
    }

    public ClusterMemberInfo[] getAllMembers() {
        return this.m_membersInfo;
    }

    public ServiceManagerImpl getServiceManager() {
        return this.m_serviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClusterFile() {
        File file = this._spaceBrowserInstance.chooseFile();
        if (file == null) {
            return;
        }
        String configFileName = file.getPath();
        if (!configFileName.endsWith(".xml")) {
            configFileName = configFileName + ".xml";
        }
        try {
            this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            EditCluster editCluster = new EditCluster(configFileName);
            DefaultMutableTreeNode clusterRootNode = this.setClusterToBrowser(editCluster, null, true, true, false, false);
            String clusterName = editCluster.getClusterName();
            this.getClusterTree(clusterName).showHighLevelNode(clusterRootNode, null);
        }
        catch (Exception ex) {
            SpaceBrowser.expDialog.showException("cluster configuration parsing", ex);
        }
        finally {
            this._parentFrame.setCursor(new Cursor(0));
        }
    }

    private DefaultMutableTreeNode setClusterToBrowser(EditCluster editCluster, ServiceID spaceID, boolean isRefreshClusterView, boolean isBrowserViewOnly, boolean isAddOperationsNode, boolean isUnmanagedSpace) {
        boolean isClusterNodesSelected = this._spaceBrowserInstance.isClustersTreeNodeSelected();
        this.setClusterView(editCluster, isRefreshClusterView, false, !isClusterNodesSelected, isAddOperationsNode);
        String clusterName = editCluster.getClusterName();
        ClusterTree clusterTreeObj = this.getClusterTree(clusterName);
        JTree clusterTree = clusterTreeObj.getTree();
        DefaultTreeModel treeModel = (DefaultTreeModel)clusterTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        root.setUserObject(editCluster);
        this._spaceBrowserInstance.addClusterTree(clusterTreeObj, root, editCluster, isRefreshClusterView);
        if (isRefreshClusterView) {
            this._spaceBrowserInstance.showClusterPanel(editCluster, false, !isClusterNodesSelected, isAddOperationsNode);
        }
        if (!isBrowserViewOnly && this._uiComponent != null) {
            this._uiComponent.addClusterTree(clusterTree, editCluster.getClusterName(), spaceID, isUnmanagedSpace);
        }
        return root;
    }

    public void setSpaceID(String clusterName, ServiceID spaceID, String memberName) {
        ClusterWrapper clusterWrapper = this._clusterWrappersMap.get(clusterName);
        if (clusterWrapper != null) {
            EditCluster editCluster = clusterWrapper.getEditCluster();
            editCluster.setSpaceIDToMember(spaceID, memberName);
        }
        this.groupPanel.setSpaceIDToNode(spaceID, memberName);
    }

    public void setSpaceID(ServiceID spaceID, String memberName) {
        Collection<ClusterWrapper> clusterWrappersCollection = this._clusterWrappersMap.values();
        for (ClusterWrapper clusterWrapper : clusterWrappersCollection) {
            if (clusterWrapper != null) {
                EditCluster editCluster = clusterWrapper.getEditCluster();
                editCluster.setSpaceIDToMember(spaceID, memberName);
            }
            this.groupPanel.setSpaceIDToNode(spaceID, memberName);
        }
    }

    public void addCluster(EditCluster editCluster, String clusterName, boolean isRefreshClusterView, ServiceID spaceID, boolean isUnmanagedSpace) throws Exception {
        if (this.containsCluster(clusterName)) {
            return;
        }
        this.setClusterToBrowser(editCluster, spaceID, isRefreshClusterView, false, true, isUnmanagedSpace);
    }

    public void putCluster(EditCluster editCluster, ClusterTree clusterTree) {
        String clusterId = editCluster.getClusterName();
        if (!this._clusterWrappersMap.containsKey(clusterId)) {
            this._clusterWrappersMap.put(clusterId, new ClusterWrapper(clusterTree, editCluster));
        }
    }

    public void removeCluster(String clusterId) {
        this._clusterWrappersMap.remove(clusterId);
        this.curEditCluster = null;
    }

    public void removeSpace(ServiceID serviceID) {
        this.m_clusterPanel.removeSpace(serviceID);
    }

    public boolean containsCluster(String clusterId) {
        return this._clusterWrappersMap.containsKey(clusterId);
    }

    public ClusterTree getClusterTree(String clusterName) {
        return this._clusterWrappersMap.get(clusterName).getClusterTree();
    }

    public void setGroupInfo(GroupInfo groupInfo) {
        this.groupPanel.setGroupInfo(groupInfo);
    }

    public void setUIComponent(UI ui) {
        this._uiComponent = ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClusterTreeNode(String nodeId) {
        try {
            Object memberNode;
            DefaultMutableTreeNode treeNode;
            Object[] nodePath;
            String clusterId;
            boolean isRequiredMember;
            int i;
            this._parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            Toolkit.getDefaultToolkit().sync();
            JTree conTree = this._spaceBrowserInstance.getContainerTree();
            String lastComponentName = "";
            TreePath treePath = null;
            boolean isClusterNodeFound = false;
            Object secondComponent = null;
            for (i = 0; !isClusterNodeFound && i < conTree.getRowCount(); ++i) {
                treePath = conTree.getPathForRow(i);
                if (treePath == null) continue;
                lastComponentName = treePath.getLastPathComponent().toString();
                secondComponent = treePath.getPathComponent(1);
                if (!lastComponentName.equals(this.m_clusterName) || !secondComponent.toString().equals("Clusters")) continue;
                isClusterNodeFound = true;
            }
            if (treePath == null) {
                return;
            }
            conTree.expandPath(treePath);
            while (conTree.getPathForRow(i) != null && !(isRequiredMember = (clusterId = JSpaceUIUtils.createClusterGuiId(nodePath = (treeNode = (DefaultMutableTreeNode)(memberNode = (treePath = conTree.getPathForRow(i)).getLastPathComponent())).getPath())).equals(nodeId))) {
                ++i;
            }
            TreePath path = conTree.getPathForRow(i);
            if (path != null) {
                conTree.expandPath(path);
                conTree.setSelectionPath(path);
                if (!((DefaultMutableTreeNode)path.getLastPathComponent()).isLeaf()) {
                    this._spaceBrowserInstance.doNodeSelected(path);
                }
            }
        }
        catch (Exception e) {
            this._spaceBrowserInstance.debug(e);
        }
        finally {
            this._parentFrame.setCursor(new Cursor(0));
        }
    }

    public GroupPanel getGroupPanel() {
        return this.groupPanel;
    }

    public void stopAllGraphTreads() {
        this.groupPanel.getGraphPanel().stop();
    }

    public void startGraphTread(String groupName) {
        this.stopAllGraphTreads();
        this.groupPanel.getGraphPanel().start();
    }

    public boolean isExistMember(String memberName) {
        for (int i = 0; i < this.m_membersInfo.length; ++i) {
            if (!this.m_membersInfo[i].memberName.equals(memberName)) continue;
            return true;
        }
        return false;
    }

    private class ClusterWrapper {
        private ClusterTree _clusterTree;
        private EditCluster _editCluster;

        public ClusterWrapper(ClusterTree clusterTree, EditCluster editCluster) {
            this._clusterTree = clusterTree;
            this._editCluster = editCluster;
        }

        public EditCluster getEditCluster() {
            return this._editCluster;
        }

        public void setEditCluster(EditCluster editCluster) {
            this._editCluster = editCluster;
        }

        public ClusterTree getClusterTree() {
            return this._clusterTree;
        }
    }
}

