/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class ClusterViewMenuBar
extends JMenuBar
implements ActionListener {
    public static boolean FREEZE_ALL_MEMBERS;
    public static boolean SHOW_BACKWARD_REPLICATION;
    public static boolean PING_MODE;
    public static boolean SHOW_OBJECTS_COUNT;
    ClusterViewDlg m_owner;
    ServiceManagerImpl serviceManager;
    private JMenu _clusterViewMenu;
    private JMenuItem menuItemRefresh;
    private JMenu menuUpdateSpeed;
    private JRadioButtonMenuItem menuItemUpdateSpeedHigh;
    private JRadioButtonMenuItem menuItemUpdateSpeedNormal;
    private JRadioButtonMenuItem menuItemUpdateSpeedLow;
    private JRadioButtonMenuItem menuItemUpdateSpeedPaused;
    private JRadioButtonMenuItem menuItemUpdateSpeedCustom;
    private JMenu menuShapeMode;
    private JRadioButtonMenuItem menuItemShapeModeOval;
    private JRadioButtonMenuItem menuItemShapeModeRect;
    private JCheckBoxMenuItem chboxMenuShowLegend;
    private JMenu menuOptions;
    private JCheckBoxMenuItem chboxMenuItemShowBackwardReplication;
    private JCheckBoxMenuItem chboxMenuItemShowObjectsCount;
    private JCheckBoxMenuItem chboxMenuItemPingMode;
    private JMenu menuZoom;
    private JRadioButtonMenuItem menuItemZoomIn;
    private JRadioButtonMenuItem menuItemZoomOut;
    private static final Logger _logger;

    public ClusterViewMenuBar(ClusterViewDlg owner) {
        block2: {
            this._clusterViewMenu = new JMenu("Cluster");
            this.menuItemRefresh = new JMenuItem();
            this.menuUpdateSpeed = new JMenu();
            this.menuItemUpdateSpeedHigh = new JRadioButtonMenuItem();
            this.menuItemUpdateSpeedNormal = new JRadioButtonMenuItem();
            this.menuItemUpdateSpeedLow = new JRadioButtonMenuItem();
            this.menuItemUpdateSpeedPaused = new JRadioButtonMenuItem();
            this.menuItemUpdateSpeedCustom = new JRadioButtonMenuItem();
            this.menuShapeMode = new JMenu();
            this.menuItemShapeModeOval = new JRadioButtonMenuItem();
            this.menuItemShapeModeRect = new JRadioButtonMenuItem();
            this.chboxMenuShowLegend = new JCheckBoxMenuItem();
            this.menuOptions = new JMenu();
            this.chboxMenuItemShowBackwardReplication = new JCheckBoxMenuItem();
            this.chboxMenuItemShowObjectsCount = new JCheckBoxMenuItem();
            this.chboxMenuItemPingMode = new JCheckBoxMenuItem();
            this.menuZoom = new JMenu("Zoom");
            this.menuItemZoomIn = new JRadioButtonMenuItem("Zoom In");
            this.menuItemZoomOut = new JRadioButtonMenuItem("Zoom Out");
            this.m_owner = owner;
            PING_MODE = true;
            try {
                this.serviceManager = this.m_owner.getServiceManager();
                this.jbInit();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void jbInit() throws Exception {
        this.menuItemRefresh.setText("Refresh");
        this.menuItemRefresh.addActionListener(this);
        this.menuUpdateSpeed.setText("Node Movement Speed");
        this.menuUpdateSpeed.setToolTipText("Cluster View nodes movement speed");
        this.menuItemUpdateSpeedHigh.setText("High");
        this.menuItemUpdateSpeedNormal.setText("Normal");
        this.menuItemUpdateSpeedLow.setText("Low");
        this.menuItemUpdateSpeedPaused.setText("Paused");
        this.menuItemUpdateSpeedCustom.setText("Custom...");
        this.menuShapeMode.setText("Node Shape");
        this.menuItemShapeModeOval.setText("Oval");
        this.menuItemShapeModeRect.setText("Rectangle");
        this.chboxMenuShowLegend.setText("Show Legend");
        this.chboxMenuShowLegend.addActionListener(this);
        this.menuOptions.setText("Options");
        this.chboxMenuItemShowBackwardReplication.setText("Backward Replication");
        this.chboxMenuItemShowBackwardReplication.addActionListener(this);
        this.chboxMenuItemShowObjectsCount.setText("Show Number of Objects");
        this.chboxMenuItemShowObjectsCount.addActionListener(this);
        SHOW_OBJECTS_COUNT = true;
        this.chboxMenuItemShowObjectsCount.setSelected(SHOW_OBJECTS_COUNT);
        this.chboxMenuItemPingMode.setText("Ping mode");
        this.chboxMenuItemPingMode.addActionListener(this);
        ButtonGroup updateSpeedGroup = new ButtonGroup();
        updateSpeedGroup.add(this.menuItemUpdateSpeedHigh);
        updateSpeedGroup.add(this.menuItemUpdateSpeedNormal);
        updateSpeedGroup.add(this.menuItemUpdateSpeedLow);
        updateSpeedGroup.add(this.menuItemUpdateSpeedPaused);
        updateSpeedGroup.add(this.menuItemUpdateSpeedCustom);
        ButtonGroup nodeSizeGroup = new ButtonGroup();
        nodeSizeGroup.add(this.menuItemZoomIn);
        nodeSizeGroup.add(this.menuItemZoomOut);
        this.menuItemZoomIn.addActionListener(this);
        this.menuItemZoomOut.addActionListener(this);
        Enumeration<AbstractButton> e = updateSpeedGroup.getElements();
        while (e.hasMoreElements()) {
            ((JRadioButtonMenuItem)e.nextElement()).addActionListener(this);
        }
        ButtonGroup shapeModeGroup = new ButtonGroup();
        shapeModeGroup.add(this.menuItemShapeModeOval);
        shapeModeGroup.add(this.menuItemShapeModeRect);
        Enumeration<AbstractButton> e2 = shapeModeGroup.getElements();
        while (e2.hasMoreElements()) {
            ((JRadioButtonMenuItem)e2.nextElement()).addActionListener(this);
        }
        this._clusterViewMenu.add(this.menuItemRefresh);
        this._clusterViewMenu.add(this.menuUpdateSpeed);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedHigh);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedNormal);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedLow);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedPaused);
        this.menuUpdateSpeed.add(this.menuItemUpdateSpeedCustom);
        this._clusterViewMenu.add(new JSeparator());
        this._clusterViewMenu.add(this.menuShapeMode);
        this.menuShapeMode.add(this.menuItemShapeModeOval);
        this.menuShapeMode.add(this.menuItemShapeModeRect);
        this._clusterViewMenu.add(this.menuZoom);
        this.menuZoom.add(this.menuItemZoomIn);
        this.menuZoom.add(this.menuItemZoomOut);
        this._clusterViewMenu.add(this.menuOptions);
        this.menuOptions.add(this.chboxMenuItemShowBackwardReplication);
        this.menuOptions.add(this.chboxMenuItemShowObjectsCount);
        this.add(this._clusterViewMenu);
        this.resetMenuToDefault();
        this.selectDefaultSpeedMenu();
    }

    public JMenu getMenu() {
        return this._clusterViewMenu;
    }

    public void resetMenuToDefault() {
        this.menuItemUpdateSpeedNormal.setSelected(true);
        this.menuItemShapeModeOval.setSelected(true);
        this.chboxMenuShowLegend.setSelected(true);
        this.chboxMenuItemShowBackwardReplication.setSelected(false);
        this.chboxMenuItemPingMode.setSelected(PING_MODE);
        this.menuItemZoomIn.setSelected(true);
    }

    public void setSelectedZoomIncreaseOption(boolean isSelected) {
        this.menuItemZoomIn.setSelected(isSelected);
    }

    public void selectDefaultSpeedMenu() {
        if (this.serviceManager.isPaused()) {
            this.menuItemUpdateSpeedPaused.setSelected(true);
            return;
        }
        switch (this.serviceManager.getUpdateSpeed()) {
            case 1000: {
                this.menuItemUpdateSpeedHigh.setSelected(true);
                break;
            }
            case 5000: {
                this.menuItemUpdateSpeedNormal.setSelected(true);
                break;
            }
            case 10000: {
                this.menuItemUpdateSpeedLow.setSelected(true);
                break;
            }
            default: {
                this.menuItemUpdateSpeedCustom.setSelected(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj.equals(this.menuItemRefresh)) {
            boolean state = this.m_owner.getServiceManager().isPaused();
            this.m_owner.getServiceManager().paused(false, false);
            try {
                this.m_owner.getServiceManager().awakeThread();
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_owner.getServiceManager().paused(state, false);
            return;
        }
        if (obj.equals(this.chboxMenuItemShowObjectsCount)) {
            SHOW_OBJECTS_COUNT = this.chboxMenuItemShowObjectsCount.isSelected();
            this.serviceManager.awakeThread();
            return;
        }
        if (obj.equals(this.chboxMenuItemShowBackwardReplication)) {
            SHOW_BACKWARD_REPLICATION = this.chboxMenuItemShowBackwardReplication.isSelected();
            EditCluster curEditCluster = this.m_owner.getCurEditCluster();
            if (curEditCluster != null) {
                String clusterName = curEditCluster.getClusterName();
                this.m_owner.getClusterTree(clusterName).performSelectedNodeAction();
            }
            return;
        }
        if (obj.equals(this.chboxMenuItemPingMode)) {
            PING_MODE = this.chboxMenuItemPingMode.isSelected();
            return;
        }
        if (obj.equals(this.menuItemUpdateSpeedHigh)) {
            this.serviceManager.setUpdateSpeed(1000);
            return;
        }
        if (obj.equals(this.menuItemUpdateSpeedNormal)) {
            this.serviceManager.setUpdateSpeed(5000);
            return;
        }
        if (obj.equals(this.menuItemUpdateSpeedLow)) {
            this.serviceManager.setUpdateSpeed(10000);
            return;
        }
        if (obj.equals(this.menuItemUpdateSpeedPaused)) {
            FREEZE_ALL_MEMBERS = this.menuItemUpdateSpeedPaused.isSelected();
            return;
        }
        if (obj.equals(this.menuItemUpdateSpeedCustom)) {
            block21: {
                String errorMessage = "Try to input only integer number, not negative.";
                String answer = JOptionPane.showInputDialog(this.m_owner.getParentFrame(), "Update speed in seconds: ", "Custom Update Speed", 1);
                if (answer != null) {
                    try {
                        int speed = Integer.parseInt(answer);
                        if (speed != Math.abs(speed)) {
                            JOptionPane.showMessageDialog(this.m_owner.getParentFrame(), errorMessage);
                            this.selectDefaultSpeedMenu();
                            break block21;
                        }
                        this.serviceManager.setUpdateSpeed(speed * 1000);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this.m_owner.getParentFrame(), errorMessage);
                        this.selectDefaultSpeedMenu();
                    }
                } else {
                    this.selectDefaultSpeedMenu();
                }
            }
            return;
        }
        if (obj.equals(this.menuItemShapeModeOval)) {
            this.m_owner.setOvalShapeMode(true);
            return;
        }
        if (obj.equals(this.menuItemShapeModeRect)) {
            this.m_owner.setOvalShapeMode(false);
            return;
        }
        if (obj.equals(this.menuItemZoomIn)) {
            this.m_owner.decreaseZoom();
            return;
        }
        if (obj.equals(this.menuItemZoomOut)) {
            this.m_owner.increaseZoom();
            return;
        }
    }

    static {
        _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");
    }
}

