/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ColumnSortListener
extends MouseAdapter {
    boolean ascending = false;
    private int _columnNumWithUniqueValues;

    public ColumnSortListener() {
        this(-1);
    }

    public ColumnSortListener(int columnNumWithUniqueValues) {
        this._columnNumWithUniqueValues = columnNumWithUniqueValues;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int selRow;
        JTableHeader header = (JTableHeader)e.getSource();
        JTable table = header.getTable();
        TableColumnModel colModel = table.getColumnModel();
        int colIndex = colModel.getColumnIndexAtX(e.getX());
        Object uniqueObjectValue = null;
        if (this._columnNumWithUniqueValues >= 0 && (selRow = table.getSelectedRow()) >= 0) {
            uniqueObjectValue = table.getValueAt(selRow, this._columnNumWithUniqueValues);
        }
        this.sortAllRowsBy((DefaultTableModel)table.getModel(), colIndex, this.ascending);
        if (uniqueObjectValue != null) {
            int rowCount = table.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                Object val = table.getValueAt(rowIndex, this._columnNumWithUniqueValues);
                if (!uniqueObjectValue.equals(val)) continue;
                table.setRowSelectionInterval(rowIndex, rowIndex);
                break;
            }
        }
        this.ascending = !this.ascending;
    }

    public void sortAllRowsBy(DefaultTableModel model, int colIndex, boolean ascending) {
        Vector<Vector> data = model.getDataVector();
        Collections.sort(data, new ColumnSorter(colIndex, ascending));
        model.fireTableStructureChanged();
    }

    public class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        public int compare(Object a, Object b) {
            Object o1 = ((Vector)a).get(this.colIndex);
            Object o2 = ((Vector)b).get(this.colIndex);
            if (o1 instanceof String && ((String)o1).length() == 0) {
                o1 = null;
            }
            if (o2 instanceof String && ((String)o2).length() == 0) {
                o2 = null;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return ((Comparable)o2).compareTo(o1);
            }
            if (this.ascending) {
                return o1.toString().compareTo(o2.toString());
            }
            return o2.toString().compareTo(o1.toString());
        }
    }
}

