/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.utils.concurrent.GSTimer;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.exception.SpaceStoppedException;
import com.j_spaces.kernel.IConsumerObject;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.WorkingGroup;
import com.j_spaces.tools.cluster.view.ClusterViewMenuBar;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.JConsoleUIUtils;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public abstract class GraphPanel
extends JComponent
implements Runnable,
MouseListener,
MouseMotionListener,
ActionListener {
    private static final String PROPERTY_STEP = "cluster.view.GraphPanel.step";
    protected Component parent;
    protected int nodeRadius;
    protected int nodeDistance;
    protected int edgeLength;
    protected int graphStep;
    int nnodes;
    protected ArrayList<Node> nodesList = new ArrayList(100);
    Image imgMember;
    BasicStroke strokeNormal = new BasicStroke(2.0f, 0, 1);
    BasicStroke strokeDotted = new BasicStroke(3.0f, 1, 1, 0.0f, new float[]{2.0f, 6.0f, 2.0f, 6.0f}, 0.0f);
    BasicStroke strokeBackward = new BasicStroke(1.0f, 0, 0);
    protected int nedges;
    protected ArrayList<Edge> edgesList = new ArrayList(100);
    Thread relaxer;
    boolean paused;
    boolean stress;
    boolean random;
    protected boolean isInvokeRelax = true;
    Node pick;
    Node source;
    boolean pickfixed;
    Image offscreen;
    Dimension offscreensize;
    Graphics2D offgraphics;
    final Color fixedColor = Color.red;
    final Color selectColor = Color.pink;
    final Color edgeColor = Color.black;
    final Color nodeColor = new Color(143, 143, 190);
    final Color stressColor = Color.darkGray;
    final Color arcColor1 = Color.black;
    final Color arcColor2 = Color.black;
    final Color arcColor3 = Color.black;
    protected final int rectWidthIncrement = 10;
    public static final int NODE_RADIUS_SMALL = 15;
    public static final int NODE_RADIUS_LARGE = 23;
    public static final int EDGE_LENGTH_SMALL = 80;
    public static final int EDGE_LENGTH_LARGE = 240;
    public static final Font FONT_SIZE_SMALL = new Font("Tahoma", 0, 9);
    public static final Font FONT_SIZE_LARGE = new Font("Tahoma", 0, 11);
    private Font curFont = FONT_SIZE_LARGE;
    private boolean _isOvalShapeMode = true;
    private JPopupMenu mirrorSpaceManagementPopupMenu;
    private JMenuItem mirrorConnectionsMenuItem;
    private JMenuItem selMirrorMemberNameMenuItem;
    private JMenuItem launchJConsoleForMirrorMenuItem;
    private JPopupMenu spaceManagementPopupMenu;
    private JMenuItem classesMenuItem;
    private JMenuItem transactionsMenuItem;
    private JMenuItem queryMenuItem;
    private JMenuItem statisticsMenuItem;
    private JMenuItem connectionsMenuItem;
    private JMenuItem benchmarkMenuItem;
    private JMenuItem selMemberNameMenuItem;
    private JMenuItem launchJConsoleMenuItem;
    private Node clickedNode;
    private static final int RELAX_DURATION = 5000;
    private final WorkingGroup<Node> _workingGroup;
    private String _calculatedJavaHome;
    private final JFrame _parentFrame;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");
    private Timer refreshTimer = null;

    public GraphPanel(JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.addMouseListener(this);
        this.graphStep = Integer.parseInt(System.getProperty(PROPERTY_STEP, "5"));
        this.initPopupMenu();
        this._workingGroup = new WorkingGroup((IConsumerObject)new CounterCalculatorConsumer(), 5, "UI-Cluster-RuntimeInfo-view", 1, 10, 15000L);
        this._workingGroup.start();
    }

    public void setGraphPanel(Component parent, int nodeRadius, int edgeLen) {
        block3: {
            try {
                this.parent = parent;
                this.nodeRadius = nodeRadius;
                this.nodeDistance = (int)((double)nodeRadius * 2.4);
                this.edgeLength = edgeLen;
                this.relaxer = new Thread(this);
            }
            catch (NumberFormatException ex) {
                this.graphStep = 5;
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    public void setSpaceIDToNode(ServiceID spaceID, String memberName) {
        for (Node node : this.nodesList) {
            if (!node.lbl.equals(memberName)) continue;
            node.setServiceID(spaceID);
            break;
        }
    }

    public abstract void paintNode(Graphics var1, Node var2, FontMetrics var3);

    public abstract void performNodeAction(Node var1);

    public void increaseZoom() {
        this.nodeRadius = 15;
        this.edgeLength = 240;
        this.curFont = FONT_SIZE_SMALL;
        this.updateEdgeLength(this.edgeLength);
        this.setRelaxAllowed();
    }

    public void decreaseZoom() {
        this.nodeRadius = 23;
        this.edgeLength = 80;
        this.curFont = FONT_SIZE_LARGE;
        this.updateEdgeLength(this.edgeLength);
        this.setRelaxAllowed();
    }

    protected void setRelaxAllowed() {
        this.isInvokeRelax = true;
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
        this.refreshTimer = new GSTimer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                GraphPanel.this.isInvokeRelax = false;
                GraphPanel.this.refreshTimer.cancel();
            }
        };
        long curTime = System.currentTimeMillis();
        this.refreshTimer.schedule(timerTask, new Date(curTime + 5000L));
    }

    public void reset() {
        this.nnodes = 0;
        this.nodesList = new ArrayList(100);
        this.nedges = 0;
        this.edgesList = new ArrayList(100);
        this.pick = null;
        this.source = null;
        this.spaceManagementPopupMenu.setVisible(false);
        this.mirrorSpaceManagementPopupMenu.setVisible(false);
    }

    private void updateEdgeLength(int edgeLen) {
        int listSize = this.edgesList.size();
        for (int i = 0; i < listSize; ++i) {
            this.edgesList.get((int)i).len = edgeLen;
        }
    }

    private void initPopupMenu() {
        this.spaceManagementPopupMenu = new JPopupMenu();
        this.selMemberNameMenuItem = new JMenuItem();
        this.classesMenuItem = new JMenuItem("Data Types");
        this.transactionsMenuItem = new JMenuItem("Transactions");
        this.queryMenuItem = new JMenuItem("Query");
        this.statisticsMenuItem = new JMenuItem("Statistics");
        this.connectionsMenuItem = new JMenuItem("Connections");
        this.spaceManagementPopupMenu.add(this.selMemberNameMenuItem);
        this.spaceManagementPopupMenu.addSeparator();
        this.spaceManagementPopupMenu.add(this.classesMenuItem);
        this.spaceManagementPopupMenu.add(this.transactionsMenuItem);
        this.spaceManagementPopupMenu.add(this.queryMenuItem);
        this.spaceManagementPopupMenu.add(this.statisticsMenuItem);
        this.spaceManagementPopupMenu.add(this.connectionsMenuItem);
        this.benchmarkMenuItem = new JMenuItem("Benchmark");
        this.benchmarkMenuItem.addActionListener(this);
        this.spaceManagementPopupMenu.add(this.benchmarkMenuItem);
        this.launchJConsoleMenuItem = new JMenuItem("Launch JConsole...");
        this._calculatedJavaHome = JConsoleUIUtils.manageJConsoleMenuItem(this._parentFrame, this.launchJConsoleMenuItem, "", true, _logger, false, false, this._parentFrame);
        this.launchJConsoleForMirrorMenuItem = new JMenuItem("Launch JConsole...");
        this._calculatedJavaHome = JConsoleUIUtils.manageJConsoleMenuItem(this._parentFrame, this.launchJConsoleForMirrorMenuItem, "", true, _logger, false, false, this._parentFrame);
        this.spaceManagementPopupMenu.addSeparator();
        this.spaceManagementPopupMenu.add(this.launchJConsoleMenuItem);
        Font curFont = this.selMemberNameMenuItem.getFont();
        this.selMemberNameMenuItem.setFont(curFont.deriveFont(1));
        this.selMemberNameMenuItem.addActionListener(this);
        this.classesMenuItem.addActionListener(this);
        this.transactionsMenuItem.addActionListener(this);
        this.queryMenuItem.addActionListener(this);
        this.statisticsMenuItem.addActionListener(this);
        this.connectionsMenuItem.addActionListener(this);
        this.launchJConsoleMenuItem.addActionListener(this);
        this.mirrorSpaceManagementPopupMenu = new JPopupMenu();
        this.selMirrorMemberNameMenuItem = new JMenuItem();
        this.mirrorConnectionsMenuItem = new JMenuItem("Connections");
        this.selMirrorMemberNameMenuItem.setFont(curFont.deriveFont(1));
        this.mirrorSpaceManagementPopupMenu.add(this.selMirrorMemberNameMenuItem);
        this.mirrorSpaceManagementPopupMenu.addSeparator();
        this.mirrorSpaceManagementPopupMenu.add(this.mirrorConnectionsMenuItem);
        this.mirrorSpaceManagementPopupMenu.addSeparator();
        this.mirrorSpaceManagementPopupMenu.add(this.launchJConsoleForMirrorMenuItem);
        this.launchJConsoleForMirrorMenuItem.addActionListener(this);
        this.selMirrorMemberNameMenuItem.addActionListener(this);
        this.mirrorConnectionsMenuItem.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block7: {
            String jndiURL;
            String jmxServiceURL;
            String[] commandArray;
            Object source = e.getSource();
            if (source == this.classesMenuItem || source == this.queryMenuItem || source == this.statisticsMenuItem || source == this.connectionsMenuItem || source == this.transactionsMenuItem || source == this.benchmarkMenuItem || source == this.mirrorConnectionsMenuItem) {
                SpaceBrowser.getInstance().selectSpaceOperationNode(this.clickedNode.getServiceID(), ((JMenuItem)source).getText());
            } else if (source == this.selMemberNameMenuItem || source == this.selMirrorMemberNameMenuItem) {
                SpaceBrowser.getInstance().selectSpaceOperationNode(this.clickedNode.getServiceID(), null);
            } else if ((source == this.launchJConsoleMenuItem || source == this.launchJConsoleForMirrorMenuItem) && (commandArray = JConsoleUIUtils.createJConsoleCommand(this._parentFrame, jmxServiceURL = JMXUtilities.createJMXUrl((String)(jndiURL = SpaceBrowser.getInstance().getJndiURL(this.clickedNode.getServiceID()))), this._calculatedJavaHome, true)) != null) {
                try {
                    Runtime.getRuntime().exec(commandArray);
                }
                catch (IOException ioe) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block7;
                    _logger.log(Level.SEVERE, ioe.toString(), ioe);
                }
            }
        }
    }

    private int findNodeByID(String nodeId) {
        for (int i = 0; i < this.nnodes; ++i) {
            if (!this.nodesList.get(i).getNodeId().equals(nodeId)) continue;
            return i;
        }
        String[] resultArray = JSpaceUIUtils.resolveClusterGuiId(nodeId);
        String clusterName = resultArray[0];
        String groupName = resultArray[1];
        String memberName = resultArray[2];
        return this.addNode(memberName, clusterName, groupName, null, false);
    }

    protected int addNode(String lbl, String clusterName, String clusterGroupName, ServiceID spaceID, boolean isMirror) {
        double x = 30.0 + 300.0 * Math.random();
        double y = 30.0 + 200.0 * Math.random();
        Node n = new Node(x, y, false, lbl, clusterName, clusterGroupName, spaceID, isMirror);
        this.nodesList.add(this.nnodes, n);
        return this.nnodes++;
    }

    void addEdge(String fromClusterNodeId, String toClusterNodeId, int len, boolean visible, boolean backward) {
        Edge e = new Edge();
        e.from = this.findNodeByID(fromClusterNodeId);
        e.to = this.findNodeByID(toClusterNodeId);
        e.len = len;
        e.visible = visible;
        e.setStatus(1);
        e.backwardRepl = backward;
        this.edgesList.add(this.nedges++, e);
        this.getNodebyId((String)toClusterNodeId).isTarget = true;
    }

    public synchronized void start() {
        if (!this.relaxer.isAlive()) {
            this.relaxer.start();
        }
        this.paused = false;
        this.notify();
    }

    public void stop() {
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread me = Thread.currentThread();
        while (this.relaxer == me) {
            this.relax();
            try {
                GraphPanel graphPanel = this;
                synchronized (graphPanel) {
                    this.wait(100L);
                }
                if (!this.paused) continue;
                graphPanel = this;
                synchronized (graphPanel) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    synchronized void relax() {
        double dy;
        double dx;
        double len;
        double vy;
        double vx;
        if (!this.isInvokeRelax) {
            return;
        }
        for (int i = 0; i < this.nedges; ++i) {
            Edge e = this.edgesList.get(i);
            Node toNode = this.nodesList.get(e.to);
            Node fromNode = this.nodesList.get(e.from);
            vx = toNode.x - fromNode.x;
            vy = toNode.y - fromNode.y;
            len = Math.sqrt(vx * vx + vy * vy);
            len = len == 0.0 ? 1.0E-4 : len;
            double f = (e.len - len) / (len * 3.0);
            dx = f * vx;
            dy = f * vy;
            toNode.dx += dx;
            toNode.dy += dy;
            fromNode.dx += -dx;
            fromNode.dy += -dy;
        }
        for (int i = 0; i < this.nnodes; ++i) {
            Node n1 = this.nodesList.get(i);
            dx = 0.0;
            dy = 0.0;
            for (int j = 0; j < this.nnodes; ++j) {
                if (i == j) continue;
                Node n2 = this.nodesList.get(j);
                vx = n1.x - n2.x;
                vy = n1.y - n2.y;
                len = vx * vx + vy * vy;
                if (len == 0.0) {
                    dx += Math.random();
                    dy += Math.random();
                    continue;
                }
                if (!(len < (double)(this.nodeDistance * this.nodeDistance))) continue;
                dx += vx / len;
                dy += vy / len;
            }
            double dlen = dx * dx + dy * dy;
            if (!(dlen > 0.0)) continue;
            dlen = Math.sqrt(dlen) / 2.0;
            n1.dx += dx / dlen;
            n1.dy += dy / dlen;
        }
        Dimension d = this.getSize();
        d.height -= this.nodeRadius + 12;
        d.width -= this.nodeRadius;
        int halfRadius = this.nodeRadius / 2;
        for (int i = 0; i < this.nnodes; ++i) {
            Node n = this.nodesList.get(i);
            if (!n.fixed && !ClusterViewMenuBar.FREEZE_ALL_MEMBERS) {
                n.x += Math.max((double)(-this.graphStep), Math.min((double)this.graphStep, n.dx));
                n.y += Math.max((double)(-this.graphStep), Math.min((double)this.graphStep, n.dy));
            }
            if (n.x < (double)halfRadius) {
                n.x = 0 + halfRadius;
            } else if (n.x > (double)d.width) {
                n.x = d.width;
            }
            if (n.y < (double)halfRadius) {
                n.y = 0 + halfRadius;
            } else if (n.y > (double)d.height) {
                n.y = d.height;
            }
            n.dx /= 2.0;
            n.dy /= 2.0;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offgraphics = (Graphics2D)this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
            this.offgraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.offgraphics.setColor(MembersLegend.getColor("Background"));
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        for (int i = 0; i < this.nedges; ++i) {
            Edge e = this.edgesList.get(i);
            Node fromNode = this.nodesList.get(e.from);
            Node toNode = this.nodesList.get(e.to);
            int x1 = (int)fromNode.x;
            int y1 = (int)fromNode.y;
            int x2 = (int)toNode.x;
            int y2 = (int)toNode.y;
            int len = (int)Math.abs(Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)) - e.len);
            if (e.backwardRepl) {
                this.offgraphics.setColor(Color.black);
                this.offgraphics.setStroke(this.strokeBackward);
            } else {
                this.offgraphics.setColor(MembersLegend.getColor(e.getStatus()));
                this.offgraphics.setStroke(this.strokeDotted);
            }
            this.offgraphics.drawLine(x1, y1, x2, y2);
        }
        FontMetrics fm = this.offgraphics.getFontMetrics();
        this.offgraphics.setStroke(this.strokeNormal);
        this.offgraphics.setFont(this.curFont);
        for (int i = 0; i < this.nnodes; ++i) {
            this.paintNode(this.offgraphics, this.nodesList.get(i), fm);
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public Node findNode(MouseEvent e) {
        Node node = null;
        double bestdist = Double.MAX_VALUE;
        int x = e.getX();
        int y = e.getY();
        for (int i = 0; i < this.nnodes; ++i) {
            Node n = this.nodesList.get(i);
            double dist = (n.x - (double)x) * (n.x - (double)x) + (n.y - (double)y) * (n.y - (double)y);
            if (!(dist < bestdist)) continue;
            node = n;
            bestdist = dist;
        }
        return node;
    }

    public Hashtable findEdges(Node source) {
        Hashtable<String, Edge> hash = new Hashtable<String, Edge>();
        int from = this.findNodeByID(source.getNodeId());
        for (int i = 0; i < this.nedges; ++i) {
            Edge edge = this.edgesList.get(i);
            if (edge == null || edge.from != from) continue;
            int to = edge.to;
            hash.put(this.nodesList.get((int)to).lbl, edge);
        }
        return hash;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.pick = this.findNode(e);
            int x = e.getX();
            int y = e.getY();
            this.pickfixed = this.pick.fixed;
            this.pick.x = x;
            this.pick.y = y;
            this.repaint();
            e.consume();
            this.performNodeAction(this.pick);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (SwingUtilities.isRightMouseButton(e)) {
            this.clickedNode = this.getClickedNode(e.getX(), e.getY());
            if (this.clickedNode != null && (this.clickedNode.status.equals("Alive") || this.clickedNode.status.equals("MirrorAlive")) && this.clickedNode.getServiceID() != null) {
                if (this.clickedNode.status.equals("MirrorAlive")) {
                    this.selMirrorMemberNameMenuItem.setText(this.clickedNode.lbl);
                    this.mirrorSpaceManagementPopupMenu.show(this, x, y);
                } else {
                    this.selMemberNameMenuItem.setText(this.clickedNode.lbl);
                    this.spaceManagementPopupMenu.show(this, x, y);
                }
            }
        } else {
            this.addMouseMotionListener(this);
            double bestdist = Double.MAX_VALUE;
            for (int i = 0; i < this.nnodes; ++i) {
                Node n = this.nodesList.get(i);
                double dist = (n.x - (double)x) * (n.x - (double)x) + (n.y - (double)y) * (n.y - (double)y);
                if (!(dist < bestdist)) continue;
                this.pick = n;
                bestdist = dist;
            }
            this.pickfixed = this.pick.fixed;
            this.pick.fixed = true;
            this.pick.x = x;
            this.pick.y = y;
            this.repaint();
            e.consume();
        }
    }

    private Node getClickedNode(int clickedX, int clickedY) {
        FontMetrics fm = this.offgraphics.getFontMetrics();
        for (Node node : this.nodesList) {
            int rectWidth;
            if (!(this._isOvalShapeMode ? (double)clickedX <= node.x + (double)this.nodeRadius / 2.0 && (double)clickedX >= node.x - (double)this.nodeRadius / 2.0 && (double)clickedY <= node.y + (double)this.nodeRadius / 2.0 && (double)clickedY >= node.y - (double)this.nodeRadius / 2.0 : (double)clickedX <= node.x + (double)(rectWidth = fm.stringWidth(node.lbl) + 10) / 2.0 && (double)clickedX >= node.x - (double)rectWidth / 2.0 && (double)clickedY <= node.y + (double)this.nodeRadius / 2.0 && (double)clickedY >= node.y - (double)this.nodeRadius / 2.0)) continue;
            return node;
        }
        return null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.removeMouseMotionListener(this);
        if (this.pick != null) {
            this.pick.x = e.getX();
            this.pick.y = e.getY();
            this.pick.fixed = this.pickfixed;
            this.pick = null;
        }
        this.repaint();
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pick != null) {
            this.pick.x = e.getX();
            this.pick.y = e.getY();
            this.repaint();
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public Node getNodebyId(String nodeId) {
        return this.nodesList.get(this.findNodeByID(nodeId));
    }

    public Node getNodeByIndex(int nodeIndex) {
        return this.nodesList.get(nodeIndex);
    }

    public void setOvalShapeMode(boolean isOvalShapeMode) {
        this._isOvalShapeMode = isOvalShapeMode;
        this.setRelaxAllowed();
    }

    public boolean isOvalShapeMode() {
        return this._isOvalShapeMode;
    }

    public static class CounterCalculatorConsumer
    implements IConsumerObject<Node> {
        public void cleanUp() {
        }

        public void dispatch(Node node) {
            String objectsCount;
            try {
                ServiceID serviceID = node.getServiceID();
                IRemoteJSpaceAdmin spaceAdminObject = SpaceBrowser.getInstance().getSpaceAdminObject(serviceID);
                ServiceItem spaceServiceItem = Repository.getInstance().getServiceItem(serviceID);
                IJSpace space = null;
                if (spaceServiceItem != null) {
                    space = (IJSpace)spaceServiceItem.service;
                }
                if (spaceAdminObject == null || space == null) {
                    objectsCount = "n/a";
                } else if (!JSpaceUIUtils.hasPermittedPermission((SecuredService)space, serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, space.isSecured())) {
                    objectsCount = "****";
                } else {
                    boolean isPersistentLRUSpace = SpaceBrowser.getInstance().isPersistentLRUSpace(node._serviceID);
                    boolean isMirrorService = SpaceBrowser.getInstance().isMirrorService(node._serviceID);
                    objectsCount = isMirrorService ? "" : (!SpaceBrowser.getInstance().isRetrieveRuntimeForPersistentLRUSpace() && isPersistentLRUSpace ? "n/a - Persistent LRU" : String.valueOf(JSpaceUtilities.countSpaceObjects((SpaceRuntimeInfo)spaceAdminObject.getRuntimeInfo())));
                }
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.WARNING) && !(ex instanceof SpaceStoppedException) && JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)ex, SpaceStoppedException.class) == null) {
                    _logger.log(Level.WARNING, ex.toString(), ex);
                }
                objectsCount = "n/a";
            }
            node.setObjectsCount(objectsCount);
        }
    }

    class Edge {
        int from;
        int to;
        double len;
        boolean backwardRepl;
        boolean visible;
        private int _status;

        public Edge(int from, int to, double len, boolean visible) {
            this.from = from;
            this.to = to;
            this.len = len;
            this.visible = visible;
            this._status = 1;
        }

        public Edge() {
        }

        public int getStatus() {
            return this._status;
        }

        public void setStatus(int status) {
            this._status = status;
        }
    }

    class Node {
        double x;
        double y;
        double dx;
        double dy;
        boolean fixed;
        boolean isTarget;
        String lbl;
        String token1;
        String token2;
        String status;
        String policies;
        private final String nodeId;
        private ServiceID _serviceID;
        private final boolean isMirror;
        private boolean _isPersistent;
        private String _objectsCount = "n/a";

        public Node(double x, double y, boolean fixed, String label, String clusterName, String clusterGroupName, ServiceID serviceID, boolean isMirror) {
            this.x = x;
            this.y = y;
            this.fixed = fixed;
            this.lbl = label;
            this.status = isMirror ? "MirrorUnreachable" : "Unreachable";
            this.policies = "";
            this.isMirror = isMirror;
            this.nodeId = JSpaceUIUtils.createClusterGuiId(clusterName, clusterGroupName, label);
            this._serviceID = serviceID;
            this.calculateCountObjects();
            try {
                StringTokenizer st = new StringTokenizer(label, ":");
                this.token1 = st.nextToken();
                this.token2 = st.hasMoreTokens() ? st.nextToken() : "";
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }

        public void calculateCountObjects() {
            if (!ClusterViewMenuBar.SHOW_OBJECTS_COUNT) {
                this._objectsCount = "";
                return;
            }
            if (this.status.equals("MirrorAlive") || this.status.equals("Alive")) {
                GraphPanel.this._workingGroup.enqueueBlocked((Object)this);
            } else {
                this._objectsCount = "n/a";
            }
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public ServiceID getServiceID() {
            return this._serviceID;
        }

        public void setServiceID(ServiceID spaceID) {
            this._serviceID = spaceID;
        }

        public boolean isMirror() {
            return this.isMirror;
        }

        public String getObjectsCount() {
            return this._objectsCount;
        }

        public void setObjectsCount(String objectsCount) {
            this._objectsCount = objectsCount;
        }
    }
}

