/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.cluster.GroupFailOverPanel;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.GroupLBPanel;
import com.j_spaces.tools.cluster.GroupReplicationPanel;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.MemberTransmissionPanel;
import com.j_spaces.tools.cluster.view.MembersGraphPanel;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.View;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.SoftBlueIceDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewMap;
import net.jini.core.lookup.ServiceID;

public class GroupPanel
extends JPanel {
    private ClusterViewDlg m_owner;
    private GroupInfo m_groupInfo;
    private MembersGraphPanel m_memGraphPanel;
    private MembersLegend m_legend;
    private JTabbedPane m_tabPanel;
    private GroupReplicationPanel m_replPanel;
    private MemberTransmissionPanel m_transmPanel;
    private GroupLBPanel m_lbPanel;
    private GroupFailOverPanel m_failOverPanel;
    private JTabbedPane replTabPanel;
    private boolean isSetLegendSplitSize;
    private ViewMap viewMap;
    private RootWindowProperties rootWindowProperties;
    private View bottomView;
    private View graphView;
    private View legendView;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public GroupPanel(ClusterViewDlg owner) {
        block2: {
            this.isSetLegendSplitSize = true;
            this.m_owner = owner;
            try {
                this.init();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    public void clearCurGroupInfo() {
        this.m_groupInfo = null;
    }

    public void setGroupInfo(GroupInfo group) {
        if (group != null && (this.m_groupInfo == null || this.m_groupInfo != group)) {
            this.m_groupInfo = group;
            this.m_memGraphPanel.init(this.m_groupInfo.groupMembers);
            this.m_transmPanel.init(this.m_groupInfo);
            this.m_replPanel.init(this.m_groupInfo);
            this.m_lbPanel.init(this.m_groupInfo.loadBalInfo, this.m_owner.getAllMembers());
            this.m_failOverPanel.init(this.m_groupInfo, this.m_owner.getAllGroups());
            this.m_tabPanel.setEnabledAt(0, this.m_groupInfo.repInfo != null);
            this.m_tabPanel.setEnabledAt(1, this.m_groupInfo.loadBalInfo != null);
            this.m_tabPanel.setEnabledAt(2, this.m_groupInfo.failOverInfo != null);
            this.m_tabPanel.setSelectedIndex(this.getEnabledTabIndex(this.m_tabPanel));
            if (this.isSetLegendSplitSize) {
                this.isSetLegendSplitSize = false;
            }
        }
    }

    public void setSpaceIDToNode(ServiceID spaceID, String memberName) {
        this.m_memGraphPanel.setSpaceIDToNode(spaceID, memberName);
    }

    public void setPanelEnabled(boolean enabled) {
        this.setComponentsEnabled(this.m_tabPanel, enabled);
    }

    private void setComponentsEnabled(Container container, boolean enabled) {
        if (container.equals(this.m_transmPanel)) {
            return;
        }
        int componentsCount = container.getComponentCount();
        for (int i = 0; i < componentsCount; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                this.setComponentsEnabled((Container)component, enabled);
            }
            if (!enabled && (component instanceof JLabel || component instanceof JTabbedPane || component instanceof JScrollPane || component instanceof JSplitPane)) continue;
            component.setEnabled(enabled);
        }
    }

    private void init() throws Exception {
        this.m_legend = new MembersLegend(this);
        this.replTabPanel = new JTabbedPane();
        this.m_tabPanel = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.m_memGraphPanel = new MembersGraphPanel(this.m_owner.getParentFrame(), this, null);
        this.m_transmPanel = new MemberTransmissionPanel(null);
        Dimension legendPanelSize = new Dimension(70, 250);
        this.m_legend.setPreferredSize(legendPanelSize);
        this.m_legend.setMaximumSize(legendPanelSize);
        this.m_legend.setMinimumSize(legendPanelSize);
        this.m_memGraphPanel.setPreferredSize(new Dimension(500, 600));
        Icon titleIcon = JSpaceUIUtils.getDockTitleIcon();
        this.graphView = new View("Graph View", titleIcon, (Component)this.m_memGraphPanel);
        this.legendView = new View("Legend", titleIcon, (Component)this.m_legend);
        this.m_replPanel = new GroupReplicationPanel(null, this.m_owner.getParentFrame(), null);
        this.replTabPanel.add("Table", this.m_transmPanel);
        this.replTabPanel.add("Settings", new JScrollPane(this.m_replPanel));
        this.m_lbPanel = new GroupLBPanel(true);
        this.m_failOverPanel = new GroupFailOverPanel(this.m_owner.getParentFrame(), null, this.m_owner.getAllGroups());
        this.m_tabPanel.add("Replication", this.replTabPanel);
        this.m_tabPanel.add("LoadBalancing", this.m_lbPanel);
        this.m_tabPanel.add("Fail Over", this.m_failOverPanel);
        JScrollPane bottomComponent = new JScrollPane(this.m_tabPanel);
        this.viewMap = new ViewMap();
        this.bottomView = new View("Table view", titleIcon, (Component)bottomComponent);
        this.viewMap.addView(0, this.bottomView);
        this.rootWindowProperties = new RootWindowProperties();
        SoftBlueIceDockingTheme currentTheme = new SoftBlueIceDockingTheme();
        this.rootWindowProperties.addSuperObject(currentTheme.getRootWindowProperties());
        this.rootWindowProperties.getDockingWindowProperties().setCloseEnabled(false);
        this.rootWindowProperties.getDockingWindowProperties().setMaximizeEnabled(true);
        this.initRootWindow();
        this.m_tabPanel.setEnabledAt(0, false);
        this.m_tabPanel.setEnabledAt(1, false);
        this.m_tabPanel.setEnabledAt(2, false);
        this.m_tabPanel.setSelectedIndex(this.getEnabledTabIndex(this.m_tabPanel));
    }

    public void resetView() {
        this.removeAll();
        this.initRootWindow();
    }

    private void initRootWindow() {
        SplitWindow topSplitWindow = new SplitWindow(true, 0.8f, (DockingWindow)this.graphView, (DockingWindow)this.legendView);
        RootWindow rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (boolean)false);
        rootWindow.getRootWindowProperties().addSuperObject(this.rootWindowProperties);
        rootWindow.setWindow((DockingWindow)new SplitWindow(false, 0.6f, (DockingWindow)topSplitWindow, (DockingWindow)this.bottomView));
        this.add((Component)rootWindow, "Center");
    }

    public void performActionOnMember(TreePath selPath, String memberName) {
        String clusterNodeId = JSpaceUIUtils.createClusterGuiId(selPath);
        this.m_memGraphPanel.performNodeAction(clusterNodeId);
        this.m_transmPanel.updateTransmTable(memberName);
    }

    protected void setRelaxAllowed() {
        this.m_memGraphPanel.setRelaxAllowed();
    }

    public void clearReplicationDetails() {
        this.m_memGraphPanel.clearEdgesList();
        this.getTrasmissionPanel().clearTransmDetails();
    }

    public boolean isReplicationGroup() {
        return this.m_groupInfo != null && this.m_groupInfo.repInfo != null;
    }

    public GroupInfo.ReplicationInfo getReplicationInfo() {
        return this.m_groupInfo.repInfo;
    }

    public MemberTransmissionPanel getTrasmissionPanel() {
        return this.m_transmPanel;
    }

    public IRefreshable getGraphPanel() {
        return this.m_memGraphPanel;
    }

    public void setOvalShapeMode(boolean isOvalShape) {
        this.m_memGraphPanel.setOvalShapeMode(isOvalShape);
    }

    public void increaseZoom() {
        this.m_memGraphPanel.increaseZoom();
    }

    public void decreaseZoom() {
        this.m_memGraphPanel.decreaseZoom();
    }

    public void setClusterTreeNode(String nodeId) {
        this.m_owner.setClusterTreeNode(nodeId);
    }

    private int getEnabledTabIndex(JTabbedPane tabbedPane) {
        int index = -1;
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            if (!tabbedPane.isEnabledAt(i)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.m_legend != null) {
            this.m_legend.repaint();
        }
    }

    public void addClusterMember(ClusterMemberInfo info) {
        this.m_memGraphPanel.addClusterMember(info);
        this.m_transmPanel.addClusterMember(info);
    }

    public void removeClusterMember() {
    }
}

