/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.gigaspaces.cluster.replication.ReplicationTransmissionPolicy;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ColumnHeaderToolTips;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.general.GSCheckBoxCellRenderer;
import com.j_spaces.tools.general.GSRegularCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class MemberTransmissionPanel
extends JPanel {
    private GroupInfo m_ownerGroup;
    private ClusterMemberInfo[] m_membersInfo;
    private String m_lastSelectedMemberName;
    private MemberTransmissionTableModel m_transmTableModel;
    private JTextField m_sourceMember;
    private JTable m_table;
    private JScrollPane _transmisTableScrollPane;
    private String[] m_columnLabels;
    private String[] m_columnToolTips;
    private Font m_columnFont;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public MemberTransmissionPanel(GroupInfo group) {
        block4: {
            this.m_sourceMember = new JTextField();
            this.m_columnLabels = new String[]{"Enable", "Target Member", "Take", "Write", "Notify", "Sync on Commit"};
            this.m_columnToolTips = new String[]{"Enable/Disable Transmission", "Where a source member will be transmit operations", "Take operation", "Write operation", "Notify operation", "Sync on commit"};
            this.m_ownerGroup = group;
            if (group != null) {
                this.m_membersInfo = group.groupMembers;
            }
            try {
                this.init();
                if (group != null) {
                    this.init(group);
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    public void init(GroupInfo group) {
        this.m_ownerGroup = group;
        if (group != null) {
            this.m_membersInfo = group.groupMembers;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_columnFont == null) {
            this.m_columnFont = this.m_table.getFont();
            this.m_table.getTableHeader().setFont(this.m_columnFont);
            FontMetrics fm = g.getFontMetrics(this.m_columnFont);
            int width = 0;
            for (int c = 0; c < this.m_table.getColumnCount(); ++c) {
                TableColumn col = this.m_table.getColumnModel().getColumn(c);
                width = fm.stringWidth(this.m_columnLabels[c]);
                if (c == 1) {
                    width += 30;
                }
                col.setPreferredWidth(width);
            }
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.m_sourceMember.setEditable(false);
        this.m_sourceMember.setFont(new Font("Arial", 1, 12));
        this.m_transmTableModel = new MemberTransmissionTableModel();
        this.m_table = new JTable(this.m_transmTableModel);
        this.m_table.setSelectionMode(0);
        this.m_table.setAutoscrolls(true);
        this.m_table.setAutoCreateColumnsFromModel(false);
        this.m_table.setRowHeight(this.m_table.getRowHeight() + 2);
        this.add((Component)this.m_sourceMember, "North");
        this.add((Component)new JScrollPane(this.m_table), "Center");
        JTableHeader header = this.m_table.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        for (int c = 0; c < this.m_table.getColumnCount(); ++c) {
            TableColumn col = this.m_table.getColumnModel().getColumn(c);
            tips.setToolTip(col, this.m_columnToolTips[c]);
            if (c != 1) {
                col.setCellRenderer(new GSCheckBoxCellRenderer());
                continue;
            }
            col.setCellRenderer(new GSRegularCellRenderer());
        }
        header.addMouseMotionListener(tips);
        header.addMouseListener(new ColumnSortListener());
    }

    private ClusterMemberInfo getMemberInfo(String memberName) {
        for (int i = 0; i < this.m_membersInfo.length; ++i) {
            if (!this.m_membersInfo[i].memberName.equals(memberName)) continue;
            return this.m_membersInfo[i];
        }
        return null;
    }

    public void updateTransmTable(String memberName) {
        ClusterMemberInfo info = this.getMemberInfo(memberName);
        if (info != null && this.m_ownerGroup.repInfo != null) {
            this.m_transmTableModel.updateMemberInfo(info);
            this.m_table.validate();
            this.m_table.repaint();
            this.m_lastSelectedMemberName = memberName;
            this.m_sourceMember.setText("Source member: " + memberName);
        }
    }

    public void clearTransmDetails() {
        this.m_transmTableModel.clear();
        this.m_sourceMember.setText("");
    }

    public void addClusterMember(ClusterMemberInfo info) {
        ClusterMemberInfo[] membersInfo = new ClusterMemberInfo[this.m_membersInfo.length + 1];
        for (int i = 0; i < this.m_membersInfo.length; ++i) {
            membersInfo[i] = this.m_membersInfo[i];
        }
        membersInfo[i] = info;
        this.m_membersInfo = membersInfo;
        this.updateTransmTable(info.memberName);
    }

    class MemberTransmissionTableModel
    extends DefaultTableModel {
        public MemberTransmissionTableModel() {
            for (int i = 0; i < MemberTransmissionPanel.this.m_columnLabels.length; ++i) {
                this.addColumn(MemberTransmissionPanel.this.m_columnLabels[i]);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            Vector v = (Vector)this.dataVector.elementAt(0);
            return v.elementAt(columnIndex).getClass();
        }

        public void clear() {
            int rowCount = this.getRowCount();
            this.dataVector.clear();
            if (rowCount > 0) {
                this.fireTableRowsDeleted(0, rowCount);
            }
        }

        public void updateMemberInfo(ClusterMemberInfo member) {
            Boolean operT = Boolean.FALSE;
            Boolean operW = Boolean.FALSE;
            Boolean operN = Boolean.FALSE;
            ArrayList<String> usedMembers = new ArrayList<String>();
            int rowCount = this.dataVector.size();
            this.dataVector.clear();
            if (!member.isMirror()) {
                if (member.m_replTransmissionPolicies != null && member.m_replTransmissionPolicies.size() > 0) {
                    for (ReplicationTransmissionPolicy replPol : member.m_replTransmissionPolicies) {
                        operT = replPol.m_RepTransmissionOperations.indexOf(84) != -1 ? Boolean.TRUE : Boolean.FALSE;
                        operW = replPol.m_RepTransmissionOperations.indexOf(87) != -1 ? Boolean.TRUE : Boolean.FALSE;
                        operN = replPol.m_RepTransmissionOperations.indexOf(78) != -1 ? Boolean.TRUE : Boolean.FALSE;
                        this.addRow(new Object[]{!replPol.m_DisableTransmission, replPol.m_TargetSpace, operT, operW, operN, replPol.m_SyncOnCommit});
                        usedMembers.add(replPol.m_TargetSpace);
                    }
                    for (int i = 0; i < MemberTransmissionPanel.this.m_membersInfo.length; ++i) {
                        if (usedMembers.contains(((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i].memberName) || ((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i].memberName.equals(member.memberName)) continue;
                        this.addRow(new Object[]{Boolean.TRUE, ((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i].memberName, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
                    }
                } else {
                    for (int i = 0; i < MemberTransmissionPanel.this.m_membersInfo.length; ++i) {
                        if (((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i].memberName.equals(member.memberName)) continue;
                        this.addRow(new Object[]{Boolean.TRUE, ((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i].memberName, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE});
                    }
                }
            } else if (rowCount > 0) {
                this.fireTableRowsDeleted(0, rowCount - 1);
            }
        }
    }
}

