/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.gigaspaces.cluster.replication.ReplicationTransmissionPolicy;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.cluster.view.ClusterViewMenuBar;
import com.j_spaces.tools.cluster.view.GraphPanel;
import com.j_spaces.tools.cluster.view.GroupPanel;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class MembersGraphPanel
extends GraphPanel
implements IRefreshable {
    private GroupPanel m_owner;
    private ClusterMemberInfo[] m_membersInfo;
    private char[] m_memberType = new char[]{' '};
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");
    private Font boldFont;

    public MembersGraphPanel(JFrame parentFrame, Component parent, ClusterMemberInfo[] members) {
        super(parentFrame);
        this.setGraphPanel(parent, 23, 80);
        this.setFont(new Font("Tahoma", 0, 11));
        this.m_owner = (GroupPanel)parent;
        this.init(members);
    }

    public void init(ClusterMemberInfo[] members) {
        if (members != null && this.m_membersInfo != members) {
            this.m_membersInfo = members;
            this.clearTransmTable();
            this.reset();
            for (ClusterMemberInfo clusterMemberInfo : this.m_membersInfo) {
                this.addNode(clusterMemberInfo.memberName, clusterMemberInfo.getClusterName(), clusterMemberInfo.getGroupName(), clusterMemberInfo.getSpaceID(), clusterMemberInfo.isMirror());
            }
        }
    }

    @Override
    public void paintNode(Graphics g, GraphPanel.Node n, FontMetrics fm) {
        if (this.isOvalShapeMode()) {
            this.paintOvalNode(g, n, fm);
        } else {
            this.paintRectNode(g, n, fm);
        }
    }

    private void paintOvalNode(Graphics g, GraphPanel.Node n, FontMetrics fm) {
        int x = (int)n.x;
        int y = (int)n.y;
        int w = this.nodeRadius;
        int h = this.nodeRadius;
        g.setColor(MembersLegend.getColor(n.status));
        g.fillOval(x - w / 2, y - h / 2, w, h);
        if (n.equals(this.source)) {
            g.setColor(MembersLegend.getColor("Source"));
            g.drawOval(x - w / 2, y - h / 2, w - 1, h - 1);
        } else if (n.isTarget) {
            g.setColor(MembersLegend.getColor("Target"));
            g.drawOval(x - w / 2, y - h / 2, w - 1, h - 1);
        }
        g.setColor(Color.black);
        g.drawString(n.token1, x - fm.stringWidth(n.token1) / 2, y + (h + 4) / 2 + fm.getAscent());
        g.drawString(n.token2, x - fm.stringWidth(n.token2) / 2, y + (h + 4) / 2 + fm.getAscent() * 2);
        if (ClusterViewMenuBar.SHOW_OBJECTS_COUNT) {
            Font curFont = g.getFont();
            if (this.boldFont == null) {
                this.boldFont = new Font(curFont.getName(), 1, curFont.getSize() - 1);
            }
            g.setFont(this.boldFont);
            if (n.getObjectsCount().length() > 0) {
                g.drawString(n.getObjectsCount(), x - fm.stringWidth(n.getObjectsCount()) / 2, y + (h + 4) / 2 + fm.getAscent() * 3);
            }
            g.setFont(curFont);
        }
        if (n.status.equals("Alive") || n.status.equals("MirrorAlive")) {
            g.drawChars(this.m_memberType, 0, 1, x - w / 7, y + h / 5);
        }
    }

    private void paintRectNode(Graphics g, GraphPanel.Node n, FontMetrics fm) {
        int x = (int)n.x;
        int y = (int)n.y;
        int w = fm.stringWidth(n.lbl) + 10;
        int h = this.nodeRadius + (int)((double)fm.getAscent() / 1.2);
        g.setColor(MembersLegend.getColor(ServiceManagerImpl.getMemberStatus(n.lbl, n.isMirror())));
        g.fillRect(x - w / 2, y - h / 2, w, h);
        if (n.equals(this.source)) {
            g.setColor(MembersLegend.getColor("Source"));
            g.drawRect(x - w / 2, y - h / 2, w - 1, h - 1);
        } else if (n.isTarget) {
            g.setColor(MembersLegend.getColor("Target"));
            g.drawRect(x - w / 2, y - h / 2, w - 1, h - 1);
        }
        g.setColor(Color.black);
        g.drawString(n.lbl, x - (w - 10) / 2, y - (h - 4) / 2 + fm.getAscent());
        if (ClusterViewMenuBar.SHOW_OBJECTS_COUNT) {
            Font curFont = g.getFont();
            g.setFont(new Font(curFont.getName(), 1, curFont.getSize() - 1));
            if (n.getObjectsCount().length() > 0) {
                g.drawString(n.getObjectsCount(), x - fm.stringWidth(n.getObjectsCount()) / 2, y - (h - 4) / 2 + fm.getAscent() * 2);
            }
            g.setFont(curFont);
        }
    }

    public void clearEdgesList() {
        this.edgesList.clear();
        this.nedges = 0;
        this.source = null;
        int nodesListSize = this.nodesList.size();
        for (int i = 0; i < nodesListSize; ++i) {
            ((GraphPanel.Node)this.nodesList.get((int)i)).isTarget = false;
        }
    }

    public void performNodeAction(String clusterNodeId) {
        this.performNodeAction(this.getNodebyId(clusterNodeId));
    }

    @Override
    public void performNodeAction(GraphPanel.Node node) {
        this.setRelaxAllowed();
        if (!this.m_owner.isReplicationGroup()) {
            return;
        }
        this.m_owner.setClusterTreeNode(node.getNodeId());
        this.m_owner.getTrasmissionPanel().updateTransmTable(node.lbl);
        this.source = node;
        this.pick = null;
        this.nedges = 0;
        this.edgesList = new ArrayList(100);
        for (int i = 0; i < this.nnodes; ++i) {
            ((GraphPanel.Node)this.nodesList.get((int)i)).isTarget = false;
        }
        ClusterMemberInfo selectedMemberInfo = this.getMemberInfo(node.lbl);
        if (selectedMemberInfo == null) {
            return;
        }
        ArrayList targets = this.checkForTargets(selectedMemberInfo, this.m_membersInfo);
        String clusterName = selectedMemberInfo.getClusterName();
        String groupName = selectedMemberInfo.getGroupName();
        if (!node.isMirror()) {
            if (targets != null && targets.size() > 0) {
                int targetsSize = targets.size();
                for (int i = 0; i < targetsSize; ++i) {
                    String fromClusterNodeId = JSpaceUIUtils.createClusterGuiId(clusterName, groupName, selectedMemberInfo.memberName);
                    String toClusterNodeId = JSpaceUIUtils.createClusterGuiId(clusterName, groupName, (String)targets.get(i));
                    this.addEdge(fromClusterNodeId, toClusterNodeId, this.edgeLength, true, false);
                }
            }
            if (ClusterViewMenuBar.SHOW_BACKWARD_REPLICATION) {
                for (int i = 0; i < this.m_membersInfo.length; ++i) {
                    targets = this.checkForTargets(this.m_membersInfo[i], new ClusterMemberInfo[]{selectedMemberInfo});
                    if (targets == null || targets.size() != 1) continue;
                    String fromClusterNodeId = JSpaceUIUtils.createClusterGuiId(clusterName, groupName, this.m_membersInfo[i].memberName);
                    String toClusterNodeId = JSpaceUIUtils.createClusterGuiId(clusterName, groupName, selectedMemberInfo.memberName);
                    this.addEdge(fromClusterNodeId, toClusterNodeId, this.edgeLength, true, true);
                }
            }
        }
        this.refresh();
    }

    public void clearTransmTable() {
        this.m_owner.getTrasmissionPanel().clearTransmDetails();
    }

    private ArrayList checkForTargets(ClusterMemberInfo selectedMemberInfo, ClusterMemberInfo[] membersInfo) {
        Hashtable<String, ReplicationTransmissionPolicy> replPolicies = new Hashtable<String, ReplicationTransmissionPolicy>();
        ArrayList<String> targets = new ArrayList<String>();
        if (selectedMemberInfo != null && selectedMemberInfo.m_replTransmissionPolicies != null && selectedMemberInfo.m_replTransmissionPolicies.size() > 0) {
            for (ReplicationTransmissionPolicy replPol : selectedMemberInfo.m_replTransmissionPolicies) {
                replPolicies.put(replPol.m_TargetSpace, replPol);
            }
            for (int i = 0; i < membersInfo.length; ++i) {
                ReplicationTransmissionPolicy replPol;
                replPol = null;
                if (membersInfo[i].memberName.equals(selectedMemberInfo.memberName)) continue;
                if (replPolicies.containsKey(membersInfo[i].memberName)) {
                    replPol = (ReplicationTransmissionPolicy)replPolicies.get(membersInfo[i].memberName);
                    if (replPol.m_DisableTransmission) continue;
                    targets.add(replPol.m_TargetSpace);
                    continue;
                }
                targets.add(membersInfo[i].memberName);
            }
        } else {
            for (int i = 0; i < membersInfo.length; ++i) {
                targets.add(membersInfo[i].memberName);
            }
        }
        return targets;
    }

    @Override
    public boolean isRunning() {
        return !this.paused;
    }

    @Override
    public void refresh() {
        block8: {
            for (int i = 0; i < this.nnodes; ++i) {
                GraphPanel.Node node = (GraphPanel.Node)this.nodesList.get(i);
                node.status = ServiceManagerImpl.getMemberStatus(node.lbl, node.isMirror());
                node.calculateCountObjects();
            }
            if (this.source != null) {
                try {
                    ServiceManagerImpl.ReplicationStatus rstatus = ServiceManagerImpl.getReplicationStatus(this.source.lbl);
                    Hashtable edgesHashtable = this.findEdges(this.source);
                    if (rstatus != null) {
                        for (int i = 0; i < rstatus.targets.length; ++i) {
                            GraphPanel.Edge e = (GraphPanel.Edge)edgesHashtable.get(rstatus.targets[i]);
                            if (e == null) continue;
                            e.setStatus(rstatus.tstatus[i]);
                        }
                    } else {
                        Enumeration enum_ = edgesHashtable.elements();
                        while (enum_.hasMoreElements()) {
                            ((GraphPanel.Edge)enum_.nextElement()).setStatus(1);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block8;
                    _logger.log(Level.SEVERE, ex.toString(), ex);
                }
            }
        }
    }

    private ClusterMemberInfo getMemberInfo(String memberName) {
        for (int i = 0; i < this.m_membersInfo.length; ++i) {
            if (!this.m_membersInfo[i].memberName.equals(memberName)) continue;
            return this.m_membersInfo[i];
        }
        return null;
    }

    public void addClusterMember(ClusterMemberInfo info) {
        ClusterMemberInfo[] membersInfo = new ClusterMemberInfo[this.m_membersInfo.length + 1];
        for (int i = 0; i < this.m_membersInfo.length; ++i) {
            membersInfo[i] = this.m_membersInfo[i];
        }
        membersInfo[i] = info;
        this.m_membersInfo = membersInfo;
        int nodeIndex = this.addNode(info.memberName, info.getClusterName(), info.getGroupName(), info.getSpaceID(), info.isMirror());
        this.performNodeAction(this.getNodeByIndex(nodeIndex));
    }

    public void removeClusterMember() {
    }

    @Override
    public void setInvokeRefresh(boolean invokeRefresh) {
    }
}

