/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.tools.cluster.view.GroupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class MembersLegend
extends JPanel {
    public static final String MEMBER_UNREACHABLE = "Unreachable";
    public static final String MEMBER_ALIVE = "Alive";
    public static final String MEMBER_SOURCE = "Source";
    public static final String MEMBER_TARGET = "Target";
    public static final String MEMBER_MIRROR_ALIVE = "MirrorAlive";
    public static final String MEMBER_MIRROR_UNREACHABLE = "MirrorUnreachable";
    public static final String REPLICATION_STATUS_ACTIVE = "Active";
    public static final String REPLICATION_STATUS_DISCONNECTED = "Disconnected";
    public static final String REPLICATION_STATUS_DISABLED = "Disabled";
    public static final String BACKGROUND_COLOR = "Background";
    protected static final Map<String, Color> dataHash = new HashMap<String, Color>();
    protected static final Object[][] data = new Object[][]{{null, "5"}, {"Member:", null}, {"Unreachable", Color.gray}, {"Alive", Color.green}, {"Source", Color.white}, {"Target", Color.black}, {null, "5"}, {"Replication:", null}, {"Active", Color.green}, {"Disconnected", Color.red}, {"Disabled", Color.white}, {null, "10"}, {"Background", SystemColor.control}, {"MirrorAlive", Color.yellow}, {"MirrorUnreachable", new Color(0, 153, 153)}};
    private GroupPanel owner;

    public MembersLegend(GroupPanel owner) {
        this.owner = owner;
        this.setBorder(new TitledBorder("Legend"));
        this.setLayout(new GridBagLayout());
        int gridx = 0;
        int gridy = 0;
        int anchor = 17;
        int fill = 0;
        Insets insets = null;
        Font font = new Font("Tahoma", 0, 10);
        Font fontBold = new Font("Tahoma", 1, 10);
        Border lineBorder = BorderFactory.createLineBorder(Color.black);
        for (int i = 0; i < data.length; ++i) {
            String label = (String)data[i][0];
            Color value = null;
            if (label == null) {
                int distance = Integer.parseInt((String)data[i][1]);
                label = "";
                insets = new Insets(distance, 2, distance, 2);
            } else {
                insets = new Insets(2, 2, 2, 2);
                value = (Color)data[i][1];
            }
            JLabel lbl = new JLabel();
            lbl.setFont(value == null ? fontBold : font);
            lbl.setText(label);
            this.add((Component)lbl, new GridBagConstraints(gridx++, gridy, 1, 1, 1.0, 0.0, anchor, fill, insets, 0, 0));
            if (value != null) {
                dataHash.put(label, value);
                this.add((Component)new JLabel("-"), new GridBagConstraints(gridx++, gridy, 1, 1, 1.0, 0.0, anchor, fill, insets, 0, 0));
                JPanel color = new JPanel();
                color.setBackground(value);
                color.setBorder(lineBorder);
                color.setToolTipText("Set custom color");
                color.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        MembersLegend.this.setCustomColor(e);
                    }
                });
                color.setName(label);
                this.add((Component)color, new GridBagConstraints(gridx, gridy, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
            }
            gridx = 0;
            ++gridy;
        }
    }

    public static Color getColor(String status) {
        return dataHash.get(status);
    }

    public static Color getColor(int status) {
        Color res = null;
        switch (status) {
            case 0: {
                res = MembersLegend.getColor(REPLICATION_STATUS_ACTIVE);
                break;
            }
            case 2: {
                MembersLegend.getColor(REPLICATION_STATUS_DISABLED);
                break;
            }
            case 1: {
                res = MembersLegend.getColor(REPLICATION_STATUS_DISCONNECTED);
            }
        }
        return res;
    }

    private void setCustomColor(MouseEvent e) {
        JPanel panel = (JPanel)e.getSource();
        Color selectedColor = JColorChooser.showDialog(panel, "Set color for <" + panel.getName() + ">", panel.getBackground());
        if (selectedColor != null) {
            panel.setBackground(selectedColor);
            dataHash.put(panel.getName(), selectedColor);
            ((JComponent)((Object)this.owner.getGraphPanel())).repaint();
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (c == null || !(c instanceof JPanel) || !dataHash.containsKey(c.getName())) continue;
            c.setBackground(dataHash.get(c.getName()));
        }
    }
}

