/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.tools.PrimaryBackupIndicationListener;
import com.j_spaces.tools.cluster.view.MembersLegend;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceID;

public class MembersTable
extends JPanel {
    private MembersTableModel m_tableModel;
    private JTable m_table;
    private JPopupMenu popupMenu;
    private JMenuItem copyMemberURLItem;
    private final int CI_MEMBER_NAME = 0;
    private final int CI_MEMBER_URL = 1;
    private final int CI_PRIMARY_BACKUP_INDICATION = 2;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public MembersTable() {
        block2: {
            this.CI_MEMBER_NAME = 0;
            this.CI_MEMBER_URL = 1;
            this.CI_PRIMARY_BACKUP_INDICATION = 2;
            try {
                this.m_tableModel = new MembersTableModel();
                this.m_tableModel.addColumn("Name");
                this.m_tableModel.addColumn("URL");
                this.m_tableModel.addColumn("Primary");
                this.m_table = new JTable(this.m_tableModel){

                    @Override
                    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            jc.setToolTipText((String)this.getValueAt(rowIndex, vColIndex));
                        }
                        return c;
                    }
                };
                JTableHeader header = this.m_table.getTableHeader();
                header.addMouseListener(new TableColumnSortListener(this.m_table, this.m_tableModel));
                header.setFont(new Font("Tahoma", 1, 12));
                this.m_table.setAutoCreateColumnsFromModel(false);
                this.m_table.setSelectionMode(0);
                this.m_table.setShowHorizontalLines(false);
                this.m_table.setAutoResizeMode(4);
                this.m_table.setAutoscrolls(true);
                TableColumnModel columnModel = this.m_table.getColumnModel();
                columnModel.getColumn(0).setCellRenderer(new CustomTableCellRenderer());
                columnModel.getColumn(2).setPreferredWidth(65);
                columnModel.getColumn(2).setMaxWidth(65);
                columnModel.getColumn(2).setMinWidth(65);
                this.handleTablePopupEventsAndMenu();
                this.setBorder(new TitledBorder("Members"));
                this.setLayout(new BorderLayout());
                this.add((Component)new JScrollPane(this.m_table), "Center");
                this.setPreferredSize(new Dimension(100, 150));
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    public void setMembers(ClusterMemberInfo[] members) {
        this.m_tableModel.setMembers(members);
    }

    private void handleTablePopupEventsAndMenu() {
        this.createPopupMenu();
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int clickedRow;
                if (SwingUtilities.isRightMouseButton(e) && (clickedRow = MembersTable.this.m_table.rowAtPoint(e.getPoint())) >= 0) {
                    MembersTable.this.m_table.setRowSelectionInterval(clickedRow, clickedRow);
                    int x = e.getX();
                    int y = e.getY();
                    MembersTable.this.popupMenu.show(e.getComponent(), x, y);
                }
            }
        });
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.copyMemberURLItem = new JMenuItem("Copy URL");
        this.popupMenu.add(this.copyMemberURLItem);
        this.copyMemberURLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String desiredURL = MembersTable.this.m_table.getValueAt(MembersTable.this.m_table.getSelectedRow(), 1).toString();
                StringSelection ss = new StringSelection(desiredURL);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
            }
        });
    }

    public int getRowsCount() {
        return this.m_table.getRowCount();
    }

    public int getAliveClusterMembersCount() {
        return ServiceManagerImpl.getAliveClusterMembersCount();
    }

    private class TableColumnSortListener
    extends MouseAdapter {
        private boolean _ascending = false;
        private int _sortedColumnIndex = -1;
        private JTable _table;
        private MembersTableModel _tableModel;
        private TableColumnModel _columnModel;

        public TableColumnSortListener(JTable table, MembersTableModel tableModel) {
            this._table = table;
            this._tableModel = tableModel;
            this._columnModel = this._table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this._sortedColumnIndex = this._columnModel.getColumnIndexAtX(e.getX());
            this.sortAllRowsBy(this._sortedColumnIndex, this._ascending);
            this._ascending = !this._ascending;
        }

        private void sortAllRowsBy(int colIndex, boolean ascending) {
            int selRow = this._table.getSelectedRow();
            ClusterMemberInfo selClusterMemberInfo = null;
            if (selRow >= 0) {
                selClusterMemberInfo = this._tableModel.getClusterMember(selRow);
            }
            Collections.sort(this._tableModel.getClusterMemberInfoList(), new ColumnSorter(colIndex, ascending));
            this._tableModel.fireTableStructureChanged();
            this.selectTableRow(selClusterMemberInfo);
        }

        protected void sortAllRows() {
            if (this._sortedColumnIndex >= 0) {
                this.sortAllRowsBy(this._sortedColumnIndex, !this._ascending);
            }
        }

        private void selectTableRow(ClusterMemberInfo selClusterMemberInfo) {
            int wrapperIndex;
            if (selClusterMemberInfo != null && (wrapperIndex = this._tableModel.getClusterMemberIndex(selClusterMemberInfo)) != -1) {
                this._table.setRowSelectionInterval(wrapperIndex, wrapperIndex);
            }
        }

        private class ColumnSorter
        implements Comparator {
            private int colIndex;
            private boolean ascending;

            public ColumnSorter(int colIndex, boolean ascending) {
                this.colIndex = colIndex;
                this.ascending = ascending;
            }

            public int compare(Object a, Object b) {
                ClusterMemberInfo clusterMemberInfo1 = (ClusterMemberInfo)a;
                ClusterMemberInfo clusterMemberInfo2 = (ClusterMemberInfo)b;
                String obj1 = TableColumnSortListener.this._tableModel.getCellValue(clusterMemberInfo1, this.colIndex);
                String obj2 = TableColumnSortListener.this._tableModel.getCellValue(clusterMemberInfo2, this.colIndex);
                if (this.ascending) {
                    return obj1.compareTo(obj2);
                }
                return obj2.compareTo(obj1);
            }
        }
    }

    class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ClusterMemberInfo clusterMemberInfo = MembersTable.this.m_tableModel.getClusterMember(row);
            boolean isMirror = false;
            if (clusterMemberInfo != null) {
                isMirror = clusterMemberInfo.isMirror();
            }
            this.setForeground(MembersLegend.getColor(ServiceManagerImpl.getMemberStatus(value.toString(), isMirror)));
            return this;
        }
    }

    class MembersTableModel
    extends DefaultTableModel {
        private List<ClusterMemberInfo> _membersList = new ArrayList<ClusterMemberInfo>(0);

        MembersTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void clear() {
            int rowCount = this._membersList.size();
            if (rowCount > 0) {
                this._membersList.clear();
                this.fireTableRowsDeleted(0, rowCount);
            }
        }

        public void setMembers(ClusterMemberInfo[] membersArray) {
            this.clear();
            for (ClusterMemberInfo clusterMemberInfo : membersArray) {
                this._membersList.add(clusterMemberInfo);
            }
            this.fireTableRowsInserted(0, this._membersList.size() - 1);
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this._membersList.size() && row >= 0) {
                ClusterMemberInfo clusterMemberInfo = this._membersList.get(row);
                switch (column) {
                    case 0: {
                        return clusterMemberInfo.memberName;
                    }
                    case 1: {
                        return clusterMemberInfo.memberURL.getURL();
                    }
                    case 2: {
                        ServiceID spaceID = clusterMemberInfo.getSpaceID();
                        SpaceMode spaceMode = PrimaryBackupIndicationListener.getInstance().getSpaceMode(spaceID);
                        if (spaceMode == null) {
                            return "-";
                        }
                        boolean isMirror = false;
                        if (clusterMemberInfo != null) {
                            isMirror = clusterMemberInfo.isMirror();
                        }
                        String status = ServiceManagerImpl.getMemberStatus(clusterMemberInfo.memberName, isMirror);
                        return spaceMode.equals((Object)SpaceMode.PRIMARY) ? "Yes" : "No";
                    }
                }
            }
            return null;
        }

        private String getPrimaryBackupIndication(ClusterMemberInfo clusterMemberInfo) {
            ServiceID spaceID = clusterMemberInfo.getSpaceID();
            SpaceMode spaceMode = PrimaryBackupIndicationListener.getInstance().getSpaceMode(spaceID);
            if (spaceMode == null) {
                return "-";
            }
            boolean isMirror = false;
            if (clusterMemberInfo != null) {
                isMirror = clusterMemberInfo.isMirror();
            }
            String status = ServiceManagerImpl.getMemberStatus(clusterMemberInfo.memberName, isMirror);
            return spaceMode.equals((Object)SpaceMode.PRIMARY) ? "Yes" : "No";
        }

        public String getCellValue(ClusterMemberInfo clusterMemberInfo, int column) {
            switch (column) {
                case 0: {
                    return clusterMemberInfo.memberName;
                }
                case 1: {
                    return clusterMemberInfo.memberURL.getURL();
                }
                case 2: {
                    return this.getPrimaryBackupIndication(clusterMemberInfo);
                }
            }
            return null;
        }

        public int getClusterMemberIndex(ClusterMemberInfo clusterMemberInfo) {
            return this._membersList.indexOf(clusterMemberInfo);
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._membersList == null ? 0 : this._membersList.size();
        }

        public ClusterMemberInfo getClusterMember(int index) {
            if (this._membersList.size() > index && index >= 0) {
                return this._membersList.get(index);
            }
            return null;
        }

        public List<ClusterMemberInfo> getClusterMemberInfoList() {
            return this._membersList;
        }
    }
}

