/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.cluster.activeelection.ElectionInProcessException;
import com.gigaspaces.cluster.activeelection.InactiveSpaceException;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.cluster.replication.MirrorServiceConfig;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.exception.SpaceUnavailableException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ScheduledRunner;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.IServiceManager;
import com.j_spaces.tools.PrimaryBackupIndicationListener;
import com.j_spaces.tools.cluster.view.ClusterTree;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class ServiceManagerImpl
extends GSThread
implements IServiceManager {
    public static final String PROPERTY_TIME_INTERVAL = "com.j_spaces.cluster.view.service_manager.interval";
    public static final int UPDATE_SPEED_HIGH = 1000;
    public static final int UPDATE_SPEED_NORMAL = 5000;
    public static final int UPDATE_SPEED_LOW = 10000;
    private static Vector m_membersOnline = new Vector();
    static Hashtable m_replicationStatus = new Hashtable();
    int m_updateSpeed;
    private boolean m_paused;
    private final Hashtable<String, ClusterMember> _curClusterSpaces;
    private final Hashtable<String, ClusterMember> _allClusterSpaces;
    private final Hashtable<String, Set<ClusterMember>> _allClusterMembers;
    private final Hashtable<ServiceID, String> m_servicesID;
    private String _curClusterName;
    IRefreshable[] m_module;
    ClusterTree m_clusterTree;
    private final Set<ServiceItem> m_serviceCollector;
    private final Map<String, SpaceClusterInfo> _clusterPoliciesWrappersMap;
    private final Set<ClusterMember> _allMirrorSpacesSet;
    private final Map<String, String> _mirrorServicesConfigMap;
    private final Map<String, ScheduledRunner> _findersThreadsMap;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.cluster.view");

    public ServiceManagerImpl(String threadName, IRefreshable[] module) {
        block2: {
            super(threadName);
            this._clusterPoliciesWrappersMap = new HashMap<String, SpaceClusterInfo>();
            this._allMirrorSpacesSet = new HashSet<ClusterMember>(1);
            this._mirrorServicesConfigMap = new HashMap<String, String>(1);
            this._findersThreadsMap = new HashMap<String, ScheduledRunner>();
            this.m_module = module;
            this._allClusterSpaces = new Hashtable();
            this._allClusterMembers = new Hashtable();
            this._curClusterSpaces = new Hashtable();
            this.m_servicesID = new Hashtable();
            this.m_serviceCollector = Collections.synchronizedSet(new HashSet());
            this.m_paused = true;
            try {
                this.m_updateSpeed = Integer.parseInt(System.getProperty(PROPERTY_TIME_INTERVAL, String.valueOf(5000)));
            }
            catch (Exception ex) {
                this.m_updateSpeed = 5000;
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
        this.start();
    }

    public ServiceManagerImpl(String threadName) {
        this(threadName, null);
    }

    public ServiceManagerImpl() {
        this("UI-cluster-view-service-manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(ServiceItem si) {
        if (si.service != null && si.service instanceof IJSpace && !this.m_servicesID.containsKey(si.serviceID)) {
            Set<ServiceItem> set = this.m_serviceCollector;
            synchronized (set) {
                this.m_serviceCollector.add(si);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("addService() | " + si);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void validateServices() {
        Iterator<ServiceItem> iter = this.m_serviceCollector.iterator();
        Set<ServiceItem> set = this.m_serviceCollector;
        synchronized (set) {
            while (iter.hasNext()) {
                boolean isAddedSuccessfully;
                block19: {
                    ServiceItem srvItem = iter.next();
                    isAddedSuccessfully = false;
                    boolean isMirrorSpace = false;
                    try {
                        if (srvItem.service != null && srvItem.service instanceof IJSpace) {
                            Entry[] attr = srvItem.attributeSets;
                            String containerName = null;
                            boolean isClusteredSpace = false;
                            String tmpClusterName = null;
                            for (int i = 0; attr != null && i < attr.length; ++i) {
                                if (attr[i] != null && attr[i] instanceof ClusterName && (tmpClusterName = ((ClusterName)attr[i]).name) != null) {
                                    if (!tmpClusterName.equals("NONE")) {
                                        isClusteredSpace = true;
                                    } else {
                                        IRemoteJSpaceAdmin admin = Repository.addSpaceAdminObjectToMap((IJSpace)srvItem.service);
                                        isClusteredSpace = Repository.addSpaceConfigToMap(admin).isMirrorServiceEnabled();
                                        if (isClusteredSpace) {
                                            isMirrorSpace = true;
                                        }
                                    }
                                }
                                if (attr[i] == null || !(attr[i] instanceof ContainerName)) continue;
                                containerName = ((ContainerName)attr[i]).name;
                            }
                            if (isClusteredSpace) {
                                IJSpace spaceProxy = (IJSpace)srvItem.service;
                                String clusterGroupMember = containerName + ":" + spaceProxy.getName();
                                ClusterMember member = this._curClusterSpaces.get(clusterGroupMember);
                                if (member != null) {
                                    try {
                                        member.getSpaceRemoteRef().ping();
                                    }
                                    catch (Exception ex) {
                                        if (_logger.isLoggable(Level.FINE)) {
                                            _logger.log(Level.FINE, "receive expected exception: ", ex);
                                        }
                                        isAddedSuccessfully = this.addClusterSpace(clusterGroupMember, spaceProxy, srvItem.serviceID, tmpClusterName, isMirrorSpace);
                                    }
                                } else {
                                    isAddedSuccessfully = this.addClusterSpace(clusterGroupMember, spaceProxy, srvItem.serviceID, tmpClusterName, isMirrorSpace);
                                }
                            } else {
                                iter.remove();
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!_logger.isLoggable(Level.FINE)) break block19;
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
                if (!isAddedSuccessfully) continue;
                iter.remove();
            }
        }
    }

    private boolean addClusterSpace(String clusterGroupMember, IJSpace spaceProxy, ServiceID serviceID, String clusterName, boolean isMirrorSpace) {
        boolean isAddedSuccessfully;
        block11: {
            isAddedSuccessfully = false;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("~~~~addClusterSpace() BEFORE IF() clusterGroupMember=" + clusterGroupMember + " ,serviceID=" + serviceID);
            }
            if (this.m_servicesID.containsKey(serviceID) || this._allClusterSpaces.containsKey(clusterGroupMember)) {
                return isAddedSuccessfully;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("~~~~addClusterSpace() AFTER IF() clusterGroupMember=" + clusterGroupMember + " ,serviceID=" + serviceID);
            }
            try {
                IRemoteJSpaceAdmin remoteAdminSpace = (IRemoteJSpaceAdmin)((IDirectSpaceProxy)spaceProxy).getRemoteJSpace();
                ClusterMember clusterMemberObj = new ClusterMember(remoteAdminSpace, spaceProxy, serviceID, clusterGroupMember);
                if (isMirrorSpace) {
                    this._allMirrorSpacesSet.add(clusterMemberObj);
                    this.addMirrorSpaceToAppropriateCluster(clusterMemberObj);
                    this._allClusterSpaces.put(clusterGroupMember, clusterMemberObj);
                } else {
                    if (!this._mirrorServicesConfigMap.containsKey(clusterName)) {
                        SpaceConfig spaceConfig = Repository.addSpaceConfigToMap(remoteAdminSpace);
                        MirrorServiceConfig mirrorServiceConfig = spaceConfig.getClusterInfo().getMirrorServiceConfig();
                        String mirrorMemberName = mirrorServiceConfig == null ? null : mirrorServiceConfig.memberName;
                        this._mirrorServicesConfigMap.put(clusterName, mirrorMemberName);
                    }
                    for (ClusterMember mirrorClusterMember : this._allMirrorSpacesSet) {
                        if (this.addMirrorSpaceToAppropriateCluster(mirrorClusterMember)) break;
                    }
                    this._allClusterSpaces.put(clusterGroupMember, clusterMemberObj);
                    this.updateClusterMembersMap(clusterMemberObj, clusterName);
                }
                if (isMirrorSpace && this._mirrorServicesConfigMap.get(this._curClusterName) != null && this._mirrorServicesConfigMap.get(this._curClusterName).equals(clusterGroupMember) || clusterName != null && clusterName.equals(this._curClusterName)) {
                    this._curClusterSpaces.put(clusterGroupMember, clusterMemberObj);
                    this.awakeThread();
                }
                this.m_servicesID.put(serviceID, clusterGroupMember);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("clustered space: " + clusterGroupMember);
                }
                isAddedSuccessfully = true;
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block11;
                _logger.log(Level.FINE, ex.toString(), ex);
            }
        }
        return isAddedSuccessfully;
    }

    private boolean addMirrorSpaceToAppropriateCluster(ClusterMember mirrorClusterMemberObj) {
        boolean isAdded = false;
        Set<Map.Entry<String, String>> mirrorServiceConfigSet = this._mirrorServicesConfigMap.entrySet();
        Iterator<Map.Entry<String, String>> iterator = mirrorServiceConfigSet.iterator();
        String mirrorMemberName = mirrorClusterMemberObj.getClusterMemberName();
        while (iterator.hasNext()) {
            Map.Entry<String, String> mapEntry = iterator.next();
            String mirrorClusterMemberName = mapEntry.getValue();
            if (mirrorClusterMemberName == null || !mirrorClusterMemberName.equals(mirrorMemberName)) continue;
            String clusterName = mapEntry.getKey();
            this.updateClusterMembersMap(mirrorClusterMemberObj, clusterName);
            isAdded = true;
            break;
        }
        return isAdded;
    }

    private void updateClusterMembersMap(ClusterMember clusterMemberObj, String clusterName) {
        Set<ClusterMember> clusterMembersSet = this._allClusterMembers.get(clusterName);
        if (clusterMembersSet == null) {
            clusterMembersSet = new HashSet<ClusterMember>();
            this._allClusterMembers.put(clusterName, clusterMembersSet);
        }
        clusterMembersSet.add(clusterMemberObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(ServiceID srvID, String clusterName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("removeService() | " + srvID.toString());
        }
        String clusterMemberName = null;
        clusterMemberName = this.m_servicesID.get(srvID);
        Object object = this.m_serviceCollector;
        synchronized (object) {
            Iterator<ServiceItem> iterator = this.m_serviceCollector.iterator();
            while (iterator.hasNext()) {
                ServiceItem serviceItem = iterator.next();
                if (!serviceItem.serviceID.equals((Object)srvID)) continue;
                iterator.remove();
                break;
            }
        }
        if (clusterMemberName != null) {
            object = this.m_servicesID;
            synchronized (object) {
                this.m_servicesID.remove(srvID);
            }
            this.removeClusterMemberInfo(clusterMemberName, clusterName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("remove clustered space: " + clusterMemberName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ping() {
        if (!this._curClusterSpaces.isEmpty()) {
            String clusterMemberName = null;
            IJSpace spaceProxy = null;
            Map<String, ClusterMember> clonedMap = this._curClusterSpaces;
            Hashtable<String, ClusterMember> hashtable = this._curClusterSpaces;
            synchronized (hashtable) {
                clonedMap = (Map)this._curClusterSpaces.clone();
            }
            Iterator<String> iter = clonedMap.keySet().iterator();
            while (iter.hasNext()) {
                clusterMemberName = iter.next();
                ClusterMember clusterMember = clonedMap.get(clusterMemberName);
                try {
                    spaceProxy = clusterMember.getRegularProxy();
                    if (spaceProxy != null) {
                        spaceProxy.ping();
                    }
                    if (!m_membersOnline.contains(clusterMemberName)) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "---add cluster member:" + clusterMemberName);
                        }
                        m_membersOnline.addElement(clusterMemberName);
                    }
                    if (!_logger.isLoggable(Level.FINER)) continue;
                    _logger.finer("ping to " + clusterMemberName + " successful");
                }
                catch (InactiveSpaceException ise) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Cluster member \"" + clusterMemberName + "\" could be backup, waiting for space indication.\n" + ise.toString(), ise);
                }
                catch (Exception ex) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                    if (ex instanceof SpaceUnavailableException) {
                        this.handleStoppedClusterMembers(clusterMemberName);
                        continue;
                    }
                    if (ex instanceof SpaceUnavailableException) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "---SpaceUnavailableException, remove cluster member:" + clusterMemberName);
                        }
                        m_membersOnline.remove(clusterMemberName);
                        m_replicationStatus.remove(clusterMemberName);
                        continue;
                    }
                    if (!(ex instanceof RemoteException) && !(ex instanceof NoSuchObjectException)) continue;
                    iter.remove();
                    this.m_servicesID.remove(clusterMember.getServiceID());
                    this.removeClusterMemberInfo(clusterMemberName, null);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.fine("ping to " + clusterMemberName + " failed");
                }
            }
        }
    }

    private void handleStoppedClusterMembers(String clusterMemberName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "---handleStoppedClusterMembers, remove cluster member:" + clusterMemberName);
        }
        m_membersOnline.remove(clusterMemberName);
        m_replicationStatus.remove(clusterMemberName);
    }

    private void removeClusterMemberInfo(String clusterMemberName, String clusterName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("--- removeClusterMemberInfo, clusterMemberName: " + clusterMemberName);
            _logger.fine("Debug Trace Call: " + JSpaceUtilities.getStackTrace((Throwable)new Exception()));
        }
        ClusterMember removedCLusterMember = this._allClusterSpaces.remove(clusterMemberName);
        this._curClusterSpaces.remove(clusterMemberName);
        this._allMirrorSpacesSet.remove(removedCLusterMember);
        m_membersOnline.remove(clusterMemberName);
        m_replicationStatus.remove(clusterMemberName);
        this._clusterPoliciesWrappersMap.remove(clusterMemberName);
        if (clusterName == null) {
            Collection<Set<ClusterMember>> allClusterMembersCollections = this._allClusterMembers.values();
            for (Set<ClusterMember> clusterMembersSet : allClusterMembersCollections) {
                this.removeClusterMemberFromSet(clusterMembersSet, clusterMemberName);
            }
        } else {
            this._mirrorServicesConfigMap.remove(clusterName);
            Set<ClusterMember> clusterMembersSet = this._allClusterMembers.get(clusterName);
            this.removeClusterMemberFromSet(clusterMembersSet, clusterMemberName);
        }
    }

    private void removeClusterMemberFromSet(Set<ClusterMember> clusterMembersSet, String clusterMemberName) {
        ClusterMember removedMember = null;
        for (ClusterMember clusterMember : clusterMembersSet) {
            if (!clusterMember.getClusterMemberName().equals(clusterMemberName)) continue;
            removedMember = clusterMember;
            break;
        }
        if (removedMember != null) {
            clusterMembersSet.remove(removedMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReplicationsStatus() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("----updateReplicationsStatus()");
        }
        String clusterMemberName2 = null;
        IRemoteJSpaceAdmin space = null;
        ReplicationStatus replStatus = null;
        SpaceClusterInfo clusterInfo = null;
        Hashtable<String, ClusterMember> hashtable = this._curClusterSpaces;
        synchronized (hashtable) {
            if (!this._curClusterSpaces.isEmpty()) {
                for (String clusterMemberName2 : this._curClusterSpaces.keySet()) {
                    ClusterMember clusterMember = this._curClusterSpaces.get(clusterMemberName2);
                    space = clusterMember.getSpaceRemoteRef();
                    try {
                        if (space == null) continue;
                        clusterInfo = this._clusterPoliciesWrappersMap.get(clusterMemberName2);
                        if (clusterInfo == null) {
                            IJSpace spaceProxy = clusterMember.getRegularProxy();
                            IRemoteJSpaceAdmin spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
                            SpaceConfig spaceCfg = Repository.addSpaceConfigToMap(spaceAdmin);
                            if (spaceCfg != null) {
                                clusterInfo = spaceCfg.getClusterInfo();
                            }
                            if (clusterInfo != null) {
                                this._clusterPoliciesWrappersMap.put(clusterMemberName2, clusterInfo);
                            }
                        }
                        if (clusterInfo == null || !clusterInfo.isReplicated()) continue;
                        SpaceMode spaceMode = PrimaryBackupIndicationListener.getInstance().getSpaceMode(clusterMember.getServiceID());
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest(">>> Space [" + clusterMember.clusterMemberName + "] mode:" + spaceMode);
                        }
                        if (spaceMode == null || spaceMode == SpaceMode.NONE) continue;
                        replStatus = new ReplicationStatus(space.getReplicationStatus());
                        m_replicationStatus.put(clusterMemberName2, replStatus);
                    }
                    catch (ElectionInProcessException exc) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, exc.toString(), exc);
                    }
                    catch (InactiveSpaceException exc) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, exc.toString(), exc);
                    }
                    catch (Exception ex) {
                        if (ex instanceof SpaceUnavailableException || !_logger.isLoggable(Level.SEVERE)) continue;
                        _logger.log(Level.SEVERE, ex.toString(), ex);
                    }
                }
            }
        }
    }

    public void setClusterTreeReference(ClusterTree tree) {
        this.m_clusterTree = tree;
    }

    public void setRefreshModules(IRefreshable[] modules) {
        this.m_module = modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshing() {
        if (this.m_module == null) return;
        IRefreshable[] iRefreshableArray = this.m_module;
        synchronized (this.m_module) {
            for (int i = 0; i < this.m_module.length; ++i) {
                if (!this.m_module[i].isRunning()) continue;
                this.m_module[i].refresh();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static int getAliveClusterMembersCount() {
        return m_membersOnline.size();
    }

    public boolean isAliveClusterMember(String clusterMemberName) {
        return m_membersOnline.contains(clusterMemberName);
    }

    public static String getMemberStatus(String clusterMemberName, boolean isMirror) {
        String aliveStatus = isMirror ? "MirrorAlive" : "Alive";
        String unreachableStatus = isMirror ? "MirrorUnreachable" : "Unreachable";
        return m_membersOnline.contains(clusterMemberName) ? aliveStatus : unreachableStatus;
    }

    public static ReplicationStatus getReplicationStatus(String clusterMemberName) {
        return (ReplicationStatus)m_replicationStatus.get(clusterMemberName);
    }

    public synchronized void paused(boolean paused, boolean shutdown) {
        this.m_paused = paused;
        if (!paused && !shutdown) {
            this.notify();
        }
        if (paused && !shutdown) {
            this.ping();
        }
    }

    public boolean isPaused() {
        return this.m_paused;
    }

    public synchronized void setUpdateSpeed(int millis) {
        this.m_updateSpeed = millis;
        this.m_paused = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awakeThread() {
        ServiceManagerImpl serviceManagerImpl = this;
        synchronized (serviceManagerImpl) {
            this.m_paused = false;
            this.notifyAll();
        }
    }

    public int getUpdateSpeed() {
        return this.m_updateSpeed;
    }

    public synchronized void shutdown() {
        this.paused(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("run()");
        }
        while (!this.isInterrupted()) {
            try {
                this.validateServices();
                this.ping();
                this.updateReplicationsStatus();
                this.refreshing();
                ServiceManagerImpl serviceManagerImpl = this;
                synchronized (serviceManagerImpl) {
                    this.wait(this.m_updateSpeed);
                }
                serviceManagerImpl = this;
                synchronized (serviceManagerImpl) {
                    if (this.m_paused) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, this.getName() + " interrupted.", ie);
                }
                this.interrupt();
                break;
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, ex.toString(), ex);
            }
        }
    }

    public void clearCurMembersInfo() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "---CLEAR---");
        }
        m_membersOnline.clear();
        this._curClusterSpaces.clear();
    }

    private boolean isClusterMembersURLUsesRMIProtocol(ClusterMemberInfo[] clusterMembers) {
        for (ClusterMemberInfo clusterMemberInfo : clusterMembers) {
            if (!clusterMemberInfo.memberURL.getProtocol().equalsIgnoreCase("rmi:")) continue;
            return true;
        }
        return false;
    }

    public void setCurrentClusterMembers(ClusterMemberInfo[] membersInfo, boolean isPaused) {
        this.clearCurMembersInfo();
        if (membersInfo != null && membersInfo.length > 0) {
            this._curClusterName = membersInfo[0].getClusterName();
            if (this._allClusterSpaces.isEmpty() || this._allClusterMembers.get(this._curClusterName) == null) {
                this.validateServices();
            }
            for (int index = 0; index < membersInfo.length; ++index) {
                ClusterMemberInfo clusterMemberInfo = membersInfo[index];
                String clusterMemberName = clusterMemberInfo.memberName;
                ClusterMember clusterMember = this._allClusterSpaces.get(clusterMemberName);
                _logger.finest("---In setCurrentClusterMembers() method,  clusterMember=" + clusterMember + ", clusterMemberName=" + clusterMemberName);
                if (clusterMember == null) continue;
                this._curClusterSpaces.put(clusterMemberName, clusterMember);
            }
            if (!this._findersThreadsMap.containsKey(this._curClusterName) && this.isClusterMembersURLUsesRMIProtocol(membersInfo)) {
                ScheduledRunner finder = new ScheduledRunner((Runnable)new FindSpaceTask(this._curClusterName, membersInfo), 2000L, 5000L);
                this._findersThreadsMap.put(this._curClusterName, finder);
            }
            if (!isPaused) {
                AdminUIThreadPool.getThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        ServiceManagerImpl.this.ping();
                    }
                });
            }
        }
    }

    public ClusterMember getClusterMember(String memberName) {
        return this._curClusterSpaces.get(memberName);
    }

    public ClusterMember[] getClusterMembers(String clusterName, boolean includeMirror) {
        Set<ClusterMember> clusterMembersSet = this._allClusterMembers.get(clusterName);
        int size = clusterMembersSet.size();
        ClusterMember[] resultArray = new ClusterMember[size];
        clusterMembersSet.toArray(resultArray);
        for (ClusterMember clusterMember : clusterMembersSet) {
            if (includeMirror || !clusterMember.isMirror()) continue;
            clusterMembersSet.remove(clusterMember);
            break;
        }
        return resultArray;
    }

    public IJSpace[] getClusterMemberProxies(String clusterName, boolean includeMirror) {
        IJSpace[] resultArray;
        block4: {
            Set<ClusterMember> clusterMembersSet = this._allClusterMembers.get(clusterName);
            if (clusterMembersSet == null) {
                return null;
            }
            int size = clusterMembersSet.size();
            resultArray = new IJSpace[size];
            Iterator<ClusterMember> iterator = clusterMembersSet.iterator();
            try {
                int index = 0;
                while (iterator.hasNext()) {
                    ClusterMember clusterMember = iterator.next();
                    IJSpace spaceProxy = ServiceManagerImpl.retrieveSpaceProxy(clusterMember);
                    if (!includeMirror && (includeMirror || clusterMember.isMirror())) continue;
                    resultArray[index++] = spaceProxy;
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return resultArray;
    }

    public static IJSpace retrieveSpaceProxy(ClusterMember clusterMember) throws NoSuchNameException, RemoteException {
        IJSpace spaceProxy = clusterMember.getClusteredProxy() == null ? clusterMember.getRegularProxy() : clusterMember.getClusteredProxy();
        return spaceProxy;
    }

    private class ClusterPolicyInitializationWrapper {
        private final ClusterPolicy _clusterPolicy;

        ClusterPolicyInitializationWrapper(ClusterPolicy clusterPolicy) {
            this._clusterPolicy = clusterPolicy;
        }

        public ClusterPolicy getClusterPolicy() {
            return this._clusterPolicy;
        }
    }

    public static class ReplicationStatus {
        public String[] targets;
        public int[] tstatus;

        public ReplicationStatus(Object[] arr) {
            this.targets = (String[])arr[0];
            this.tstatus = (int[])arr[1];
        }

        public boolean equals(ReplicationStatus replStat) {
            int i;
            StringBuilder bufTargets = new StringBuilder();
            StringBuilder bufNewTargets = new StringBuilder();
            for (i = 0; i < this.targets.length; ++i) {
                bufTargets.append(this.targets[i]);
            }
            for (i = 0; i < replStat.targets.length; ++i) {
                bufNewTargets.append(replStat.targets[i]);
            }
            byte[] byteTargets = bufTargets.toString().getBytes();
            byte[] byteNewTargets = bufNewTargets.toString().getBytes();
            Arrays.sort(byteTargets);
            Arrays.sort(byteNewTargets);
            return Arrays.equals(byteTargets, byteNewTargets);
        }

        public String getMemberName(int index) {
            if (this.targets != null && this.targets.length > 0 && index < this.targets.length) {
                return this.targets[index];
            }
            return "none";
        }

        public void show() {
            for (int i = 0; i < this.targets.length; ++i) {
                if (!_logger.isLoggable(Level.INFO)) continue;
                _logger.info(this.targets[i] + ": " + this.tstatus[i]);
            }
        }
    }

    public static class ClusterMember {
        private IRemoteJSpaceAdmin spaceRemoteRef = null;
        private IJSpace regularProxy = null;
        private IJSpace clusteredProxy = null;
        private final ServiceID serviceID;
        private final String clusterMemberName;
        private boolean isMirror = false;

        public ClusterMember(IRemoteJSpaceAdmin spaceRemoteRef, IJSpace spaceProxy, ServiceID serviceID, String clusterMemberName) {
            this.spaceRemoteRef = spaceRemoteRef;
            this.serviceID = serviceID;
            this.clusterMemberName = clusterMemberName;
            if (((ISpaceProxy)spaceProxy).isClustered()) {
                this.clusteredProxy = spaceProxy;
            } else {
                this.regularProxy = spaceProxy;
                try {
                    this.isMirror = Repository.addSpaceConfigToMap(Repository.addSpaceAdminObjectToMap(this.regularProxy)).isMirrorServiceEnabled();
                }
                catch (RemoteException re) {
                    _logger.log(Level.SEVERE, re.toString(), re);
                }
            }
        }

        public boolean isMirror() {
            return this.isMirror;
        }

        public IRemoteJSpaceAdmin getSpaceRemoteRef() {
            return this.spaceRemoteRef;
        }

        public IJSpace getClusteredProxy() {
            return this.clusteredProxy;
        }

        public String getClusterMemberName() {
            return this.clusterMemberName;
        }

        public IJSpace getRegularProxy() throws RemoteException, NoSuchNameException {
            if (this.regularProxy == null) {
                this.init();
            }
            return this.regularProxy;
        }

        private void init() throws RemoteException, NoSuchNameException {
            if (this.clusteredProxy != null) {
                this.regularProxy = this.clusteredProxy.getDirectProxy().getNonClusteredProxy();
            }
        }

        public ServiceID getServiceID() {
            return this.serviceID;
        }
    }

    private class FindSpaceTask
    implements Runnable {
        private final String _clusterName;
        private final ClusterMemberInfo[] _clusterMembersInfo;

        FindSpaceTask(String clusterName, ClusterMemberInfo[] membersInfo) {
            this._clusterName = clusterName;
            this._clusterMembersInfo = membersInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this._clusterMembersInfo == null || this._clusterMembersInfo.length == 0) {
                return;
            }
            ClusterMemberInfo[] clusterMemberInfoArray = this._clusterMembersInfo;
            synchronized (this._clusterMembersInfo) {
                for (int i = 0; i < this._clusterMembersInfo.length; ++i) {
                    if (ServiceManagerImpl.this._allClusterSpaces.containsKey(this._clusterMembersInfo[i].memberName) || !this._clusterMembersInfo[i].memberURL.getProtocol().equalsIgnoreCase("rmi:")) continue;
                    try {
                        IJSpace spaceProxy = (IJSpace)SpaceFinder.find((SpaceURL)this._clusterMembersInfo[i].memberURL);
                        ServiceManagerImpl.this.addClusterSpace(this._clusterMembersInfo[i].memberName, spaceProxy, JSpaceUtilities.getSpaceServiceID((IJSpace)spaceProxy), this._clusterName, this._clusterMembersInfo[i].isMirror());
                        IJSpaceContainer containerProxy = spaceProxy.getDirectProxy().getContainer();
                        if (SpaceBrowser.getInstance().isProxyExists(containerProxy)) continue;
                        String spaceContainerName = containerProxy.getName();
                        SpaceBrowser.getInstance().addContainerTree(containerProxy, spaceContainerName, "rmi:", false);
                        SpaceBrowser.getInstance().addRMIContainer(containerProxy, this._clusterMembersInfo[i].memberURL.getURL());
                        continue;
                    }
                    catch (Exception ex) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

