/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.components;

import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class ItemsControlPanel
extends JPanel {
    public static final String ADD_BUTTON_TEXT = "Add";
    public static final String EDIT_BUTTON_TEXT = "Edit";
    public static final String REMOVE_BUTTON_TEXT = "Remove";
    public static final String REMOVE_ALL_BUTTON_TEXT = "Remove All";
    public Vector columnIdentifiers;
    Object[] columnDefaultValues;
    String borderTitle;
    boolean askConfirmation;
    boolean actionListenerADD;
    protected Map<String, AbstractButton> controls = new Hashtable<String, AbstractButton>();
    protected JButton butAdd = new JButton();
    protected JButton butEdit = new JButton();
    protected JButton butRemove = new JButton();
    protected JButton butRemoveAll = new JButton();
    protected JPanel controlsPanel = new JPanel();
    private JTable jtable = new JTable();
    protected JScrollPane tableScrollPanel = new JScrollPane();
    private JDialog _parentDialog;
    private static final String COMPLETE_TABLE_DATA_MESSAGE = "Please complete filling all data in the table.";

    public ItemsControlPanel(Object[] columnNames, String borderTitle, boolean actionListenerADD, JDialog parentDialog) {
        this.borderTitle = borderTitle;
        this._parentDialog = parentDialog;
        this.askConfirmation = true;
        this.actionListenerADD = actionListenerADD;
        this.setColumnNames(columnNames);
        this.setDataModel(new DefaultTableModel(columnNames, 0));
        this.columnDefaultValues = new Object[columnNames.length];
        for (int i = 0; i < this.columnDefaultValues.length; ++i) {
            this.columnDefaultValues[i] = "";
        }
        this.init();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ItemsControlPanel(Object[] columnNames, String borderTitle, JDialog parentDialog) {
        this(columnNames, borderTitle, true, parentDialog);
    }

    public ItemsControlPanel(Object[] columnNames) {
        this(columnNames, null, null);
    }

    public ItemsControlPanel() {
        this(new Object[0], null, null);
    }

    public void addRow(Object[] rowData) {
        this.getDataModel().addRow(rowData);
    }

    public void setColumnNames(Object[] columnNames) {
        this.columnIdentifiers = ItemsControlPanel.convertToVector(columnNames);
    }

    public Object[] getColumnNames() {
        return this.columnIdentifiers.toArray();
    }

    public DefaultTableModel getDataModel() {
        return (DefaultTableModel)this.jtable.getModel();
    }

    public Vector getSelectedRowData() {
        int index = this.getJTable().getSelectedRow();
        return this.getDataModel().getDataVector().get(index);
    }

    public boolean hasSelectedRow() {
        return this.getJTable().getSelectedRow() >= 0;
    }

    public void setSelectedRow(int index) {
        this.getJTable().getSelectionModel().setSelectionInterval(index, index);
    }

    public void clean() {
        this.stopCellEditing();
        this.getDataModel().getDataVector().removeAllElements();
        this.getDataModel().setDataVector(new Object[0][], this.columnIdentifiers.toArray());
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        JSpaceUIUtils.setAWTComponentsStatus(this.controlsPanel, b);
    }

    public void setDataModel(DefaultTableModel tableModel) {
        this.jtable.setModel(tableModel);
    }

    public void setEditButtonVisible(boolean b) {
        this.butEdit.setVisible(b);
    }

    public boolean isEditButtonVisible() {
        return this.butEdit.isVisible();
    }

    public JTable getJTable() {
        return this.jtable;
    }

    public void setDefaulColumnValues(Object[] values) {
        this.columnDefaultValues = values;
    }

    public Object[] getDefaulColumnValues() {
        return this.columnDefaultValues;
    }

    public AbstractButton getButton(String text) {
        return this.controls.get(text);
    }

    public void setControlsVisible(boolean b) {
        this.controlsPanel.setVisible(b);
    }

    public void stopCellEditing() {
        if (this.jtable.isEditing()) {
            this.jtable.getCellEditor().stopCellEditing();
        }
    }

    private void init() {
        this.jtable.setAutoscrolls(true);
        this.jtable.setAutoCreateColumnsFromModel(false);
        this.jtable.setSelectionMode(0);
        this.jtable.setPreferredScrollableViewportSize(new Dimension(360, 100));
        this.jtable.getTableHeader().addMouseListener(new ColumnSortListener());
        this.jtable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean isEnabled = ItemsControlPanel.this.jtable.getModel().getRowCount() > 0;
                ItemsControlPanel.this.butEdit.setEnabled(isEnabled);
                ItemsControlPanel.this.butRemove.setEnabled(isEnabled);
                ItemsControlPanel.this.butRemoveAll.setEnabled(isEnabled);
            }
        });
        if (this.actionListenerADD) {
            this.butAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ItemsControlPanel.this.jtable.isEditing()) {
                        ItemsControlPanel.this.jtable.getCellEditor().stopCellEditing();
                    }
                    if (ItemsControlPanel.this.isNewRowCanBeAdded()) {
                        ItemsControlPanel.this.getDataModel().addRow(ItemsControlPanel.this.columnDefaultValues);
                    }
                }
            });
        }
        this.butRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex;
                if (ItemsControlPanel.this.jtable.isEditing()) {
                    ItemsControlPanel.this.jtable.getCellEditor().stopCellEditing();
                }
                if ((rowIndex = ItemsControlPanel.this.jtable.getSelectedRow()) != -1) {
                    DefaultTableModel tableModel = ItemsControlPanel.this.getDataModel();
                    tableModel.removeRow(rowIndex);
                    int curListSize = tableModel.getRowCount();
                    if (curListSize > 0) {
                        if (rowIndex < curListSize) {
                            ItemsControlPanel.this.jtable.setRowSelectionInterval(rowIndex, rowIndex);
                        } else if (curListSize > 0) {
                            ItemsControlPanel.this.jtable.setRowSelectionInterval(curListSize - 1, curListSize - 1);
                        }
                    }
                }
            }
        });
        this.butRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ItemsControlPanel.this.jtable.isEditing()) {
                    ItemsControlPanel.this.jtable.getCellEditor().stopCellEditing();
                }
                if (ItemsControlPanel.this.askConfirmation && JOptionPane.showConfirmDialog(ItemsControlPanel.this, "Remove all items, are you sure?", "Confirmation", 0) != 0) {
                    return;
                }
                ItemsControlPanel.this.clean();
            }
        });
    }

    private boolean isNewRowCanBeAdded() {
        int rowCount = this.jtable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String val = this.jtable.getValueAt(i, 0).toString();
            if (val.trim().length() != 0) continue;
            JOptionPane.showMessageDialog(this._parentDialog, COMPLETE_TABLE_DATA_MESSAGE, "Missing data", 1);
            return false;
        }
        return true;
    }

    private void jbInit() throws Exception {
        this.butAdd.setText(ADD_BUTTON_TEXT);
        this.butRemove.setText(REMOVE_BUTTON_TEXT);
        this.butRemoveAll.setText(REMOVE_ALL_BUTTON_TEXT);
        this.butEdit.setText(EDIT_BUTTON_TEXT);
        this.controls.put(this.butAdd.getText(), this.butAdd);
        this.controls.put(this.butRemove.getText(), this.butRemove);
        this.controls.put(this.butRemoveAll.getText(), this.butRemoveAll);
        this.controls.put(this.butEdit.getText(), this.butEdit);
        this.controlsPanel.setLayout(new GridBagLayout());
        this.controlsPanel.add((Component)this.butAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 2, 2, 2), 0, 0));
        this.controlsPanel.add((Component)this.butRemove, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(15, 2, 2, 2), 0, 0));
        this.controlsPanel.add((Component)this.butRemoveAll, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.controlsPanel.add((Component)this.butEdit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        if (this.borderTitle != null) {
            this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), this.borderTitle));
        }
        this.tableScrollPanel.getViewport().add((Component)this.jtable, null);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.controlsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tableScrollPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static Vector convertToVector(Object[] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(anArray.length);
        for (int i = 0; i < anArray.length; ++i) {
            v.addElement(anArray[i]);
        }
        return v;
    }
}

