/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.general;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class GSCheckBoxCellRenderer
extends JLabel
implements TableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;
    protected static Border noFocusBorder;
    private TableCellRenderer cellRenderer;

    public GSCheckBoxCellRenderer() {
        noFocusBorder = new EmptyBorder(1, 2, 1, 2);
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        if (value == null) {
            this.setText("");
            return this;
        }
        if (value.toString().equals("")) {
            this.setText("");
            return this;
        }
        this.cellRenderer = table.getDefaultRenderer(Boolean.class);
        JComponent comp = (JComponent)this.cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!table.isCellEditable(row, column)) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(SystemColor.control);
            }
            comp.setEnabled(false);
        } else {
            comp.setEnabled(true);
        }
        if (!(comp instanceof AbstractButton)) return comp;
        ((AbstractButton)comp).setBorderPainted(true);
        if (hasFocus) {
            comp.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            return comp;
        }
        comp.setBorder(noFocusBorder);
        return comp;
    }
}

