/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.general;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class GSRegularCellRenderer
extends JLabel
implements TableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;
    protected static Border noFocusBorder;
    private TableCellRenderer cellRenderer;

    public GSRegularCellRenderer() {
        noFocusBorder = new EmptyBorder(1, 2, 1, 2);
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setText(value.toString());
        if (!table.isCellEditable(row, column)) {
            this.setBackground(isSelected ? SystemColor.textHighlight : SystemColor.control);
            this.setForeground(isSelected ? Color.white : Color.black);
        }
        return this;
    }
}

