/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexFactory;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.j_spaces.tools.spacebrowser.ClassIndexesDefinitionPanel;
import com.j_spaces.tools.spacebrowser.utils.TableChangedListener;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSeparator;

public class AddClassIndexDialog
extends EscapeDialog
implements ActionListener,
TableChangedListener {
    private JButton _okButton;
    private JButton _cancelButton;
    private SpaceIndex[] _resultSpaceIndexes;
    private ClassIndexesDefinitionPanel _classIndexesDefinitionPanel;
    private final int COMPONENT_HEIGHT = 22;

    public AddClassIndexDialog(JFrame parentFrame, String[] classProperties, String[] existingIndexes) {
        super(parentFrame, "Create Index", true);
        this._classIndexesDefinitionPanel = new ClassIndexesDefinitionPanel(this, classProperties, existingIndexes);
        this._classIndexesDefinitionPanel.addTableChangeListener(this);
        this.init();
        this.setSize(450, 350);
        this.setResizable(true);
        this.setLocationRelativeTo(parentFrame);
    }

    public SpaceIndex[] getSpaceIndexes() {
        return this._resultSpaceIndexes;
    }

    private void init() {
        Box buttonsBox = this.createButtonsBox();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(Box.createVerticalStrut(10));
        contentPane.add(this._classIndexesDefinitionPanel);
        contentPane.add(Box.createVerticalStrut(7));
        contentPane.add(new JSeparator(0));
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(buttonsBox);
        contentPane.add(Box.createVerticalStrut(5));
        this.handleOkButtonState(this._classIndexesDefinitionPanel.getClassIndexes().size());
    }

    private void handleOkButtonState(int numOfIndexes) {
        this._okButton.setEnabled(numOfIndexes > 0);
    }

    private Box createButtonsBox() {
        this._okButton = new JButton("OK");
        this._cancelButton = new JButton("Cancel");
        Dimension buttonSize = new Dimension(75, 22);
        this._okButton.setPreferredSize(buttonSize);
        this._okButton.setMinimumSize(buttonSize);
        this._cancelButton.setPreferredSize(buttonSize);
        this._cancelButton.setMinimumSize(buttonSize);
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        Box hBox = new Box(0);
        hBox.add(Box.createHorizontalGlue());
        hBox.add(this._okButton);
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(this._cancelButton);
        hBox.add(Box.createHorizontalGlue());
        return hBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this._okButton)) {
            this.okButtonPressed();
        } else if (e.getSource().equals(this._cancelButton)) {
            this.setVisible(false);
        }
    }

    private void okButtonPressed() {
        if (this._classIndexesDefinitionPanel.isDataValid()) {
            this.createSpaceIndexes();
            this.setVisible(false);
        }
    }

    private void createSpaceIndexes() {
        List<ClassIndexesDefinitionPanel.ClassIndexWrapper> classIndexes = this._classIndexesDefinitionPanel.getClassIndexes();
        ArrayList<SpaceIndex> spaceIndexesList = new ArrayList<SpaceIndex>(classIndexes.size());
        for (ClassIndexesDefinitionPanel.ClassIndexWrapper classIndexWrapper : classIndexes) {
            String path = classIndexWrapper.getPath();
            SpaceIndexType type = classIndexWrapper.getType();
            spaceIndexesList.add(SpaceIndexFactory.createPathIndex((String)path, (SpaceIndexType)type));
        }
        this._resultSpaceIndexes = spaceIndexesList.toArray(new SpaceIndex[0]);
    }

    @Override
    public void rowsNumChanged(int rowsCount) {
        this._okButton.setEnabled(rowsCount > 0);
    }
}

