/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.statistics.space_operations.SpaceColorMap;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import com.j_spaces.tools.spacebrowser.utils.ProgressThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddressBarDialog
extends EscapeDialog
implements ActionListener {
    private static AddressBarDialog addressBarDialog;
    private JButton closeDialogButton = new JButton("Close");
    private JButton findServiceButton = new JButton("Find");
    private JPanel adressContainer = new JPanel();
    private JLabel adressLabel = new JLabel();
    private final BorderLayout adressConBorderLayout = new BorderLayout(2, 2);
    private final JComboBox addressText = new JComboBox();
    private final ComboBoxEditor addressEditor = this.addressText.getEditor();
    private static final String ADDRESS_URL = "address.url";
    private static final String PROP_URL = "URL";
    private static final String PROP_MAX_SAVED_URL_COUNT = "MAX_SAVED_URL_COUNT";
    private static final int SAVED_URLS_COUNT = 10;
    private int curURLCount = 10;
    private static final String ADDRESS_TIP = "address.tip";
    private static final String ADDRESS_LABEL = "address.label";
    private MainUI _parentFrame;

    public static synchronized AddressBarDialog getInstance(MainUI parentFrame) {
        if (addressBarDialog == null) {
            addressBarDialog = new AddressBarDialog(parentFrame);
        }
        return addressBarDialog;
    }

    public static synchronized boolean isInstanceInitialized() {
        return addressBarDialog != null;
    }

    private AddressBarDialog(MainUI parentFrame) {
        super(parentFrame, "Locate Space", false);
        this._parentFrame = parentFrame;
        this.init();
        this.setSize(650, 105);
        this.setResizable(false);
        this.setLocationRelativeTo(parentFrame);
    }

    private void init() {
        this.addressText.setAutoscrolls(true);
        this.addressText.setFont(new Font("Dialog", 1, 12));
        this.adressContainer.setLayout(this.adressConBorderLayout);
        String defaultURL = JSpaceUIUtils.getResource().getString(ADDRESS_URL) + this.getDefaultContainerName();
        this.addressText.addItem(defaultURL);
        this.addressText.setEditable(true);
        this.addressText.setToolTipText(JSpaceUIUtils.getResource().getString(ADDRESS_TIP));
        this.adressLabel.setText(" " + JSpaceUIUtils.getResource().getString(ADDRESS_LABEL));
        this.adressContainer.add((Component)this.adressLabel, "West");
        this.adressContainer.add((Component)this.addressText, "Center");
        this.adressContainer.setPreferredSize(new Dimension(2000, 23));
        this.adressContainer.setMaximumSize(new Dimension(2000, 23));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(this.adressContainer);
        Properties serializing = Repository.getInstance().getProperties();
        String maxURLCountStr = (String)serializing.get(PROP_MAX_SAVED_URL_COUNT);
        if (maxURLCountStr != null) {
            this.curURLCount = Integer.parseInt(maxURLCountStr);
        }
        for (int i = 0; i < this.curURLCount; ++i) {
            DefaultComboBoxModel comboModel;
            Object url = serializing.get(PROP_URL + (i + 1));
            if (url == null || (comboModel = (DefaultComboBoxModel)this.addressText.getModel()).getIndexOf(url) != -1) continue;
            this.addressText.addItem(url);
        }
        this.addressEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressBarDialog.this.findSpace();
            }
        });
        this.closeDialogButton.addActionListener(this);
        this.findServiceButton.addActionListener(this);
        Dimension buttonSize = new Dimension(70, 23);
        this.closeDialogButton.setPreferredSize(buttonSize);
        this.closeDialogButton.setMaximumSize(buttonSize);
        this.closeDialogButton.setMinimumSize(buttonSize);
        this.findServiceButton.setPreferredSize(buttonSize);
        this.findServiceButton.setMaximumSize(buttonSize);
        this.findServiceButton.setMinimumSize(buttonSize);
        Box southBox = new Box(0);
        southBox.add(Box.createHorizontalGlue());
        southBox.add(this.findServiceButton);
        southBox.add(Box.createHorizontalStrut(20));
        southBox.add(this.closeDialogButton);
        southBox.add(Box.createHorizontalGlue());
        contentPane.add(Box.createVerticalStrut(10));
        contentPane.add(southBox);
        contentPane.add(Box.createVerticalStrut(7));
    }

    private String getDefaultContainerName() {
        String result = null;
        result = System.getProperty("com.gs.browser.containername", "myCache_container");
        return result;
    }

    public void saveProperties() {
        Properties serializing = SpaceColorMap.instance().getProperties();
        serializing.put(PROP_MAX_SAVED_URL_COUNT, String.valueOf(this.curURLCount));
        ComboBoxModel comboBoxModel = this.addressText.getModel();
        int itemsCount = comboBoxModel.getSize();
        if (itemsCount > this.curURLCount) {
            itemsCount = this.curURLCount;
        }
        for (int i = 0; i < itemsCount; ++i) {
            String url = (String)comboBoxModel.getElementAt(i);
            serializing.put(PROP_URL + (i + 1), url);
        }
        Repository.getInstance().setProperties(serializing);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.closeDialogButton)) {
            this.setVisible(false);
        } else if (e.getSource().equals(this.findServiceButton)) {
            this.findSpace();
        }
    }

    private void findSpace() {
        ProgressThread pt;
        String url = (String)this.addressEditor.getItem();
        try {
            pt = new ProgressThread(this._parentFrame, this);
            pt.setURL(url);
        }
        catch (MalformedURLException ex) {
            SpaceBrowser.showException("Wrong space URL", ex);
            return;
        }
        pt.start();
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)this.addressText.getModel();
        if (comboModel.getIndexOf(url) == -1) {
            this.addressText.insertItemAt(url, 0);
        }
        this.addressText.setSelectedItem(url);
    }
}

