/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.kernel.ClassLoaderHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class BrowserLAFMenu
extends JMenu
implements ActionListener {
    private static final String lafMetal = "Metal";
    private static final String lafMac = "Mac";
    private static final String lafMotif = "Motif";
    private static final String lafWindows = "Windows";
    private static final String lafMetalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String lafMacClassName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String lafMotifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String lafWindowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    JRadioButtonMenuItem lafMetalMenuItem;
    JRadioButtonMenuItem lafMacMenuItem;
    JRadioButtonMenuItem lafMotifMenuItem;
    JRadioButtonMenuItem lafWindowsMenuItem;
    Component owner;
    Vector members;
    String lafCurrentName = "javax.swing.plaf.metal.MetalLookAndFeel";

    public BrowserLAFMenu() {
        this(null, "Look & Feel", null);
    }

    public BrowserLAFMenu(Component owner, String label) {
        this(owner, label, null);
    }

    public BrowserLAFMenu(Component owner, String label, Vector members) {
        this.owner = owner;
        this.members = members;
        this.setText(label);
        this.lafMetalMenuItem = new JRadioButtonMenuItem(lafMetal);
        this.lafMetalMenuItem.setMnemonic('M');
        this.lafMetalMenuItem.setActionCommand(lafMetalClassName);
        this.lafMetalMenuItem.setEnabled(this.isAvailableLookAndFeel(lafMetalClassName));
        this.lafMetalMenuItem.setSelected(true);
        this.lafMacMenuItem = new JRadioButtonMenuItem(lafMac);
        this.lafMacMenuItem.setMnemonic('C');
        this.lafMacMenuItem.setActionCommand(lafMacClassName);
        this.lafMacMenuItem.setEnabled(this.isAvailableLookAndFeel(lafMacClassName));
        this.lafMotifMenuItem = new JRadioButtonMenuItem(lafMotif);
        this.lafMotifMenuItem.setMnemonic('O');
        this.lafMotifMenuItem.setActionCommand(lafMotifClassName);
        this.lafMotifMenuItem.setEnabled(this.isAvailableLookAndFeel(lafMotifClassName));
        this.lafWindowsMenuItem = new JRadioButtonMenuItem(lafWindows);
        this.lafWindowsMenuItem.setMnemonic('W');
        this.lafWindowsMenuItem.setActionCommand(lafWindowsClassName);
        this.lafWindowsMenuItem.setEnabled(this.isAvailableLookAndFeel(lafWindowsClassName));
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.lafMetalMenuItem);
        group1.add(this.lafMacMenuItem);
        group1.add(this.lafMotifMenuItem);
        group1.add(this.lafWindowsMenuItem);
        this.add(this.lafMetalMenuItem);
        this.add(this.lafMacMenuItem);
        this.add(this.lafMotifMenuItem);
        this.add(this.lafWindowsMenuItem);
        this.lafMetalMenuItem.addActionListener(this);
        this.lafMacMenuItem.addActionListener(this);
        this.lafMotifMenuItem.addActionListener(this);
        this.lafWindowsMenuItem.addActionListener(this);
    }

    protected boolean isAvailableLookAndFeel(String laf) {
        try {
            Class lnfClass = ClassLoaderHelper.loadClass((String)laf);
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            return newLAF.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.lafCurrentName)) {
            return;
        }
        this.lafCurrentName = e.getActionCommand();
        try {
            UIManager.setLookAndFeel(this.lafCurrentName);
            if (this.owner != null) {
                SwingUtilities.updateComponentTreeUI(this.owner);
            }
            if (this.members != null) {
                for (int i = 0; i < this.members.size(); ++i) {
                    Component c = (Component)this.members.elementAt(i);
                    if (c == null) continue;
                    SwingUtilities.updateComponentTreeUI(c);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Failed loading LoolAndFeel: " + this.lafCurrentName);
            ex.printStackTrace();
        }
    }
}

